/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.explorer.BeanTableExplorerView;
import com.floreantpos.model.PriceTable;
import com.floreantpos.model.dao.PriceShiftDAO;
import com.floreantpos.model.dao.PriceTableDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.PriceTableForm;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.JButton;
import javax.swing.table.DefaultTableCellRenderer;

public class PriceTableExplorer
extends BeanTableExplorerView<PriceTable> {
    public PriceTableExplorer() {
        super(PriceTable.class);
        JButton jButton = new JButton(POSConstants.DETAILS);
        jButton.addActionListener(actionEvent -> this.a(Boolean.TRUE));
        TransparentPanel transparentPanel = this.getBottomActionPanel();
        transparentPanel.add((Component)jButton, 0);
    }

    @Override
    public DefaultTableCellRenderer geTableCellRenderer() {
        return new PosTableRenderer();
    }

    @Override
    public void initTableModel(BeanTableModel<PriceTable> beanTableModel) {
        beanTableModel.addColumn(POSConstants.NAME, PriceTable.PROP_NAME);
        beanTableModel.addColumn(POSConstants.DESCRIPTION, PriceTable.PROP_DESCRIPTION);
        beanTableModel.addColumn(Messages.getString("LastUpdateTime"), PriceTable.PROP_LAST_UPDATE_TIME);
        beanTableModel.addColumn(Messages.getString("PriceTableExplorer.0"), PriceTable.PROP_LAST_UPDATED_BY);
    }

    @Override
    public void initData() {
        this.setRows(PriceTableDAO.getInstance().findAll());
    }

    @Override
    public PriceTable createNew() {
        return this.openNewForm(new PriceTableForm(new PriceTable()), 900, 700);
    }

    @Override
    public PriceTable editSelectedRow(PriceTable priceTable) {
        return this.a(priceTable, Boolean.FALSE);
    }

    private PriceTable a(PriceTable priceTable, boolean bl) {
        PriceShiftDAO.getInstance().refresh(priceTable);
        this.checkDataValidation(priceTable.isDeleted(), priceTable.getName());
        return this.openEditForm(new PriceTableForm(priceTable, bl), 900, 700);
    }

    @Override
    public boolean delete(PriceTable priceTable) {
        PriceShiftDAO.getInstance().refresh(priceTable);
        this.checkDataValidation(priceTable.isDeleted(), priceTable.getName());
        PriceTableDAO.getInstance().delete(priceTable);
        return true;
    }

    private void a(boolean bl) {
        try {
            PriceTable priceTable = (PriceTable)this.getSelectedRow();
            if (priceTable == null) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToShowDetails"));
                return;
            }
            PriceTableForm priceTableForm = new PriceTableForm(priceTable, bl);
            priceTableForm.setEditable(!bl);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)priceTableForm);
            if (bl) {
                beanEditorDialog.getButtonPanel().remove(2);
            }
            beanEditorDialog.openWithScale(900, 700);
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }
}

