/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.db.update;

import com.floreantpos.PosException;
import com.floreantpos.mailservices.MailService;
import com.floreantpos.main.Application;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.VoidItem;
import com.floreantpos.model.base.BasePosTransaction;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.TicketItemDAO;
import com.floreantpos.model.dao.VoidItemDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.GlassPane;
import com.floreantpos.util.DatabaseUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URI;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.jdbc.Work;

public class UpdateDBTo239 {
    private SessionFactory a;

    public UpdateDBTo239(SessionFactory sessionFactory) {
        this.a = sessionFactory;
    }

    public void update() throws Exception {
        this.a.openSession().doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                Serializable serializable;
                Object object;
                String string = System.getProperty("user.home");
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddhhmmss");
                File file = new File(string, "oropos_data_conversion_log_" + simpleDateFormat.format(System.currentTimeMillis()) + ".csv");
                try {
                    object = new BufferedWriter(new FileWriter(file));
                    serializable = null;
                    try {
                        UpdateDBTo239.this.a(connection, (BufferedWriter)object);
                        UpdateDBTo239.this.a((BufferedWriter)object);
                    }
                    catch (Throwable throwable) {
                        serializable = throwable;
                        throw throwable;
                    }
                    finally {
                        if (object != null) {
                            if (serializable != null) {
                                try {
                                    ((BufferedWriter)object).close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)serializable).addSuppressed(throwable);
                                }
                            } else {
                                ((BufferedWriter)object).close();
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    throw new PosException(exception.getMessage(), exception);
                }
                try {
                    object = IOUtils.toByteArray((URI)file.toURI());
                    serializable = new StringBuffer();
                    ((StringBuffer)serializable).append("<pre>");
                    ((StringBuffer)serializable).append("System: " + VersionInfo.getAppName());
                    ((StringBuffer)serializable).append("<br/>Version: " + VersionInfo.getVersion());
                    Store store = DataProvider.get().getStore();
                    Terminal terminal = DataProvider.get().getCurrentTerminal();
                    String string2 = store.getName() + " data conversion log";
                    if (store != null) {
                        string2 = VersionInfo.getAppName() + " - " + store.getName() + " data conversion log";
                        ((StringBuffer)serializable).append("<br/>Store: " + store.getName());
                        if (terminal != null) {
                            ((StringBuffer)serializable).append("<br/>Terminal key: " + terminal.getTerminalKey());
                        }
                        ((StringBuffer)serializable).append("<br/>");
                    }
                    ((StringBuffer)serializable).append("</pre>");
                    MailService.sendMail("oroposlog@gmail.com", string2, ((StringBuffer)serializable).toString(), file.getName(), file.getName(), (byte[])object);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    private void a(Connection connection, BufferedWriter bufferedWriter) throws SQLException, IOException {
        try {
            connection.setAutoCommit(false);
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String string = DatabaseUtil.getActualTableName(databaseMetaData, "TICKET_ITEM_MODIFIER_RELATION");
            String string2 = DatabaseUtil.getActualTableName(databaseMetaData, "TICKET_ITEM_MODIFIER");
            String string3 = DatabaseUtil.getActualColumnName(databaseMetaData, string2, "ID");
            String string4 = DatabaseUtil.getActualColumnName(databaseMetaData, string, "MODIFIER_ID");
            String string5 = DatabaseUtil.getActualColumnName(databaseMetaData, string2, "ITEM_QUANTITY");
            try (Statement statement = connection.createStatement();){
                String string6 = "delete from %s where %s != 0 and %s not in (select %s from %s)";
                string6 = String.format(string6, string2, string5, string3, string4, string);
                int n = statement.executeUpdate(string6);
                bufferedWriter.write("Deleted " + n + " unused rows from " + string2 + ".\n");
            }
            bufferedWriter.write("Updating modifier table successful.\n");
            connection.commit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void a(BufferedWriter bufferedWriter) throws IOException {
        DataProvider.get().initialize();
        bufferedWriter.write("Before/After,Ticket ID,Subtotal,Discount,Service charge,Tax,Delivery charge,Tips,Total,Due\n");
        try (Session session = TicketDAO.getInstance().createNewSession();){
            Criteria criteria = session.createCriteria(Ticket.class);
            criteria.setProjection(Projections.rowCount());
            int n = POSUtil.getInteger(criteria.uniqueResult());
            GlassPane glassPane = (GlassPane)Application.getPosWindow().getGlassPane();
            glassPane.showMessage("Converting data to new format, this may take a while");
            glassPane.setProgressMaximum(n);
            int n2 = 1000;
            int n3 = 0;
            for (int i = 0; i < n; i += n2) {
                criteria = session.createCriteria(Ticket.class);
                criteria.addOrder(Order.asc((String)Ticket.PROP_ID));
                criteria.setFirstResult(i);
                criteria.setMaxResults(n2);
                List list = criteria.list();
                Transaction transaction = session.beginTransaction();
                for (Ticket ticket : list) {
                    Comparable comparable;
                    double d = ticket.getDueAmount();
                    boolean bl = ticket.getServiceCharge() > 0.0;
                    String string = String.format("%s,%s,%s,%s,%s,%s,%s,%s,%s,%s ", "Before", "t-" + ticket.getId(), ticket.getSubtotalAmount(), ticket.getDiscountAmount(), ticket.getServiceCharge(), ticket.getTaxAmount(), ticket.getDeliveryCharge(), ticket.getGratuityAmount(), ticket.getTotalAmount(), ticket.getDueAmount());
                    bufferedWriter.write(string + "\n");
                    List<TicketItem> list2 = ticket.getTicketItems();
                    for (TicketItem object2 : list2) {
                        object2.setServiceChargeApplicable(true);
                        object2.setDataVersion(1);
                        if (object2.getCreateDate() == null || object2.getCreateDate().compareTo(ticket.getCreateDate()) < 0) {
                            object2.setCreateDate(ticket.getCreateDate());
                        }
                        if (!ticket.isClosed().booleanValue() || object2.isVoided().booleanValue()) continue;
                        object2.setPaid(true);
                    }
                    Set<PosTransaction> set = ticket.getTransactions();
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        comparable = (PosTransaction)iterator.next();
                        ((BasePosTransaction)comparable).setServiceChargeAmount(0.0);
                        ((BasePosTransaction)comparable).setTaxAmount(0.0);
                        ((BasePosTransaction)comparable).setDataVersion(1);
                        ((BasePosTransaction)comparable).setFeeAmount(POSUtil.getDoubleAmount(((PosTransaction)comparable).getExtraProperty("transactionFee")));
                        if (((BasePosTransaction)comparable).getTransactionTime() != null && ((BasePosTransaction)comparable).getTransactionTime().compareTo(ticket.getCreateDate()) >= 0) continue;
                        ((BasePosTransaction)comparable).setTransactionTime(ticket.getCreateDate());
                    }
                    if (bl) {
                        ticket.setServiceChargeApplicable(true);
                        Double d2 = ticket.getSubtotalAmount();
                        comparable = ticket.getDiscountAmount();
                        Double d3 = ticket.getServiceCharge();
                        double d4 = d3 * 100.0 / (d2 - (Double)comparable);
                        ticket.setOutletServiceChargeRate(d4);
                    } else {
                        ticket.setServiceChargeApplicable(false);
                    }
                    ticket.calculatePrice();
                    double d4 = ticket.getDueAmount();
                    if (ticket.isClosed().booleanValue() && d == 0.0 && d != d4) {
                        ticket.setOldDataTolerance(d4 - d);
                        ticket.calculatePrice();
                    }
                    string = String.format("%s,%s,%s,%s,%s,%s,%s,%s,%s,%s", "After", "t-" + ticket.getId(), ticket.getSubtotalAmount(), ticket.getDiscountAmount(), ticket.getServiceCharge(), ticket.getTaxAmount(), ticket.getDeliveryCharge(), ticket.getGratuityAmount(), ticket.getTotalAmount(), ticket.getDueAmount());
                    bufferedWriter.write(string + "\n");
                    bufferedWriter.write(",,,,,,,,,\n");
                    ticket.setDataVersion(1);
                    TicketDAO.getInstance().update(ticket, session);
                    glassPane.setProgress(n3++);
                    bufferedWriter.flush();
                }
                transaction.commit();
            }
        }
    }

    private void a(PrintWriter printWriter) {
        try {
            List list;
            VoidItem voidItem2;
            List<VoidItem> list2 = VoidItemDAO.getInstance().findAll();
            if (list2 == null || list2.isEmpty()) {
                return;
            }
            HashMap hashMap = new HashMap();
            for (VoidItem voidItem2 : list2) {
                list = (List)hashMap.get(voidItem2.getTicketId());
                if (list == null) {
                    list = new ArrayList();
                    hashMap.put(voidItem2.getTicketId(), list);
                }
                list.add(voidItem2);
            }
            Transaction transaction = null;
            voidItem2 = TicketItemDAO.getInstance().createNewSession();
            list = null;
            try {
                transaction = voidItem2.beginTransaction();
                for (String string : hashMap.keySet()) {
                    List list3;
                    Ticket ticket = TicketDAO.getInstance().get(string, (Session)voidItem2);
                    if (ticket == null || (list3 = (List)hashMap.get(string)) == null || list3.size() <= 0) continue;
                    List<TicketItem> list4 = ticket.getTicketItems();
                    block13: for (TicketItem ticketItem : list4) {
                        for (VoidItem voidItem3 : list3) {
                            if (!ticketItem.isVoided().booleanValue() || ticketItem.getMenuItemId() == null || !ticketItem.getMenuItemId().equals(voidItem3.getMenuItemId()) || voidItem3.getTicketId() == null || !voidItem3.getTicketId().equals(ticket.getId())) continue;
                            ticketItem.setItemReturned(ticketItem.isReturned());
                            ticketItem.setVoidReason(voidItem3.getVoidReason());
                            ticketItem.setItemWasted(voidItem3.isItemWasted());
                            ticketItem.addProperty("voidedByUser", voidItem3.getVoidByUserId());
                            TicketItemDAO.getInstance().update(ticketItem, (Session)voidItem2);
                            continue block13;
                        }
                    }
                }
                transaction.commit();
            }
            catch (Throwable throwable) {
                list = throwable;
                throw throwable;
            }
            finally {
                if (voidItem2 != null) {
                    if (list != null) {
                        try {
                            voidItem2.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)((Object)list)).addSuppressed(throwable);
                        }
                    } else {
                        voidItem2.close();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            printWriter.write("Could not update voided ticket items");
        }
    }
}

