/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.extension.cronjob;

import com.floreantpos.PosLog;
import com.floreantpos.model.CronJob;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.util.NumberUtil;
import com.orocube.common.util.TicketStatus;
import java.util.List;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class DeliveryOrderKitchenSendingJob
extends CronJob {
    private static boolean b = false;

    public DeliveryOrderKitchenSendingJob() {
        this.setId("delivery-kitchen-sender");
        this.setJobName("Auto kitchen sending job");
        this.setFrequency("Every");
        this.setExecutionTime("-1:1");
    }

    @Override
    public synchronized void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        try {
            Outlet outlet = DataProvider.get().getOutlet();
            if (b || !outlet.isAutoSendOrdersToKitchen()) {
                return;
            }
            b = true;
            PosLog.debug(this.getClass(), "executing Kitchen Sending Job");
            String string = outlet.getProperty("deliveryConfig.preperationTime");
            int n = NumberUtil.parseOrGetZero(string).intValue();
            List<Ticket> list = TicketDAO.getInstance().findTicketsToSendToKitchen(n);
            for (Ticket ticket : list) {
                OrderType orderType;
                if (ticket.getTicketStatus() == TicketStatus.Pending || (orderType = ticket.getOrderType()) == null || !orderType.isShouldPrintToKitchen().booleanValue()) continue;
                TicketDAO.getInstance().loadFullTicket(ticket);
                ReceiptPrintService.printToKitchen(ticket);
            }
            b = false;
        }
        catch (Exception exception) {
            b = false;
            PosLog.error(this.getClass(), exception);
        }
    }
}

