/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.extension.cronjob;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.mailservices.MailAttachment;
import com.floreantpos.mailservices.MailService;
import com.floreantpos.model.CronJob;
import com.floreantpos.model.dao.CronJobDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.service.ItemwiseSalesReportService;
import com.floreantpos.report.service.PayoutReportService;
import com.floreantpos.report.service.SalesBalanceReportService;
import com.floreantpos.util.POSUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class EmailReportJob
extends CronJob {
    public static final String PROP_EMAIL = "EMAIL";
    public static final String PROP_EMAIL_REPORTS = "EMAIL_REPORTS_LIST";

    @Override
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        Date date;
        PosLog.info(this.getClass(), "Initializing email to send report...");
        Date date2 = date = new Date();
        Date date3 = DateUtil.startOfDay(date);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yy");
        try {
            CronJob cronJob = CronJobDAO.getInstance().get(jobExecutionContext.getJobDetail().getKey().getName());
            Map map = (Map)new ObjectMapper().readValue(cronJob.getProperties(), (TypeReference)new TypeReference<Map<String, String>>(){});
            String string = (String)map.get(PROP_EMAIL);
            String string2 = Messages.getString("EmailReportJob.0");
            String string3 = " ";
            ArrayList<MailAttachment> arrayList = new ArrayList<MailAttachment>();
            String string4 = (String)map.get(PROP_EMAIL_REPORTS);
            List<String> list = Arrays.asList(string4.split(","));
            for (String string5 : list) {
                int n = POSUtil.parseInteger(string5);
                switch (n) {
                    case 1: {
                        String string6 = "payout_report_" + simpleDateFormat.format(date3) + "_to_" + simpleDateFormat.format(date2) + ".pdf";
                        byte[] byArray = JasperExportManager.exportReportToPdf((JasperPrint)new PayoutReportService().createJasperPrint(date3, date2));
                        arrayList.add(new MailAttachment(string6, byArray));
                        break;
                    }
                    case 2: {
                        String string7 = "sales_report_" + simpleDateFormat.format(date3) + "_to_" + simpleDateFormat.format(date2) + ".pdf";
                        byte[] byArray = JasperExportManager.exportReportToPdf((JasperPrint)new ItemwiseSalesReportService(date3, date2, null, null, true, false, true).createJasperPrint());
                        arrayList.add(new MailAttachment(string7, byArray));
                        break;
                    }
                    case 3: {
                        String string8 = "sales_balance_report_" + simpleDateFormat.format(date3) + ".pdf";
                        byte[] byArray = JasperExportManager.exportReportToPdf((JasperPrint)SalesBalanceReportService.createSalesBalanceReport(date3, date2, null));
                        arrayList.add(new MailAttachment(string8, byArray));
                    }
                }
            }
            if (MailService.sendMailWithAttchments(string, string2, string3, arrayList)) {
                PosLog.info(this.getClass(), "Successfully send email to " + string + " ...");
            } else {
                PosLog.error(this.getClass(), "Unable to send email to " + string + " ...");
            }
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), "Runtime error occured in sending email...", exception);
        }
    }
}

