/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.extension.cronjob;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.mailservices.MailService;
import com.floreantpos.model.CronJob;
import com.floreantpos.model.dao.CronJobDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.service.SalesBalanceReportService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class EmailSalesBalanceReportJob
extends CronJob {
    @Override
    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        Date date = new Date();
        Date date2 = DateUtil.startOfDay(date);
        Date date3 = date;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yy");
        try {
            CronJob cronJob = CronJobDAO.getInstance().get(jobExecutionContext.getJobDetail().getKey().getName());
            Map map = (Map)new ObjectMapper().readValue(cronJob.getProperties(), (TypeReference)new TypeReference<Map<String, String>>(){});
            String string = (String)map.get("EMAIL");
            String string2 = Messages.getString("EmailSalesBalanceReportJob.0");
            String string3 = " ";
            String string4 = "sales_balance_report_" + simpleDateFormat.format(date2) + ".pdf";
            byte[] byArray = JasperExportManager.exportReportToPdf((JasperPrint)SalesBalanceReportService.createSalesBalanceReport(date2, date3, null));
            if (MailService.sendMail(string, string2, string3, string4, string4, byArray)) {
                PosLog.info(this.getClass(), "Successfully send email to " + string + " ...");
            } else {
                PosLog.error(this.getClass(), "Unable to send email to " + string + " ...");
            }
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), "Runtime error occured in sending email...", exception);
        }
    }
}

