/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.main;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.actions.ShutDownAction;
import com.floreantpos.config.AppConfig;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.extension.AbstractFloreantPlugin;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.licensing.PluginListDialog;
import com.floreantpos.licensing.ProductLicenseInfo;
import com.floreantpos.main.Application;
import com.floreantpos.main.ProcessUtil;
import com.floreantpos.main.update.UpdateManager;
import com.floreantpos.model.CronJob;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.CronJobDAO;
import com.floreantpos.model.util.CacheRefreshListener;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.GlassPane;
import com.floreantpos.swing.PosBlinkButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.ProgressObserver;
import com.floreantpos.ui.RefreshableTicketList;
import com.floreantpos.ui.dialog.AutoLogOffAlertDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.kitchendisplay.LineDisplayWindow;
import com.floreantpos.ui.views.IView;
import com.floreantpos.ui.views.LoginView;
import com.floreantpos.ui.views.OrderInfoDialog;
import com.floreantpos.ui.views.OrderInfoView;
import com.floreantpos.ui.views.SwitchboardView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.ui.views.payment.BusyDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.PosGuiUtil;
import com.floreantpos.webservice.PosWebService;
import com.orocube.common.about.dialog.OroCommonLicenceActivationDialog;
import com.orocube.common.util.TerminalUtil;
import com.orocube.common.util.TicketStatus;
import com.orocube.licensemanager.OroLicense;
import com.orocube.licensemanager.ui.LicenseSelectionListener;
import com.orocube.licensemanager.ui.PluginMessageDialog;
import com.orocube.rest.service.mqtt.OroMqttDataListener;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import jiconfont.IconCode;
import jiconfont.icons.GoogleMaterialDesignIcons;
import jiconfont.swing.IconFontSwing;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.apache.commons.lang.StringUtils;

public class PosWindow
extends JFrame
implements CacheRefreshListener,
ProgressObserver,
OroMqttDataListener,
WindowListener {
    private static final String a = Messages.getString("PosWindow.4");
    private static final String b = "extendedstate";
    private static final String c = "wlocy";
    private static final String d = "wlocx";
    private static final String e = "wheight";
    private static final String f = "wwidth";
    private GlassPane g;
    private JLabel h;
    private static final SimpleDateFormat i = new SimpleDateFormat("hh:mm:ss aaa");
    private JLabel j;
    private JLabel k;
    private JLabel l;
    private JLabel m;
    private JLabel n;
    private JLabel o;
    private PosBlinkButton p;
    private Timer q;
    private Timer r;
    private Timer s;
    private final AutoLogoffHandler t = new AutoLogoffHandler();
    private JPanel u;
    private JSeparator v;
    private JButton w;
    private final CircularFifoQueue<Ticket> x = new CircularFifoQueue(20);
    private JLabel y;
    private JSeparator z;

    public void initComponents() {
        this.setIconImage(Application.getApplicationIcon().getImage());
        this.g = new GlassPane();
        this.g.setOpacity(0.6f);
        this.setGlassPane(this.g);
        this.h = new JLabel();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JSeparator(0), "North");
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("fillx, ins 5 3 5 5", "[][][]", "[]"));
        jPanel2.setOpaque(true);
        Font font = this.h.getFont().deriveFont(1, PosUIManager.getFontSize(10));
        this.j = new JLabel();
        this.l = new JLabel(Messages.getString("PosWindow.3") + TerminalConfig.getTerminalId());
        this.k = new JLabel();
        this.m = new JLabel();
        this.n = new JLabel("");
        this.n.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.o = new JLabel("");
        this.o.setForeground(Color.RED);
        this.p = new PosBlinkButton(Messages.getString("NewOrderReceived"));
        this.p.setPreferredSize(PosUIManager.getSize(0, 20));
        this.j.setFont(font);
        this.k.setFont(font);
        this.l.setFont(font);
        this.m.setFont(font);
        this.n.setFont(font);
        this.o.setFont(font);
        this.p.setFont(font);
        jPanel2.add(this.j);
        jPanel2.add(this.l);
        jPanel2.add(this.k);
        jPanel2.add((Component)this.m, "grow");
        this.u = new JPanel((LayoutManager)new MigLayout("right, filly,hidemode 3, ins 0 0 0 0"));
        this.u.add(this.o);
        this.w = new JButton();
        this.w.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.INFO, (float)15.0f));
        this.w.setToolTipText(Messages.getString("PosWindow.1"));
        this.u.add(this.w);
        this.updateVissabityOfLicenceInfo(false);
        this.w.addActionListener(actionEvent -> this.a());
        this.z = new JSeparator(1);
        this.z.setVisible(false);
        this.u.add((Component)this.z, "growy");
        this.y = new JLabel();
        this.u.add(this.y);
        this.v = new JSeparator(1);
        this.u.add((Component)this.v, "growy");
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)this.u, "Center");
        jPanel.add((Component)this.n, "East");
        this.getContentPane().add((Component)jPanel, "South");
        this.c();
        DataProvider.get().addCacheRefreshListener(this);
    }

    private void a() {
        try {
            Application.getInstance().initLicense(TerminalUtil.getSystemUID());
            final ArrayList<AbstractFloreantPlugin> arrayList = new ArrayList<AbstractFloreantPlugin>();
            List<AbstractFloreantPlugin> list = ExtensionManager.getBusinessPlugins();
            if (list != null) {
                for (AbstractFloreantPlugin object : list) {
                    ProductLicenseInfo productLicenseInfo;
                    if (object.getLicense() == null || object.getLicense().getExpiryDate() == null || !(productLicenseInfo = new ProductLicenseInfo(object.getLicense())).isExpired()) continue;
                    arrayList.add(object);
                }
            }
            if (arrayList.size() > 0) {
                final BusyDialog busyDialog = new BusyDialog();
                busyDialog.setCaption(Messages.getString("CheckingLicenseForPlugins"));
                SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){
                    boolean a = false;

                    @Override
                    protected Void doInBackground() throws Exception {
                        for (AbstractFloreantPlugin abstractFloreantPlugin : arrayList) {
                            try {
                                OroLicense oroLicense = OroCommonLicenceActivationDialog.loadAndValidateOnlineLicense((OroLicense)abstractFloreantPlugin.getLicense());
                                if (oroLicense == null || !oroLicense.isValid()) continue;
                                abstractFloreantPlugin.setLicense(oroLicense);
                                this.a = true;
                            }
                            catch (Exception exception) {
                                PosLog.error(this.getClass(), exception.getMessage());
                            }
                        }
                        return null;
                    }

                    @Override
                    protected void done() {
                        busyDialog.dispose();
                        if (this.a) {
                            PosWindow.this.i();
                        }
                        PosWindow.this.b();
                    }
                };
                swingWorker.execute();
                busyDialog.open();
            } else {
                this.b();
            }
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    private void b() {
        PluginListDialog pluginListDialog = new PluginListDialog(Messages.getString("LicenseStatus"));
        pluginListDialog.setSize(PosUIManager.getSize(600, 500));
        pluginListDialog.open();
    }

    public void initTimers() {
        this.q = new Timer(1000, new ClockTimerHandler());
        this.q.start();
        if (TerminalConfig.isCheckUpdateOnStartUp()) {
            this.s = new Timer(900000, new UpdateCheckHandler());
            this.s.start();
        }
    }

    private void c() {
        this.addWindowListener(this);
        this.o.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                PosWindow.this.g();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                super.mouseEntered(mouseEvent);
                PosWindow.this.o.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                super.mouseExited(mouseEvent);
                PosWindow.this.o.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        this.p.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                PosWindow.this.h();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                PosWindow.this.p.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                PosWindow.this.p.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
    }

    public void rendererUserInfo() {
        User user = Application.getCurrentUser();
        if (user != null) {
            this.k.setText(Messages.getString("PosWindow.6") + user.getFullName() + " (" + user.getType().getName() + ")");
        } else {
            this.k.setText("");
        }
    }

    public void setRestaurantName(String string) {
        this.j.setText(string);
    }

    public void setStatus(String string) {
        this.h.setText(string);
    }

    public void setupSizeAndLocation() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(AppConfig.getInt(f, (int)dimension.getWidth()), AppConfig.getInt(e, (int)dimension.getHeight()));
        this.setLocation(AppConfig.getInt(d, dimension.width - this.getWidth() >> 1), AppConfig.getInt(c, dimension.height - this.getHeight() >> 1));
        this.setMinimumSize(new Dimension(1024, 724));
        this.setDefaultCloseOperation(0);
        int n = AppConfig.getInt(b, -1);
        if (n != -1) {
            this.setExtendedState(n);
        }
    }

    public void enterFullScreenMode() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(dimension);
        this.setExtendedState(6);
        this.setUndecorated(true);
        this.setLocation(0, 0);
    }

    public void leaveFullScreenMode() {
        GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()[0];
        this.setUndecorated(false);
        graphicsDevice.setFullScreenWindow(null);
    }

    public void saveSizeAndLocation() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        AppConfig.putInt(f, n);
        AppConfig.putInt(e, n2);
        Point point = this.getLocationOnScreen();
        AppConfig.putInt(d, point.x);
        AppConfig.putInt(c, point.y);
        AppConfig.putInt(b, this.getExtendedState());
        Window[] windowArray = Window.getWindows();
        boolean bl = false;
        for (Window window : windowArray) {
            if (!(window instanceof LineDisplayWindow)) continue;
            LineDisplayWindow lineDisplayWindow = (LineDisplayWindow)window;
            bl = lineDisplayWindow.isVisible();
            lineDisplayWindow.saveSizeAndLocation();
        }
        AppConfig.put("ldwvisible", bl);
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.d();
        } else {
            this.e();
        }
    }

    private void d() {
        if (this.q != null) {
            this.q.start();
        }
    }

    private void e() {
        if (this.q != null) {
            this.q.stop();
        }
    }

    public void startAutoLogoffTimer() {
        this.stopAutoLogoffTimer();
        Terminal terminal = DataProvider.get().getCurrentTerminal();
        if (terminal != null && terminal.isIsAutoLogOffEnabled().booleanValue()) {
            this.r = new Timer(terminal.getAutoLogOffSec() * 1000, this.t);
            this.r.start();
            Toolkit.getDefaultToolkit().addAWTEventListener(this.t, 131128L);
        }
    }

    public void stopAutoLogoffTimer() {
        if (this.r != null && this.r.isRunning()) {
            this.r.stop();
        }
        this.r = null;
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.t);
    }

    private void f() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(i.format(Calendar.getInstance().getTime()));
        this.n.setText(stringBuilder.toString());
    }

    public void checkForUpdate() {
        UpdateManager updateManager = Application.getInstance().getUpdateManager();
        if (!updateManager.isUpdateAvailable()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Messages.getString("PosWindow.0"));
        this.o.setText(stringBuilder.toString());
        if (this.s != null) {
            this.s.stop();
        }
    }

    public void setGlassPaneVisible(boolean bl) {
        this.g.setVisible(bl);
    }

    public void updateVissabityOfLicenceInfo(boolean bl) {
        if (this.w != null) {
            this.w.setVisible(bl);
        }
    }

    public void updateView() {
        CronJob cronJob;
        this.l.setText(Messages.getString("PosWindow.10") + TerminalConfig.getTerminalId());
        this.y.setVisible(false);
        this.z.setVisible(false);
        Terminal terminal = DataProvider.get().getCurrentTerminal();
        if (terminal != null && (cronJob = CronJobDAO.getInstance().get("cloud_auto_sync")) != null) {
            Boolean bl = terminal.isMasterTerminal() != false && PosWebService.get().isConnected() && cronJob.isActive() != false;
            this.y.setVisible(bl);
            this.z.setVisible(bl != false && StringUtils.isNotBlank((String)this.y.getText()));
        }
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        if (Application.getCurrentUser() != null) {
            new ShutDownAction().actionPerformed(null);
        } else {
            Application.getInstance().shutdownPOS();
        }
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    private void g() {
        try {
            if (this.s != null && this.s.isRunning()) {
                this.s.stop();
            }
            Application.getInstance().checkForUpdate();
            if (this.s != null) {
                this.s.start();
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    @Override
    public void ticketReceived(List<Ticket> list) {
        boolean bl = false;
        for (Ticket ticket : list) {
            if (ticket.getTicketStatus() != TicketStatus.Pending && !ticket.isShowNewOrderNotification()) continue;
            if (!this.x.contains((Object)ticket)) {
                this.x.add((Object)ticket);
                bl = true;
            }
            ticket.setShowNewOrderNotification(false);
        }
        if (!bl) {
            return;
        }
        this.u.add(this.p);
        this.u.add((Component)this.v, "growy");
        this.u.revalidate();
        this.u.repaint();
        this.p.setText(Messages.getString("NewOrderReceived") + " (" + this.x.size() + ")");
        this.p.setBlinking(true);
        this.p.setVisible(true);
        this.toFront();
        POSUtil.beep();
    }

    @Override
    public void cacheRefreshed() {
        this.updateView();
    }

    private void h() {
        try {
            RootView rootView = RootView.getInstance();
            IView iView = rootView.getCurrentView();
            User user = Application.getCurrentUser();
            if (user == null || iView == null || iView instanceof LoginView) {
                OrderType orderType = DataProvider.get().getDeliveryOrderType();
                if (orderType != null) {
                    TerminalConfig.setDefaultView(orderType.getId());
                    LoginView.getInstance().doLogin();
                } else {
                    LoginView.getInstance().doLogin();
                    if (rootView.getCurrentView() != null && !SwitchboardView.VIEW_NAME.equals(rootView.getCurrentView().getViewName())) {
                        rootView.showView(SwitchboardView.getInstance());
                    }
                }
            }
            iView = rootView.getCurrentView();
            user = Application.getCurrentUser();
            if (user == null || iView == null || iView instanceof LoginView) {
                return;
            }
            int n = 1;
            for (Ticket ticket : this.x) {
                ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
                arrayList.add(ticket);
                OrderInfoView orderInfoView = new OrderInfoView(arrayList);
                OrderInfoDialog orderInfoDialog = new OrderInfoDialog(orderInfoView);
                orderInfoDialog.setTitle(Messages.getString("PosWindow.8") + " " + n++);
                orderInfoDialog.updateView();
                orderInfoDialog.pack();
                orderInfoDialog.setSize(orderInfoDialog.getSize().width + 50, PosUIManager.getSize(650));
                orderInfoDialog.setLocationRelativeTo(Application.getPosWindow());
                orderInfoDialog.setVisible(true);
            }
            IView iView2 = RootView.getInstance().getCurrentView();
            if (iView2 instanceof RefreshableTicketList) {
                iView2.refresh();
            }
            this.x.clear();
            this.p.setVisible(false);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    public void clearMqttTickets() {
        this.x.clear();
        this.p.setVisible(false);
    }

    private void i() {
        try {
            PluginMessageDialog.show((Component)this, (LicenseSelectionListener)new LicenseSelectionListener(){

                public void restartPOS(boolean bl) {
                    try {
                        ProcessUtil.restart();
                    }
                    catch (Exception exception) {
                        PosLog.error(this.getClass(), exception);
                    }
                }

                public void licenseFileSelected(File file) throws Exception {
                }

                public OroLicense getLicense() throws Exception {
                    return null;
                }
            }, null, (String)Messages.getString("OroCommonLicenceActivationDialog.7"), (boolean)false);
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    @Override
    public void progress(int n) {
    }

    @Override
    public void progress(String string) {
        this.y.setText(string);
        this.z.setVisible(Boolean.TRUE);
    }

    @Override
    public void progress(int n, String string) throws Exception {
        String string2 = string + " " + n + "%";
        PosLog.debug(this.getClass(), string2);
        this.y.setText(a + ": " + string2);
        this.z.setVisible(Boolean.TRUE);
    }

    @Override
    public void progressComplete(boolean bl) {
        if (bl) {
            this.y.setText(a + ":  \u2714");
            this.y.setToolTipText(a + Messages.getString("PosWindow.5"));
        } else {
            this.y.setText(a + ":  \u274c");
            this.y.setToolTipText(a + Messages.getString("PosWindow.7"));
        }
    }

    @Override
    public Component getParentComponent() {
        return null;
    }

    private class AutoLogoffHandler
    implements AWTEventListener,
    ActionListener {
        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            this.reset();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!PosWindow.this.isShowing()) {
                return;
            }
            if (PosGuiUtil.isModalDialogShowing()) {
                return;
            }
            if (PosWindow.this.r != null && PosWindow.this.r.isRunning()) {
                PosWindow.this.r.stop();
            }
            AutoLogOffAlertDialog autoLogOffAlertDialog = new AutoLogOffAlertDialog();
            autoLogOffAlertDialog.pack();
            autoLogOffAlertDialog.open();
            if (autoLogOffAlertDialog.isCanceled()) {
                PosWindow.this.r.restart();
                return;
            }
            Application.getInstance().doAutoLogout();
        }

        public void reset() {
            if (PosWindow.this.r != null && PosWindow.this.r.isRunning()) {
                PosWindow.this.r.restart();
            }
        }
    }

    private class UpdateCheckHandler
    implements ActionListener {
        private UpdateCheckHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PosWindow.this.checkForUpdate();
        }
    }

    private class ClockTimerHandler
    implements ActionListener {
        private ClockTimerHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!PosWindow.this.isShowing()) {
                PosWindow.this.q.stop();
                return;
            }
            PosWindow.this.f();
        }
    }
}

