/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.PropertyContainer;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseGratuity;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.util.DataProvider;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"ticket"})
@XmlRootElement
public class Gratuity
extends BaseGratuity
implements PropertyContainer,
TimedModel {
    private static final String AUTO_CALCULATED = "auto_calculated";
    private static final long serialVersionUID = 1L;
    private transient boolean syncEdited;
    private transient Ticket ticket;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    private Double transactionTipsAmount;
    private transient JsonObject propertiesContainer;

    public Gratuity() {
        this.setAutoCalculated(false);
    }

    public void calculateTransactionTips() {
        this.transactionTipsAmount = PosTransactionDAO.getInstance().getTipsAmount(this.getTicketId());
    }

    public Double getTransactionTipsAmount() {
        if (this.transactionTipsAmount == null) {
            this.calculateTransactionTips();
        }
        return this.transactionTipsAmount;
    }

    public Ticket getTicket() {
        if (this.ticket == null && StringUtils.isNotEmpty((String)this.getTicketId())) {
            this.ticket = (Ticket)DataProvider.get().getObjectOf(Ticket.class, (Serializable)((Object)this.getTicketId()));
        }
        return this.ticket;
    }

    public boolean isSyncEdited() {
        return this.syncEdited;
    }

    public void setSyncEdited(boolean bl) {
        this.syncEdited = bl;
    }

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean bl) {
        this.updateSyncTime = bl;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean bl) {
        this.updateLastUpdateTime = bl;
    }

    @Override
    public String getProperties() {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.toString();
        }
        String string = super.getProperties();
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
        return string;
    }

    @Override
    public void setProperties(String string) {
        super.setProperties(string);
        this.propertiesContainer = StringUtils.isNotEmpty((String)string) ? (JsonObject)new Gson().fromJson(string, JsonObject.class) : new JsonObject();
    }

    @Override
    public JsonObject getPropertyStore() {
        if (this.propertiesContainer == null) {
            String string = super.getProperties();
            this.propertiesContainer = StringUtils.isBlank((String)string) ? new JsonObject() : (JsonObject)new Gson().fromJson(string, JsonObject.class);
        }
        return this.propertiesContainer;
    }

    @Override
    public void addProperty(String string, String string2) {
        this.getPropertyStore().addProperty(string, string2);
        super.setProperties(this.getPropertyStore().toString());
    }

    @Override
    public void removeProperty(String string) {
        if (this.getPropertyStore() != null) {
            this.getPropertyStore().remove(string);
        }
        super.setProperties(this.getPropertyStore().toString());
    }

    public boolean isAutoCalculated() {
        return Boolean.valueOf(this.getProperty(AUTO_CALCULATED));
    }

    public void setAutoCalculated(boolean bl) {
        this.addProperty(AUTO_CALCULATED, String.valueOf(bl));
    }
}

