/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import org.apache.commons.lang.StringUtils;

public interface PropertyContainer {
    @JsonIgnore
    public JsonObject getPropertyStore();

    default public boolean hasProperty(String string) {
        return this.getPropertyStore().has(string);
    }

    default public String getProperty(String string) {
        if (this.getPropertyStore().has(string)) {
            JsonElement jsonElement = this.getPropertyStore().get(string);
            if (jsonElement instanceof JsonNull) {
                return "";
            }
            return jsonElement.getAsString();
        }
        return null;
    }

    default public String getProperty(String string, String string2) {
        if (this.getPropertyStore().has(string)) {
            JsonElement jsonElement = this.getPropertyStore().get(string);
            if (jsonElement instanceof JsonNull) {
                return "";
            }
            return jsonElement.getAsString();
        }
        return string2;
    }

    default public Boolean getBooleanProperty(String string, boolean bl) {
        JsonElement jsonElement = this.getPropertyStore().get(string);
        if (jsonElement == null) {
            return bl;
        }
        return jsonElement.getAsBoolean();
    }

    default public double getDoubleProperty(String string) {
        return PropertyContainer.parseDouble(this.getProperty(string));
    }

    default public int getIntProperty(String string) {
        return (int)PropertyContainer.parseDouble(this.getProperty(string));
    }

    default public void addProperty(String string, String string2) {
        this.getPropertyStore().addProperty(string, string2);
    }

    default public void removeProperty(String string) {
        if (this.getPropertyStore() != null) {
            this.getPropertyStore().remove(string);
        }
    }

    public static double parseDouble(String string) {
        if (StringUtils.isBlank((String)string)) {
            return 0.0;
        }
        try {
            return Double.parseDouble(string);
        }
        catch (Exception exception) {
            return 0.0;
        }
    }
}

