/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.Messages;
import com.floreantpos.model.PurchaseOrderItem;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BasePurchaseOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@XmlRootElement
@JsonIgnoreProperties(ignoreUnknown=true, value={"statusDisplay", "orderStatusDisplay"})
public class PurchaseOrder
extends BasePurchaseOrder
implements TimedModel {
    private static final long serialVersionUID = 1L;
    public static final int ORDER_PENDING = 0;
    public static final int ORDER_VERIFIED = 1;
    public static final int ORDER_FULLY_INVOICED = 2;
    public static final int ORDER_PARTIALLY_INVOICED = 3;
    public static final int ORDER_FULLY_RECEIVED = 4;
    public static final int ORDER_PARTIALLY_RECEIVED = 5;
    public static final int ORDER_PARTIALLY_RECEIVED_AND_INVOICED = 6;
    public static final int ORDER_CLOSED = 7;
    public static final int ORDER_CANCELLED = 8;
    public static final String[] ORDER_STATUS = new String[]{Messages.getString("PurchaseOrder.0"), Messages.getString("PurchaseOrder.1"), Messages.getString("PurchaseOrder.2"), Messages.getString("PurchaseOrder.3"), Messages.getString("PurchaseOrder.4"), Messages.getString("PurchaseOrder.5"), Messages.getString("PurchaseOrder.6"), Messages.getString("PurchaseOrder.7"), Messages.getString("PurchaseOrder.8")};
    public static final String PO_VERIFIED_BY = Messages.getString("PurchaseOrder.9");
    public static final String PO_SENT_BY = Messages.getString("PurchaseOrder.10");
    public static final String PO_RECEIVED_BY = Messages.getString("PurchaseOrder.11");
    public static final String PO_INVOICED_BY = Messages.getString("PurchaseOrder.12");
    public static final String PO_CLOSED_BY = Messages.getString("PurchaseOrder.13");
    public String orderStatusDisplay;
    public static final String DEBIT = Messages.getString("PurchaseOrder.14");
    public static final String CREDIT = Messages.getString("PurchaseOrder.15");
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    public String statusDisplay;

    public PurchaseOrder() {
    }

    public PurchaseOrder(String string) {
        super(string);
    }

    @XmlTransient
    public String getOrderStatusDisplay() {
        return ORDER_STATUS[this.getStatus()];
    }

    public void setOrderStatusDisplay(String string) {
        this.orderStatusDisplay = ORDER_STATUS[this.getStatus()];
    }

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean bl) {
        this.updateSyncTime = bl;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean bl) {
        this.updateLastUpdateTime = bl;
    }

    @Override
    public List<PurchaseOrderItem> getOrderItems() {
        List<PurchaseOrderItem> list = super.getOrderItems();
        if (list == null) {
            list = new ArrayList<PurchaseOrderItem>();
            super.setOrderItems(list);
        }
        return list;
    }

    public void calculatePrice() {
        List<PurchaseOrderItem> list = this.getOrderItems();
        if (list == null) {
            return;
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (PurchaseOrderItem purchaseOrderItem : list) {
            purchaseOrderItem.calculatePrice();
            d += purchaseOrderItem.getSubtotalAmount().doubleValue();
            d2 += purchaseOrderItem.getDiscountAmount().doubleValue();
            d3 += purchaseOrderItem.getTaxAmount().doubleValue();
        }
        this.setSubtotalAmount(d);
        this.setDiscountAmount(d2);
        this.setTaxAmount(d3);
        double d4 = d - d2 + d3;
        d4 = this.fixInvalidAmount(d4);
        this.setTotalAmount(d4);
        double d5 = d4 - this.getPaidAmount();
        this.setDueAmount(d5);
    }

    private double fixInvalidAmount(double d) {
        if (d < 0.0 || Double.isNaN(d)) {
            d = 0.0;
        }
        return d;
    }

    public void addProperty(String string, String string2) {
        if (this.getProperties() == null) {
            this.setProperties(new HashMap<String, String>());
        }
        this.getProperties().put(string, string2);
    }

    public boolean hasProperty(String string) {
        return this.getProperty(string) != null;
    }

    public String getProperty(String string) {
        if (this.getProperties() == null) {
            return null;
        }
        return this.getProperties().get(string);
    }

    public String getProperty(String string, String string2) {
        if (this.getProperties() == null) {
            return null;
        }
        String string3 = this.getProperties().get(string);
        if (StringUtils.isEmpty((String)string3)) {
            return string2;
        }
        return string3;
    }

    public void removeProperty(String string) {
        Map<String, String> map = this.getProperties();
        if (map == null) {
            return;
        }
        map.remove(string);
    }

    @XmlTransient
    public String getStatusDisplay() {
        int n = this.getStatus();
        if (n == 0) {
            return Messages.getString("PurchaseOrder.16");
        }
        if (n == 1 || n == 5) {
            return Messages.getString("PurchaseOrder.17");
        }
        return "";
    }

    public void setStatusDisplay(String string) {
        this.statusDisplay = string;
    }
}

