/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.IconFactory;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PropertyContainer;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseShopFloor;
import com.floreantpos.model.util.DataProvider;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.Color;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonIgnoreProperties(ignoreUnknown=true, value={"foregroundColor", "backgroundColor", "floorSize", "image", "orderTypes"})
public class ShopFloor
extends BaseShopFloor
implements PropertyContainer,
TimedModel {
    public static final String JSON_PROP_ID = "id";
    public static final String JSON_PROP_ORDER_TYPES = "orderTypes";
    private static final long serialVersionUID = 1L;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    private transient JsonObject propertiesContainer;

    public ShopFloor() {
    }

    public ShopFloor(String string) {
        super(string);
    }

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean bl) {
        this.updateSyncTime = bl;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean bl) {
        this.updateLastUpdateTime = bl;
    }

    @XmlTransient
    public ImageIcon getImage() {
        return IconFactory.getIconFromImageResource(this.getImageId());
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public boolean hasTableWithNumber(String string) {
        Set<ShopTable> set = this.getTables();
        if (set == null) {
            return false;
        }
        for (ShopTable shopTable : set) {
            if (!shopTable.getTableNumber().equals(string)) continue;
            return true;
        }
        return false;
    }

    @XmlTransient
    public Color getForegroundColor() {
        if (this.getForegroundColorCode() == null) {
            return null;
        }
        return new Color(this.getForegroundColorCode());
    }

    public void setForegroundColor(Color color) {
        if (color != null) {
            this.setForegroundColorCode(color.getRGB());
        }
    }

    @XmlTransient
    public Color getBackgroundColor() {
        if (this.getBackgroundColorCode() == null) {
            return null;
        }
        return new Color(this.getBackgroundColorCode());
    }

    public void setBackgroundColor(Color color) {
        if (color != null) {
            this.setBackgroundColorCode(color.getRGB());
        }
    }

    @XmlTransient
    public Dimension getFloorSize() {
        Integer n = this.getHeight();
        Integer n2 = this.getWidth();
        if (n2 <= 0) {
            n2 = 850;
        }
        if (n <= 0) {
            n = 500;
        }
        return new Dimension(n2, n);
    }

    @Override
    public String getProperties() {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.toString();
        }
        String string = super.getProperties();
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
        return string;
    }

    @Override
    public void setProperties(String string) {
        super.setProperties(string);
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
    }

    @Override
    public JsonObject getPropertyStore() {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = new JsonObject();
        }
        return this.propertiesContainer;
    }

    public void setOrderTypes(List<OrderType> list) {
        if (list == null || list.isEmpty()) {
            if (this.propertiesContainer != null) {
                this.propertiesContainer.remove(JSON_PROP_ORDER_TYPES);
            }
            return;
        }
        if (this.propertiesContainer == null) {
            this.propertiesContainer = this.getPropertyStore();
        }
        JsonArray jsonArray = new JsonArray();
        for (OrderType orderType : list) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty(OrderType.PROP_ID, orderType.getId());
            jsonArray.add((JsonElement)jsonObject);
        }
        this.propertiesContainer.add(JSON_PROP_ORDER_TYPES, (JsonElement)jsonArray);
    }

    @XmlTransient
    public List<OrderType> getOrderTypes() {
        ArrayList<OrderType> arrayList = new ArrayList<OrderType>();
        if (this.propertiesContainer == null) {
            return arrayList;
        }
        JsonArray jsonArray = this.propertiesContainer.getAsJsonArray(JSON_PROP_ORDER_TYPES);
        if (jsonArray == null || jsonArray.isJsonNull()) {
            return arrayList;
        }
        for (JsonElement jsonElement : jsonArray) {
            OrderType orderType;
            JsonElement jsonElement2;
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            if (jsonObject == null || (jsonElement2 = jsonObject.get(JSON_PROP_ID)) == null || (orderType = DataProvider.get().getOrderType(jsonElement2.getAsString())) == null) continue;
            arrayList.add(orderType);
        }
        return arrayList;
    }
}

