/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.Department;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PropertyContainer;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.TerminalType;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.User;
import com.floreantpos.model.base.BaseTerminal;
import com.floreantpos.model.dao.DepartmentDAO;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.model.dao.SalesAreaDAO;
import com.floreantpos.model.ext.DeviceType;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"showServerName", "assignedUser", "outlet", "department", "salesArea", "terminalType"})
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="terminal")
public class Terminal
extends BaseTerminal
implements PropertyContainer,
TimedModel {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROP_PRINT_RECIEPT_ON_BUMP = "printReceiptOnBump";
    public static final String JSON_ENABLE_ITEM_DETAIL_SHOWING = "enableItemDetailShowing";
    public static final int TYPE_MOBILE = 1;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    private transient JsonObject propertiesContainer;
    private transient String deviceName;

    public Terminal() {
    }

    public Terminal(Integer n) {
        super(n);
    }

    public User getAssignedUser() {
        return DataProvider.get().getUserById(this.getAssignedUserId());
    }

    public void setAssignedUser(User user) {
        this.setAssignedUserId(user == null ? null : user.getId());
    }

    @Transient
    public Outlet getOutlet() {
        String string = this.getOutletId();
        if (string == null) {
            return null;
        }
        return OutletDAO.getInstance().get(string);
    }

    public void setOutlet(Outlet outlet) {
        this.setOutletId(outlet == null ? null : outlet.getId());
    }

    @Transient
    public Department getDepartment() {
        if (this.getDepartmentId() == null) {
            return null;
        }
        return DepartmentDAO.getInstance().get(this.getDepartmentId());
    }

    public void setDepartment(Department department) {
        this.setDepartmentId(department == null ? null : department.getId());
    }

    public SalesArea getSalesArea() {
        if (this.getSalesAreaId() == null) {
            return null;
        }
        return SalesAreaDAO.getInstance().get(this.getSalesAreaId());
    }

    public void setSalesArea(SalesArea salesArea) {
        this.setSalesAreaId(salesArea == null ? null : salesArea.getId());
    }

    @Transient
    public TerminalType getTerminalType() {
        return DataProvider.get().getTerminalType(this.getTerminalTypeId());
    }

    public void setTerminalType(TerminalType terminalType) {
        this.setTerminalTypeId(terminalType == null ? null : terminalType.getId());
    }

    public boolean isCashDrawerAssigned() {
        return this.getAssignedUser() != null;
    }

    @Override
    public String toString() {
        return StringUtils.isBlank((String)this.getName()) ? String.valueOf(this.getId()) : this.getName();
    }

    public boolean isShowTableNumber() {
        return this.getProperty("floorplan.showTableNumber") == null ? true : Boolean.valueOf(this.getProperty("floorplan.showTableNumber"));
    }

    public boolean isShowServerName() {
        return this.getProperty("floorplan.showServerName") == null ? true : Boolean.valueOf(this.getProperty("floorplan.showServerName"));
    }

    public boolean isShowTokenNum() {
        return this.getProperty("floorplan.showTokenName") == null ? true : Boolean.valueOf(this.getProperty("floorplan.showTokenName"));
    }

    public boolean isAutoPrintReceipt() {
        return Boolean.valueOf(this.getProperty("auto_print_receipt", "false"));
    }

    public void setAutoPrintReceipt(boolean bl) {
        this.addProperty("auto_print_receipt", String.valueOf(bl));
    }

    public void setPrimaryFontSize(int n) {
        this.addProperty("floorplan.primaryFontSize", String.valueOf(n));
    }

    public int getPrimaryFontSize() {
        return this.getProperty("floorplan.primaryFontSize") == null ? 12 : Integer.valueOf(this.getProperty("floorplan.primaryFontSize"));
    }

    public void setSecondaryFontSize(int n) {
        this.addProperty("floorplan.secondaryFontSize", String.valueOf(n));
    }

    public int getSecondaryFontSize() {
        return this.getProperty("floorplan.secondaryFontSize") == null ? 2 : Integer.valueOf(this.getProperty("floorplan.secondaryFontSize"));
    }

    public void setBtnWidth(int n) {
        this.addProperty("floorplan.btnWidth", String.valueOf(n));
    }

    public int getBtnWidth() {
        return this.getProperty("floorplan.btnWidth") == null ? 40 : Integer.valueOf(this.getProperty("floorplan.btnWidth"));
    }

    public void setBtnHeight(int n) {
        this.addProperty("floorplan.btnHeight", String.valueOf(n));
    }

    public int getBtnHeight() {
        return this.getProperty("floorplan.btnHeight") == null ? 40 : Integer.valueOf(this.getProperty("floorplan.btnHeight"));
    }

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean bl) {
        this.updateSyncTime = bl;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean bl) {
        this.updateLastUpdateTime = bl;
    }

    public boolean isShowTableName() {
        return Boolean.valueOf(this.getProperty("floorplan.showTableName", "false"));
    }

    @Override
    public String getExtraProperties() {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.toString();
        }
        String string = super.getExtraProperties();
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
        return string;
    }

    @Override
    public void setExtraProperties(String string) {
        super.setExtraProperties(string);
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
    }

    @Override
    public JsonObject getPropertyStore() {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = new JsonObject();
        }
        return this.propertiesContainer;
    }

    public String getDeviceName() {
        return DeviceType.fromType(this.getDeviceType()).name().replaceAll("_", " ");
    }

    public void setDeviceName(String string) {
        this.deviceName = string;
    }

    public boolean isPrintRecieptOnBump() {
        return POSUtil.getBoolean(this.getProperty(JSON_PROP_PRINT_RECIEPT_ON_BUMP));
    }

    public void setPrintRecieptOnBump(boolean bl) {
        this.addProperty(JSON_PROP_PRINT_RECIEPT_ON_BUMP, String.valueOf(bl));
    }

    public boolean isEnableItemDetailShowing() {
        return POSUtil.getBoolean(this.getProperty(JSON_ENABLE_ITEM_DETAIL_SHOWING));
    }

    public void setEnableItemDetailShowing(boolean bl) {
        this.addProperty(JSON_ENABLE_ITEM_DETAIL_SHOWING, String.valueOf(bl));
    }

    public boolean doesReceivePayment() {
        return POSUtil.getBoolean(this.getProperty("receivesPayment"), (boolean)Boolean.TRUE);
    }

    public void setReceivePayment(boolean bl) {
        this.addProperty("receivesPayment", String.valueOf(bl));
    }
}

