/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemSize;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.PizzaCrust;
import com.floreantpos.model.PizzaPrice;
import com.floreantpos.model.PropertyContainer;
import com.floreantpos.model.Store;
import com.floreantpos.model.Tax;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.TicketItemTax;
import com.floreantpos.model.base.BaseTicketItemModifier;
import com.floreantpos.model.ext.KitchenStatus;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.OrgJsonUtil;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

@JsonIgnoreProperties(ignoreUnknown=true, value={"itemQuantityDisplay"})
public class TicketItemModifier
extends BaseTicketItemModifier
implements ITicketItem,
PropertyContainer {
    private static final long serialVersionUID = 1L;
    public static final int NORMAL_MODIFIER = 1;
    public static final int EXTRA_MODIFIER = 3;
    public static final int CRUST = 5;
    public static final int SEPERATOR = 6;
    public static final String TRANSIENT_PROP_TICKET_ITEM_QUANTITY = "ticketItemQuantity";
    public MenuModifier menuModifier;
    private boolean selected;
    private int tableRowNum;
    private double ticketItemQuantity;
    private List<TicketItemTax> taxes;
    private transient com.google.gson.JsonObject propertiesContainer;

    public TicketItemModifier() {
    }

    public TicketItemModifier(String string) {
        super(string);
    }

    public TicketItemModifier(TicketItem ticketItem, String string, double d, double d2) {
        this.setTicketItem(ticketItem);
        this.setName(string);
        this.setUnitPrice(d);
        this.setItemQuantity(d2);
    }

    public TicketItemModifier(String string, TicketItem ticketItem, String string2, double d, double d2, TicketItemTax ticketItemTax) {
        this.setId(string);
        this.setTicketItem(ticketItem);
        this.setName(string2);
        this.setUnitPrice(d);
        this.setItemQuantity(d2);
        this.addTotaxes(ticketItemTax);
    }

    public int getTableRowNum() {
        return this.tableRowNum;
    }

    public void setTableRowNum(int n) {
        this.tableRowNum = n;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public boolean canAddCookingInstruction() {
        return false;
    }

    public void calculatePrice() {
        if (this.getTicketItem() != null && this.getTicketItem().getDataVersion() == 2) {
            this.calculatePriceV2();
            return;
        }
        if (this.isInfoOnly().booleanValue()) {
            return;
        }
        BigDecimal bigDecimal = NumberUtil.convertToBigDecimal(this.getUnitPrice());
        BigDecimal bigDecimal2 = this.calculateSubTotal(bigDecimal);
        BigDecimal bigDecimal3 = this.calculateDiscount(bigDecimal2);
        BigDecimal bigDecimal4 = this.calculateTax(bigDecimal2, bigDecimal3);
        BigDecimal bigDecimal5 = BigDecimal.ZERO;
        BigDecimal bigDecimal6 = NumberUtil.convertToBigDecimal(0.0);
        double d = this.calculateTotalCost(this.getUnitCost());
        TicketItem ticketItem = this.getTicketItem();
        if (ticketItem != null) {
            bigDecimal5 = ticketItem.calculateServiceCharge(bigDecimal2);
            if (ticketItem.isTaxOnServiceCharge().booleanValue()) {
                bigDecimal4 = this.calculateTax(bigDecimal2.add(bigDecimal5), bigDecimal3);
            }
        }
        bigDecimal6 = this.isTaxIncluded() != false ? bigDecimal2.subtract(bigDecimal3) : bigDecimal2.subtract(bigDecimal3).add(bigDecimal4);
        bigDecimal6 = bigDecimal6.add(bigDecimal5);
        this.setTotalCost(d);
        this.setSubTotalAmount(bigDecimal2.doubleValue());
        this.setDiscountAmount(bigDecimal3.doubleValue());
        this.setTaxAmount(bigDecimal4.doubleValue());
        this.setServiceCharge(bigDecimal5.doubleValue());
        this.setTotalAmount(bigDecimal6.doubleValue());
        this.setAdjustedUnitPrice(this.getUnitPrice());
        this.setAdjustedDiscount(bigDecimal3.doubleValue());
        this.setAdjustedSubtotal(this.getSubTotalAmount());
        this.setAdjustedTax(this.getTaxAmount());
        this.setAdjustedTotal(this.getTotalAmount());
    }

    @Deprecated
    public void calculateAdjustedPrice() {
        Ticket ticket = this.getTicketItem().getTicket();
        if (ticket == null) {
            return;
        }
        BigDecimal bigDecimal = NumberUtil.convertToBigDecimal(this.getSubTotalAmount());
        BigDecimal bigDecimal2 = NumberUtil.convertToBigDecimal(this.getDiscountAmount());
        BigDecimal bigDecimal3 = NumberUtil.round(bigDecimal.subtract(bigDecimal2));
        BigDecimal bigDecimal4 = NumberUtil.round(NumberUtil.convertToBigDecimal(ticket.getTicketDiscountAmount()));
        BigDecimal bigDecimal5 = NumberUtil.round(NumberUtil.convertToBigDecimal(ticket.getSubtotalAmountWithVoidItems()));
        BigDecimal bigDecimal6 = NumberUtil.round(NumberUtil.convertToBigDecimal(ticket.getItemDiscountAmount()));
        BigDecimal bigDecimal7 = NumberUtil.round(bigDecimal5.subtract(bigDecimal6));
        BigDecimal bigDecimal8 = NumberUtil.round(bigDecimal7.subtract(bigDecimal4));
        BigDecimal bigDecimal9 = bigDecimal3.multiply(bigDecimal8).divide(bigDecimal7, 4, RoundingMode.HALF_UP);
        BigDecimal bigDecimal10 = NumberUtil.round(bigDecimal.subtract(bigDecimal9));
        BigDecimal bigDecimal11 = NumberUtil.round(this.calculateTax(bigDecimal9, new BigDecimal("0")));
        BigDecimal bigDecimal12 = NumberUtil.convertToBigDecimal(0.0);
        if (bigDecimal11.doubleValue() < 0.0) {
            bigDecimal11 = BigDecimal.ZERO;
        }
        bigDecimal12 = this.isTaxIncluded() != false ? bigDecimal9 : NumberUtil.round(bigDecimal9.add(bigDecimal11));
        bigDecimal12 = bigDecimal12.add(NumberUtil.convertToBigDecimal(this.getServiceCharge()));
        this.setAdjustedUnitPrice(bigDecimal9.divide(NumberUtil.convertToBigDecimal(this.getTicketItem().getQuantity()), 4, RoundingMode.HALF_UP).doubleValue());
        this.setAdjustedDiscount(bigDecimal10.doubleValue());
        this.setAdjustedSubtotal(bigDecimal9.doubleValue());
        this.setAdjustedTax(bigDecimal11.doubleValue());
        this.setAdjustedTotal(bigDecimal12.doubleValue());
    }

    public void calculatePriceV2() {
        if (this.isInfoOnly().booleanValue()) {
            return;
        }
        double d = this.getUnitPrice();
        double d2 = NumberUtil.round(this.calculateSubTotalV2(d));
        double d3 = NumberUtil.round(this.calculateDiscount(d2));
        double d4 = NumberUtil.round(this.calculateTotalCost(this.getUnitCost()));
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        TicketItem ticketItem = this.getTicketItem();
        Ticket ticket = ticketItem.getTicket();
        if (ticketItem != null && ticket != null) {
            d6 = ticket.isDiscountOnSerivceCharge() || ticket.hasRepriceDiscount() ? NumberUtil.round(ticketItem.calculateServiceChargeV2(d2 - d3)) : NumberUtil.round(ticketItem.calculateServiceChargeV2(d2));
        }
        d5 = ticketItem != null && ticketItem.isTaxOnServiceCharge() != false ? NumberUtil.round(this.calculateTaxV2(d2 + d6, d3)) : NumberUtil.round(this.calculateTaxV2(d2, d3));
        d7 = this.isTaxIncluded() != false ? NumberUtil.round(d2 - d3 + d6) : NumberUtil.round(d2 - d3 + d5 + d6);
        this.setTotalCost(d4);
        this.setSubTotalAmount(d2);
        this.setDiscountAmount(d3);
        this.setTaxAmount(d5);
        this.setServiceCharge(d6);
        this.setTotalAmount(d7);
        this.setAdjustedUnitPrice(this.getUnitPrice());
        this.setAdjustedDiscount(d3);
        this.setAdjustedSubtotal(d2);
        this.setAdjustedTax(d5);
        this.setAdjustedTotal(d7);
    }

    public void calculateAdjustedPriceV2() {
        TicketItem ticketItem = this.getTicketItem();
        Ticket ticket = null;
        if (ticketItem != null) {
            ticket = this.getTicketItem().getTicket();
        }
        double d = this.getServiceCharge();
        double d2 = 0.0;
        double d3 = this.getItemQuantity();
        double d4 = ticket.getDiscountPercentageRate();
        double d5 = (this.getSubtotalAmount() - this.getDiscountAmount()) / d3;
        double d6 = d5 - d5 * d4;
        if (this.getUnitPrice() == 0.0) {
            d6 = 0.0;
        }
        double d7 = NumberUtil.round(d6 * d3);
        double d8 = NumberUtil.round(this.getSubtotalAmount() - d7);
        if (ticket != null && ticket.isDiscountOnSerivceCharge() || ticket.hasRepriceDiscount()) {
            d = NumberUtil.round(ticketItem.calculateServiceChargeV2(d7));
        }
        d2 = ticketItem != null && ticketItem.isTaxOnServiceCharge() != false ? NumberUtil.round(this.calculateTaxV2(d7 + d, 0.0)) : NumberUtil.round(this.calculateTaxV2(d7, 0.0));
        double d9 = 0.0;
        d9 = this.isTaxIncluded() != false ? NumberUtil.round(d7 + d) : NumberUtil.round(d7 + d2 + d);
        this.setAdjustedUnitPrice(d6);
        this.setAdjustedDiscount(d8);
        this.setAdjustedSubtotal(d7);
        this.setAdjustedTax(d2);
        this.setServiceCharge(d);
        this.setAdjustedTotal(d9);
    }

    public double calculateDiscount(double d) {
        double d2 = 0.0;
        JSONArray jSONArray = new JSONArray();
        TicketItem ticketItem = this.getTicketItem();
        if (ticketItem == null) {
            return 0.0;
        }
        List<TicketItemDiscount> list = ticketItem.getDiscounts();
        if (list != null) {
            for (TicketItemDiscount ticketItemDiscount : list) {
                if (ticketItemDiscount.getType() == 2) continue;
                if (ticketItemDiscount.getType() == 1) {
                    TicketItemDiscount ticketItemDiscount2 = (TicketItemDiscount)SerializationUtils.clone((Serializable)ticketItemDiscount);
                    double d3 = ticketItemDiscount2.calculateDiscount(d - d2);
                    jSONArray.put((Object)ticketItemDiscount2.toJson());
                    ticketItemDiscount.setAmount(ticketItemDiscount.getAmount() + d3);
                    d2 += d3;
                    continue;
                }
                if (ticketItemDiscount.getType() != 0) continue;
            }
            this.addProperty("discountDetail", jSONArray.toString());
        }
        if (d2 > Math.abs(d)) {
            return d;
        }
        return d2;
    }

    public List<TicketItemDiscount> getDiscounts() {
        ArrayList<TicketItemDiscount> arrayList = new ArrayList<TicketItemDiscount>();
        String string = this.getProperty("discountDetail");
        if (StringUtils.isNotEmpty((String)string)) {
            JSONArray jSONArray = new JSONArray(string);
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jSONObject = jSONArray.getJSONObject(i);
                TicketItemDiscount ticketItemDiscount = new TicketItemDiscount();
                ticketItemDiscount.setTicketItem(this.getTicketItem());
                ticketItemDiscount.setDiscountId(OrgJsonUtil.getString(jSONObject, TicketItemDiscount.PROP_DISCOUNT_ID));
                ticketItemDiscount.setName(OrgJsonUtil.getString(jSONObject, TicketItemDiscount.PROP_NAME));
                ticketItemDiscount.setType(OrgJsonUtil.getInt(jSONObject, TicketItemDiscount.PROP_TYPE));
                ticketItemDiscount.setAutoApply(OrgJsonUtil.getBoolean(jSONObject, TicketItemDiscount.PROP_AUTO_APPLY));
                ticketItemDiscount.setCouponQuantity(OrgJsonUtil.getDouble(jSONObject, TicketItemDiscount.PROP_COUPON_QUANTITY));
                ticketItemDiscount.setMinimumAmount(OrgJsonUtil.getDouble(jSONObject, TicketItemDiscount.PROP_MINIMUM_AMOUNT));
                ticketItemDiscount.setValue(OrgJsonUtil.getDouble(jSONObject, TicketItemDiscount.PROP_VALUE));
                ticketItemDiscount.setAmount(OrgJsonUtil.getDouble(jSONObject, TicketItemDiscount.PROP_AMOUNT));
                arrayList.add(ticketItemDiscount);
            }
        }
        return arrayList;
    }

    public BigDecimal calculateDiscount(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = NumberUtil.convertToBigDecimal(0.0);
        List<TicketItemDiscount> list = this.getTicketItem().getDiscounts();
        if (list != null) {
            for (TicketItemDiscount ticketItemDiscount : list) {
                if (ticketItemDiscount.getType() == 2) continue;
                if (ticketItemDiscount.getType() == 1) {
                    bigDecimal2 = bigDecimal2.add(ticketItemDiscount.calculateDiscount(bigDecimal));
                    continue;
                }
                if (ticketItemDiscount.getType() != 0) continue;
                double d = ticketItemDiscount.getValue() * 100.0 / this.getTicketItem().getSubtotalAmount();
                TicketItemDiscount ticketItemDiscount2 = new TicketItemDiscount();
                ticketItemDiscount2.setType(1);
                ticketItemDiscount2.setValue(d);
                ticketItemDiscount2.setTicketItem(this.getTicketItem());
                ticketItemDiscount2.setCouponQuantity(ticketItemDiscount.getCouponQuantity());
                bigDecimal2 = bigDecimal2.add(ticketItemDiscount2.calculateDiscount(bigDecimal));
            }
        }
        if (bigDecimal2.compareTo(bigDecimal.abs()) > 0) {
            return bigDecimal;
        }
        return NumberUtil.round(bigDecimal2);
    }

    public void merge(TicketItemModifier ticketItemModifier) {
        this.setItemQuantity(this.getItemQuantity() + ticketItemModifier.getItemQuantity());
    }

    private BigDecimal calculateTax(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        Ticket ticket = this.getTicketItem().getTicket();
        if (ticket != null && ticket.isTaxExempt().booleanValue()) {
            return BigDecimal.ZERO;
        }
        BigDecimal bigDecimal3 = NumberUtil.convertToBigDecimal("0");
        bigDecimal = bigDecimal.subtract(bigDecimal2);
        List<TicketItemTax> list = this.getTaxes();
        if (list != null) {
            if (this.isTaxIncluded().booleanValue()) {
                BigDecimal bigDecimal4 = NumberUtil.convertToBigDecimal(0.0);
                for (TicketItemTax ticketItemTax : list) {
                    bigDecimal4 = bigDecimal4.add(NumberUtil.convertToBigDecimal(ticketItemTax.getRate()).divide(NumberUtil.convertToBigDecimal("100"), 4, RoundingMode.HALF_UP));
                }
                if (bigDecimal4.compareTo(NumberUtil.convertToBigDecimal("0")) == 0) {
                    return bigDecimal3;
                }
                BigDecimal bigDecimal5 = bigDecimal4.add(NumberUtil.convertToBigDecimal(1.0));
                double d = bigDecimal.doubleValue() / bigDecimal5.doubleValue();
                for (TicketItemTax ticketItemTax : list) {
                    bigDecimal4 = NumberUtil.convertToBigDecimal(ticketItemTax.getRate()).divide(NumberUtil.convertToBigDecimal("100"), 4, RoundingMode.HALF_UP);
                    BigDecimal bigDecimal6 = NumberUtil.convertToBigDecimal(d).multiply(bigDecimal4);
                    ticketItemTax.setTaxAmount(bigDecimal6.doubleValue());
                    bigDecimal3 = bigDecimal3.add(bigDecimal6);
                }
            } else {
                for (TicketItemTax ticketItemTax : list) {
                    BigDecimal bigDecimal7 = NumberUtil.convertToBigDecimal(ticketItemTax.getRate()).divide(NumberUtil.convertToBigDecimal("100"), 4, RoundingMode.HALF_UP);
                    if (bigDecimal7.compareTo(NumberUtil.convertToBigDecimal("0")) == 0) {
                        return bigDecimal3;
                    }
                    BigDecimal bigDecimal8 = bigDecimal.multiply(bigDecimal7);
                    ticketItemTax.setTaxAmount(bigDecimal8.doubleValue());
                    bigDecimal3 = bigDecimal3.add(bigDecimal8);
                }
            }
        }
        if (bigDecimal3.doubleValue() < 0.0) {
            bigDecimal3 = BigDecimal.ZERO;
        }
        this.buildTaxes();
        return Tax.applyFloridaTaxRule(bigDecimal, bigDecimal3);
    }

    private double calculateTaxV2(double d, double d2) {
        Ticket ticket = this.getTicketItem().getTicket();
        double d3 = 0.0;
        d -= d2;
        List<TicketItemTax> list = this.getTaxes();
        if (list != null) {
            if (this.isTaxIncluded().booleanValue()) {
                double d4 = 0.0;
                for (TicketItemTax ticketItemTax : list) {
                    d4 += ticketItemTax.getRate() / 100.0;
                }
                if (d4 == 0.0) {
                    return d3;
                }
                double d5 = d4 + 1.0;
                double d6 = d / d5;
                for (TicketItemTax ticketItemTax : list) {
                    d4 = ticketItemTax.getRate() / 100.0;
                    double d7 = d6 * d4;
                    ticketItemTax.setTaxAmount(d7);
                    d3 += d7;
                }
            } else {
                for (TicketItemTax ticketItemTax : list) {
                    double d8 = ticketItemTax.getRate() / 100.0;
                    if (d8 == 0.0) {
                        return d3;
                    }
                    double d9 = d * d8;
                    ticketItemTax.setTaxAmount(d9);
                    d3 += d9;
                }
            }
        }
        d3 = Tax.applyFloridaTaxRuleV2(this.getTicketItem().getTicket(), d, d3);
        this.buildTaxes();
        this.setTaxExemptAmount(0.0);
        if (ticket != null && ticket.isTaxExempt().booleanValue()) {
            this.setTaxExemptAmount(NumberUtil.round(d3));
            return 0.0;
        }
        return d3;
    }

    public double getTotalTaxRate() {
        List<TicketItemTax> list = this.getTaxes();
        if (list == null || list.isEmpty()) {
            return 0.0;
        }
        double d = 0.0;
        for (TicketItemTax ticketItemTax : list) {
            d += ticketItemTax.getRate().doubleValue();
        }
        return d;
    }

    private BigDecimal calculateSubTotal(BigDecimal bigDecimal) {
        Double d = this.getItemQuantity();
        if (this.getTicketItem() != null) {
            d = d * Math.abs(this.getTicketItem().getQuantity());
        }
        return bigDecimal.multiply(NumberUtil.convertToBigDecimal(d));
    }

    private double calculateTotalCost(double d) {
        Double d2 = this.getItemQuantity();
        if (this.getTicketItem() != null) {
            d2 = d2 * Math.abs(this.getTicketItem().getQuantity());
        }
        return d * d2;
    }

    private double calculateSubTotalV2(double d) {
        Double d2 = this.getItemQuantity();
        if (this.getTicketItem() != null) {
            d2 = d2 * Math.abs(this.getTicketItem().getQuantity());
        }
        return d * d2;
    }

    @Override
    public String getNameDisplay() {
        return this.getItemQuantityDisplay() + " " + this.getNameDisplay(false);
    }

    public String getNameDisplay(boolean bl) {
        Store store;
        boolean bl2;
        if (this.isInfoOnly().booleanValue()) {
            return this.getName().trim();
        }
        double d = Math.abs(this.getItemQuantity());
        String string = "";
        if (d > 1.0) {
            string = NumberUtil.trimDecilamIfNotNeeded(d) + "x ";
        }
        String string2 = d > 1.0 ? string + this.getName() : this.getName().trim();
        if (this.getModifierType() == 1 && !bl) {
            string2 = string2 + "*";
        }
        boolean bl3 = bl2 = (store = DataProvider.get().getStore()).getProperty("showModifierPrice") == null ? false : Boolean.valueOf(store.getProperty("showModifierPrice"));
        if (bl2 && this.getUnitPrice() > 0.0 && !bl) {
            string2 = string + this.getName() + " @" + NumberUtil.formatNumber(this.getUnitPrice());
        }
        if (bl) {
            return "-- " + string2;
        }
        return " -- " + string2;
    }

    @Override
    public String getUnitPriceDisplay() {
        if (this.isInfoOnly().booleanValue()) {
            return null;
        }
        return NumberUtil.formatNumberAcceptNegative(this.getUnitPrice());
    }

    @Override
    public String getItemQuantityDisplay() {
        return "";
    }

    @Override
    public String getTaxAmountWithoutModifiersDisplay() {
        if (this.isInfoOnly().booleanValue()) {
            return null;
        }
        return NumberUtil.formatNumberAcceptNegative(this.getTaxAmount());
    }

    @Override
    public String getTotalAmountWithoutModifiersDisplay() {
        if (this.isInfoOnly().booleanValue()) {
            return null;
        }
        return NumberUtil.formatNumberAcceptNegative(this.getTotalAmount());
    }

    @Override
    public String getSubTotalAmountWithoutModifiersDisplay() {
        if (this.isInfoOnly().booleanValue()) {
            return null;
        }
        return NumberUtil.formatNumberAcceptNegative(this.getSubTotalAmount());
    }

    @Override
    public String getItemCode() {
        return "";
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    @Override
    public Double getItemQuantity() {
        Double d = super.getItemQuantity();
        if (d == 0.0) {
            d = (double)super.getItemCount();
        }
        return d;
    }

    @Override
    public boolean canAddDiscount() {
        return false;
    }

    @Override
    public boolean canVoid() {
        return false;
    }

    @Override
    public boolean canAddAdOn() {
        return false;
    }

    @Override
    public KitchenStatus getKitchenStatusValue() {
        return KitchenStatus.fromString(super.getStatus());
    }

    public void setKitchenStatusValue(KitchenStatus kitchenStatus) {
        super.setStatus(kitchenStatus.name());
    }

    @Override
    public Double getSubtotalAmount() {
        return super.getSubTotalAmount();
    }

    @Override
    public String getSubTotalAmountDisplay() {
        return null;
    }

    @XmlTransient
    public MenuModifier getMenuModifier() {
        return this.menuModifier;
    }

    public void setMenuModifier(MenuModifier menuModifier) {
        this.menuModifier = menuModifier;
    }

    @Override
    public boolean isSaved() {
        return this.getId() != null;
    }

    public void setTaxes(List<TicketItemTax> list) {
        this.taxes = list;
        if (this.taxes == null) {
            this.taxes = new ArrayList<TicketItemTax>();
        }
    }

    public List<TicketItemTax> getTaxes() {
        if (this.taxes == null) {
            this.taxes = new ArrayList<TicketItemTax>();
            String string = super.getTaxesProperty();
            if (StringUtils.isNotEmpty((String)string)) {
                JsonReader jsonReader = Json.createReader((Reader)new StringReader(string));
                JsonArray jsonArray = jsonReader.readArray();
                jsonReader.close();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonObject jsonObject = (JsonObject)jsonArray.get(i);
                    TicketItemTax ticketItemTax = new TicketItemTax();
                    ticketItemTax.setName(jsonObject.getString(TicketItemTax.PROP_NAME));
                    ticketItemTax.setRate(POSUtil.parseDouble("" + jsonObject.get((Object)TicketItemTax.PROP_RATE)));
                    ticketItemTax.setTaxAmount(POSUtil.parseDouble("" + jsonObject.get((Object)TicketItemTax.PROP_TAX_AMOUNT)));
                    this.taxes.add(ticketItemTax);
                }
            }
        }
        return this.taxes;
    }

    public void addTotaxes(TicketItemTax ticketItemTax) {
        if (this.taxes == null) {
            this.taxes = new ArrayList<TicketItemTax>();
        }
        this.taxes = this.getTaxes();
        this.taxes.add(ticketItemTax);
    }

    public void buildTaxes() {
        if (this.taxes == null || this.taxes.isEmpty()) {
            this.setTaxesProperty(null);
            return;
        }
        JSONArray jSONArray = new JSONArray();
        for (TicketItemTax ticketItemTax : this.taxes) {
            jSONArray.put((Object)ticketItemTax.toJson());
        }
        this.setTaxesProperty(jSONArray.toString());
    }

    public void setTicketItemQuantity(double d) {
        this.ticketItemQuantity = d;
    }

    public double getTicketItemQuantity() {
        if (this.getTicketItem() != null) {
            return this.getTicketItem().getQuantity();
        }
        return this.ticketItemQuantity;
    }

    @Override
    public String getProperty(String string) {
        String string2;
        if (this.propertiesContainer == null) {
            string2 = super.getProperties();
            if (StringUtils.isEmpty((String)string2)) {
                return null;
            }
            this.propertiesContainer = (com.google.gson.JsonObject)new Gson().fromJson(string2, com.google.gson.JsonObject.class);
        }
        if (this.propertiesContainer.has(string) && !(string2 = this.propertiesContainer.get(string)).isJsonNull()) {
            return string2.getAsString();
        }
        return null;
    }

    @Override
    public String getProperties() {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.toString();
        }
        String string = super.getProperties();
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        try {
            this.propertiesContainer = (com.google.gson.JsonObject)new Gson().fromJson(string, com.google.gson.JsonObject.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    @Override
    public void setProperties(String string) {
        super.setProperties(string);
        try {
            this.propertiesContainer = (com.google.gson.JsonObject)new Gson().fromJson(string, com.google.gson.JsonObject.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void addProperty(String string, String string2) {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = new com.google.gson.JsonObject();
        }
        this.propertiesContainer.addProperty(string, string2);
        super.setProperties(this.propertiesContainer.toString());
    }

    @Override
    public com.google.gson.JsonObject getPropertyStore() {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = new com.google.gson.JsonObject();
        }
        return this.propertiesContainer;
    }

    public Double getMultiplierPrice(Double d) {
        if (StringUtils.isEmpty((String)super.getMultiplierName())) {
            return d;
        }
        Multiplier multiplier = DataProvider.get().getMultiplierById(super.getMultiplierName());
        if (multiplier == null || multiplier.isMain().booleanValue()) {
            return d;
        }
        return d * multiplier.getRate() / 100.0;
    }

    public void setSizeAndCrust(PizzaPrice pizzaPrice) {
        this.setModifierType(5);
        this.setInfoOnly(true);
        this.setPizzaCrustId(pizzaPrice.getCrust().getId());
        this.setMenuSizeId(pizzaPrice.getSize().getId());
        this.setName(pizzaPrice.getSize().getName() + " " + pizzaPrice.getCrust());
    }

    /*
     * WARNING - void declaration
     */
    public MenuItemSize getMenuSize(MenuItem menuItem) {
        MenuItemSize menuItemSize;
        List<PizzaPrice> list = menuItem.getPizzaPriceList();
        if (list == null) {
            return null;
        }
        String string = this.getMenuSizeId();
        if (StringUtils.isNotBlank((String)string)) {
            for (PizzaPrice object2 : list) {
                menuItemSize = object2.getSize();
                if (!string.equals(menuItemSize.getId())) continue;
                return menuItemSize;
            }
        }
        String string2 = this.getName();
        String string3 = "";
        menuItemSize = null;
        for (PizzaPrice pizzaPrice : list) {
            void var5_7;
            MenuItemSize menuItemSize2 = pizzaPrice.getSize();
            if (!string2.contains(menuItemSize2.getName()) || menuItemSize2.getName().length() <= var5_7.length()) continue;
            String string4 = menuItemSize2.getName();
            menuItemSize = menuItemSize2;
        }
        return menuItemSize;
    }

    /*
     * WARNING - void declaration
     */
    public PizzaCrust getPizzaCrust(MenuItem menuItem) {
        PizzaCrust pizzaCrust;
        List<PizzaPrice> list = menuItem.getPizzaPriceList();
        if (list == null) {
            return null;
        }
        String string = this.getPizzaCrustId();
        if (StringUtils.isNotBlank((String)string)) {
            for (PizzaPrice object2 : list) {
                pizzaCrust = object2.getCrust();
                if (!string.equals(pizzaCrust.getId())) continue;
                return pizzaCrust;
            }
        }
        String string2 = this.getName();
        String string3 = "";
        pizzaCrust = null;
        for (PizzaPrice pizzaPrice : list) {
            void var5_7;
            PizzaCrust pizzaCrust2 = pizzaPrice.getCrust();
            if (!string2.contains(pizzaCrust2.getName()) || pizzaCrust2.getName().length() <= var5_7.length()) continue;
            String string4 = pizzaCrust2.getName();
            pizzaCrust = pizzaCrust2;
        }
        return pizzaCrust;
    }

    public String getMenuSizeId() {
        return this.getProperty("menu_size_id");
    }

    public void setMenuSizeId(String string) {
        this.addProperty("menu_size_id", string);
    }

    public String getPizzaCrustId() {
        return this.getProperty("pizza_crust_id");
    }

    public void setPizzaCrustId(String string) {
        this.addProperty("pizza_crust_id", string);
    }
}

