/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.ActionHistory;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.User;
import com.floreantpos.model.base.BaseShopTable;
import com.floreantpos.model.dao.BaseActionHistoryDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.AsyncAction;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class ActionHistoryDAO
extends BaseActionHistoryDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    public void saveOrUpdateActionHistory(List<ActionHistory> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        try (Session session = this.createNewSession();){
            transaction = session.beginTransaction();
            for (ActionHistory actionHistory : list) {
                ActionHistory actionHistory2 = this.get(actionHistory.getId());
                if (actionHistory2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(actionHistory.getLastUpdateTime(), actionHistory2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), actionHistory.getActionName() + " already updated");
                        continue;
                    }
                    long l = actionHistory2.getVersion();
                    PropertyUtils.copyProperties((Object)actionHistory2, (Object)actionHistory);
                    actionHistory2.setVersion(l);
                    actionHistory2.setUpdateLastUpdateTime(bl);
                    actionHistory2.setUpdateSyncTime(bl2);
                    this.update(actionHistory2, session);
                    continue;
                }
                actionHistory.setVersion(0L);
                actionHistory.setUpdateLastUpdateTime(bl);
                actionHistory.setUpdateSyncTime(bl2);
                this.save(actionHistory, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
    }

    public static void saveHistory(final User user, final Ticket ticket, final PosTransaction posTransaction, final String string, final String string2) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Transaction transaction = null;
                try (Session session = ActionHistoryDAO.getInstance().createNewSession();){
                    transaction = session.beginTransaction();
                    ActionHistoryDAO.saveHistory(user, ticket, posTransaction, string, string2, session);
                    transaction.commit();
                }
                catch (Exception exception) {
                    if (transaction != null) {
                        transaction.rollback();
                    }
                    LogFactory.getLog(ActionHistoryDAO.class).error((Object)"Error occured while trying to save action history", (Throwable)exception);
                }
            }
        };
        AsyncAction.execute(runnable);
    }

    public static void saveHistory(User user, Ticket ticket, String string, String string2) {
        ActionHistoryDAO.saveHistory(user, ticket, null, string, string2);
    }

    public static void saveHistory(Ticket ticket, String string, String string2) {
        ActionHistoryDAO.saveHistory(Application.getCurrentUser(), ticket, null, string, string2);
    }

    public static void saveHistory(String string, String string2) {
        ActionHistoryDAO.saveHistory(Application.getCurrentUser(), null, null, string, string2);
    }

    public static void saveHistory(String string, String string2, Session session) {
        ActionHistoryDAO.saveHistory(Application.getCurrentUser(), null, null, string, string2, session);
    }

    public static void saveHistory(User user, String string, String string2) {
        ActionHistoryDAO.saveHistory(user, null, null, string, string2);
    }

    public static void saveHistory(User user, Ticket ticket, PosTransaction posTransaction, String string, String string2, Session session) {
        ActionHistory actionHistory = new ActionHistory();
        actionHistory.setActionName(string);
        actionHistory.setDescription(string2);
        actionHistory.setPerformer(user);
        actionHistory.setActionTime(StoreDAO.getServerTimestamp());
        actionHistory.setOutletId(DataProvider.get().getCurrentOutletId());
        if (ticket != null) {
            actionHistory.setTicketId(ticket.getId());
        }
        if (posTransaction != null) {
            actionHistory.setTransactionId(posTransaction.getId());
        }
        ActionHistoryDAO.getInstance().save(actionHistory, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void save(Map<String, ActionHistory> map) {
        ActionHistoryDAO actionHistoryDAO = ActionHistoryDAO.getInstance();
        Transaction transaction = null;
        try (Session session = actionHistoryDAO.createNewSession();){
            transaction = session.beginTransaction();
            for (ActionHistory actionHistory : map.values()) {
                actionHistory.setOutletId(DataProvider.get().getCurrentOutletId());
                actionHistoryDAO.save(actionHistory, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            if (transaction != null) {
                transaction.rollback();
            }
        }
        finally {
            map.clear();
        }
    }

    public void performActionHistorySaveOperation(Ticket ticket) {
        this.performActionHistorySaveOperation(ticket, false);
    }

    public void performActionHistorySaveOperation(final Ticket ticket, final boolean bl) {
        if (ticket == null) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ActionHistoryDAO.this.performSave(ticket, bl);
            }
        };
        AsyncAction.execute(runnable);
    }

    private void populateEventsDescription(Ticket ticket) {
        if (ticket == null) {
            return;
        }
        Map<String, ActionHistory> map = ticket.getEvents();
        if (map.isEmpty()) {
            return;
        }
        Collection<ActionHistory> collection = map.values();
        collection.forEach(actionHistory -> {
            Object object = actionHistory.getObjectReference();
            String string = actionHistory.getDescription();
            if (object instanceof TicketDiscount) {
                TicketDiscount ticketDiscount = (TicketDiscount)object;
                string = ticketDiscount.getType() == 3 ? String.format("Ticket id : %s, Loyalty points : %s", ticketDiscount.getTicket().getId(), ticketDiscount.getLoyaltyPoint()) : String.format("Ticket id : %s, Discount id : %s, Coupon quantity : %s", ticketDiscount.getTicket().getId(), ticketDiscount.getDiscountId(), ticketDiscount.getCouponQuantity());
            } else if (object instanceof TicketItemDiscount) {
                TicketItemDiscount ticketItemDiscount = (TicketItemDiscount)object;
                TicketItem ticketItem = ticketItemDiscount.getTicketItem();
                string = String.format("Ticket id : %s, Item id : %s, Discount id : %s, Coupon quantity : %s", ticket != null ? ticket.getId() : "", ticketItem != null ? ticketItem.getId() : "", ticketItemDiscount.getDiscountId(), ticketItemDiscount.getCouponQuantity());
            } else if (actionHistory.getActionName() == "Tax exempt" && ticket.isTaxExempt().booleanValue()) {
                String string2 = ticket.getProperty("tax_exempt_id");
                string = String.format("Ticket id : %s, Exempt id : %s", ticket.getId(), string2);
            }
            actionHistory.setDescription(string);
        });
    }

    public void performSave(Ticket ticket, boolean bl) {
        if (ticket == null) {
            return;
        }
        try {
            ActionHistoryDAO.saveHistory("Save check", "Check#:" + ticket.getId());
            this.populateEventsDescription(ticket);
            ActionHistoryDAO.save(ticket.getEvents());
        }
        catch (Exception exception) {
            PosLog.error(this.getReferenceClass(), exception);
        }
    }

    public static void addDiscountRemovedActionHistory(Ticket ticket, TicketDiscount ticketDiscount) {
        if (ticket == null) {
            return;
        }
        String string = String.valueOf(ticketDiscount.hashCode());
        if (ticket.getEvents().containsKey(string)) {
            ticket.getEvents().remove(string);
        } else {
            String string2 = ticketDiscount.getType() == 3 ? "Loyalty removed" : "Ticket discount removed";
            ActionHistoryDAO.addActionHistory(ticket, string, string2, null, ticketDiscount);
        }
    }

    public static void addDiscountAddedActionHistory(Ticket ticket, TicketDiscount ticketDiscount) {
        if (ticket == null) {
            return;
        }
        String string = String.valueOf(ticketDiscount.hashCode());
        String string2 = ticketDiscount.getType() == 3 ? "Loyalty added" : "Ticket discount added";
        ActionHistoryDAO.addActionHistory(ticket, string, string2, null, ticketDiscount);
    }

    public static void addSetGratuityActionHistory(Ticket ticket, Gratuity gratuity) {
        if (ticket == null) {
            return;
        }
        if (ticket.getId() == null) {
            return;
        }
        String string = "Gratuity set";
        String string2 = "Gratuity set";
        String string3 = String.format("Ticket id : %s, Gratuity amount : %s", ticket.getId(), gratuity == null ? 0.0 : gratuity.getAmount());
        ActionHistoryDAO.addActionHistory(ticket, string2, string, string3, gratuity);
    }

    public static void addTableAddedActionHistory(Ticket ticket, List<ShopTable> list) {
        Object object;
        if (ticket == null) {
            return;
        }
        if (ticket.getId() == null) {
            return;
        }
        if (list == null) {
            return;
        }
        String string = "Table change";
        String string2 = "Table change";
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<ShopTable> iterator = list.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            stringBuilder.append(((BaseShopTable)object).getId());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        object = String.format("Ticket id : %s, Tables : %s", ticket.getId(), stringBuilder.toString());
        ActionHistoryDAO.addActionHistory(ticket, string2, string, (String)object, list);
    }

    public static void addSalesAreaAddedActionHistory(Ticket ticket, SalesArea salesArea) {
        if (ticket == null) {
            return;
        }
        if (ticket.getId() == null) {
            return;
        }
        if (salesArea == null) {
            return;
        }
        String string = "Sales area change";
        String string2 = "Sales area change";
        String string3 = String.format("Ticket id : %s, Sales area : %s", ticket.getId(), salesArea.getName());
        ActionHistoryDAO.addActionHistory(ticket, string2, string, string3, salesArea);
    }

    public static void addTicketItemDiscountRemovedActionHistory(Ticket ticket, TicketItemDiscount ticketItemDiscount) {
        if (ticket == null) {
            return;
        }
        String string = String.valueOf(ticketItemDiscount.hashCode());
        if (ticket.getEvents().containsKey(string)) {
            ticket.getEvents().remove(string);
        } else {
            ActionHistoryDAO.addActionHistory(ticket, string, "Item discount removed", null, ticketItemDiscount);
        }
    }

    public static void addTicketItemDiscountAddedActionHistory(Ticket ticket, TicketItemDiscount ticketItemDiscount) {
        if (ticket == null) {
            return;
        }
        String string = String.valueOf(ticketItemDiscount.hashCode());
        ActionHistoryDAO.addActionHistory(ticket, string, "Item discount added", null, ticketItemDiscount);
    }

    public static void addSplitTicketActionHistory(Ticket ticket, List<Ticket> list) {
        if (ticket == null) {
            return;
        }
        if (ticket.getId() == null || list == null) {
            return;
        }
        try {
            String string = ticket.getProperty("SPLIT_TYPE");
            ActionHistoryDAO actionHistoryDAO = ActionHistoryDAO.getInstance();
            list.forEach(ticket2 -> {
                Map<String, ActionHistory> map = ticket2.getEvents();
                String string2 = "Split check";
                String string3 = "Split check";
                String string4 = String.format("Parent ticket id : %s, Ticket id : %s, Split type : %s", ticket.getId(), ticket2.getId(), string);
                ActionHistory actionHistory = ActionHistory.create(ticket2, string2, string4);
                actionHistory.setObjectReference(ticket2);
                map.put(string3, actionHistory);
                actionHistoryDAO.performSave((Ticket)ticket2, !ticket.getId().equals(ticket2.getId()));
            });
        }
        catch (Exception exception) {
            PosLog.error(ActionHistory.class, exception);
        }
    }

    public static void addItemVoidedActionHistory(Ticket ticket, TicketItem ticketItem, double d) {
        if (ticket == null || ticket.getId() == null || ticketItem == null) {
            return;
        }
        String string = String.valueOf(ticketItem.hashCode());
        String string2 = "Ticket item void";
        String string3 = String.format("Ticket id : %s, Item id : %s, Void quantity : %s", ticket.getId(), ticketItem.getId(), d);
        ActionHistoryDAO.addActionHistory(ticket, string, string2, string3, ticketItem);
    }

    public static void addActionHistory(Ticket ticket, String string, String string2) {
        ActionHistoryDAO.addActionHistory(ticket, string, string, string2);
    }

    public static void addActionHistory(Ticket ticket, String string, String string2, String string3) {
        ActionHistoryDAO.addActionHistory(ticket, string, string2, string3, null);
    }

    public static void addActionHistory(Ticket ticket, String string, String string2, String string3, Object object) {
        if (ticket == null) {
            return;
        }
        ActionHistory actionHistory = ActionHistory.create(ticket, string2, string3);
        actionHistory.setObjectReference(object);
        ticket.getEvents().put(string, actionHistory);
    }
}

