/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.Department;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TerminalType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.BaseOrderTypeDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.sql.rowset.serial.SerialBlob;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.sql.JoinType;
import org.hibernate.transform.Transformers;

public class OrderTypeDAO
extends BaseOrderTypeDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime((OrderType)object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime((OrderType)object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime((OrderType)object);
        super.saveOrUpdate(object, session);
    }

    @Override
    protected void delete(Object object, Session session) {
        OrderType orderType = (OrderType)object;
        if (orderType == null) {
            throw new PosException(Messages.getString("OrderTypeDAO.0"));
        }
        orderType.setDeleted(true);
        orderType.setCategories(null);
        orderType.setDefaultTaxGroup(null);
        orderType.setDefaultTaxGroupId(null);
        orderType.setDepartments(null);
        orderType.setEnableCourse(false);
        orderType.setEnabled(false);
        orderType.setForHereTaxGroup(null);
        orderType.setForHereTaxGroupId(null);
        orderType.setTerminalTypes(null);
        this.update(orderType, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OrderType> findAll() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.addOrder(Order.asc((String)OrderType.PROP_SORT_ORDER));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OrderType> findEnabledOrderTypesForTerminal(Terminal terminal) {
        List list;
        Session session = null;
        try {
            TerminalType terminalType = terminal.getTerminalType();
            Department department = terminal.getDepartment();
            SalesArea salesArea = terminal.getSalesArea();
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass(), "c");
            criteria.add((Criterion)Restrictions.eq((String)OrderType.PROP_ENABLED, (Object)true));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            if (terminalType != null) {
                criteria.createAlias("c.terminalTypes", "terminalType", JoinType.LEFT_OUTER_JOIN);
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isEmpty((String)"c.terminalTypes"), (Criterion)Restrictions.in((String)"terminalType.id", Arrays.asList(terminalType.getId()))));
            }
            if (department != null) {
                criteria.createAlias("c.departments", "department", JoinType.LEFT_OUTER_JOIN);
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isEmpty((String)"c.departments"), (Criterion)Restrictions.in((String)"department.id", Arrays.asList(department.getId()))));
            }
            if (salesArea != null) {
                // empty if block
            }
            criteria.addOrder(Order.asc((String)OrderType.PROP_SORT_ORDER));
            criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
            list = criteria.list();
        }
        catch (Throwable throwable) {
            this.closeSession(session);
            throw throwable;
        }
        this.closeSession(session);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OrderType> findLoginScreenViewOrderTypes() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.add((Criterion)Restrictions.eq((String)OrderType.PROP_ENABLED, (Object)true));
            criteria.add((Criterion)Restrictions.eq((String)OrderType.PROP_SHOW_IN_LOGIN_SCREEN, (Object)true));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public OrderType findByName(String string) {
        Session session = null;
        try {
            session = this.createNewSession();
            OrderType orderType = this.findByName(string, session);
            return orderType;
        }
        finally {
            this.closeSession(session);
        }
    }

    @Deprecated
    public OrderType findByName(String string, Session session) {
        if (session == null) {
            session = this.getSession();
        }
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.add((Criterion)Restrictions.eq((String)OrderType.PROP_NAME, (Object)string));
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
        return (OrderType)criteria.uniqueResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean containsOrderTypeObj() {
        Session session = null;
        try {
            session = this.createNewSession();
            SQLQuery sQLQuery = session.createSQLQuery("select count(s.MENU_ITEM_ID), count(s.ORDER_TYPE_ID) from ITEM_ORDER_TYPE s");
            List list = sQLQuery.list();
            Object[] objectArray = (Object[])list.get(0);
            Integer n = this.getInt(objectArray, 0);
            Integer n2 = this.getInt(objectArray, 1);
            if (n < 1) {
                boolean bl = true;
                return bl;
            }
            boolean bl = n2 > 0;
            return bl;
        }
        catch (Exception exception) {
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void updateMenuItemOrderType() {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            SQLQuery sQLQuery = session.createSQLQuery("Update ITEM_ORDER_TYPE t SET t.ORDER_TYPE_ID=(Select o.id from ORDER_TYPE o where o.NAME=t.ORDER_TYPE)");
            sQLQuery.executeUpdate();
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
        }
        finally {
            if (session != null) {
                this.closeSession(session);
            }
        }
    }

    private Integer getInt(Object[] objectArray, int n) {
        if (objectArray.length < n + 1) {
            return null;
        }
        if (objectArray[n] instanceof Number) {
            return ((Number)objectArray[n]).intValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrderType getFirstOrderType() {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.setFirstResult(0);
            criteria.setMaxResults(1);
            List list = criteria.list();
            if (list.size() > 0) {
                OrderType orderType = (OrderType)list.get(0);
                return orderType;
            }
            OrderType orderType = null;
            return orderType;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrderType getOrderType(boolean bl) {
        Session session = null;
        Criteria criteria = null;
        try {
            List list;
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.add((Criterion)Restrictions.eq((String)OrderType.PROP_ENABLED, (Object)true));
            criteria.add((Criterion)Restrictions.eq((String)OrderType.PROP_SHOW_TABLE_SELECTION, (Object)bl));
            if (!bl) {
                criteria.add((Criterion)Restrictions.eq((String)OrderType.PROP_DELIVERY, (Object)Boolean.FALSE));
            }
            if ((list = criteria.list()).size() > 0) {
                OrderType orderType = (OrderType)list.get(0);
                return orderType;
            }
            OrderType orderType = null;
            return orderType;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<String> getHomeDeliveryOrderTypeIds() {
        try (Session session = this.createNewSession();){
            List<String> list = this.getHomeDeliveryOrderTypeIds(session);
            return list;
        }
    }

    public List<String> getHomeDeliveryOrderTypeIds(Session session) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        this.addDeletedFilter(criteria);
        criteria.add((Criterion)Restrictions.eq((String)OrderType.PROP_ENABLED, (Object)true));
        criteria.add((Criterion)Restrictions.eq((String)OrderType.PROP_DELIVERY, (Object)Boolean.TRUE));
        criteria.setProjection((Projection)Projections.property((String)OrderType.PROP_ID));
        return criteria.list();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrderType getHomeDeliveryOrderType() {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)"deleted"), (Criterion)Restrictions.eq((String)"deleted", (Object)Boolean.FALSE)));
            criteria.add((Criterion)Restrictions.eq((String)OrderType.PROP_ENABLED, (Object)true));
            criteria.add((Criterion)Restrictions.eq((String)OrderType.PROP_DELIVERY, (Object)Boolean.TRUE));
            List list = criteria.list();
            if (list.size() > 0) {
                OrderType orderType = (OrderType)list.get(0);
                return orderType;
            }
            OrderType orderType = null;
            return orderType;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdateOrderType(OrderType orderType, List<Department> list) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            session.saveOrUpdate((Object)orderType);
            for (Department department : list) {
                session.saveOrUpdate((Object)department);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            try {
                transaction.rollback();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OrderType initialize(OrderType orderType) {
        if (orderType == null || orderType.getId() == null) {
            return orderType;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)orderType);
            Hibernate.initialize(orderType.getDepartments());
            Hibernate.initialize(orderType.getTerminalTypes());
            Hibernate.initialize(orderType.getCategories());
            OrderType orderType2 = orderType;
            return orderType2;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdateOrderTypes(List<OrderType> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (OrderType orderType : list) {
                String string = orderType.getId();
                OrderType orderType2 = null;
                if (StringUtils.isNotBlank((String)string)) {
                    orderType2 = this.get(string);
                }
                byte[] byArray = orderType.getImageBytes();
                if (orderType2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(orderType.getLastUpdateTime(), orderType2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), orderType.getName() + " already updated");
                        continue;
                    }
                    String string2 = orderType2.getId();
                    long l = orderType2.getVersion();
                    PropertyUtils.copyProperties((Object)orderType2, (Object)orderType);
                    orderType2.setId(string2);
                    orderType2.setVersion(l);
                    orderType2.setUpdateLastUpdateTime(bl);
                    orderType2.setUpdateSyncTime(bl2);
                    if (byArray != null) {
                        orderType2.setImageData(new SerialBlob(byArray));
                    }
                    this.update(orderType2, session);
                    continue;
                }
                orderType.setUpdateLastUpdateTime(bl);
                orderType.setUpdateSyncTime(bl2);
                orderType.setVersion(0L);
                if (byArray != null) {
                    orderType.setImageData(new SerialBlob(byArray));
                }
                this.save(orderType, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    public boolean canDelete(OrderType orderType) {
        if (orderType == null || orderType.getId() == null) {
            return false;
        }
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(Ticket.class);
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_ORDER_TYPE_ID, (Object)orderType.getId()));
            criteria.setMaxResults(1);
            boolean bl = criteria.list().size() == 0;
            return bl;
        }
    }

    public List<OrderType> getOrderTypesByTerminalType(TerminalType terminalType, Session session) {
        String string = "SELECT DISTINCT ORDER_TYPE_ID FROM TERMINAL_TYPE_ORDER_TYPE WHERE TERMINAL_TYPE_ID = :tt_id";
        SQLQuery sQLQuery = session.createSQLQuery(string);
        sQLQuery.setParameter("tt_id", (Object)terminalType.getId());
        List list = sQLQuery.list();
        if (list != null && !list.isEmpty()) {
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add(Restrictions.in((String)OrderType.PROP_ID, (Collection)list));
            criteria.setProjection(Projections.alias((Projection)Projections.property((String)OrderType.PROP_NAME), (String)OrderType.PROP_NAME));
            return criteria.setResultTransformer(Transformers.aliasToBean((Class)this.getReferenceClass())).list();
        }
        return null;
    }

    public void saveOrUpdateOrderTypeCollections(List<OrderType> list) {
        Transaction transaction = null;
        try (Session session = OrderTypeDAO.getInstance().createNewSession();){
            transaction = session.beginTransaction();
            for (OrderType orderType : list) {
                Set<Department> set;
                Object object;
                Set<TerminalType> set2;
                OrderType orderType2 = OrderTypeDAO.getInstance().get(orderType.getId(), session);
                if (orderType2 == null) continue;
                Hibernate.initialize(orderType2.getDepartments());
                Hibernate.initialize(orderType2.getTerminalTypes());
                Hibernate.initialize(orderType2.getCategories());
                if (orderType2.getTerminalTypes() != null) {
                    orderType2.getTerminalTypes().clear();
                }
                if ((set2 = orderType.getTerminalTypes()) != null && set2.size() > 0) {
                    object = set2.iterator();
                    while (object.hasNext()) {
                        set = (TerminalType)object.next();
                        orderType2.addToterminalTypes((TerminalType)((Object)set));
                    }
                }
                if (orderType2.getCategories() != null) {
                    orderType2.getCategories().clear();
                }
                if ((object = orderType.getCategories()) != null && object.size() > 0) {
                    set = object.iterator();
                    while (set.hasNext()) {
                        MenuCategory menuCategory = (MenuCategory)set.next();
                        orderType2.addTocategories(menuCategory);
                    }
                }
                if (orderType2.getDepartments() != null) {
                    orderType2.getDepartments().clear();
                }
                if ((set = orderType.getDepartments()) != null && set.size() > 0) {
                    for (Department department : set) {
                        orderType2.addTodepartments(department);
                    }
                }
                orderType2.setUpdateLastUpdateTime(false);
                OrderTypeDAO.getInstance().saveOrUpdate(orderType2, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw exception;
        }
    }
}

