/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TimedModel;
import com.floreantpos.webservice.CloudDataUploader;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.hibernate.EmptyInterceptor;
import org.hibernate.Transaction;
import org.hibernate.type.Type;

public class PosDataInterceptor
extends EmptyInterceptor {
    private Set<Ticket> ticketsToUpload = new HashSet<Ticket>();

    public boolean onFlushDirty(Object object, Serializable serializable, Object[] objectArray, Object[] objectArray2, String[] stringArray, Type[] typeArray) {
        if (object instanceof TicketItem || object instanceof TimedModel) {
            return false;
        }
        try {
            int n = this.getUpdateTimePropIndex(stringArray);
            if (n != -1) {
                objectArray[n] = new Date();
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean onSave(Object object, Serializable serializable, Object[] objectArray, String[] stringArray, Type[] typeArray) {
        if (object instanceof TicketItem || object instanceof TimedModel) {
            return false;
        }
        try {
            int n = this.getUpdateTimePropIndex(stringArray);
            if (n != -1) {
                objectArray[n] = new Date();
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void postFlush(Iterator iterator) {
        try {
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof Ticket)) continue;
                Ticket ticket = (Ticket)e;
                this.ticketsToUpload.add(ticket);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTransactionCompletion(Transaction transaction) {
        try {
            if (this.ticketsToUpload != null && this.ticketsToUpload.size() > 0) {
                for (Ticket ticket : this.ticketsToUpload) {
                    CloudDataUploader.get().uploadTicketIfOnlineOrder(ticket);
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.ticketsToUpload.clear();
        }
    }

    private int getUpdateTimePropIndex(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!Ticket.PROP_LAST_UPDATE_TIME.equals(stringArray[i])) continue;
            return i;
        }
        return -1;
    }
}

