/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.ShopTableType;
import com.floreantpos.model.dao.BaseShopTableTypeDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Order;

public class ShopTableTypeDAO
extends BaseShopTableTypeDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    @Override
    protected void delete(Object object, Session session) {
        ShopTableType shopTableType = (ShopTableType)object;
        if (shopTableType == null) {
            throw new PosException(Messages.getString("ShopTableTypeDAO.0"));
        }
        this.checkForeignRelation(shopTableType);
        shopTableType.setDeleted(Boolean.TRUE);
        this.update(shopTableType, session);
    }

    private void checkForeignRelation(ShopTableType shopTableType) throws PosException {
        String string = shopTableType.getId();
        try (Session session = this.createNewSession();){
            List list = GenericDAO.getInstance().getForeignDataList(session, ShopTable.class, "types", ShopTableType.PROP_ID, string, ShopTable.PROP_ID);
            if (list != null && list.size() > 0) {
                String string2 = Messages.getString("ShopTableTypeDAO.2") + (list.size() > 1 ? Messages.getString("ShopTableTypeDAO.3") : ":");
                int n = 1;
                for (Integer n2 : list) {
                    string2 = string2 + "\n" + n + ". " + n2;
                    ++n;
                }
                throw new PosException(Messages.getString("ShopTableTypeDAO.7"), string2);
            }
        }
    }

    @Override
    public List<ShopTableType> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    public void saveOrUpdateShopTableType(List<ShopTableType> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        try (Session session = this.createNewSession();){
            transaction = session.beginTransaction();
            for (ShopTableType shopTableType : list) {
                ShopTableType shopTableType2 = this.get(shopTableType.getId());
                if (shopTableType2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(shopTableType.getLastUpdateTime(), shopTableType2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), shopTableType.getName() + " already updated");
                        continue;
                    }
                    long l = shopTableType2.getVersion();
                    PropertyUtils.copyProperties((Object)shopTableType2, (Object)shopTableType);
                    shopTableType2.setVersion(l);
                    shopTableType2.setUpdateLastUpdateTime(bl);
                    shopTableType2.setUpdateSyncTime(bl2);
                    this.update(shopTableType2);
                    continue;
                }
                shopTableType.setVersion(0L);
                shopTableType.setUpdateLastUpdateTime(bl);
                shopTableType.setUpdateSyncTime(bl2);
                this.save(shopTableType);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
    }

    @Override
    public Order getDefaultOrder() {
        return Order.asc((String)ShopTableType.PROP_ID);
    }
}

