/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.payment;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.customer.CustomerSelectorDialog;
import com.floreantpos.customer.CustomerSelectorFactory;
import com.floreantpos.model.BalanceType;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerAccountTransaction;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.dao.BalanceUpdateTransactionDAO;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.payment.AbstractPaymentPlugin;
import com.floreantpos.services.PostPaymentProcessor;
import com.floreantpos.ui.views.payment.SettleTicketProcessor;
import com.floreantpos.util.NumberUtil;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;

public class MemberPaymentPlugin
extends AbstractPaymentPlugin
implements PostPaymentProcessor {
    @Override
    public String getName() {
        return Messages.getString("MemberAccount");
    }

    @Override
    public void pay(Ticket ticket, double d, SettleTicketProcessor settleTicketProcessor) throws Exception {
        Comparable<Double> comparable;
        Customer customer = ticket.getCustomer();
        if (customer != null) {
            comparable = customer.getCreditLimit();
            Double d2 = customer.getBalance();
            if (d > NumberUtil.round(d2 + (Double)comparable)) {
                throw new PosException(Messages.getString("CreditLimitExceed"));
            }
        }
        comparable = (CustomerAccountTransaction)PaymentType.MEMBER_ACCOUNT.createTransaction(ticket, d);
        settleTicketProcessor.settleTicket((PosTransaction)comparable, this);
    }

    @Override
    public String getId() {
        return "MEMBER_ACCOUNT";
    }

    @Override
    public void paymentDone(PosTransaction posTransaction, Session session) {
        Ticket ticket = posTransaction.getTicket();
        Customer customer = ticket.getCustomer();
        Double d = customer.getBalance();
        customer.setBalance(d - posTransaction.getAmount());
        CustomerDAO.getInstance().saveOrUpdate(customer, session);
        BalanceUpdateTransactionDAO.getInstance().saveBalanceUpdateTrans(BalanceType.CUSTOMER, posTransaction.getTicket(), posTransaction, TransactionType.DEBIT, customer.getId(), posTransaction.getAmount(), d, null, session);
        ticket.updateCustomerRef(customer);
    }

    public void doRefund(Ticket ticket, List<PosTransaction> list) throws Exception {
    }

    public Customer doSetMember(Ticket ticket) {
        Customer customer = ticket.getCustomer();
        if (customer == null) {
            CustomerSelectorDialog customerSelectorDialog = CustomerSelectorFactory.createCustomerSelectorDialog(ticket.getOrderType());
            customerSelectorDialog.setCreateNewTicket(false);
            if (ticket != null) {
                customerSelectorDialog.setTicket(ticket);
            }
            customerSelectorDialog.openUndecoratedFullScreen();
            if (customerSelectorDialog.isCanceled()) {
                throw new PosException(Messages.getString("MemberNotSelected"));
            }
            customer = customerSelectorDialog.getSelectedCustomer();
            if (customer == null) {
                throw new PosException(Messages.getString("MemberNotSelected"));
            }
            ticket.setCustomer(customer);
        }
        CustomerDAO.getInstance().refresh(customer);
        return customer;
    }

    @Override
    public void voidPayment(PosTransaction posTransaction, Session session) {
        String string = posTransaction.getCustomerId();
        if (StringUtils.isEmpty((String)string)) {
            string = posTransaction.getTicket().getCustomerId();
        }
        if (StringUtils.isEmpty((String)string)) {
            throw new PosException(Messages.getString("MemberPaymentPlugin.8"));
        }
        Customer customer = CustomerDAO.getInstance().get(string, session);
        Double d = customer.getBalance();
        customer.setBalance(d + posTransaction.getAmount());
        CustomerDAO.getInstance().saveOrUpdate(customer, session);
        BalanceUpdateTransactionDAO.getInstance().saveBalanceUpdateTrans(BalanceType.CUSTOMER, posTransaction.getTicket(), posTransaction, TransactionType.CREDIT, customer.getId(), posTransaction.getAmount(), d, null, session);
    }

    @Override
    public String getProductName() {
        return null;
    }
}

