/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.print;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.main.Application;
import com.floreantpos.model.CardReader;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.KitchenTicket;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.ext.ReciptPaperSize;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.print.PosPrintService;
import com.floreantpos.print.ReceiptPrintServiceProvider;
import com.floreantpos.report.KitchenTicketDataSource;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.TicketDataSource;
import com.floreantpos.report.TicketPrintProperties;
import com.floreantpos.services.PosTransactionService;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.TicketReceiptView;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.PrintServiceUtil;
import java.awt.print.PrinterAbortException;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.engine.export.JRPrintServiceExporter;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimplePrintServiceExporterConfiguration;
import org.apache.commons.lang3.text.WordUtils;

public class JasperPrintService
extends ReceiptPrintServiceProvider {
    @Override
    public void printTicket(Ticket ticket, HashMap hashMap, String string) throws Exception {
        JasperPrint jasperPrint = this.createPrint(ticket, hashMap, null);
        jasperPrint.setName("ORDER-" + ticket.getId() + string);
        jasperPrint.setProperty("printerName", string);
        JasperPrintService.printQuitely(jasperPrint);
    }

    @Override
    public void printTransaction(Ticket ticket, HashMap hashMap, PosTransaction posTransaction, String string) throws Exception {
        JasperPrint jasperPrint = this.createPrint(ticket, hashMap, posTransaction);
        jasperPrint.setName("ORDER-" + ticket.getId() + string);
        jasperPrint.setProperty("printerName", string);
        JasperPrintService.printQuitely(jasperPrint);
    }

    @Override
    public void printVoidTicket(Ticket ticket, HashMap hashMap, String string) throws Exception {
        JasperPrint jasperPrint = this.createPrint(ticket, hashMap, null);
        jasperPrint.setName("VOID_" + ticket.getId());
        jasperPrint.setProperty("printerName", string);
        JasperPrintService.printQuitely(jasperPrint);
    }

    @Override
    public void printKitchenTicket(KitchenTicket kitchenTicket, HashMap hashMap, Ticket ticket, String string, String string2) throws Exception {
        JasperPrint jasperPrint = this.createKitchenPrint(hashMap, string, kitchenTicket, string2);
        jasperPrint.setName("KitchenReceipt_" + ticket.getId() + "_" + kitchenTicket.getSequenceNumber());
        jasperPrint.setProperty("printerName", string2);
        JasperPrintService.printQuitely(jasperPrint);
    }

    @Override
    public void printVoidKitchenTicket(KitchenTicket kitchenTicket, HashMap hashMap, String string, String string2) throws Exception {
        KitchenTicketDataSource kitchenTicketDataSource = new KitchenTicketDataSource(kitchenTicket);
        JasperPrint jasperPrint = this.createJasperPrint(ReportUtil.getReport("kitchen-receipt"), hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)kitchenTicketDataSource));
        jasperPrint.setName("Void_KitchenReceipt_" + kitchenTicket.getId() + "_" + kitchenTicket.getSequenceNumber());
        jasperPrint.setProperty("printerName", string2);
        JasperPrintService.printQuitely(jasperPrint);
    }

    @Override
    public void rendererTicketReceipt(Ticket ticket, JPanel jPanel) throws Exception {
        TicketPrintProperties ticketPrintProperties = new TicketPrintProperties(null, false, true, true);
        HashMap<String, Object> hashMap = ReceiptPrintService.populateTicketProperties(ticket, ticketPrintProperties, null);
        hashMap.put("IS_IGNORE_PAGINATION", true);
        JasperPrint jasperPrint = this.createPrint(ticket, hashMap, null, false);
        TicketReceiptView ticketReceiptView = new TicketReceiptView(jasperPrint);
        jPanel.add(ticketReceiptView.getReportPanel());
    }

    @Override
    public void rendererPosTransactionReceipt(PosTransaction posTransaction, JPanel jPanel) throws Exception {
        JasperPrint jasperPrint = this.createTransactionReceipt(posTransaction);
        TicketReceiptView ticketReceiptView = new TicketReceiptView(jasperPrint);
        jPanel.add(ticketReceiptView.getReportPanel());
    }

    @Override
    public void rendererKitchenReceipt(Ticket ticket, JPanel jPanel) throws Exception {
        JasperPrint jasperPrint = this.a(ticket);
        TicketReceiptView ticketReceiptView = new TicketReceiptView(jasperPrint);
        jPanel.add(ticketReceiptView.getReportPanel());
    }

    public JasperPrint createJasperPrint(JasperReport jasperReport, Map<String, Object> map, JRDataSource jRDataSource) throws Exception {
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, map, (JRDataSource)jRDataSource);
        return jasperPrint;
    }

    public JasperPrint createPrint(Ticket ticket, Map<String, Object> map, PosTransaction posTransaction) throws Exception {
        return this.createPrint(ticket, map, posTransaction, false);
    }

    public JasperPrint createPrint(Ticket ticket, Map<String, Object> map, PosTransaction posTransaction2, boolean bl) throws Exception {
        Object object;
        ReciptPaperSize reciptPaperSize = JasperPrintService.a("main.recipt.paper_size");
        TicketDataSource ticketDataSource = new TicketDataSource(ticket, bl);
        ReportUtil.populatePatternExpression(map, DataProvider.get().getStore());
        ArrayList<PosTransaction> arrayList = new ArrayList<PosTransaction>(ticket.getTransactions().stream().filter(posTransaction -> posTransaction.isVoided() == false).collect(Collectors.toList()));
        PosTransactionService.sortTransactionsByDateDesc(arrayList);
        if (arrayList.size() > 0) {
            object = new TransactionReportModel(posTransaction2, arrayList);
            map.put("tenderAmountDataSource", new JRTableModelDataSource((TableModel)object));
            JasperReport jasperReport = ReportUtil.getReport(reciptPaperSize.getReportNameAccording2Size("ticket-recipt-transaction"));
            map.put("tenderAmountReport", jasperReport);
        }
        object = ReportUtil.getReport(reciptPaperSize.getReportNameAccording2Size("ticket-recipt"));
        return this.createJasperPrint((JasperReport)object, map, (JRDataSource)new JRTableModelDataSource((TableModel)ticketDataSource));
    }

    public JasperPrint createRefundPrint(Ticket ticket, HashMap<String, Object> hashMap) throws Exception {
        return this.createPrint(ticket, hashMap, null, false);
    }

    public JasperPrint createTransactionReceipt(PosTransaction posTransaction) {
        try {
            Ticket ticket = posTransaction.getTicket();
            TicketPrintProperties ticketPrintProperties = new TicketPrintProperties(Messages.getString("ReceiptPrintService.3"), true, true, true);
            ticketPrintProperties.setPrintCookingInstructions(false);
            HashMap<String, Object> hashMap = ReceiptPrintService.populateTicketProperties(ticket, ticketPrintProperties, posTransaction);
            hashMap.put("IS_IGNORE_PAGINATION", true);
            if (posTransaction != null && posTransaction.isCard()) {
                CardReader cardReader = CardReader.fromString(posTransaction.getCardReader());
                if (cardReader == CardReader.EXTERNAL_TERMINAL) {
                    return null;
                }
                hashMap.put("cardPayment", true);
                hashMap.put("copyType", Messages.getString("ReceiptPrintService.4"));
                JasperPrint jasperPrint = this.createPrint(ticket, hashMap, posTransaction);
                jasperPrint.setName("Ticket-" + ticket.getId() + "-CustomerCopy");
                jasperPrint.setProperty("printerName", DataProvider.get().getPrinters().getReceiptPrinter());
                hashMap.put("copyType", Messages.getString("ReceiptPrintService.5"));
                jasperPrint = this.createPrint(ticket, hashMap, posTransaction);
                jasperPrint.setName("Ticket-" + ticket.getId() + "-MerchantCopy");
                jasperPrint.setProperty("printerName", DataProvider.get().getPrinters().getReceiptPrinter());
                return jasperPrint;
            }
            JasperPrint jasperPrint = this.createPrint(ticket, hashMap, posTransaction);
            jasperPrint.setName("Ticket-" + ticket.getId());
            jasperPrint.setProperty("printerName", DataProvider.get().getPrinters().getReceiptPrinter());
            return jasperPrint;
        }
        catch (Exception exception) {
            ReceiptPrintService.getLogger().error((Object)POSConstants.PRINT_ERROR, (Throwable)exception);
            return null;
        }
    }

    private static ReciptPaperSize a(String string) {
        return ReceiptPrintService.getReceiptPaperSize(string);
    }

    public JasperPrint createKitchenPrint(KitchenTicket kitchenTicket) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("cardPayment", true);
        hashMap.put("showHeaderSeparator", Boolean.TRUE);
        hashMap.put("showHeaderSeparator", Boolean.TRUE);
        KitchenTicketDataSource kitchenTicketDataSource = new KitchenTicketDataSource(kitchenTicket);
        ReciptPaperSize reciptPaperSize = JasperPrintService.a("kitchen.recipt.paper_size");
        return this.createJasperPrint(ReportUtil.getReport(reciptPaperSize.getReportNameAccording2Size("kitchen-receipt")), hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)kitchenTicketDataSource));
    }

    public JasperPrint createKitchenPrint(HashMap hashMap, String string, KitchenTicket kitchenTicket, String string2) throws Exception {
        return this.createKitchenPrint(hashMap, string, kitchenTicket, string2, false);
    }

    public JasperPrint createKitchenPrint(HashMap hashMap, String string, KitchenTicket kitchenTicket, String string2, boolean bl) throws Exception {
        KitchenTicketDataSource kitchenTicketDataSource = new KitchenTicketDataSource(kitchenTicket);
        String string3 = "kitchen-receipt";
        ReciptPaperSize reciptPaperSize = JasperPrintService.a("kitchen.recipt.paper_size");
        if (Application.getInstance().getTerminal().isGroupByCatagoryKitReceipt().booleanValue()) {
            string3 = "kitchen-receipt-with-group";
        }
        return this.createJasperPrint(ReportUtil.getReport(reciptPaperSize.getReportNameAccording2Size(string3)), hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)kitchenTicketDataSource));
    }

    public static void printQuitely(JasperPrint jasperPrint) throws JRException {
        block4: {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
                Date date = new Date();
                String string = simpleDateFormat.format(date);
                String string2 = jasperPrint.getProperty("printerName");
                if (string2 != null && string2.equals(ReceiptPrintService.OROPOS_PDF_PRINTER)) {
                    String string3 = jasperPrint.getName().replace(string2, "") + "-[" + string + "]";
                    File file = new File(ReceiptPrintService.getPdfPrinterDir(), string3 + ".pdf");
                    JasperExportManager.exportReportToPdfFile((JasperPrint)jasperPrint, (String)file.getAbsolutePath());
                } else {
                    SimplePrintServiceExporterConfiguration simplePrintServiceExporterConfiguration = new SimplePrintServiceExporterConfiguration();
                    simplePrintServiceExporterConfiguration.setPrintService(PrintServiceUtil.getPrintServiceForPrinter(jasperPrint.getProperty("printerName")));
                    JRPrintServiceExporter jRPrintServiceExporter = new JRPrintServiceExporter();
                    jRPrintServiceExporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
                    jRPrintServiceExporter.setConfiguration((ExporterConfiguration)simplePrintServiceExporterConfiguration);
                    jRPrintServiceExporter.exportReport();
                }
            }
            catch (Exception exception) {
                if (exception != null && exception.getCause() instanceof PrinterAbortException) break block4;
                String string = "No print selected\n";
                ReceiptPrintService.getLogger().error((Object)(string + exception));
            }
        }
    }

    private JasperPrint a(Ticket ticket) {
        try {
            List<KitchenTicket> list = KitchenTicket.fromTicket(ticket, false);
            Iterator<KitchenTicket> iterator = list.iterator();
            if (iterator.hasNext()) {
                KitchenTicket kitchenTicket = iterator.next();
                kitchenTicket.setParentTicket(ticket);
                HashMap hashMap = ReceiptPrintService.populateKitchenTicketProperties(kitchenTicket, "", "", true);
                JasperPrint jasperPrint = this.createKitchenPrint(hashMap, "", kitchenTicket, "", true);
                jasperPrint.setName("FP_KitchenReceipt_" + ticket.getId() + "_" + kitchenTicket.getSequenceNumber());
                return jasperPrint;
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
        return null;
    }

    public void printGenericReport(HashMap<String, Object> hashMap) throws Exception {
        JasperPrint jasperPrint = this.createJasperPrint(ReportUtil.getReport("generic-receipt"), hashMap, (JRDataSource)new JREmptyDataSource());
        jasperPrint.setProperty("printerName", DataProvider.get().getPrinters().getReceiptPrinter());
        JasperPrintService.printQuitely(jasperPrint);
    }

    @Override
    public void testPrinter(HashMap<String, Object> hashMap, String string) throws Exception {
        JasperPrint jasperPrint = this.createJasperPrint(ReportUtil.getReport("test-printer"), hashMap, (JRDataSource)new JREmptyDataSource());
        jasperPrint.setProperty("printerName", string);
        JasperPrintService.printQuitely(jasperPrint);
    }

    @Override
    public void printServerSummaryReport(CashDrawer cashDrawer, HashMap hashMap, String string) throws Exception {
        JasperPrint jasperPrint = PosPrintService.createServerSummaryReportPrint(cashDrawer, hashMap);
        jasperPrint.setProperty("printerName", string);
        JasperPrintService.printQuitely(jasperPrint);
    }

    @Override
    public void showServerSummaryReport(CashDrawer cashDrawer, HashMap hashMap, JPanel jPanel) throws Exception {
        jPanel.removeAll();
        JasperPrint jasperPrint = PosPrintService.createServerSummaryReportPrint(cashDrawer, hashMap);
        TicketReceiptView ticketReceiptView = new TicketReceiptView(jasperPrint);
        ticketReceiptView.setZoom(1.25f);
        jPanel.add(ticketReceiptView.getReportPanel());
        jPanel.revalidate();
        jPanel.repaint();
    }

    @Override
    public void printCashDrawerReport(CashDrawer cashDrawer, HashMap hashMap, String string) throws Exception {
        JasperPrint jasperPrint = PosPrintService.createCashDrawerReportPrint(cashDrawer, hashMap);
        jasperPrint.setProperty("printerName", string);
        JasperPrintService.printQuitely(jasperPrint);
    }

    @Override
    public void showCashDrawerReport(CashDrawer cashDrawer, HashMap hashMap, JPanel jPanel) throws Exception {
        jPanel.removeAll();
        JasperPrint jasperPrint = PosPrintService.createCashDrawerReportPrint(cashDrawer, hashMap);
        TicketReceiptView ticketReceiptView = new TicketReceiptView(jasperPrint);
        ticketReceiptView.setZoom(1.25f);
        jPanel.add(ticketReceiptView.getReportPanel());
        jPanel.revalidate();
        jPanel.repaint();
    }

    @Override
    public void printStoreSessionSummaryReport(CashDrawer cashDrawer, HashMap hashMap, String string) throws Exception {
        JasperPrint jasperPrint = PosPrintService.createStoreSessionSummaryReportPrint(cashDrawer, hashMap);
        jasperPrint.setProperty("printerName", string);
        JasperPrintService.printQuitely(jasperPrint);
    }

    @Override
    public void showStoreSessionSummaryReport(CashDrawer cashDrawer, HashMap hashMap, JPanel jPanel) throws Exception {
        jPanel.removeAll();
        JasperPrint jasperPrint = PosPrintService.createStoreSessionSummaryReportPrint(cashDrawer, hashMap);
        TicketReceiptView ticketReceiptView = new TicketReceiptView(jasperPrint);
        ticketReceiptView.setZoom(1.25f);
        jPanel.add(ticketReceiptView.getReportPanel());
        jPanel.revalidate();
        jPanel.repaint();
    }

    private static class TransactionReportModel
    extends ListTableModel<PosTransaction> {
        private PosTransaction a;

        public TransactionReportModel(PosTransaction posTransaction, List<PosTransaction> list) {
            super(new String[]{"tenderName", "transAmount"}, list);
            this.a = posTransaction;
        }

        @Override
        public String[] getColumnNames() {
            return this.columnNames;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            PosTransaction posTransaction = (PosTransaction)this.getRowData(n);
            String string = CurrencyUtil.getCurrencySymbol();
            switch (n2) {
                case 0: {
                    PaymentType paymentType = posTransaction.getPaymentType();
                    String string2 = null;
                    string2 = paymentType == PaymentType.CUSTOM_PAYMENT ? posTransaction.getCustomPaymentName() : WordUtils.capitalizeFully((String)posTransaction.getPaymentType().getDisplayString());
                    string2 = posTransaction instanceof RefundTransaction ? string2 + Messages.getString("EscPosPrintService.0") + string : string2 + string;
                    return string2;
                }
                case 1: {
                    Double d = posTransaction.getAmount();
                    if (posTransaction.equals(this.a)) {
                        d = this.a.getTenderAmount();
                    }
                    if (posTransaction instanceof RefundTransaction) {
                        d = -1.0 * posTransaction.getAmount();
                    }
                    return d;
                }
            }
            return null;
        }
    }
}

