/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.model.CreditCardTransaction;
import com.floreantpos.model.CustomPayment;
import com.floreantpos.model.CustomPaymentTransaction;
import com.floreantpos.model.CustomerAccountTransaction;
import com.floreantpos.model.DebitCardTransaction;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.dao.CustomPaymentDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.CardReportModel;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.swing.ListComboBoxModel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.PanelTester;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.jdesktop.swingx.JXDatePicker;

public class CreditCardReportView
extends JPanel {
    private JXDatePicker a = UiUtil.getCurrentMonthStart();
    private JXDatePicker b = UiUtil.getCurrentMonthEnd();
    private JComboBox<Object> c;
    private JComboBox<Object> d;
    private JButton e = new JButton(POSConstants.GO);
    private JPanel f;

    public CreditCardReportView() {
        super(new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout());
        this.d = new JComboBox();
        this.c = new JComboBox();
        jPanel.add((Component)new JLabel(POSConstants.FROM + ":"), "grow");
        jPanel.add((Component)this.a);
        jPanel.add((Component)new JLabel(POSConstants.TO + ":"), "grow");
        jPanel.add((Component)this.b);
        jPanel.add((Component)new JLabel(Messages.getString("PAYMENT_TYPE") + ":"), "grow");
        jPanel.add(this.c);
        jPanel.add((Component)new JLabel(Messages.getString("customPayment") + ":"), "grow");
        jPanel.add(this.d);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(POSConstants.ALL);
        arrayList.add((Object)PaymentType.CARD);
        arrayList.add((Object)PaymentType.CUSTOM_PAYMENT);
        this.c.setModel(new ListComboBoxModel(arrayList));
        this.c.addActionListener(actionEvent -> this.a());
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        arrayList2.add(0, POSConstants.ALL);
        arrayList2.addAll(CustomPaymentDAO.getInstance().findAll());
        this.d.setModel(new ListComboBoxModel(arrayList2));
        jPanel.add((Component)this.e, "skip 1, al right");
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(0, 10, 10, 10));
        jPanel2.add((Component)new JSeparator(), "North");
        this.f = new JPanel(new BorderLayout());
        jPanel2.add(this.f);
        this.add(jPanel2);
        this.e.addActionListener(actionEvent -> this.b());
    }

    private void a() {
        if (this.c.getSelectedItem().equals((Object)PaymentType.CARD)) {
            this.d.setSelectedIndex(0);
            this.d.setEnabled(false);
        } else {
            this.d.setEnabled(true);
        }
    }

    private void b() {
        try {
            Class clazz22;
            Date date = this.a.getDate();
            Date date2 = this.b.getDate();
            PaymentType paymentType = null;
            if (this.c.getSelectedItem() instanceof PaymentType) {
                paymentType = (PaymentType)((Object)this.c.getSelectedItem());
            }
            CustomPayment customPayment = null;
            if (this.d.getSelectedItem() instanceof CustomPayment) {
                customPayment = (CustomPayment)this.d.getSelectedItem();
            }
            DateUtil.validateDate(date, date2);
            date = DateUtil.startOfDay(date);
            date2 = DateUtil.endOfDay(date2);
            double d = 0.0;
            ArrayList<PosTransaction> arrayList = new ArrayList<PosTransaction>();
            Class[] classArray = new Class[]{CreditCardTransaction.class, DebitCardTransaction.class, CustomPaymentTransaction.class, CustomerAccountTransaction.class, RefundTransaction.class};
            for (Class clazz22 : classArray) {
                List<? extends PosTransaction> list = PosTransactionDAO.getInstance().findTransactions(null, null, clazz22, date, date2, true, false, true, paymentType, customPayment);
                for (PosTransaction posTransaction : list) {
                    double d2 = posTransaction.getAmount();
                    if (posTransaction instanceof RefundTransaction) {
                        if (posTransaction.getPaymentType().equals((Object)PaymentType.CASH) || posTransaction.getPaymentType().equals((Object)PaymentType.GIFT_CERTIFICATE) || posTransaction.getPaymentType().equals((Object)PaymentType.PROMOTION)) continue;
                        d2 = -1.0 * d2;
                    }
                    d += d2;
                    arrayList.add(posTransaction);
                }
            }
            HashMap hashMap = new HashMap();
            ReportUtil.populateRestaurantProperties(hashMap);
            ReportUtil.populateReportTime(hashMap, date, date2);
            ReportUtil.populateReportFooter(hashMap);
            this.a(hashMap);
            hashMap.put("reportTitle", Messages.getString("CreditCardReportView.0"));
            hashMap.put("total", NumberUtil.formatNumber(d));
            hashMap.put("totalCount", ReportUtil.reportLabelWithBoldTag(Messages.getString("CreditCardReportView.3")) + arrayList.size());
            JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("credit-card-report"));
            JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, (Map)hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)new CardReportModel(arrayList)));
            clazz22 = new JRViewer(jasperPrint);
            this.f.removeAll();
            this.f.add((Component)((Object)clazz22));
            this.f.revalidate();
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void a(HashMap<String, Object> hashMap) {
        hashMap.put("colTicketNo", Messages.getString("TicketNo"));
        hashMap.put("colPaymentType", Messages.getString("SettleTicketDialog.9"));
        hashMap.put("colCardType", Messages.getString("CreditCardReportView.1"));
        hashMap.put("colMember", Messages.getString("MEMBER"));
        hashMap.put("colDate", POSConstants.DATE);
        hashMap.put("colServer", POSConstants.SERVER);
        hashMap.put("colAuthC", Messages.getString("AuthCode"));
        hashMap.put("tips", Messages.getString("CreditCardReportView.2") + CurrencyUtil.getCurrencySymbolWithBracket());
        hashMap.put("totalHeader", Messages.getString("CreditCardReportView.6") + CurrencyUtil.getCurrencySymbolWithBracket());
        hashMap.put("rowTotal", POSConstants.TOTAL + ":");
    }

    public static void main(String[] stringArray) {
        PanelTester.width = 800;
        PanelTester.height = 500;
        PanelTester.test(new CreditCardReportView());
    }
}

