/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.report.ReportItem;
import com.floreantpos.util.NumberUtil;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.lang.StringUtils;

public class SalesReportModel
extends AbstractTableModel {
    private String[] a = new String[]{"barcode", "name", "unit", "qty", "price", "cost", "costPercentage", "grossTotal", "tax", "netTotal", "group", "discount", "serviceCharge", "grossSale", "returnAmount", "profit", "profitPercentage", "userName", "qtyAndUnit"};
    private List<ReportItem> b;
    private double c;
    private double d;
    private double e;
    private double f;
    private double g;
    private double h;
    private double i;
    private double j;
    private double k;

    @Override
    public int getRowCount() {
        if (this.b == null) {
            return 0;
        }
        return this.b.size();
    }

    @Override
    public int getColumnCount() {
        return this.a.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.a[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        ReportItem reportItem = this.b.get(n);
        if (reportItem.isComboChildItem() && (n2 < 1 || n2 > 3) && n2 != 10 && n2 != 17 && n2 != 18) {
            return null;
        }
        switch (n2) {
            case 0: {
                return reportItem.getBarcode() != null ? reportItem.getBarcode() : reportItem.getId();
            }
            case 1: {
                return reportItem.getName();
            }
            case 2: {
                return reportItem.getUnit();
            }
            case 3: {
                return reportItem.getQuantity();
            }
            case 4: {
                return reportItem.getPrice();
            }
            case 5: {
                return reportItem.getCost();
            }
            case 6: {
                if (reportItem.getAdjustedPrice() > 0.0) {
                    return reportItem.getCost() / reportItem.getAdjustedPrice() * 100.0;
                }
                return 0.0;
            }
            case 7: {
                return reportItem.getGrossTotal();
            }
            case 8: {
                return reportItem.getTaxTotal();
            }
            case 9: {
                return reportItem.getNetTotal();
            }
            case 10: {
                if (reportItem.getGroupName() != null) {
                    return Messages.getString("SalesReportModel.1") + reportItem.getGroupName();
                }
                return Messages.getString("SalesReportModel.2");
            }
            case 11: {
                return reportItem.getDiscount();
            }
            case 12: {
                return reportItem.getServiceCharge();
            }
            case 13: {
                return reportItem.getGrossSale();
            }
            case 14: {
                return reportItem.getReturnAmount();
            }
            case 15: {
                return reportItem.getProfit();
            }
            case 16: {
                return reportItem.getProfitPrecentage();
            }
            case 17: {
                return reportItem.getUserName();
            }
            case 18: {
                String string = NumberUtil.format6DigitNumber(reportItem.getQuantity());
                if (StringUtils.isNotBlank((String)reportItem.getUnit())) {
                    string = string + "" + reportItem.getUnit();
                }
                return string;
            }
        }
        return null;
    }

    public List<ReportItem> getItems() {
        return this.b;
    }

    public void setItems(List<ReportItem> list) {
        this.b = list;
    }

    public double getGndTotalGrossSales() {
        return this.c;
    }

    public void setGndTotalGrossSales(double d) {
        this.c = d;
    }

    public double getGndTotalDiscount() {
        return this.d;
    }

    public void setGndTotalDiscount(double d) {
        this.d = d;
    }

    public double getGndTotalReturn() {
        return this.e;
    }

    public void setGndTotalReturn(double d) {
        this.e = d;
    }

    public double getGndTotalNetSales() {
        return this.f;
    }

    public void setGndTotalNetSales(double d) {
        this.f = d;
    }

    public double getGndTotalServCharge() {
        return this.g;
    }

    public void setGndTotalServCharge(double d) {
        this.g = d;
    }

    public double getGndTotalTax() {
        return this.h;
    }

    public void setGndTotalTax(double d) {
        this.h = d;
    }

    public double getGndTotalTotal() {
        return this.i;
    }

    public void setGndTotalTotal(double d) {
        this.i = d;
    }

    public double getGndTotalCost() {
        return this.j;
    }

    public void setGndTotalCost(double d) {
        this.j = d;
    }

    public double getGndTotalProfit() {
        return this.k;
    }

    public void setGndTotalProfit(double d) {
        this.k = d;
    }

    public void calculateGrandTotal() {
        if (this.b == null) {
            return;
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        for (ReportItem reportItem : this.b) {
            d += reportItem.getGrossSale();
            d2 += reportItem.getDiscount();
            d3 += reportItem.getReturnAmount();
            d4 += reportItem.getNetTotal();
            d5 += reportItem.getServiceCharge();
            d6 += reportItem.getTaxTotal();
            d7 += reportItem.getGrossTotal();
            d8 += reportItem.getCost();
            d9 += reportItem.getGrossTotal() - reportItem.getCost();
        }
        this.setGndTotalGrossSales(d);
        this.setGndTotalDiscount(d2);
        this.setGndTotalReturn(d3);
        this.setGndTotalNetSales(d4);
        this.setGndTotalServCharge(d5);
        this.setGndTotalTax(d6);
        this.setGndTotalTotal(d7);
        this.setGndTotalCost(d8);
        this.setGndTotalProfit(d9);
    }
}

