/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.swing.ListTableModel;
import com.floreantpos.util.NumberUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ServerProductivityReport {
    private Date a;
    private Date b;
    private Date c;
    private int d = 0;
    private List<ServerProductivityReportData> e = new ArrayList<ServerProductivityReportData>();
    private ServerProductivityReportTableModel f;

    public ServerProductivityReportTableModel getTableModel() {
        if (this.f == null) {
            this.f = new ServerProductivityReportTableModel(this.e);
        }
        return this.f;
    }

    public Date getFromDate() {
        return this.a;
    }

    public void setFromDate(Date date) {
        this.a = date;
    }

    public Date getReportTime() {
        return this.c;
    }

    public void setReportTime(Date date) {
        this.c = date;
    }

    public Date getToDate() {
        return this.b;
    }

    public void setToDate(Date date) {
        this.b = date;
    }

    public void addReportData(ServerProductivityReportData serverProductivityReportData) {
        this.e.add(serverProductivityReportData);
    }

    public void calculate() {
        if (this.e != null) {
            for (ServerProductivityReportData serverProductivityReportData : this.e) {
                if (StringUtils.isNotBlank((String)serverProductivityReportData.getCategoryName())) continue;
                this.d += serverProductivityReportData.getTotalCheckCount();
            }
        }
    }

    public class ServerProductivityReportTableModel
    extends ListTableModel {
        String[] a = new String[]{"serverName", "categoryName", "totalCheckCount", "totalGuestCount", "totalSales", "netSales", "averageNetSales", "totalAllocation", "grossSales", "salesDiscount", "returnAmount", "averageCheck", "averageGuest", "allocation", "checkCount", "grandTotalCheckCount"};

        public ServerProductivityReportTableModel(List<ServerProductivityReportData> list) {
            this.setColumnNames(this.a);
            this.setRows(list);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ServerProductivityReportData serverProductivityReportData = (ServerProductivityReportData)this.rows.get(n);
            switch (n2) {
                case 0: {
                    return serverProductivityReportData.getServerName();
                }
                case 1: {
                    return serverProductivityReportData.getCategoryName();
                }
                case 2: {
                    return String.valueOf(serverProductivityReportData.getTotalCheckCount());
                }
                case 3: {
                    return String.valueOf(serverProductivityReportData.getTotalGuestCount());
                }
                case 4: {
                    return NumberUtil.formatNumber(serverProductivityReportData.getTotalSales());
                }
                case 5: {
                    return serverProductivityReportData.getNetSales();
                }
                case 6: {
                    return NumberUtil.formatNumber(serverProductivityReportData.getAverageNetSales());
                }
                case 7: {
                    return NumberUtil.formatNumber(serverProductivityReportData.getTotalAllocation());
                }
                case 8: {
                    return serverProductivityReportData.getGrossSales();
                }
                case 9: {
                    return serverProductivityReportData.getSalesDiscount();
                }
                case 10: {
                    return serverProductivityReportData.getReturnAmount();
                }
                case 11: {
                    return NumberUtil.formatNumber(serverProductivityReportData.getAverageCheck());
                }
                case 12: {
                    return NumberUtil.formatNumber(serverProductivityReportData.getAverageGuest());
                }
                case 13: {
                    return NumberUtil.formatNumber(serverProductivityReportData.getAllocation());
                }
                case 14: {
                    return serverProductivityReportData.getItemCount();
                }
                case 15: {
                    return ServerProductivityReport.this.d;
                }
            }
            return null;
        }
    }

    public static class ServerProductivityReportData {
        private String a;
        private int b;
        private int c;
        private double d;
        private double e;
        private String f;
        private double g;
        private double h;
        private double i;
        private double j;
        private double k;
        private double l;
        private double m;
        private double n;
        private double o;

        public double getAllocation() {
            return this.o;
        }

        public void setAllocation(double d) {
            this.o = d;
        }

        public double getAverageCheck() {
            return this.j;
        }

        public void setAverageCheck(double d) {
            this.j = d;
        }

        public double getAverageGuest() {
            return this.k;
        }

        public void setAverageGuest(double d) {
            this.k = d;
        }

        public String getCategoryName() {
            return this.f;
        }

        public void setCategoryName(String string) {
            this.f = string;
        }

        public double getSalesDiscount() {
            return this.h;
        }

        public void setSalesDiscount(double d) {
            this.h = d;
        }

        public double getReturnAmount() {
            return this.i;
        }

        public void setReturnAmount(double d) {
            this.i = d;
        }

        public String getServerName() {
            return this.a;
        }

        public void setServerName(String string) {
            this.a = string;
        }

        public double getTotalAllocation() {
            return this.e;
        }

        public void setTotalAllocation(double d) {
            this.e = d;
        }

        public int getTotalCheckCount() {
            return this.b;
        }

        public void setTotalCheckCount(int n) {
            this.b = n;
        }

        public int getTotalGuestCount() {
            return this.c;
        }

        public void setTotalGuestCount(int n) {
            this.c = n;
        }

        public double getTotalSales() {
            return this.d;
        }

        public void setTotalSales(double d) {
            this.d = d;
        }

        public void calculate() {
            if (this.b > 0) {
                this.j = this.d / (double)this.b;
            }
            if (this.c > 0) {
                this.k = this.d / (double)this.c;
            }
            this.m = this.l - this.h - this.i;
            if (this.g > 0.0) {
                this.n = this.m / this.g;
                if (this.b > 0) {
                    this.o = this.g / (double)this.b * 100.0;
                }
            }
        }

        public double getAverageNetSales() {
            return this.n;
        }

        public void setAverageNetSales(double d) {
            this.n = d;
        }

        public double getGrossSales() {
            return this.l;
        }

        public void setGrossSales(double d) {
            this.l = d;
        }

        public double getNetSales() {
            return this.m;
        }

        public void setNetSales(double d) {
            this.m = d;
        }

        public double getItemCount() {
            return this.g;
        }

        public void setItemCount(double d) {
            this.g = d;
        }
    }
}

