/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report.service;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.model.BalanceForwardTransaction;
import com.floreantpos.model.BalanceUpdateTransaction;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.TransactionSubType;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.model.GiftCardTransactionsReportModel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;

public class GiftCarReportService {
    public JasperPrint reportCreation(List<BalanceUpdateTransaction> list, GiftCard giftCard) {
        return this.reportCreation(list, giftCard, Boolean.FALSE);
    }

    public JasperPrint reportCreation(List<BalanceUpdateTransaction> list, GiftCard giftCard, boolean bl) {
        JasperPrint jasperPrint = null;
        try {
            if (list == null || list.isEmpty()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GiftCardTransactionInfoView.10"));
                return null;
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            ReportUtil.populateRestaurantProperties(hashMap, true);
            ReportUtil.populateReportFooter(hashMap);
            this.a(hashMap, giftCard, list);
            hashMap.put("isSalesOnly", bl);
            JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("gift_card_transaction_report"));
            jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)new GiftCardTransactionsReportModel(list)));
        }
        catch (Exception exception) {
            PosLog.info(this.getClass(), "" + exception.getMessage());
        }
        return jasperPrint;
    }

    private void a(Map<String, Object> map, GiftCard giftCard, List<BalanceUpdateTransaction> list) {
        Object object;
        if (giftCard != null) {
            object = giftCard.getCardNumber() != null ? giftCard.getCardNumber() : "";
            String string = DateUtil.formatDateWithTime(giftCard.getActivationDate());
            String string2 = giftCard.getOwnerName() != null ? giftCard.getOwnerName() : "";
            String object2 = giftCard.getBalance() != null ? CurrencyUtil.getCurrencySymbol() + NumberUtil.formatNumber(giftCard.getBalance()) : "";
            map.put("cardNo", ReportUtil.reportLabelWithBoldTag(Messages.getString("GiftCardExplorer.42") + ": ") + (String)object);
            map.put("activeDate", ReportUtil.reportLabelWithBoldTag(Messages.getString("GiftCardSummaryReportView.2") + ": ") + string);
            map.put("cardOwner", ReportUtil.reportLabelWithBoldTag(Messages.getString("CardOwner") + " ") + (String)string2);
            map.put("endBalance", ReportUtil.reportLabelWithBoldTag(Messages.getString("EndBalance") + " ") + object2);
        }
        object = 0.0;
        int n = 0;
        for (BalanceUpdateTransaction balanceUpdateTransaction : list) {
            if (balanceUpdateTransaction.getDataVersion() != null && balanceUpdateTransaction.getDataVersion() == 2) {
                String string = balanceUpdateTransaction.getTransactionSubType();
                TransactionSubType transactionSubType = TransactionSubType.getSubType(string);
                if (transactionSubType != null && (transactionSubType == TransactionSubType.SALES || transactionSubType == TransactionSubType.VOIDED_SALES)) {
                    object = (Double)object + -1.0 * balanceUpdateTransaction.getAmount();
                }
            } else if (!(balanceUpdateTransaction instanceof BalanceForwardTransaction) && balanceUpdateTransaction.getTransactionType().equals(TransactionType.CREDIT.name())) {
                object = (Double)object + balanceUpdateTransaction.getAmount();
            }
            if (balanceUpdateTransaction instanceof BalanceForwardTransaction) continue;
            ++n;
        }
        map.put("reportTitle", Messages.getString("GiftCardTransactionsReport"));
        map.put("reportTime", ReportUtil.reportLabelWithBoldTag(POSConstants.REPORT_TIME) + DateUtil.formatDateWithTime(new Date()));
        map.put("titleAmount", POSConstants.AMOUNT + CurrencyUtil.getCurrencySymbolWithBracket());
        map.put("colTicketN", Messages.getString("TicketNo"));
        map.put("colTransT", Messages.getString("TRANSACTION_TIME"));
        map.put("colDes", Messages.getString("MenuItemSizeForm.4"));
        map.put("totalTransactions", ReportUtil.reportLabelWithBoldTag(Messages.getString("GiftCardTransactionReportView.0") + ": ") + n);
        map.put("totalSalesAmount", ReportUtil.reportLabelWithBoldTag(Messages.getString("GiftCardTransactionReportView.3") + ": ") + CurrencyUtil.getCurrencySymbol() + NumberUtil.formatNumber((Double)object));
        map.put("lblGiftCardNumber", ReportUtil.reportLabelWithBoldTag(Messages.getString("GiftCardTransactionReportView.4") + ": "));
        map.put("colGroupTotal", ReportUtil.reportLabelWithBoldTag(Messages.getString("EndBalance")));
    }
}

