/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.services;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.config.CardConfig;
import com.floreantpos.config.GiftCardConfig;
import com.floreantpos.extension.GiftCardPaymentPlugin;
import com.floreantpos.main.Application;
import com.floreantpos.model.BalanceType;
import com.floreantpos.model.CardReader;
import com.floreantpos.model.CashBreakdown;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.CashDropTransaction;
import com.floreantpos.model.CreditCardTransaction;
import com.floreantpos.model.Currency;
import com.floreantpos.model.Customer;
import com.floreantpos.model.DebitCardTransaction;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PayOutTransaction;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TransactionSubType;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.BalanceUpdateTransactionDAO;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.GiftCardDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.services.PostPaymentProcessor;
import com.floreantpos.ui.dialog.MultiCurrencyTenderDialog;
import com.floreantpos.ui.views.payment.CardProcessor;
import com.floreantpos.ui.views.payment.GiftCardProcessor;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class PosTransactionService {
    private static PosTransactionService a = new PosTransactionService();

    public void settleTicket(Ticket ticket, PosTransaction posTransaction, User user) throws Exception {
        this.settleTicket(ticket, posTransaction, user, null, null);
    }

    public void settleTicket(Ticket ticket, PosTransaction posTransaction, User user, PostPaymentProcessor postPaymentProcessor, List<MultiCurrencyTenderDialog.PaymentByCurrency> list) throws Exception {
        if (user == null) {
            user = Application.getCurrentUser();
        }
        Terminal terminal = DataProvider.get().getCurrentTerminal();
        Transaction transaction = null;
        try (Session session = null;){
            session = TerminalDAO.getInstance().createNewSession();
            Date date = StoreDAO.getServerTimestamp();
            transaction = session.beginTransaction();
            this.b(ticket, posTransaction, session);
            CashDrawer cashDrawer = user.getActiveDrawerPullReport();
            this.adjustMulticurrencyBalance(session, terminal, cashDrawer, list, posTransaction);
            posTransaction.setTransactionType(TransactionType.CREDIT.name());
            posTransaction.setPaymentType(posTransaction.getPaymentType());
            posTransaction.setTerminal(terminal);
            posTransaction.setUser(user);
            posTransaction.setServer(ticket.getOwner());
            posTransaction.setCashDrawer(cashDrawer);
            posTransaction.setTransactionTime(date);
            posTransaction.setCustomerId(ticket.getCustomerId());
            posTransaction.setCustomerName(ticket.getCustomerName());
            posTransaction.setStoreSessionId(DataProvider.get().getStoreSessionId());
            ticket.setCashier(user);
            if (posTransaction.getAmount() > 0.0) {
                ticket.addTotransactions(posTransaction);
            }
            ticket.setVoided(false);
            ticket.setTerminal(terminal);
            ticket.setPaidAmount(NumberUtil.round(ticket.getPaidAmount() + posTransaction.getAmount()));
            ticket.setShouldUpdateStock(true);
            ticket.calculatePrice();
            this.b(ticket, posTransaction);
            if (NumberUtil.isZero(ticket.getDueAmount())) {
                ticket.setPaid(true);
                PosTransactionService.closeTicketIfApplicable(ticket, date);
            } else {
                ticket.setPaid(false);
                ticket.setClosed(false);
            }
            if (ticket.getOrderType() != null && ticket.getOrderType().isBarTab().booleanValue()) {
                ticket.removeProperty("payment_method");
                ticket.removeProperty("card_name");
                ticket.removeProperty("card_transaction_id");
                ticket.removeProperty("card_tracks");
                ticket.removeProperty("card_reader");
                ticket.removeProperty("advance_payment");
                ticket.removeProperty("card_number");
                ticket.removeProperty("card_exp_year");
                ticket.removeProperty("card_exp_month");
                ticket.removeProperty("card_auth_code");
            }
            this.a(ticket, posTransaction, session);
            this.c(ticket, posTransaction);
            this.a(ticket);
            TicketDAO.getInstance().saveOrUpdate(ticket, session);
            if (postPaymentProcessor != null) {
                postPaymentProcessor.paymentDone(posTransaction, session);
            }
            transaction.commit();
            this.a(ticket, posTransaction);
        }
    }

    public void settleBarTabTicket(Ticket ticket, PosTransaction posTransaction, boolean bl, User user) throws Exception {
        Application application = Application.getInstance();
        Terminal terminal = application.refreshAndGetTerminal();
        Transaction transaction = null;
        GenericDAO genericDAO = new GenericDAO();
        try (Session session = genericDAO.createNewSession();){
            Date date = StoreDAO.getServerTimestamp();
            transaction = session.beginTransaction();
            ticket.setVoided(false);
            ticket.setTerminal(terminal);
            ticket.setPaidAmount(NumberUtil.round(ticket.getPaidAmount() + posTransaction.getAmount()));
            ticket.calculatePrice();
            if (bl) {
                ticket.setPaid(true);
                PosTransactionService.closeTicketIfApplicable(ticket, date);
            } else {
                ticket.setPaid(false);
                ticket.setClosed(false);
            }
            posTransaction.setTransactionType(TransactionType.CREDIT.name());
            posTransaction.setPaymentType(posTransaction.getPaymentType());
            posTransaction.setTerminal(terminal);
            posTransaction.setUser(user);
            posTransaction.setServer(ticket.getOwner());
            posTransaction.setCashDrawer(user.getActiveDrawerPullReport());
            posTransaction.setTransactionTime(date);
            posTransaction.setStoreSessionId(DataProvider.get().getStoreSessionId());
            ticket.setCashier(user);
            ticket.addTotransactions(posTransaction);
            ticket.setShouldUpdateStock(true);
            this.a(ticket);
            TicketDAO.getInstance().saveOrUpdate(ticket, session);
            this.b(ticket, posTransaction, session);
            transaction.commit();
        }
        catch (Exception exception) {
            try {
                transaction.rollback();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw exception;
        }
        this.a(ticket, posTransaction);
    }

    public void voidTicket(Ticket ticket, User user) throws Exception {
        Terminal terminal = Application.getInstance().getTerminal();
        ticket.setVoidedBy(user);
        ticket.setTerminal(terminal);
        ticket.calculatePrice();
        TicketDAO.getInstance().voidTicket(ticket);
        try {
            ReceiptPrintService.printVoidTicket(ticket);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public PosTransaction refundTicket(Ticket ticket, PosTransaction posTransaction, double d, User user, PaymentType paymentType, Map<String, String> map) throws Exception {
        if (map == null) {
            map = new HashMap<String, String>();
        }
        RefundTransaction refundTransaction = this.createRefundTransaction(ticket, posTransaction, d, paymentType, map);
        refundTransaction.setUser(user);
        refundTransaction.setServer(ticket.getOwner());
        if (NumberUtil.isZero(ticket.getDueAmount())) {
            ticket.setClosed(true);
            ticket.setClosingDate(StoreDAO.getServerTimestamp());
        }
        Transaction transaction = null;
        try (Session session = TicketDAO.getInstance().createNewSession();){
            transaction = session.beginTransaction();
            ticket.setShouldUpdateStock(true);
            this.a(ticket);
            this.b(ticket, refundTransaction, session);
            BalanceType balanceType = null;
            String string = null;
            Double d2 = null;
            TransactionSubType transactionSubType = null;
            if (paymentType == PaymentType.GIFT_CERTIFICATE) {
                String string2 = map.get(PosTransaction.PROP_GIFT_CERT_NUMBER);
                if (StringUtils.isBlank((String)string2)) {
                    throw new PosException(Messages.getString("GiftCardCannotBeEmpty"));
                }
                GiftCardPaymentPlugin giftCardPaymentPlugin = GiftCardConfig.getPaymentGateway();
                GiftCardProcessor giftCardProcessor = giftCardPaymentPlugin.getProcessor();
                GiftCard giftCard = giftCardProcessor.getCard(string2);
                if (giftCard == null) {
                    throw new PosException(Messages.getString("PosTransactionService.7"));
                }
                d2 = giftCard.getBalance();
                transactionSubType = TransactionSubType.REFUNDED;
                giftCardProcessor.refund(string2, d, session);
                balanceType = BalanceType.GIFT_CARD;
                string = string2;
            } else if (paymentType == PaymentType.MEMBER_ACCOUNT) {
                Customer customer = ticket.getCustomer();
                if (customer == null) {
                    throw new PosException(Messages.getString("PosTransactionService.1"));
                }
                d2 = customer.getBalance();
                refundTransaction.setCustomerBalanceBefore(d2);
                customer.setBalance(d2 + d);
                refundTransaction.setCustomerBalanceAfter(customer.getBalance());
                refundTransaction.setRefunded(true);
                CustomerDAO.getInstance().saveOrUpdate(ticket.getCustomer(), session);
                balanceType = BalanceType.CUSTOMER;
                string = customer.getId();
            } else if ((paymentType == PaymentType.CREDIT_CARD || paymentType == PaymentType.DEBIT_CARD) && StringUtils.isNotBlank((String)posTransaction.getCardMerchantGateway()) && CardReader.fromString(posTransaction.getCardReader()) != CardReader.EXTERNAL_TERMINAL) {
                double d3 = posTransaction.getAmount();
                CardProcessor cardProcessor = CardConfig.getPaymentGatewayByName(posTransaction.getCardMerchantGateway()).getProcessor();
                try {
                    posTransaction.setAmount(d);
                    cardProcessor.refundTransaction(posTransaction, d);
                }
                catch (PosException posException) {
                    throw posException;
                }
                catch (Exception exception) {
                    throw new PosException(exception.getMessage(), exception);
                }
                finally {
                    posTransaction.setAmount(d3);
                }
            }
            if (posTransaction != null) {
                this.a(posTransaction, d, refundTransaction);
            }
            ticket.addTotransactions(refundTransaction);
            ticket.setRefunded(true);
            ticket.setCashier(user);
            ticket.calculateRefundAmount();
            ticket.setPaidAmount(NumberUtil.round(ticket.getPaidAmount() - refundTransaction.getAmount()));
            ticket.calculatePrice();
            TicketDAO.getInstance().saveOrUpdate(ticket, session);
            if (d > 0.0) {
                this.deductCustomerLoyaltyPoint(ticket.getCustomer(), d, refundTransaction, session);
            }
            if (balanceType != null) {
                BalanceUpdateTransactionDAO.getInstance().saveBalanceUpdateTrans(balanceType, ticket, refundTransaction, TransactionType.CREDIT, string, d, d2, transactionSubType, session);
            }
            transaction.commit();
        }
        return refundTransaction;
    }

    private void a(PosTransaction posTransaction, double d, RefundTransaction refundTransaction) {
        String string = posTransaction.getProperty("REFUNDED_AMOUNT");
        double d2 = 0.0;
        if (StringUtils.isNotEmpty((String)string)) {
            try {
                d2 = NumberUtil.parseDouble(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        refundTransaction.addProperty("REFUNDED_AMOUNT", String.valueOf(d + d2));
        if (posTransaction.getTipsAmount() > 0.0) {
            double d3;
            double d4;
            double d5;
            String string2 = posTransaction.getProperty("REFUNDED_TIPS_AMOUNT");
            double d6 = 0.0;
            if (StringUtils.isNotEmpty((String)string)) {
                try {
                    d6 = NumberUtil.parseDouble(string2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((d5 = (d4 = d2 + d) - (d3 = posTransaction.getAmount() - posTransaction.getTipsAmount()) - d6) > 0.0) {
                posTransaction.setTipsAmount(d5);
                refundTransaction.addProperty("REFUNDED_TIPS_AMOUNT", String.valueOf(d5 + d6));
            }
        }
    }

    public void adjustMulticurrencyBalance(Session session, Terminal terminal, CashDrawer cashDrawer, List<MultiCurrencyTenderDialog.PaymentByCurrency> list, PosTransaction posTransaction) {
        if (cashDrawer == null) {
            return;
        }
        if (posTransaction.getPaymentType() != PaymentType.CASH) {
            return;
        }
        if (terminal.isEnableMultiCurrency().booleanValue()) {
            CashDrawerDAO.getInstance().refresh(cashDrawer, session);
            if (list == null) {
                if (posTransaction.isVoided().booleanValue()) {
                    list = new ArrayList<MultiCurrencyTenderDialog.PaymentByCurrency>();
                    List<Currency> list2 = CurrencyUtil.getAllCurrency();
                    if (list2 != null && list2.size() > 0) {
                        for (Currency currency : list2) {
                            MultiCurrencyTenderDialog.PaymentByCurrency paymentByCurrency2 = new MultiCurrencyTenderDialog.PaymentByCurrency();
                            paymentByCurrency2.currency = currency;
                            String string = currency.getId() + "_CASH_BACK";
                            String string2 = currency.getId() + "_TENDERED";
                            double d = POSUtil.parseDouble(posTransaction.getProperty(string2));
                            if (!(d > 0.0)) continue;
                            double d2 = POSUtil.parseDouble(posTransaction.getProperty(string));
                            double d3 = d - d2;
                            paymentByCurrency2.tenderedAmount = -1.0 * d3;
                            list.add(paymentByCurrency2);
                        }
                    }
                } else {
                    Double d = 0.0;
                    MultiCurrencyTenderDialog.PaymentByCurrency paymentByCurrency3 = new MultiCurrencyTenderDialog.PaymentByCurrency();
                    paymentByCurrency3.currency = CurrencyUtil.getMainCurrency();
                    paymentByCurrency3.tenderedAmount = posTransaction.getAmount();
                    if (posTransaction instanceof RefundTransaction || posTransaction instanceof PayOutTransaction || posTransaction instanceof CashDropTransaction) {
                        paymentByCurrency3.tenderedAmount = -1.0 * posTransaction.getAmount();
                    }
                    if (!(posTransaction instanceof RefundTransaction || posTransaction instanceof PayOutTransaction || posTransaction instanceof CashDropTransaction)) {
                        d = posTransaction.getTicket().getDueAmount();
                        paymentByCurrency3.cashBackAmount = d > paymentByCurrency3.tenderedAmount ? 0.0 : paymentByCurrency3.tenderedAmount - d;
                    }
                    list = Arrays.asList(paymentByCurrency3);
                }
            }
            list.forEach(paymentByCurrency -> {
                Currency currency = paymentByCurrency.currency;
                CashBreakdown cashBreakdown = cashDrawer.getCurrencyBalance(currency);
                double d = paymentByCurrency.tenderedAmount - paymentByCurrency.cashBackAmount;
                if (cashBreakdown != null) {
                    cashBreakdown.setBalance(cashBreakdown.getBalance() + d);
                }
                if (!posTransaction.isVoided().booleanValue()) {
                    String string = paymentByCurrency.currency.getId() + "_CASH_BACK";
                    String string2 = paymentByCurrency.currency.getId() + "_TENDERED";
                    posTransaction.addProperty(string2, String.valueOf(paymentByCurrency.tenderedAmount));
                    posTransaction.addProperty(string, String.valueOf(paymentByCurrency.cashBackAmount));
                }
            });
            session.saveOrUpdate((Object)cashDrawer);
        }
    }

    private void a(Ticket ticket, PosTransaction posTransaction) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Total: " + NumberUtil.formatNumber(ticket.getTotalAmountWithTips()));
        stringBuilder.append(". Transaction amount: " + NumberUtil.formatNumber(posTransaction.getAmount()));
        ActionHistoryDAO.saveHistory(Application.getCurrentUser(), ticket, posTransaction, "Settle check", stringBuilder.toString());
    }

    private void a(Ticket ticket, PosTransaction posTransaction, Session session) {
        Store store = DataProvider.get().getStore();
        Boolean bl = Boolean.valueOf(store.getProperty("loyalty.enabled"));
        if (!bl.booleanValue()) {
            return;
        }
        Customer customer = ticket.getCustomer();
        if (customer == null) {
            return;
        }
        customer = CustomerDAO.getInstance().get(customer.getId(), session);
        this.a(ticket, customer, posTransaction, session);
        this.a(ticket, posTransaction, store, customer, session);
        ticket.updateCustomer(customer);
    }

    private void a(Ticket ticket, Customer customer, PosTransaction posTransaction, Session session) {
        if (ticket == null) {
            throw new PosException(Messages.getString("PosTransactionService.0"));
        }
        if (ticket.getDiscounts() == null) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        ticket.getDiscounts().forEach(ticketDiscount -> {
            if (!ticketDiscount.isLoyaltyCharged()) {
                arrayList.add(ticketDiscount);
            }
        });
        if (arrayList.isEmpty()) {
            return;
        }
        if (customer == null) {
            throw new PosException(Messages.getString("PosTransactionService.3"));
        }
        int n = 0;
        int n2 = customer.getLoyaltyPoint();
        for (TicketDiscount ticketDiscount2 : arrayList) {
            int n3 = ticketDiscount2.getLoyaltyPoint();
            customer.setLoyaltyPoint(n2 - n3);
            ticketDiscount2.setLoyaltyCharged(Boolean.TRUE);
            n += n3;
        }
        posTransaction.addExtraProperty("loyalty.charged_amount", String.valueOf(n));
        ticket.buildDiscounts();
        if (n > 0) {
            BalanceUpdateTransactionDAO.getInstance().saveBalanceUpdateTrans(BalanceType.LOYALTY, ticket, posTransaction, TransactionType.DEBIT, customer.getId(), Double.valueOf(n), Double.valueOf(n2), null, session);
        }
    }

    private void a(Ticket ticket, PosTransaction posTransaction, Store store, Customer customer, Session session) {
        if (ticket == null) {
            throw new PosException(Messages.getString("PosTransactionService.0"));
        }
        if (posTransaction == null) {
            throw new PosException(Messages.getString("PosTransactionService.5"));
        }
        if (store == null) {
            throw new PosException(Messages.getString("PosTransactionService.6"));
        }
        if (customer == null) {
            return;
        }
        Integer n = customer.getLoyaltyPoint();
        Integer n2 = customer.getLoyaltyPoint();
        int n3 = 0;
        try {
            String string = ticket.getProperty("loyalty");
            Boolean bl = string != null && Boolean.valueOf(string) != false;
            if (!bl.booleanValue()) {
                int n4 = Integer.parseInt(store.getProperty("loyalty.pointForVisit"));
                if (n4 > 0) {
                    n3 = n4;
                }
                ticket.addProperty("loyalty", String.valueOf(Boolean.TRUE));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        n2 = n2 + n3;
        int n5 = 0;
        try {
            int n6 = Integer.parseInt(store.getProperty("loyalty.pointForPuchases"));
            if (n6 > 0) {
                n5 = (int)(posTransaction.getAmount() / (double)n6);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        n2 = n2 + n5;
        posTransaction.addExtraProperty("transaction.loyalty_point_earned", String.valueOf(n5));
        customer.setLoyaltyPoint(n2);
        CustomerDAO.getInstance().update(customer, session);
        BalanceUpdateTransactionDAO.getInstance().saveBalanceUpdateTrans(BalanceType.LOYALTY, ticket, posTransaction, TransactionType.CREDIT, customer.getId(), Double.valueOf(n3 + n5), (double)n, null, session);
    }

    public void deductCustomerLoyaltyPoint(Customer customer, double d, PosTransaction posTransaction, Session session) {
        if (customer == null || d <= 0.0) {
            return;
        }
        Store store = DataProvider.get().getStore();
        Boolean bl = Boolean.valueOf(store.getProperty("loyalty.enabled"));
        Boolean bl2 = Boolean.valueOf(store.getProperty("loyalty.deductPointOnRefund"));
        if (!bl.booleanValue() || !bl2.booleanValue()) {
            return;
        }
        Integer n = customer.getLoyaltyPoint();
        Integer n2 = customer.getLoyaltyPoint();
        Integer n3 = 0;
        try {
            int n4 = Integer.parseInt(store.getProperty("loyalty.pointForPuchases"));
            if (n4 > 0) {
                n3 = (int)Math.ceil(d / (double)n4);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        n2 = n2 - n3;
        posTransaction.addExtraProperty("loyalty.deducted", String.valueOf(n3));
        customer.setLoyaltyPoint(n2 > 0 ? n2 : 0);
        CustomerDAO.getInstance().update(customer, session);
        BalanceUpdateTransactionDAO.getInstance().saveBalanceUpdateTrans(BalanceType.LOYALTY, posTransaction.getTicket(), posTransaction, TransactionType.DEBIT, customer.getId(), (double)n3, (double)n, null, session);
    }

    private void b(Ticket ticket, PosTransaction posTransaction) {
        double d = 0.0;
        Currency currency = CurrencyUtil.getMainCurrency();
        if (currency != null) {
            d = currency.getTolerance();
        }
        posTransaction.setToleranceAmount(ticket.getToleranceAmount());
        double d2 = NumberUtil.round(posTransaction.getTenderAmount() - posTransaction.getAmount());
        if (d2 == 0.0) {
            return;
        }
        Store store = DataProvider.get().getStore();
        double d3 = store.isAllowPenyRounding() ? (double)Math.round(d2 * 100.0 / 5.0) * 5.0 / 100.0 : d2;
        double d4 = d2 - d3;
        if (Math.abs(d3) <= d) {
            posTransaction.setToleranceAmount(d2);
            posTransaction.setChangeAmount(0.0);
        } else {
            posTransaction.setToleranceAmount(d4);
            posTransaction.setChangeAmount(d3);
        }
        posTransaction.setAmount(posTransaction.getAmount() + posTransaction.getToleranceAmount());
    }

    public static void closeTicketIfApplicable(Ticket ticket, Date date) {
        OrderType orderType = ticket.getOrderType();
        if (orderType != null && (orderType.isCloseOnPaid().booleanValue() || orderType.isBarTab().booleanValue())) {
            ticket.setClosed(true);
            ticket.setClosingDate(date);
        }
    }

    private void c(Ticket ticket, PosTransaction posTransaction) {
        double d = ticket.getGratuityAmount();
        if (d <= 0.0) {
            return;
        }
        double d2 = 0.0;
        Set<PosTransaction> set = ticket.getTransactions();
        if (set != null && set.size() > 0) {
            for (PosTransaction posTransaction2 : set) {
                if (posTransaction2 instanceof RefundTransaction || posTransaction2.isVoided().booleanValue()) continue;
                d2 += posTransaction2.getTipsAmount().doubleValue();
            }
        }
        double d3 = d - d2;
        double d4 = d3 + ticket.getPaidAmount() - ticket.getTotalAmountWithTips();
        if (d3 > 0.0) {
            if (ticket.getDueAmount() == 0.0) {
                posTransaction.setTipsAmount(d3);
            } else if (d4 > 0.0) {
                Double d5 = posTransaction.getAmount();
                if (d4 > d5) {
                    posTransaction.setTipsAmount(d5);
                } else {
                    posTransaction.setTipsAmount(d4);
                }
            }
        }
    }

    public RefundTransaction createRefundTransaction(Ticket ticket, PosTransaction posTransaction, double d, PaymentType paymentType, Map<String, String> map) {
        double d2;
        if (posTransaction != null && d > (d2 = posTransaction.getRefundableAmount().doubleValue())) {
            throw new PosException(Messages.getString("RefundDialog.36") + " " + d2);
        }
        RefundTransaction refundTransaction = new RefundTransaction();
        if (map != null) {
            refundTransaction.setCustomPaymentFieldName(map.get(PosTransaction.PROP_CUSTOM_PAYMENT_FIELD_NAME));
            refundTransaction.setCustomPaymentId(map.get(PosTransaction.PROP_CUSTOM_PAYMENT_ID));
            refundTransaction.setCustomPaymentName(map.get(PosTransaction.PROP_CUSTOM_PAYMENT_NAME));
            refundTransaction.setCustomPaymentRef(map.get(PosTransaction.PROP_CUSTOM_PAYMENT_REF));
            refundTransaction.setGiftCertNumber(map.get(PosTransaction.PROP_GIFT_CERT_NUMBER));
        }
        refundTransaction.setPaymentType(paymentType);
        refundTransaction.setTenderAmount(d);
        refundTransaction.setAmount(d);
        refundTransaction.setTicket(ticket);
        refundTransaction.setCustomerId(ticket.getCustomerId());
        refundTransaction.setCustomerName(ticket.getCustomerName());
        refundTransaction.setTerminal(DataProvider.get().getCurrentTerminal());
        refundTransaction.setTransactionType(TransactionType.DEBIT.name());
        refundTransaction.setCashDrawer(Application.getCurrentUser().getActiveDrawerPullReport());
        refundTransaction.setOutletId(DataProvider.get().getCurrentOutletId());
        refundTransaction.setTransactionTime(StoreDAO.getServerTimestamp());
        refundTransaction.setStoreSessionId(DataProvider.get().getStoreSessionId());
        if (posTransaction == null) {
            return refundTransaction;
        }
        refundTransaction.setCardExpMonth(posTransaction.getCardExpMonth());
        refundTransaction.setCardHolderName(posTransaction.getCardHolderName());
        refundTransaction.setCardAuthCode(posTransaction.getCardAuthCode());
        refundTransaction.setCardMerchantGateway(posTransaction.getCardMerchantGateway());
        refundTransaction.setCardNumber(posTransaction.getCardNumber());
        refundTransaction.setCardTrack(posTransaction.getCardTrack());
        refundTransaction.setCardTransactionId(posTransaction.getCardTransactionId());
        refundTransaction.setCardReader(posTransaction.getCardReader());
        refundTransaction.setCardType(posTransaction.getCardType());
        refundTransaction.addProperty("REFUNDED_TRANSACTION_ID", posTransaction.getId());
        return refundTransaction;
    }

    private void a(Ticket ticket) {
        List<TicketItem> list = ticket.getTicketItems();
        for (TicketItem ticketItem : list) {
            ticketItem.setPaid(true);
        }
    }

    private void b(Ticket ticket, PosTransaction posTransaction, Session session) {
        boolean bl = Boolean.FALSE;
        List<TicketItem> list = ticket.getTicketItems();
        for (TicketItem ticketItem : list) {
            double d;
            if (!ticketItem.isGiftCard() || posTransaction instanceof RefundTransaction) continue;
            String string = ticketItem.getGiftCardNo();
            GiftCard giftCard = GiftCardDAO.getInstance().findByCardNumber(session, string);
            if (giftCard == null) {
                if (posTransaction instanceof CreditCardTransaction || posTransaction instanceof DebitCardTransaction) {
                    PosLog.error(PosTransactionService.class, String.format("Gift card add balance: Gift card with number %s not found while payment with card %s.", string, posTransaction.getCardNumber()));
                    return;
                }
                throw new PosException(String.format(Messages.getString("GiftCardNoNotFound"), string));
            }
            double d2 = ticketItem.getUnitPrice();
            if (d2 == (d = ticketItem.getGiftCardPaidAmount())) {
                return;
            }
            bl = Boolean.TRUE;
            ticketItem.setGiftCardPaidAmount(d2);
            posTransaction.setGiftCertNumber(string);
            posTransaction.setGiftCertFaceValue(d2);
            posTransaction.addGiftCardBalanceAddInfo(ticketItem.getId(), string, d2);
            Double d3 = giftCard.getBalance();
            giftCard.setBalance(d3 + d2);
            GiftCardDAO.getInstance().saveOrUpdate(giftCard, session);
            BalanceUpdateTransactionDAO.getInstance().saveBalanceUpdateTrans(BalanceType.GIFT_CARD, ticket, posTransaction, TransactionType.CREDIT, string, d2, d3, TransactionSubType.BALANCE_ADDED, session);
        }
        if (bl) {
            TicketDAO.getInstance().saveOrUpdate(ticket, session);
        }
    }

    public static PosTransactionService getInstance() {
        return a;
    }

    public static void sortTransactionsByDateDesc(List<PosTransaction> list) {
        Collections.sort(list, new Comparator<PosTransaction>(){

            @Override
            public int compare(PosTransaction posTransaction, PosTransaction posTransaction2) {
                if (posTransaction.getTransactionTime() == null) {
                    return -1;
                }
                if (posTransaction2.getTransactionTime() == null) {
                    return 1;
                }
                return posTransaction2.getTransactionTime().compareTo(posTransaction.getTransactionTime());
            }
        });
    }
}

