/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.services.report;

import com.floreantpos.POSConstants;
import com.floreantpos.model.CashTransaction;
import com.floreantpos.model.CreditCardTransaction;
import com.floreantpos.model.CustomPaymentTransaction;
import com.floreantpos.model.CustomerAccountTransaction;
import com.floreantpos.model.DebitCardTransaction;
import com.floreantpos.model.GiftCertificateTransaction;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.PayOutTransaction;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Shift;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketSource;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao._RootDAO;
import com.floreantpos.model.ext.CardTypeEnum;
import com.floreantpos.util.POSUtil;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;

public class SalesReportUtil {
    private Date a;
    private Date b;
    private User c;
    private String d;
    private StoreSession e;
    private Shift f;
    private List<String> g;
    private boolean h = Boolean.FALSE;

    public SalesReportUtil(Date date, Date date2) {
        this.a = date;
        this.b = date2;
    }

    public SalesReportUtil(Date date, Date date2, User user) {
        this.a = date;
        this.b = date2;
        this.c = user;
    }

    public SalesReportUtil(StoreSession storeSession) {
        this.e = storeSession;
    }

    @Deprecated
    public SalesReportUtil(User user, StoreSession storeSession) {
        this.c = user;
        this.e = storeSession;
    }

    public double calculateItemCount(Session session) {
        Criteria criteria = this.buildCriteriaForTicketItem(session, Boolean.FALSE);
        criteria.setProjection((Projection)Projections.sum((String)TicketItem.PROP_QUANTITY));
        double d = POSUtil.getDoubleAmount(criteria.uniqueResult());
        return d;
    }

    public double calculateTotalCost(Session session) {
        Criteria criteria = this.buildCriteriaForTicketItem(session);
        criteria.setProjection((Projection)Projections.sum((String)TicketItem.PROP_TOTAL_COST));
        double d = POSUtil.getDoubleAmount(criteria.uniqueResult());
        return d;
    }

    public double calculateGrossSalesWithOutIncludedTax(Session session) {
        return this.a(session) - this.b(session);
    }

    private double a(Session session) {
        Criteria criteria = this.buildCriteriaForTicketItem(session, Boolean.FALSE);
        criteria.setProjection((Projection)Projections.sum((String)TicketItem.PROP_SUBTOTAL_AMOUNT));
        double d = POSUtil.getDoubleAmount(criteria.uniqueResult());
        return d;
    }

    private double b(Session session) {
        Criteria criteria = this.buildCriteriaForTicketItem(session, Boolean.FALSE);
        criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_TAX_INCLUDED, (Object)Boolean.TRUE));
        criteria.setProjection((Projection)Projections.sum((String)TicketItem.PROP_ADJUSTED_TAX));
        double d = POSUtil.getDoubleAmount(criteria.uniqueResult());
        return d;
    }

    public double calculateDiscountAmount(Session session) {
        Criteria criteria = this.buildCriteriaForTicketItem(session);
        criteria.setProjection((Projection)Projections.sum((String)TicketItem.PROP_ADJUSTED_DISCOUNT));
        double d = POSUtil.getDoubleAmount(criteria.uniqueResult());
        return d;
    }

    public double calculateReturnAmountWithOutIncludedTax(Session session) {
        return this.c(session) + this.d(session);
    }

    private double c(Session session) {
        Criteria criteria = this.buildCriteriaForTicketItem(session, Boolean.TRUE);
        criteria.setProjection((Projection)Projections.sum((String)TicketItem.PROP_SUBTOTAL_AMOUNT));
        double d = Math.abs(POSUtil.getDoubleAmount(criteria.uniqueResult()));
        return d;
    }

    private double d(Session session) {
        Criteria criteria = this.buildCriteriaForTicketItem(session, Boolean.TRUE);
        criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_TAX_INCLUDED, (Object)Boolean.TRUE));
        criteria.setProjection((Projection)Projections.sum((String)TicketItem.PROP_ADJUSTED_TAX));
        double d = POSUtil.getDoubleAmount(criteria.uniqueResult());
        return d;
    }

    public double calculateServiceChargeAmount(Session session) {
        Criteria criteria = this.buildCriteriaForTicketItem(session);
        criteria.setProjection((Projection)Projections.sum((String)TicketItem.PROP_SERVICE_CHARGE));
        double d = POSUtil.getDoubleAmount(criteria.uniqueResult());
        return d;
    }

    public double calculateSalesTaxAmount(Session session) {
        Criteria criteria = this.buildCriteriaForTicketItem(session);
        criteria.setProjection((Projection)Projections.sum((String)TicketItem.PROP_ADJUSTED_TAX));
        double d = POSUtil.getDoubleAmount(criteria.uniqueResult());
        return d;
    }

    public Criteria buildCriteriaForTicketItem(Session session) {
        return this.buildCriteriaForTicketItem(session, null);
    }

    public Criteria buildCriteriaForTicketItem(Session session, Boolean bl) {
        Criteria criteria = session.createCriteria(TicketItem.class).createAlias(TicketItem.PROP_TICKET, "t");
        if (this.a != null) {
            criteria.add((Criterion)Restrictions.ge((String)TicketItem.PROP_CREATE_DATE, (Object)this.a));
        }
        if (this.b != null) {
            criteria.add((Criterion)Restrictions.lt((String)TicketItem.PROP_CREATE_DATE, (Object)this.b));
        }
        criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_TREAT_AS_SEAT, (Object)Boolean.FALSE));
        if (bl != null) {
            criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_ITEM_RETURNED, (Object)bl));
        }
        criteria.add((Criterion)Restrictions.eq((String)("t." + Ticket.PROP_VOIDED), (Object)Boolean.FALSE));
        if (this.h) {
            criteria.add((Criterion)Restrictions.eq((String)("t." + Ticket.PROP_SOURCE), (Object)TicketSource.Online.name()));
        }
        if (this.e != null) {
            criteria.add((Criterion)Restrictions.eq((String)("t." + Ticket.PROP_STORE_SESSION_ID), (Object)this.e.getId()));
        }
        if (this.f != null) {
            criteria.add((Criterion)Restrictions.eq((String)("t." + Ticket.PROP_SHIFT_ID), (Object)this.f.getId()));
        }
        if (this.g != null && this.g.size() > 0) {
            criteria.add(Restrictions.in((String)("t." + Ticket.PROP_ORDER_TYPE_ID), this.g));
        }
        if (!POSUtil.isBlankOrNull(this.d)) {
            if (this.d.equalsIgnoreCase(POSConstants.NONE)) {
                criteria.add(Restrictions.isNull((String)TicketItem.PROP_CATEGORY_NAME));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)TicketItem.PROP_CATEGORY_NAME, (Object)this.d));
            }
        }
        _RootDAO.addUserWithAllRoleCriteria(criteria, this.c, "t." + Ticket.PROP_OWNER_ID);
        return criteria;
    }

    public double calculateGratuity(Session session) {
        Criteria criteria = session.createCriteria(Ticket.class, "t").createAlias(Ticket.PROP_GRATUITY, "g");
        criteria.add((Criterion)Restrictions.eq((String)("t." + Ticket.PROP_VOIDED), (Object)Boolean.FALSE));
        if (this.a != null) {
            criteria.add((Criterion)Restrictions.ge((String)("t." + Ticket.PROP_CREATE_DATE), (Object)this.a));
        }
        if (this.b != null) {
            criteria.add((Criterion)Restrictions.lt((String)("t." + Ticket.PROP_CREATE_DATE), (Object)this.b));
        }
        if (this.e != null) {
            criteria.add((Criterion)Restrictions.eq((String)("t." + Ticket.PROP_STORE_SESSION_ID), (Object)this.e.getId()));
        }
        if (this.h) {
            criteria.add((Criterion)Restrictions.eq((String)("t." + Ticket.PROP_SOURCE), (Object)TicketSource.Online.name()));
        }
        _RootDAO.addUserWithAllRoleCriteria(criteria, this.c, Ticket.PROP_OWNER_ID);
        criteria.setProjection((Projection)Projections.sum((String)("g." + Gratuity.PROP_AMOUNT)));
        return POSUtil.getDoubleAmount(criteria.uniqueResult());
    }

    @Deprecated
    public double calculateGratuityOld(Session session) {
        DetachedCriteria detachedCriteria = DetachedCriteria.forClass(Ticket.class);
        detachedCriteria.setProjection((Projection)Property.forName((String)Ticket.PROP_ID));
        if (this.h) {
            detachedCriteria.add((Criterion)Restrictions.eq((String)("t." + Ticket.PROP_SOURCE), (Object)TicketSource.Online.name()));
        }
        if (this.a != null) {
            detachedCriteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)this.a));
        }
        if (this.b != null) {
            detachedCriteria.add((Criterion)Restrictions.lt((String)Ticket.PROP_CREATE_DATE, (Object)this.b));
        }
        detachedCriteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)Boolean.FALSE));
        if (this.e != null) {
            detachedCriteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_STORE_SESSION_ID, (Object)this.e.getId()));
        }
        if (this.c != null) {
            detachedCriteria.add(Restrictions.in((String)Ticket.PROP_OWNER_ID, this.c.getRoleIds()));
        }
        Criteria criteria = session.createCriteria(Gratuity.class);
        criteria.add(Property.forName((String)Gratuity.PROP_TICKET_ID).in(detachedCriteria));
        criteria.setProjection((Projection)Projections.sum((String)Gratuity.PROP_AMOUNT));
        double d = POSUtil.getDoubleAmount(criteria.uniqueResult());
        return d;
    }

    public double calculateDeliveryCharge(Session session) {
        Criteria criteria = this.a(session, this.a, this.b, this.c, this.e);
        criteria.setProjection((Projection)Projections.sum((String)Ticket.PROP_DELIVERY_CHARGE));
        double d = POSUtil.getDoubleAmount(criteria.uniqueResult());
        return d;
    }

    private Criteria a(Session session, Date date, Date date2, User user, StoreSession storeSession) {
        Criteria criteria = session.createCriteria(Ticket.class);
        if (date != null) {
            criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
        }
        if (date2 != null) {
            criteria.add((Criterion)Restrictions.lt((String)Ticket.PROP_CREATE_DATE, (Object)date2));
        }
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)Boolean.FALSE));
        if (this.h) {
            criteria.add((Criterion)Restrictions.eq((String)("t." + Ticket.PROP_SOURCE), (Object)TicketSource.Online.name()));
        }
        if (storeSession != null) {
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_STORE_SESSION_ID, (Object)storeSession.getId()));
        }
        _RootDAO.addUserWithAllRoleCriteria(criteria, user, Ticket.PROP_OWNER_ID);
        return criteria;
    }

    public double calculateFeeAmount(Session session) {
        Criteria criteria = this.a(session, this.a, this.b, this.c, this.e, PosTransaction.class);
        criteria.add((Criterion)Restrictions.ne((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.CASH.name()));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_FEE_AMOUNT));
        return POSUtil.getDoubleAmount(criteria.uniqueResult());
    }

    public double calculateTotalTips(Session session) {
        Criteria criteria = this.a(session, this.a, this.b, this.c, this.e, PosTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_TIPS_AMOUNT));
        return POSUtil.getDoubleAmount(criteria.uniqueResult());
    }

    public double calculateCashTips(Session session) {
        Criteria criteria = this.a(session, this.a, this.b, this.c, this.e, CashTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.CASH.name()));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_TIPS_AMOUNT));
        return POSUtil.getDoubleAmount(criteria.uniqueResult());
    }

    public double calculateChargedTips(Session session) {
        Criteria criteria = this.a(session, this.a, this.b, this.c, this.e, PosTransaction.class);
        criteria.add((Criterion)Restrictions.ne((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.CASH.name()));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_TIPS_AMOUNT));
        return POSUtil.getDoubleAmount(criteria.uniqueResult());
    }

    public double calculateCashReceipt(Session session) {
        Criteria criteria = this.a(session, this.a, this.b, this.c, this.e, CashTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
        return POSUtil.getDoubleAmount(criteria.uniqueResult());
    }

    public double calculateTotalReceipt(Session session) {
        Criteria criteria = this.a(session, this.a, this.b, this.c, this.e, PosTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
        return POSUtil.getDoubleAmount(criteria.uniqueResult());
    }

    public double calculateCreditReceipt(Session session) {
        Criteria criteria = this.a(session, this.a, this.b, this.c, this.e, CreditCardTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
        return POSUtil.getDoubleAmount(criteria.uniqueResult());
    }

    public double calculateDebitReceipt(Session session) {
        Criteria criteria = this.a(session, this.a, this.b, this.c, this.e, DebitCardTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)CashTransaction.PROP_AMOUNT));
        return POSUtil.getDoubleAmount(criteria.uniqueResult());
    }

    public double calculateMemberPayment(Session session) {
        Criteria criteria = this.a(session, this.a, this.b, this.c, this.e, CustomerAccountTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
        return POSUtil.getDoubleAmount(criteria.uniqueResult());
    }

    public double calculateCustomPaymentWithoutPromotion(Session session) {
        Criteria criteria = this.a(session, this.a, this.b, this.c, this.e, CustomPaymentTransaction.class);
        criteria.add((Criterion)Restrictions.ne((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.PROMOTION.name()));
        criteria.setProjection((Projection)Projections.sum((String)CustomPaymentTransaction.PROP_AMOUNT));
        return POSUtil.getDoubleAmount(criteria.uniqueResult());
    }

    public double calculatePromotionPayment(Session session) {
        Criteria criteria = this.a(session, this.a, this.b, this.c, this.e, CustomPaymentTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.PROMOTION.name()));
        criteria.setProjection((Projection)Projections.sum((String)CustomPaymentTransaction.PROP_AMOUNT));
        return POSUtil.getDoubleAmount(criteria.uniqueResult());
    }

    public double calculateGiftCertReceipts(Session session) {
        Criteria criteria = this.a(session, this.a, this.b, this.c, this.e, GiftCertificateTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)GiftCertificateTransaction.PROP_AMOUNT));
        return POSUtil.getDoubleAmount(criteria.uniqueResult());
    }

    public double calculateRefundAmount(Session session) {
        Criteria criteria = this.a(session, this.a, this.b, this.c, this.e, RefundTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)RefundTransaction.PROP_AMOUNT));
        return POSUtil.getDoubleAmount(criteria.uniqueResult());
    }

    public double calculateToleranceAmount(Session session) {
        Criteria criteria = this.a(session, this.a, this.b, this.c, this.e, CashTransaction.class);
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_TOLERANCE_AMOUNT));
        return POSUtil.getDoubleAmount(criteria.uniqueResult());
    }

    public double calculateVisaCreditCardSummery(Session session, Class clazz, Date date, Date date2, User user) {
        Criteria criteria = this.a(session, date, date2, user, this.e, clazz);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_CARD_TYPE, (Object)CardTypeEnum.VISA.name()).ignoreCase());
        criteria.setProjection((Projection)Projections.sum((String)CashTransaction.PROP_AMOUNT));
        return POSUtil.getDoubleAmount(criteria.uniqueResult());
    }

    public double calculateMasterCardSummery(Session session, Class clazz, Date date, Date date2, User user) {
        Criteria criteria = this.a(session, date, date2, user, this.e, clazz);
        criteria.add((Criterion)PosTransactionDAO.createMasterCardSearchCriteria());
        criteria.setProjection((Projection)Projections.sum((String)CashTransaction.PROP_AMOUNT));
        return POSUtil.getDoubleAmount(criteria.uniqueResult());
    }

    public double calculateAmexSummery(Session session, Class clazz, Date date, Date date2, User user) {
        Criteria criteria = this.a(session, date, date2, user, this.e, clazz);
        criteria.add((Criterion)PosTransactionDAO.createAmexOrAmericanExpCardSearchCriteria());
        criteria.setProjection((Projection)Projections.sum((String)CashTransaction.PROP_AMOUNT));
        return POSUtil.getDoubleAmount(criteria.uniqueResult());
    }

    public double calculateDiscoverySummery(Session session, Class clazz, Date date, Date date2, User user) {
        Criteria criteria = this.a(session, date, date2, user, this.e, clazz);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_CARD_TYPE, (Object)CardTypeEnum.DISCOVER.name()).ignoreCase());
        criteria.setProjection((Projection)Projections.sum((String)CashTransaction.PROP_AMOUNT));
        return POSUtil.getDoubleAmount(criteria.uniqueResult());
    }

    public double calculateVisaDebitCardSummery(Session session, Class clazz, Date date, Date date2, User user) {
        Criteria criteria = this.a(session, date, date2, user, this.e, clazz);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_CARD_TYPE, (Object)CardTypeEnum.VISA.name()).ignoreCase());
        criteria.setProjection((Projection)Projections.sum((String)CashTransaction.PROP_AMOUNT));
        return POSUtil.getDoubleAmount(criteria.uniqueResult());
    }

    public double calculateMasterDebitCardSummery(Session session, Class clazz, Date date, Date date2, User user) {
        Criteria criteria = this.a(session, date, date2, user, this.e, clazz);
        criteria.add((Criterion)PosTransactionDAO.createMasterCardSearchCriteria());
        criteria.setProjection((Projection)Projections.sum((String)CashTransaction.PROP_AMOUNT));
        return POSUtil.getDoubleAmount(criteria.uniqueResult());
    }

    private Criteria a(Session session, Date date, Date date2, User user, StoreSession storeSession, Class<? extends PosTransaction> clazz) {
        Criteria criteria = session.createCriteria(clazz);
        if (clazz.equals(RefundTransaction.class) || clazz.equals(PayOutTransaction.class)) {
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.DEBIT.name()));
        } else {
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        }
        _RootDAO.addUserWithAllRoleCriteria(criteria, user, PosTransaction.PROP_USER_ID);
        if (storeSession != null) {
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_STORE_SESSION_ID, (Object)storeSession.getId()));
        }
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        if (date != null) {
            criteria.add((Criterion)Restrictions.ge((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date));
        }
        if (date2 != null) {
            criteria.add((Criterion)Restrictions.lt((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date2));
        }
        criteria.add(Restrictions.isNotNull((String)PosTransaction.PROP_TICKET));
        return criteria;
    }

    public Date getFromDate() {
        return this.a;
    }

    public void setFromDate(Date date) {
        this.a = date;
    }

    public Date getToDate() {
        return this.b;
    }

    public void setToDate(Date date) {
        this.b = date;
    }

    public User getUser() {
        return this.c;
    }

    public void setUser(User user) {
        this.c = user;
    }

    public String getCategoryName() {
        return this.d;
    }

    public void setCategoryName(String string) {
        this.d = string;
    }

    public StoreSession getStoreSession() {
        return this.e;
    }

    public void setStoreSession(StoreSession storeSession) {
        this.e = storeSession;
    }

    public Shift getShift() {
        return this.f;
    }

    public void setShift(Shift shift) {
        this.f = shift;
    }

    public List<String> getOrderTypeIds() {
        return this.g;
    }

    public void setOrderTypeIds(List<String> list) {
        this.g = list;
    }

    public boolean isShowOnlineTickets() {
        return this.h;
    }

    public void setShowOnlineTickets(boolean bl) {
        this.h = bl;
    }
}

