/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.services.report;

import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.CategoryBreakOut;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.services.report.SalesReportUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.transform.Transformers;

public class ServerSummaryReportService {
    private StoreSession a;
    private User b;
    private CashDrawer c = new CashDrawer();

    public ServerSummaryReportService(User user, StoreSession storeSession) {
        this.b = user;
        this.a = storeSession;
    }

    public CashDrawer populateServerSummaryReport() {
        try (Session session = GenericDAO.getInstance().createNewSession();){
            Date date = new Date();
            Date date2 = this.a.getOpenTime() == null ? date : this.a.getOpenTime();
            Date date3 = this.a.getCloseTime() == null ? date : this.a.getCloseTime();
            SalesReportUtil salesReportUtil = new SalesReportUtil(date2, date3, this.b);
            this.c.setGrossSales(salesReportUtil.calculateGrossSalesWithOutIncludedTax(session));
            this.c.setTotalDiscountSales(salesReportUtil.calculateDiscountAmount(session));
            this.c.setReturnAmount(salesReportUtil.calculateReturnAmountWithOutIncludedTax(session));
            double d = this.c.getGrossSales() - this.c.getTotalDiscountSales() - this.c.getReturnAmount();
            this.c.setNetSales(d);
            this.c.setServiceCharge(salesReportUtil.calculateServiceChargeAmount(session));
            this.c.setSalesTax(salesReportUtil.calculateSalesTaxAmount(session));
            this.c.setDeliveryCharge(salesReportUtil.calculateDeliveryCharge(session));
            this.c.setGratuity(salesReportUtil.calculateGratuity(session));
            this.c.setFeeAmount(salesReportUtil.calculateFeeAmount(session));
            double d2 = this.c.getNetSales() + this.c.getServiceCharge() + this.c.getSalesTax() + this.c.getDeliveryCharge() + this.c.getGratuity() + this.c.getFeeAmount();
            this.c.setTotalRevenue(d2);
            this.c.setCashTips(salesReportUtil.calculateCashTips(session));
            this.c.setChargedTips(salesReportUtil.calculateChargedTips(session));
            this.c.setCashReceiptAmount(salesReportUtil.calculateCashReceipt(session));
            this.c.setCreditCardReceiptAmount(salesReportUtil.calculateCreditReceipt(session));
            this.c.setDebitCardReceiptAmount(salesReportUtil.calculateDebitReceipt(session));
            this.c.setCustomerPaymentAmount(salesReportUtil.calculateMemberPayment(session));
            this.c.setCustomPaymentAmount(salesReportUtil.calculateCustomPaymentWithoutPromotion(session));
            this.c.setPromotionAmount(salesReportUtil.calculatePromotionPayment(session));
            this.c.setGiftCertChangeAmount(salesReportUtil.calculateGiftCertReceipts(session));
            this.c.setRefundAmount(salesReportUtil.calculateRefundAmount(session));
            this.c.setToleranceAmount(salesReportUtil.calculateToleranceAmount(session));
            Store store = DataProvider.get().getStore();
            if (POSUtil.getBoolean(store.getProperty("show_category_breakout.in_server_Summary"))) {
                this.a(session);
            }
            double d3 = this.c.getCashReceiptAmount() + this.c.getCreditCardReceiptAmount() + this.c.getDebitCardReceiptAmount() + this.c.getCustomerPaymentAmount() + this.c.getPromotionAmount() + this.c.getCustomPaymentAmount() + this.c.getGiftCertChangeAmount() - this.c.getRefundAmount() - this.c.getToleranceAmount();
            this.c.setReceiptDifferential(NumberUtil.round(d2 - d3));
            this.c.setAssignedUser(this.b);
            this.c.setStartTime(this.a.getOpenTime());
            this.c.setAssignedBy(this.a.getOpenedBy());
            this.c.setReportTime(this.a.getCloseTime());
            this.c.setClosedBy(this.a.getClosedBy());
            this.c.setStoreOperationData(this.a);
            CashDrawer cashDrawer = this.c;
            return cashDrawer;
        }
    }

    private void a(Session session) {
        Date date = new Date();
        Date date2 = this.a.getOpenTime() == null ? date : this.a.getOpenTime();
        Date date3 = this.a.getCloseTime() == null ? date : this.a.getCloseTime();
        SalesReportUtil salesReportUtil = new SalesReportUtil(date2, date3, this.b);
        Criteria criteria = salesReportUtil.buildCriteriaForTicketItem(session, Boolean.FALSE);
        ProjectionList projectionList = Projections.projectionList();
        projectionList.add((Projection)Projections.groupProperty((String)TicketItem.PROP_CATEGORY_ID), "categoryId");
        projectionList.add((Projection)Projections.sum((String)TicketItem.PROP_SUBTOTAL_AMOUNT), "breakOutAmt");
        criteria.setProjection((Projection)projectionList);
        criteria.setResultTransformer(Transformers.aliasToBean(CategoryBreakOut.class));
        List list = criteria.list();
        ArrayList<CategoryBreakOut> arrayList = new ArrayList<CategoryBreakOut>();
        for (CategoryBreakOut categoryBreakOut : list) {
            if (categoryBreakOut.getBreakOutAmt() <= 0.0) continue;
            String string = categoryBreakOut.getCategoryId();
            if (StringUtils.isNotBlank((String)string)) {
                categoryBreakOut.setCategoryName(MenuCategoryDAO.getInstance().getNameById(string));
            }
            arrayList.add(categoryBreakOut);
        }
        this.c.setCategoryBreakOut(arrayList);
    }
}

