/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.swing;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.util.NumberUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.swingx.JXCollapsiblePane;

public class QwertyKeyPad
extends JXCollapsiblePane
implements ActionListener,
ChangeListener {
    Font a = this.getFont().deriveFont(1, PosUIManager.getFontSize(24));
    String[] b = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "0", "#"};
    String[] c = new String[]{"q", "w", "e", "r", "t", "y", "u", "i", "o", "p", "@"};
    String[] d = new String[]{"a", "s", "d", "f", "g", "h", "j", "k", "l", ";", "+"};
    String[] e = new String[]{"z", "x", "c", "v", "b", "n", "m", "&", String.valueOf(NumberUtil.getGroupingSeparator()), String.valueOf(NumberUtil.getDecimalSeparator()), "-"};
    private ArrayList<PosButton> f = new ArrayList();
    private Dimension g = PosUIManager.getSize(60, 60);
    private KeyListener h;

    public QwertyKeyPad() {
        this.a();
    }

    private void a() {
        this.setLayout(new BorderLayout(0, 0));
        TransparentPanel transparentPanel = new TransparentPanel(new GridLayout(0, 1, 2, 2));
        transparentPanel.add(this.a(this.b));
        transparentPanel.add(this.a(this.c));
        transparentPanel.add(this.a(this.d));
        transparentPanel.add(this.a(this.e));
        this.add(transparentPanel, "Center");
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 2, 2));
        PosButton posButton = new PosButton();
        posButton.setText(Messages.getString("QwertyKeyPad.1"));
        posButton.setFocusable(false);
        posButton.addActionListener(this);
        jPanel.add(posButton);
        POSToggleButton pOSToggleButton = new POSToggleButton();
        pOSToggleButton.setText(Messages.getString("QwertyKeyPad.2"));
        pOSToggleButton.setFocusable(false);
        pOSToggleButton.addChangeListener(this);
        jPanel.add(pOSToggleButton);
        PosButton posButton2 = new PosButton();
        posButton2.setText(POSConstants.CLEAR);
        posButton2.setFocusable(false);
        posButton2.addActionListener(this);
        jPanel.add(posButton2);
        PosButton posButton3 = new PosButton();
        posButton3.setFocusable(false);
        posButton3.setText(POSConstants.CLEAR_ALL);
        posButton3.addActionListener(this);
        jPanel.add(posButton3);
        jPanel.setPreferredSize(PosUIManager.getSize(90, 0));
        this.add(jPanel, "East");
    }

    private TransparentPanel a(String[] stringArray) {
        TransparentPanel transparentPanel = new TransparentPanel(new GridLayout(0, this.b.length, 2, 2));
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            PosButton posButton = new PosButton();
            posButton.setText(string);
            posButton.setMinimumSize(this.g);
            posButton.addActionListener(this);
            posButton.setFont(this.a);
            posButton.setFocusable(false);
            this.f.add(posButton);
            transparentPanel.add(posButton);
        }
        return transparentPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (!(component instanceof JTextComponent)) {
            return;
        }
        JTextComponent jTextComponent = (JTextComponent)component;
        if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
            return;
        }
        JTextComponent jTextComponent2 = (JTextComponent)component;
        this.a(jTextComponent2, actionEvent.getActionCommand());
        if (this.h != null) {
            this.h.keyReleased(null);
        }
    }

    private void a(JTextComponent jTextComponent, String string) {
        try {
            int n;
            Document document = jTextComponent.getDocument();
            String string2 = jTextComponent.getSelectedText();
            if (StringUtils.isNotEmpty((String)string2)) {
                n = jTextComponent.getSelectionStart();
                document.remove(n, string2.length());
            }
            n = jTextComponent.getCaretPosition();
            if (string.equals(POSConstants.CLEAR)) {
                if (n > 0) {
                    document.remove(n - 1, 1);
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            } else if (string.equals(POSConstants.CLEAR_ALL)) {
                document.remove(0, document.getLength());
            } else if (string.equals(Messages.getString("QwertyKeyPad.0"))) {
                document.insertString(n, " ", null);
            } else {
                document.insertString(n, string, null);
            }
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        JToggleButton jToggleButton = (JToggleButton)changeEvent.getSource();
        if (jToggleButton.isSelected()) {
            for (PosButton posButton : this.f) {
                posButton.setText(posButton.getText().toUpperCase());
            }
        } else {
            for (PosButton posButton : this.f) {
                posButton.setText(posButton.getText().toLowerCase());
            }
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        final QwertyKeyPad qwertyKeyPad = new QwertyKeyPad();
        jFrame.add((Component)((Object)qwertyKeyPad));
        qwertyKeyPad.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent componentEvent) {
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                PosLog.info(this.getClass(), "" + qwertyKeyPad.getSize());
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
            }
        });
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public void setKeyPadListener(KeyListener keyListener) {
        this.h = keyListener;
    }
}

