/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.swing.JRViewer;
import net.sf.jasperreports.swing.JRViewerToolbar;

public class GiftCardInfo
extends POSDialog {
    private GiftCard a;
    private JasperPrint b;

    public GiftCardInfo(GiftCard giftCard) {
        this.a = giftCard;
        this.a();
    }

    private String a(String string) {
        String string2 = this.a.getCardNumber();
        StringBuilder stringBuilder = new StringBuilder(string2);
        for (int i = 0; i < stringBuilder.length(); ++i) {
            if (i != 4 && i != 9 && i != 14) continue;
            stringBuilder.insert(i, "-");
        }
        return stringBuilder.toString();
    }

    public JRViewer createReport() {
        JRViewer jRViewer;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("cafeName", DataProvider.get().getStore().getName());
        hashMap.put("cardNumber", this.a("-"));
        hashMap.put("cardHolder", this.a.getOwnerName());
        hashMap.put("cardStatus", this.a.isActive());
        hashMap.put("cardExpireDate", this.a.getExpiryDate());
        hashMap.put("batchNumber", this.a.getBatchNo());
        hashMap.put("balance", CurrencyUtil.getCurrencySymbol() + " " + String.valueOf(NumberUtil.format(this.a.getBalance())));
        hashMap.put("cardLogo", Application.getApplicationIcon().getImage());
        hashMap.put("bgImage", new ImageIcon(this.getClass().getResource("/images/giftCardBackground.jpg")).getImage());
        hashMap.put("currency_symbol", CurrencyUtil.getCurrencySymbol());
        hashMap.put("lblGiftCard", Messages.getString("GIFT_CARD"));
        hashMap.put("lblBatch", Messages.getString("BATCH"));
        hashMap.put("lblBalance", Messages.getString("Balance"));
        hashMap.put("lblExp", Messages.getString("EXP"));
        hashMap.put("lblStatus", Messages.getString("TICKET_LIST_COLUMN_STATUS"));
        JasperReport jasperReport = ReportUtil.getReport("gift_card");
        try {
            Component[] componentArray;
            this.b = JasperFillManager.fillReport((JasperReport)jasperReport, hashMap, (JRDataSource)new JREmptyDataSource());
            jRViewer = new JRViewer(this.b);
            for (Component component : componentArray = jRViewer.getComponents()) {
                if (!(component instanceof JRViewerToolbar)) continue;
                component.setVisible(false);
            }
        }
        catch (JRException jRException) {
            PosLog.error(this.getClass(), (Exception)((Object)jRException));
            return null;
        }
        return jRViewer;
    }

    private void a() {
        if (this.a == null) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CardNotFound"));
            return;
        }
        this.setTitle(Messages.getString("GiftCardInfo.1"));
        this.setLayout(new BorderLayout(10, 10));
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)this.createReport(), "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        PosButton posButton = new PosButton(Messages.getString("Print"));
        PosButton posButton2 = new PosButton(Messages.getString("Close"));
        posButton2.addActionListener(actionEvent -> this.dispose());
        posButton.addActionListener(actionEvent -> this.a(actionEvent));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new MigLayout("fill,center"));
        jPanel4.add((Component)posButton, "split 2,grow");
        jPanel4.add((Component)posButton2, "grow");
        jPanel3.add((Component)jPanel4, "South");
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel3, "South");
        this.add((Component)jPanel, "Center");
    }

    private void a(ActionEvent actionEvent) {
        try {
            this.b.setName(Messages.getString("GiftCard"));
            ReceiptPrintService.printQuitely(this.b);
        }
        catch (JRException jRException) {
            PosLog.error(this.getClass(), (Exception)((Object)jRException));
        }
    }
}

