/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.config.AppProperties;
import com.floreantpos.main.Application;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TipsCashoutReport;
import com.floreantpos.model.TipsCashoutReportData;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.GratuityDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.ListComboBoxModel;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.TipsCashoutReportDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;

public class GratuityDialog
extends OkCancelOptionDialog
implements ActionListener {
    private JList<User> a;
    private JButton b;
    private JLabel c;
    private JLabel d;
    private JTable e;
    private JPanel f;
    private GratuityTableModel g;
    private PosButton h;
    private JLabel i;
    private PosButton j;
    private Map<String, TipsCashoutReportData> k;
    private User l;

    public GratuityDialog(Window window, User user) {
        super(window, "");
        this.l = user;
        this.setModal(true);
        this.setTitle(AppProperties.getAppName());
        this.a();
        UserDAO userDAO = new UserDAO();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(Messages.getString("ALL"));
        arrayList.addAll(userDAO.findRootUsers());
        this.a.setModel(new ListComboBoxModel(arrayList));
        this.e.getTableHeader().setPreferredSize(PosUIManager.getSize(0, 35));
        this.e.setRowHeight(PosUIManager.getSize(35));
        this.e.setDefaultRenderer(Object.class, new PosTableRenderer());
        this.g = new GratuityTableModel(null);
        this.e.setModel(this.g);
        for (Object e : arrayList) {
            if (!(e instanceof User) || !((User)e).getId().equals(user.getId())) continue;
            this.a.setSelectedValue(e, true);
            break;
        }
        this.b.addActionListener(this);
    }

    private void a() {
        this.setCaption(Messages.getString("GratuityDialog.2"));
        this.f = new JPanel();
        this.f.setLayout((LayoutManager)new MigLayout("fill"));
        this.a = new JList();
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("GratuityDialog.5")));
        jPanel.setPreferredSize(PosUIManager.getSize(200, 0));
        jPanel.add((Component)new JScrollPane(this.a), "grow");
        this.getContentPanel().add((Component)jPanel, "West");
        this.a.setFixedCellHeight(40);
        this.a.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                GratuityDialog.this.showGratuity(GratuityDialog.this.d());
            }
        });
        this.b = new JButton();
        this.h = new PosButton();
        this.h.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GratuityDialog.this.b();
            }
        });
        this.h.setText(Messages.getString("GratuityDialog.7"));
        this.j = new PosButton();
        this.j.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GratuityDialog.this.c();
            }
        });
        this.j.setText(Messages.getString("GratuityDialog.8"));
        this.getButtonPanel().add((Component)this.j, 0);
        this.getButtonPanel().add((Component)this.h, 0);
        this.f.add(new JLabel(POSConstants.USER_ID + ":"));
        this.c = new JLabel();
        this.f.add((Component)this.c, "wrap");
        this.f.add(new JLabel(POSConstants.USER_NAME + ":"));
        this.d = new JLabel();
        this.f.add((Component)this.d, "wrap");
        this.f.add(new JLabel(POSConstants.DETAILS));
        this.f.add((Component)new JSeparator(), "grow,span");
        JScrollPane jScrollPane = new JScrollPane();
        this.f.add((Component)jScrollPane, "grow,span");
        this.e = new JTable();
        jScrollPane.setViewportView(this.e);
        this.f.add((Component)new JSeparator(), "newline,span");
        this.i = new JLabel();
        Font font = new Font(null, 1, 14);
        this.i.setFont(font);
        this.f.add((Component)new JLabel(Messages.getString("GratuityDialog.19")), "split 2,right,span");
        this.f.add((Component)this.i, "wrap,gapright 5");
        this.getContentPanel().add(this.f);
    }

    private void b() {
        try {
            ListComboBoxModel listComboBoxModel = (ListComboBoxModel)this.a.getModel();
            TipsCashoutReportDialog tipsCashoutReportDialog = new TipsCashoutReportDialog(null, listComboBoxModel, this.d(), true);
            tipsCashoutReportDialog.setCaption(POSConstants.SERVER_TIPS_REPORT);
            tipsCashoutReportDialog.setSize(810, 600);
            tipsCashoutReportDialog.open();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    private void c() {
        try {
            GratuityDAO gratuityDAO = new GratuityDAO();
            TipsCashoutReport tipsCashoutReport = gratuityDAO.createReport(null, null, this.d());
            TipsCashoutReportDialog tipsCashoutReportDialog = new TipsCashoutReportDialog(tipsCashoutReport);
            tipsCashoutReportDialog.setCaption(POSConstants.SERVER_TIPS_REPORT);
            tipsCashoutReportDialog.setSize(650, 600);
            tipsCashoutReportDialog.open();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    public void showGratuity(User user) {
        TipsCashoutReportData tipsCashoutReportData;
        Object object;
        GratuityDAO gratuityDAO = new GratuityDAO();
        List<Gratuity> list = gratuityDAO.findByUserRoles(user);
        this.k = new HashMap<String, TipsCashoutReportData>();
        for (Gratuity gratuity : list) {
            String string;
            User user2 = UserDAO.getInstance().get(gratuity.getOwnerId());
            if (user2 != null && !user2.isRoot().booleanValue()) {
                user2 = user2.getParentUser();
            }
            if ((object = this.k.get(string = user2 != null ? user2.getId() : null)) == null) {
                tipsCashoutReportData = new TipsCashoutReportData();
                tipsCashoutReportData.setOwner(user2);
                tipsCashoutReportData.setTicketId(gratuity.getTicketId());
                tipsCashoutReportData.setAmount(gratuity.getTransactionTipsAmount());
                tipsCashoutReportData.setTipsPaidAmount(gratuity.getTipsPaidAmount());
                this.k.put(string, tipsCashoutReportData);
                continue;
            }
            ((TipsCashoutReportData)object).setAmount(((TipsCashoutReportData)object).getAmount() + gratuity.getTransactionTipsAmount());
            ((TipsCashoutReportData)object).setTipsPaidAmount(((TipsCashoutReportData)object).getTipsPaidAmount() + gratuity.getTipsPaidAmount());
        }
        double d = 0.0;
        double d2 = 0.0;
        object = this.k.values().iterator();
        while (object.hasNext()) {
            tipsCashoutReportData = object.next();
            if (tipsCashoutReportData.getAmount() - tipsCashoutReportData.getTipsPaidAmount() <= 0.0) {
                object.remove();
                continue;
            }
            d += tipsCashoutReportData.getAmount().doubleValue();
            d2 += tipsCashoutReportData.getTipsPaidAmount().doubleValue();
        }
        if (user != null) {
            this.c.setText(String.valueOf(user.getId()));
            this.d.setText(user.getFirstName() + " " + user.getLastName());
        } else {
            this.c.setText(Messages.getString("ALL"));
            this.d.setText(Messages.getString("ALL"));
        }
        this.i.setText(NumberUtil.formatNumber(d - d2));
        this.g.setRows(new ArrayList<TipsCashoutReportData>(this.k.values()));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (POSConstants.GO.equalsIgnoreCase(string)) {
            this.showGratuity(this.d());
        }
    }

    private User d() {
        User user = this.a.getSelectedValue();
        if (user instanceof User) {
            return user;
        }
        return null;
    }

    @Override
    public void doOk() {
        this.e();
    }

    private void e() {
        try {
            List<Gratuity> list;
            Terminal terminal = DataProvider.get().getCurrentTerminal();
            CashDrawer cashDrawer = terminal.getCurrentCashDrawer();
            if (cashDrawer == null) {
                throw new PosException(Messages.getString("GratuityDialog.0"));
            }
            User user = this.d();
            TipsCashoutReportData tipsCashoutReportData = null;
            if (user == null) {
                int n = this.e.getSelectedRow();
                if (n == -1) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GratuityDialog.25"));
                    return;
                }
                tipsCashoutReportData = (TipsCashoutReportData)this.g.getRowData(n);
                if (tipsCashoutReportData == null) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GratuityDialog.25"));
                    return;
                }
                User user2 = tipsCashoutReportData.getOwner();
                if (user2 == null) {
                    throw new PosException("Tips owner not found.");
                }
                user = UserDAO.getInstance().get(user2.getId());
                if (user == null) {
                    throw new PosException("Tips owner not found.");
                }
            }
            if ((list = GratuityDAO.getInstance().findByUserRoles(user)) == null || list.size() <= 0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GratuityDialog.27"));
                return;
            }
            if (tipsCashoutReportData == null && this.g.getRowCount() > 0) {
                tipsCashoutReportData = (TipsCashoutReportData)this.g.getRowData(0);
            }
            double d = 0.0;
            if (tipsCashoutReportData != null) {
                try {
                    d = tipsCashoutReportData.getAmount() - tipsCashoutReportData.getTipsPaidAmount();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((d = NumberUtil.round(d)) == 0.0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GratuityDialog.28"));
                return;
            }
            double d2 = NumberSelectionDialog2.takeDoubleInput(Messages.getString("EnterTipsAmount"), d);
            if (d2 == -1.0) {
                return;
            }
            if (d2 < 0.0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GratuityDialog.30"));
                return;
            }
            GratuityDAO.getInstance().payTips(list, cashDrawer, this.l, d2);
            String string = POSConstants.PAY_TIPS;
            ActionHistoryDAO.saveHistory(Application.getCurrentUser(), "Pay tips", string);
            POSMessageDialog.showMessage(Messages.getString("GratuityDialog.1") + CurrencyUtil.getCurrencySymbol() + (d2 > d ? NumberUtil.format(d) : NumberUtil.format(d2)));
            this.showGratuity(this.d());
        }
        catch (PosException posException) {
            POSMessageDialog.showError(this.f, posException.getMessage(), posException);
        }
    }

    private class GratuityTableModel
    extends ListTableModel {
        public GratuityTableModel(List<TipsCashoutReportData> list) {
            super(new String[]{Messages.getString("GratuityDialog.22"), POSConstants.FIRST_NAME, POSConstants.LAST_NAME, Messages.getString("GratuityDialog.23")}, list);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            TipsCashoutReportData tipsCashoutReportData = (TipsCashoutReportData)this.rows.get(n);
            User user = tipsCashoutReportData.getOwner();
            switch (n2) {
                case 0: {
                    return user == null ? null : user.getId();
                }
                case 1: {
                    return user == null ? null : user.getFirstName();
                }
                case 2: {
                    return user == null ? null : user.getLastName();
                }
                case 3: {
                    return NumberUtil.roundToTwoDigit(tipsCashoutReportData.getAmount() - tipsCashoutReportData.getTipsPaidAmount());
                }
            }
            return null;
        }
    }
}

