/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.Recepie;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.RecepieDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.NumericKeypad;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.WrapLayout;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.orocube.looks.plastic.PosTabbedPaneUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class ItemDetailDialog
extends OkCancelOptionDialog {
    private Ticket b;
    private MenuItem c;
    private List<IUnit> d;
    private JLabel e;
    private JLabel f = new JLabel();
    private JLabel g = new JLabel();
    private JLabel h;
    private IUnit i;
    private IUnit j;
    InputPanel a;
    private double k;
    private double l;
    private JTabbedPane m = new JTabbedPane();
    private boolean n;

    public ItemDetailDialog() {
        super(POSUtil.getFocusedWindow());
        this.a();
    }

    public ItemDetailDialog(Ticket ticket, MenuItem menuItem) {
        super(POSUtil.getFocusedWindow());
        this.b = ticket;
        this.c = menuItem;
        this.d = this.c.getUnits();
        this.i = menuItem.getUnit();
        this.a();
    }

    private void a() {
        this.setResizable(false);
        this.setTitle(Messages.getString("ItemDetailDialog.2"));
        this.setCaption(this.c.getDisplayName());
        JPanel jPanel = this.getContentPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout(0, 5));
        Dimension dimension = PosUIManager.getSize(300, 200);
        this.e = new JLabel("");
        this.e.setVerticalAlignment(0);
        this.e.setHorizontalAlignment(0);
        this.e.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.e.setPreferredSize(dimension);
        jPanel2.add((Component)this.e, "North");
        this.g.setVerticalAlignment(1);
        this.g.setPreferredSize(PosUIManager.getSize(342, 200));
        String string = this.c.getDescription();
        if (StringUtils.isNotBlank((String)string)) {
            string = string.replaceAll("\n", "<br/>");
            this.g.setText("<html><p style='text-align: justify;'>" + string + "</p></html>");
        } else {
            this.g.setText(Messages.getString("ItemDetailDialog.4"));
        }
        JPanel jPanel3 = new JPanel((LayoutManager)new MigLayout("hidemode 3,inset 0"));
        jPanel3.add(this.g);
        this.h = new JLabel();
        this.h.setVerticalAlignment(1);
        this.h.setPreferredSize(PosUIManager.getSize(300, 200));
        JPanel jPanel4 = new JPanel((LayoutManager)new MigLayout("hidemode 3,inset 0"));
        jPanel4.add(this.h);
        this.m.setUI(new PosTabbedPaneUI());
        this.m.addTab(POSConstants.DESCRIPTION, jPanel3);
        this.m.addTab(Messages.getString("ItemDetailDialog.3"), jPanel4);
        this.m.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
                int n = jTabbedPane.getSelectedIndex();
                if (n == 1) {
                    ItemDetailDialog.this.c();
                }
            }
        });
        jPanel2.add((Component)this.m, "Center");
        this.l = this.k = this.c.getPriceFromPriceRule(this.b);
        StringBuilder stringBuilder = this.d();
        this.f.setText(stringBuilder.toString());
        this.f.setVerticalAlignment(1);
        this.f.setHorizontalAlignment(0);
        jPanel2.add((Component)this.f, "South");
        JPanel jPanel5 = new JPanel((LayoutManager)new MigLayout("hidemode 3,inset 0"));
        jPanel.add((Component)jPanel2, "West");
        this.a = new InputPanel(Messages.getString("ItemDetailDialog.1"), this.c.isFractionalUnit());
        this.a.setQty(1.0);
        jPanel5.add((Component)this.a, "gapleft 10, span 2");
        this.a.a(this.c.isEditablePrice());
        jPanel.add((Component)jPanel5, "East");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ImageResource imageResource = DataProvider.get().getImageResource(ItemDetailDialog.this.c.getImageId());
                if (imageResource != null) {
                    ItemDetailDialog.this.e.setIcon(imageResource.getImageOfHeight(PosUIManager.getSize(200)));
                } else {
                    ImageIcon imageIcon = IconFactory.getIcon("image-placeholder.jpg");
                    ItemDetailDialog.this.e.setIcon(imageIcon);
                }
                ItemDetailDialog.this.a.h.requestFocus();
            }
        });
    }

    private void a(JPanel jPanel) {
        if (this.d == null) {
            return;
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        for (IUnit iUnit : this.d) {
            UnitButton unitButton = new UnitButton(iUnit);
            buttonGroup.add(unitButton);
            jPanel.add(unitButton);
        }
    }

    public IUnit getSelectedUnit() {
        return this.j;
    }

    @Override
    public void setTitle(String string) {
        super.setTitle(string);
    }

    public void setDialogTitle(String string) {
        super.setTitle(string);
    }

    public double getWeightOrQuantity() {
        String string = this.a.h.getText();
        if (StringUtils.isEmpty((String)string) || !NumberUtils.isNumber((String)string)) {
            return 0.0;
        }
        return NumberUtil.parseDouble(string);
    }

    public double getPrice() {
        String string = this.a.d.getText();
        if (StringUtils.isEmpty((String)string) || !NumberUtils.isNumber((String)string)) {
            return 0.0;
        }
        return NumberUtil.parseDouble(string);
    }

    private Boolean b() {
        if (this.c == null) {
            return Boolean.FALSE;
        }
        Double d = this.c.getUnitQuantity(this.j == null ? this.i : this.j, this.c.getUnit());
        d = Double.parseDouble(this.a.h.getText()) * d;
        double d2 = d;
        int n = (int)d2;
        d = new Double(n);
        return d2 > d;
    }

    @Override
    public void doOk() {
        if (!NumberUtils.isNumber((String)this.a.h.getText()) || this.getWeightOrQuantity() <= 0.0) {
            POSMessageDialog.showError(this, Messages.getString("PosMessage.312"));
            return;
        }
        if ((this.c.isFractionalUnit() == null || !this.c.isFractionalUnit().booleanValue()) && this.b().booleanValue()) {
            POSMessageDialog.showError(this, Messages.getString("ItemQtySelectionDialog.0"));
            return;
        }
        if (this.c.isEditablePrice().booleanValue()) {
            if (!NumberUtils.isNumber((String)this.a.d.getText())) {
                POSMessageDialog.showError(this, Messages.getString("PosMessage.280"));
                return;
            }
            if (this.getPrice() < 0.0) {
                POSMessageDialog.showError(this, POSConstants.NEGATIVE_AMOUNT_NOT_ALLOWED);
                return;
            }
        }
        this.setCanceled(false);
        this.dispose();
    }

    private void c() {
        Recepie recepie;
        if (this.n) {
            return;
        }
        this.h.setText(Messages.getString("ItemDetailDialog.5"));
        String string = this.c.getDefaultRecipeId();
        if (StringUtils.isNotEmpty((String)string) && (recepie = RecepieDAO.getInstance().get(string)) != null) {
            this.h.setText("<html><p style='text-align: justify;'>" + recepie.getDescription() + "</p></html>");
        }
        this.n = true;
    }

    private StringBuilder d() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html><p style='font-size: 26pt;'><b>");
        stringBuilder.append(POSConstants.PRICE);
        stringBuilder.append(": ");
        stringBuilder.append(CurrencyUtil.getCurrencySymbol() + NumberUtil.formatNumber(this.l));
        stringBuilder.append("</b></p></html>");
        return stringBuilder;
    }

    class UnitButton
    extends POSToggleButton
    implements ActionListener {
        private IUnit b;

        public UnitButton(IUnit iUnit) {
            this.b = iUnit;
            this.setText(iUnit.getName());
            this.addActionListener(this);
            if (iUnit.equals(ItemDetailDialog.this.i)) {
                this.setSelected(true);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
            if (jToggleButton.isSelected()) {
                ItemDetailDialog.this.j = this.b;
                double d = ItemDetailDialog.this.c.getUnitQuantity(ItemDetailDialog.this.c.getUnit(), ItemDetailDialog.this.j);
                ItemDetailDialog.this.l = ItemDetailDialog.this.c.getDestinationUnitPrice(ItemDetailDialog.this.c, ItemDetailDialog.this.j, ItemDetailDialog.this.k, d);
                StringBuilder stringBuilder = ItemDetailDialog.this.d();
                ItemDetailDialog.this.f.setText(stringBuilder.toString());
                if (ItemDetailDialog.this.c.isEditablePrice().booleanValue()) {
                    ItemDetailDialog.this.a.setPrice(ItemDetailDialog.this.l * ItemDetailDialog.this.getWeightOrQuantity());
                }
            }
        }
    }

    class InputPanel
    extends JPanel {
        JLabel a = new JLabel();
        PosButton b = new PosButton("-");
        PosButton c = new PosButton("+");
        JTextField d;
        JLabel e = new JLabel();
        PosButton f = new PosButton("-");
        PosButton g = new PosButton("+");
        JTextField h;
        boolean i;

        public InputPanel(String string, boolean bl) {
            this.i = bl;
            this.setLayout((LayoutManager)new MigLayout("fill, ins 0, hidemode 3"));
            this.a.setText("<html><p style='font-size: 20pt; font-weight: bold; text-align: right;'>" + Messages.getString("ItemDetailDialog.0") + "</p></html>");
            this.a.setHorizontalAlignment(4);
            this.b = new PosButton("-");
            this.b.setFont(new Font("Arial", 0, 30));
            this.b.setFocusable(false);
            this.b.setPreferredSize(PosUIManager.getSize(60, 60));
            this.c = new PosButton("+");
            this.c.setPreferredSize(PosUIManager.getSize(60, 60));
            this.c.setFont(new Font("Arial", 1, 30));
            this.c.setFocusable(false);
            this.d = new DoubleTextField(10, 16, 6);
            this.d.setHorizontalAlignment(11);
            this.d.setFont(this.d.getFont().deriveFont(1, PosUIManager.getNumberFieldFontSize()));
            this.d.setFocusable(true);
            this.d.requestFocus();
            this.d.setBackground(Color.WHITE);
            this.add((Component)this.a, "grow");
            this.add((Component)this.b, "grow");
            this.add((Component)this.d, "grow");
            this.add((Component)this.c, "wrap");
            this.e.setText("<html><p style='font-size: 20pt; font-weight: bold; text-align: right;'>" + Messages.getString("ItemDetailDialog.1") + "</p></html>");
            this.e.setHorizontalAlignment(4);
            this.f = new PosButton("-");
            this.f.setFont(new Font("Arial", 0, 30));
            this.f.setFocusable(false);
            this.f.setPreferredSize(PosUIManager.getSize(60, 60));
            this.g = new PosButton("+");
            this.g.setPreferredSize(PosUIManager.getSize(60, 60));
            this.g.setFont(new Font("Arial", 1, 30));
            this.g.setFocusable(false);
            this.h = bl ? new DoubleTextField(10, 16, 6) : new IntegerTextField(10);
            this.h.setHorizontalAlignment(11);
            this.h.setFont(this.d.getFont().deriveFont(1, PosUIManager.getNumberFieldFontSize()));
            this.h.setFocusable(true);
            this.h.requestFocus();
            this.h.setBackground(Color.WHITE);
            this.add((Component)this.e, "grow");
            this.add((Component)this.f, "grow");
            this.add((Component)this.h, "grow");
            this.add((Component)this.g, "");
            this.h.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    InputPanel.this.e();
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    InputPanel.this.e();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    InputPanel.this.e();
                }
            });
            NumericKeypad numericKeypad = new NumericKeypad();
            numericKeypad.setPreferredSize(PosUIManager.getSize(200, 300));
            this.add((Component)numericKeypad, "newline, skip 1, span 2, grow");
            if (ItemDetailDialog.this.c.isAllowUnitSelection()) {
                JPanel jPanel = new JPanel(new WrapLayout(3));
                jPanel.setPreferredSize(PosUIManager.getSize(200, 100));
                CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, Messages.getString("SelectUnit"), 2, 0), new EmptyBorder(0, 0, 0, 0));
                jPanel.setBorder(compoundBorder);
                ItemDetailDialog.this.a(jPanel);
                this.add((Component)jPanel, "grow, span 2");
            }
            this.addButtonListeners();
        }

        public void addButtonListeners() {
            this.c.addActionListener(actionEvent -> this.a());
            this.b.addActionListener(actionEvent -> this.b());
            this.g.addActionListener(actionEvent -> this.c());
            this.f.addActionListener(actionEvent -> this.d());
        }

        public void setPrice(double d) {
            if (d == 0.0) {
                this.d.setText("0");
                this.d.selectAll();
            } else {
                this.d.setText(NumberUtil.formatNumber(d));
            }
            this.d.selectAll();
        }

        public void setQty(double d) {
            if (d == 0.0) {
                if (this.i) {
                    this.h.setText("0");
                    this.h.selectAll();
                } else {
                    this.h.setText("");
                }
            } else if (this.i) {
                this.h.setText(NumberUtil.formatNumber(d));
            } else {
                this.h.setText(String.valueOf((int)d));
            }
            this.h.selectAll();
        }

        void a(boolean bl) {
            this.a.setVisible(bl);
            this.d.setVisible(bl);
            this.b.setVisible(bl);
            this.c.setVisible(bl);
        }

        private void a() {
            this.d.requestFocus();
            String string = this.d.getText();
            if (StringUtils.isNotEmpty((String)string) && NumberUtils.isNumber((String)string)) {
                double d = NumberUtil.parseDouble(string);
                if (d == Math.floor(d) || !Double.isInfinite(d)) {
                    this.d.setText("" + NumberUtil.trimDecilamIfNotNeeded(d += 1.0));
                }
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        private void b() {
            this.d.requestFocus();
            String string = this.d.getText();
            if (StringUtils.isNotEmpty((String)string) && NumberUtils.isNumber((String)string)) {
                double d = NumberUtil.parseDouble(string);
                if ((d == Math.floor(d) || !Double.isInfinite(d)) && (d -= 1.0) >= 0.0) {
                    this.d.setText("" + NumberUtil.trimDecilamIfNotNeeded(d));
                }
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        private void c() {
            this.h.requestFocus();
            String string = this.h.getText();
            if (StringUtils.isNotEmpty((String)string) && NumberUtils.isNumber((String)string)) {
                double d = NumberUtil.parseDouble(string);
                if (d == Math.floor(d) || !Double.isInfinite(d)) {
                    this.h.setText("" + NumberUtil.trimDecilamIfNotNeeded(d += 1.0));
                }
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        private void d() {
            this.h.requestFocus();
            String string = this.h.getText();
            if (StringUtils.isNotEmpty((String)string) && NumberUtils.isNumber((String)string)) {
                double d = NumberUtil.parseDouble(string);
                if ((d == Math.floor(d) || !Double.isInfinite(d)) && (d -= 1.0) >= 0.0) {
                    this.h.setText("" + NumberUtil.trimDecilamIfNotNeeded(d));
                }
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        private void e() {
            if (ItemDetailDialog.this.c.isEditablePrice().booleanValue() && this.d.isVisible()) {
                double d = ItemDetailDialog.this.getWeightOrQuantity();
                this.setPrice(ItemDetailDialog.this.l * d);
            }
        }
    }
}

