/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.CreditCardTransaction;
import com.floreantpos.model.Customer;
import com.floreantpos.model.DebitCardTransaction;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.VoidTransaction;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.payment.MemberPaymentPlugin;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.services.PosTransactionService;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.GlobalInputDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.payment.CustomPaymentSelectionDialog;
import com.floreantpos.ui.views.payment.SettleTicketProcessor;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.DrawerUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class RefundDialog
extends OkCancelOptionDialog {
    private Ticket a;
    private Map<String, PosButton> b = new HashMap<String, PosButton>();
    private JPanel c;
    private double d = 0.0;
    private SettleTicketProcessor e;

    public RefundDialog(Window window, Ticket ticket, SettleTicketProcessor settleTicketProcessor) {
        super(window, "");
        this.a = ticket;
        this.e = settleTicketProcessor;
        this.a();
        this.b();
        this.c();
    }

    private void a() {
        this.setCaption(Messages.getString("RefundDialog.1") + CurrencyUtil.getCurrencySymbol() + NumberUtil.formatAmount(this.a((PosTransaction)null)));
        this.setOkButtonText(POSConstants.SAVE_BUTTON_TEXT);
        this.setDefaultCloseOperation(0);
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new MigLayout("inset 0,fill,hidemode 3", "[grow]", ""));
        Font font = new Font("Tahoma", 1, PosUIManager.getFontSize(16));
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("fill,ins 0 5 2 5,hidemode 3", "[grow]", "[grow]"));
        this.c = new JPanel((LayoutManager)new MigLayout("wrap 3,center", "sg,fill", ""));
        JLabel jLabel = new JLabel(Messages.getString("RefundDialog.13"));
        jLabel.setFont(font);
        PosScrollPane posScrollPane = new PosScrollPane(this.c);
        posScrollPane.setBorder(BorderFactory.createTitledBorder(null, Messages.getString("RefundDialog.14"), 2, 2));
        jPanel2.add((Component)posScrollPane, "grow,aligny bottom,span");
        jPanel.add((Component)jPanel2, "grow");
        this.getContentPanel().add(jPanel);
    }

    private void b() {
        this.c.removeAll();
        this.c.add(this.a(PaymentType.CASH), "aligny top");
        this.c.add(this.a(PaymentType.CUSTOM_PAYMENT), "aligny top");
        this.c.add(this.a(PaymentType.GIFT_CERTIFICATE), "aligny top");
        this.c.add(this.a(PaymentType.MEMBER_ACCOUNT), "aligny top");
        if (this.a != null && this.a.getTransactions() != null) {
            for (PosTransaction posTransaction : this.a.getTransactions()) {
                if (posTransaction.isVoided().booleanValue() || !(posTransaction instanceof DebitCardTransaction) && !(posTransaction instanceof CreditCardTransaction)) continue;
                PosButton posButton = new PosButton();
                posButton.putClientProperty("transaction", posTransaction);
                posButton.setAction(new CardRefundAction());
                posButton.setMinimumSize(PosUIManager.getSize(120, 110));
                if (posTransaction.getRefundableAmount() <= 0.0) {
                    posButton.setEnabled(false);
                }
                this.a(posTransaction, posButton);
                this.c.add((Component)posButton, "aligny top");
                this.b.put(posTransaction.getId(), posButton);
            }
        }
        this.c.revalidate();
        this.c.repaint();
    }

    private Component a(PaymentType paymentType) {
        String string = paymentType.getDisplayString();
        string = StringUtils.capitalize((String)string.toLowerCase());
        PosButton posButton = new PosButton();
        posButton.setAction(new SimpleRefundAction(paymentType));
        posButton.setText("<html><center><h3>" + string + "</h3></center></html>");
        posButton.setMinimumSize(PosUIManager.getSize(120, 110));
        boolean bl = this.a.getPaidAmount() != this.a.getRefundAmount();
        posButton.setEnabled(bl);
        return posButton;
    }

    private void a(PosTransaction posTransaction, PosButton posButton) {
        double d = posTransaction.getRefundedAmount();
        String string = posTransaction.getPaymentType().getDisplayString();
        string = StringUtils.capitalize((String)string.toLowerCase());
        if (d > 0.0) {
            posButton.setText("<html><center>" + string + "<br><h3>" + CurrencyUtil.getCurrencySymbol() + posTransaction.getAmount() + "</h3><h5>" + Messages.getString("RefundDialog.28") + CurrencyUtil.getCurrencySymbol() + NumberUtil.format(d) + "</h5></html>");
            posButton.setEnabled(posTransaction.getAmount() != d);
            if (posTransaction.getAmount() != d) {
                posButton.setSelected(true);
            }
        } else {
            Double d2 = posTransaction.getAmount();
            try {
                Double d3 = NumberUtil.parseDouble(posTransaction.getExtraProperty("transactionFee"));
                d2 = d2 - d3;
            }
            catch (Exception exception) {
                // empty catch block
            }
            posButton.setSelected(true);
            posButton.setText("<html><center>" + string + "<br><h3>" + CurrencyUtil.getCurrencySymbol() + NumberUtil.format(d2) + "<h3></center></html>");
        }
    }

    private void c() {
        this.d = 0.0;
        for (PosTransaction posTransaction : this.a.getTransactions()) {
            if (posTransaction instanceof RefundTransaction || posTransaction.isVoided().booleanValue()) continue;
            this.d += posTransaction.getTaxAmount().doubleValue();
        }
    }

    @Override
    public void doOk() {
        this.setCanceled(false);
        this.dispose();
    }

    private void a(PosTransaction posTransaction, PaymentType paymentType) {
        try {
            Object object;
            double d = this.a(posTransaction);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (paymentType == PaymentType.GIFT_CERTIFICATE) {
                object = this.f();
                if (object == null) {
                    return;
                }
                hashMap.put(PosTransaction.PROP_GIFT_CERT_NUMBER, (String)object);
            } else if (paymentType == PaymentType.CUSTOM_PAYMENT) {
                object = new CustomPaymentSelectionDialog();
                ((Dialog)object).setTitle(Messages.getString("SettleTicketDialog.8"));
                ((Window)object).pack();
                ((POSDialog)object).open();
                if (((POSDialog)object).isCanceled()) {
                    return;
                }
                hashMap.put(PosTransaction.PROP_CUSTOM_PAYMENT_FIELD_NAME, ((CustomPaymentSelectionDialog)object).getPaymentFieldName());
                hashMap.put(PosTransaction.PROP_CUSTOM_PAYMENT_ID, ((CustomPaymentSelectionDialog)object).getCustomPaymentId());
                hashMap.put(PosTransaction.PROP_CUSTOM_PAYMENT_NAME, ((CustomPaymentSelectionDialog)object).getPaymentName());
                hashMap.put(PosTransaction.PROP_CUSTOM_PAYMENT_REF, ((CustomPaymentSelectionDialog)object).getPaymentRef());
            } else if (paymentType == PaymentType.MEMBER_ACCOUNT) {
                object = new MemberPaymentPlugin();
                Customer customer = ((MemberPaymentPlugin)object).doSetMember(this.a);
                if (customer == null) {
                    return;
                }
                hashMap.put(PosTransaction.PROP_CUSTOM_PAYMENT_FIELD_NAME, "MEMBER ID");
                hashMap.put(PosTransaction.PROP_CUSTOM_PAYMENT_REF, customer.getId());
            }
            double d2 = NumberSelectionDialog2.takeDoubleInput(Messages.getString("RefundDialog.34"), d);
            if (d2 < 0.0) {
                return;
            }
            if (d2 == 0.0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("RefundDialog.35"));
                return;
            }
            if (d2 > d) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("RefundDialog.36") + d);
                return;
            }
            List<String> list = this.e();
            PosTransaction posTransaction2 = PosTransactionService.getInstance().refundTicket(this.a, posTransaction, d2, Application.getCurrentUser(), paymentType, hashMap);
            this.a.calculatePrice();
            this.a(posTransaction2.getAmount(), list);
            if (NumberUtil.isZero(this.a.getDueAmount())) {
                this.doOk();
            }
            DrawerUtil.kickDrawer();
            this.e.doInformListenerPaymentUpdate();
            this.setCaption(Messages.getString("RefundDialog.38") + CurrencyUtil.getCurrencySymbol() + this.a((PosTransaction)null));
            this.b();
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
            this.dispose();
        }
        catch (Exception exception) {
            TicketDAO.getInstance().refresh(this.a);
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private void a(double d, List<String> list) {
        this.d();
        RefundTransaction refundTransaction = this.a(list);
        if (refundTransaction != null && DataProvider.get().getCurrentTerminal().isAutoPrintReceipt() && NumberUtil.isZero(this.a.getDueAmount())) {
            ReceiptPrintService.printRefundTicket(this.a, refundTransaction);
        }
        if (POSMessageDialog.showMessageAndPromtToPrint(POSUtil.getFocusedWindow(), Messages.getString("RefundDialog.37") + CurrencyUtil.getCurrencySymbol() + NumberUtil.formatAmount(d))) {
            if (refundTransaction == null) {
                return;
            }
            if (ReceiptPrintService.hasNoReceiptPrinters()) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("NoPrinterIsConfigured"));
                return;
            }
            ReceiptPrintService.printRefundTicket(this.a, refundTransaction);
        }
    }

    private void d() {
        try {
            if (this.a.getOrderType().isShouldPrintToKitchen().booleanValue() && this.a.needsKitchenPrint()) {
                ReceiptPrintService.printToKitchen(this.a);
            }
        }
        catch (PosException posException) {
            PosLog.error(this.getClass(), posException.getMessage());
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    private RefundTransaction a(List<String> list) {
        if (this.a.getTransactions() != null && this.a.getTransactions().size() > 0) {
            for (PosTransaction posTransaction : this.a.getTransactions()) {
                if (!(posTransaction instanceof RefundTransaction) || list.contains(posTransaction.getId())) continue;
                return (RefundTransaction)posTransaction;
            }
        }
        return null;
    }

    private List<String> e() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.a.getTransactions() != null && this.a.getTransactions().size() > 0) {
            for (PosTransaction posTransaction : this.a.getTransactions()) {
                if (!(posTransaction instanceof RefundTransaction)) continue;
                arrayList.add(posTransaction.getId());
            }
        }
        return arrayList;
    }

    private String f() {
        GlobalInputDialog globalInputDialog = new GlobalInputDialog();
        globalInputDialog.setCaption(Messages.getString("RefundDialog.33"));
        globalInputDialog.setBlankErrorMessage(Messages.getString("GiftCardCannotBeEmpty"));
        globalInputDialog.open();
        if (globalInputDialog.isCanceled()) {
            return null;
        }
        String string = globalInputDialog.getInput();
        return string;
    }

    private double a(PosTransaction posTransaction) {
        double d = 0.0;
        if (this.a.getDueAmount() >= 0.0) {
            return 0.0;
        }
        d = Math.abs(this.a.getDueAmount());
        return NumberUtil.roundToTwoDigit(d);
    }

    private class SimpleRefundAction
    extends PosAction {
        PaymentType a;

        public SimpleRefundAction(PaymentType paymentType) {
            this.a = paymentType;
        }

        @Override
        public void execute() {
            ArrayList<PosTransaction> arrayList = new ArrayList<PosTransaction>();
            for (PosTransaction posTransaction : RefundDialog.this.a.getTransactions()) {
                if (posTransaction.isVoided().booleanValue() || posTransaction instanceof RefundTransaction || posTransaction instanceof VoidTransaction) continue;
                arrayList.add(posTransaction);
            }
            RefundDialog.this.a(null, this.a);
        }
    }

    private class CardRefundAction
    extends PosAction {
        public CardRefundAction() {
            this.setRequiredPermission(UserPermission.PERFORM_MANAGER_TASK);
            this.setMandatoryPermission(true);
        }

        @Override
        public void execute() {
            PosButton posButton = (PosButton)this.event.getSource();
            PosTransaction posTransaction = (PosTransaction)posButton.getClientProperty("transaction");
            String string = posTransaction.getProperty("REFUNDED_AMOUNT");
            double d = 0.0;
            if (StringUtils.isNotEmpty((String)string)) {
                try {
                    d = NumberUtil.parseDouble(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (d >= posTransaction.getAmount()) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("RefundDialog.43"));
                    posButton.setSelected(false);
                    return;
                }
            }
            RefundDialog.this.a(posTransaction, posTransaction.getPaymentType());
        }
    }
}

