/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.config.CardConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.ActionHistory;
import com.floreantpos.model.CreditCardTransaction;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.VoidTransaction;
import com.floreantpos.model.base.BaseActionHistory;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;

public class VoidPaymentDialog
extends OkCancelOptionDialog {
    private Ticket a;
    private List<PosTransaction> b = new ArrayList<PosTransaction>();
    private Map<String, PosButton> c = new HashMap<String, PosButton>();
    private JPanel d;

    public VoidPaymentDialog(Window window, Ticket ticket) {
        this.a = ticket;
        this.a();
        this.initialize();
        this.setDefaultCloseOperation(0);
    }

    private void a() {
        this.setCaption(Messages.getString("VoidPaymentDialog.0"));
        this.setOkButtonText(POSConstants.SAVE_BUTTON_TEXT);
        this.setCancelButtonVisible(false);
        this.setDefaultCloseOperation(2);
        this.getContentPanel().add(this.b());
    }

    public void initialize() {
        try {
            this.c();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.CANNOT_LOAD_VOID_REASONS, exception);
        }
    }

    private JPanel b() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.d = new JPanel(new FlowLayout(1));
        jPanel.add(this.d);
        return jPanel;
    }

    private void c() {
        this.d.removeAll();
        if (this.a != null) {
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Object object;
                    PosButton posButton = (PosButton)actionEvent.getSource();
                    PosTransaction posTransaction = (PosTransaction)posButton.getClientProperty("transaction");
                    int n = POSMessageDialog.showYesNoQuestionDialog(VoidPaymentDialog.this, Messages.getString("VoidPaymentDialog.2"), Messages.getString("CONFIRM"));
                    if (n != 0) {
                        return;
                    }
                    if (posTransaction instanceof CreditCardTransaction) {
                        object = CardConfig.getPaymentGateway().getProcessor();
                        try {
                            object.voidTransaction(posTransaction);
                            if (!posTransaction.isVoided().booleanValue()) {
                                object.refundTransaction(posTransaction, posTransaction.getAmount());
                                if (!posTransaction.isRefunded()) {
                                    POSMessageDialog.showError(Messages.getString("VoidPaymentDialog.4"));
                                    return;
                                }
                            }
                        }
                        catch (Exception exception) {
                            try {
                                object.refundTransaction(posTransaction, posTransaction.getAmount());
                                if (!posTransaction.isRefunded()) {
                                    POSMessageDialog.showError(Messages.getString("VoidPaymentDialog.4"));
                                    return;
                                }
                            }
                            catch (Exception exception2) {
                                POSMessageDialog.showError(Messages.getString("VoidPaymentDialog.4"));
                                return;
                            }
                        }
                    }
                    posTransaction.setVoided(true);
                    VoidPaymentDialog.this.a.setPaidAmount(NumberUtil.round(VoidPaymentDialog.this.a.getPaidAmount() - posTransaction.getAmount()));
                    VoidPaymentDialog.this.a.setDueAmount(NumberUtil.round(VoidPaymentDialog.this.a.getDueAmount() + posTransaction.getAmount()));
                    VoidPaymentDialog.this.a.setClosed(false);
                    VoidPaymentDialog.this.a.setPaid(false);
                    VoidPaymentDialog.this.a.calculatePrice();
                    TicketDAO.getInstance().update(VoidPaymentDialog.this.a);
                    object = new ActionHistory();
                    ((BaseActionHistory)object).setActionName("Trans reversal");
                    ((ActionHistory)object).setDescription("Trans# " + posTransaction.getId());
                    ((PosButton)actionEvent.getSource()).setEnabled(false);
                }
            };
            for (PosTransaction posTransaction : this.a.getTransactions()) {
                if (posTransaction instanceof RefundTransaction || posTransaction instanceof VoidTransaction || posTransaction.isVoided().booleanValue()) continue;
                PosButton posButton = new PosButton();
                posButton.putClientProperty("transaction", posTransaction);
                posButton.addActionListener(actionListener);
                posButton.setPreferredSize(PosUIManager.getSize(120, 110));
                this.a(posTransaction, posButton);
                this.d.add((Component)posButton, "aligny top");
                this.c.put(posTransaction.getId(), posButton);
            }
        }
        this.setCancelButtonVisible(false);
        this.d.revalidate();
        this.d.repaint();
    }

    private void a(PosTransaction posTransaction, PosButton posButton) {
        double d = 0.0;
        if (d > 0.0) {
            posButton.setText("<html><center>" + (Object)((Object)posTransaction.getPaymentType()) + "<br><h2>" + CurrencyUtil.getCurrencySymbol() + posTransaction.getAmount() + "</h2><h5>" + Messages.getString("VoidPaymentDialog.13") + CurrencyUtil.getCurrencySymbol() + d + "</h5></html>");
            posButton.setEnabled(posTransaction.getAmount() != d);
            if (posTransaction.getAmount() != d) {
                this.b.add(posTransaction);
                posButton.setSelected(true);
            }
        } else {
            this.b.add(posTransaction);
            posButton.setSelected(true);
            posButton.setText("<html><center>" + (Object)((Object)posTransaction.getPaymentType()) + "<br><h2>" + CurrencyUtil.getCurrencySymbol() + posTransaction.getAmount());
        }
    }

    @Override
    public void doOk() {
        try {
            this.canceled = false;
            this.dispose();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }
}

