/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.floorplan;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.SystemProperties;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.customer.CustomerSelectorDialog;
import com.floreantpos.customer.CustomerSelectorFactory;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.FloorLayoutPlugin;
import com.floreantpos.model.Customer;
import com.floreantpos.model.ShopSeat;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemSeat;
import com.floreantpos.swing.HorizontalSimpleScrollPane;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.WrapLayout;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CopyUtil;
import com.floreantpos.util.GlobalIdGenerator;
import com.floreantpos.util.POSUtil;
import com.jidesoft.swing.TitledSeparator;
import com.orocube.licensemanager.LicenseMode;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class SeatSelectionDialog
extends POSDialog
implements ActionListener {
    private TitlePanel a;
    private ShopSeat b;
    private JLayeredPane c = new JLayeredPane();
    private SeatMemberInfoView d;
    private List<ShopTable> e;
    private ShopTable f;
    private ButtonGroup g = new ButtonGroup();
    private Map<Integer, TableButton> h = new HashMap<Integer, TableButton>();
    private Map<ShopSeat, SeatButton> i = new HashMap<ShopSeat, SeatButton>();
    private Map<ShopSeat, SeatButton> j = new HashMap<ShopSeat, SeatButton>();
    private Map<ShopSeat, TicketItemSeat> k = new HashMap<ShopSeat, TicketItemSeat>();
    private PosButton l;
    private PosButton m;
    private TicketItemSeat n;
    private Ticket o;
    private TicketItemSeat p;
    private boolean q;
    private boolean r = SystemProperties.isSeatCustomerEnable();
    private PosButton s;
    private POSToggleButton t;
    private JPanel u;
    private JPanel v;

    public SeatSelectionDialog(Ticket ticket) {
        this.o = ticket;
        this.q = false;
        this.a();
        this.b();
        this.a(this.e.get(0));
        TableButton tableButton = this.h.get(this.e.get(0).getId());
        if (tableButton != null) {
            tableButton.setSelected(true);
        }
    }

    public SeatSelectionDialog(Ticket ticket, TicketItemSeat ticketItemSeat) {
        this.o = ticket;
        this.q = true;
        this.a();
        this.b();
        this.l.setVisible(true);
        this.a(this.e.get(0));
        TableButton tableButton = this.h.get(this.e.get(0).getId());
        if (tableButton != null) {
            tableButton.setSelected(true);
        }
        try {
            this.p = ticketItemSeat;
            this.n = (TicketItemSeat)CopyUtil.deepCopy(ticketItemSeat);
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
        if (ticketItemSeat != null) {
            SeatButton seatButton = this.i.get(ticketItemSeat.getShopSeat());
            if (seatButton == null) {
                ShopSeat shopSeat = ticketItemSeat.getShopSeat();
                if (shopSeat == null) {
                    shopSeat = this.a(ticketItemSeat, this.o.getExtraSeats());
                }
                seatButton = this.j.get(shopSeat);
            }
            if (seatButton != null) {
                this.b = seatButton.getSeat();
                this.b.setMember(ticketItemSeat.getMember());
                tableButton = this.h.get(this.b.getTableId());
                if (tableButton != null) {
                    tableButton.setSelected(true);
                    if (this.b.getTableId() != null) {
                        this.a(this.b.getShopTable());
                    }
                } else {
                    this.d();
                }
                this.d.rendererMemberInfo(this.b);
            }
        } else {
            this.m.setSelected(true);
            this.m.setBackground(Color.red);
            tableButton = this.h.get(this.e.get(0).getId());
            if (tableButton != null) {
                tableButton.setSelected(true);
            }
            this.a(this.e.get(0));
            this.d.rendererMemberInfo(this.b);
        }
    }

    private void a() {
        SeatButton seatButton;
        ShopSeat shopSeat2;
        Object object;
        this.e = this.o.getTables();
        List<TicketItem> list = this.o.getTicketItems();
        for (ShopTable object2 : this.e) {
            Set<ShopSeat> set = object2.getSeats();
            if (set == null) continue;
            object = set.iterator();
            while (object.hasNext()) {
                shopSeat2 = object.next();
                shopSeat2.setMember(null);
                seatButton = new SeatButton(shopSeat2);
                this.i.put(shopSeat2, seatButton);
            }
        }
        List<ShopSeat> list2 = this.o.getExtraSeats();
        if (!list2.isEmpty()) {
            list2.forEach(shopSeat -> {
                SeatButton seatButton = new SeatButton((ShopSeat)shopSeat);
                this.j.put((ShopSeat)shopSeat, seatButton);
            });
        }
        if (list != null) {
            for (TicketItem ticketItem : list) {
                if (!ticketItem.isTreatAsSeat().booleanValue() || (object = ticketItem.getSeat()) == null) continue;
                shopSeat2 = ((TicketItemSeat)object).getShopSeat();
                if (shopSeat2 == null) {
                    shopSeat2 = this.a((TicketItemSeat)object, list2);
                }
                if (shopSeat2 == null) continue;
                this.k.put(shopSeat2, (TicketItemSeat)object);
                seatButton = this.i.get(shopSeat2);
                if (seatButton != null) {
                    seatButton.getSeat().setMember(((TicketItemSeat)object).getMember());
                }
                if ((seatButton = this.j.get(shopSeat2)) == null) continue;
                seatButton.getSeat().setMember(((TicketItemSeat)object).getMember());
            }
        }
    }

    private ShopSeat a(TicketItemSeat ticketItemSeat, List<ShopSeat> list) {
        if (ticketItemSeat == null) {
            return null;
        }
        List list2 = list.stream().filter(shopSeat -> shopSeat.getId().equals(ticketItemSeat.getSeatId())).collect(Collectors.toList());
        if (list2.isEmpty()) {
            return null;
        }
        return (ShopSeat)list2.get(0);
    }

    private void b() {
        this.setResizable(true);
        this.setLayout(new BorderLayout());
        this.a = new TitlePanel();
        this.add((Component)this.a, "North");
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        this.s = new PosButton(Messages.getString("SeatSelectionDialog.4"));
        this.s.setActionCommand("Add seat");
        this.s.addActionListener(this);
        jPanel2.add(this.s);
        this.t = new POSToggleButton(Messages.getString("SeatSelectionDialog.8"));
        this.t.setActionCommand("Delete seat");
        jPanel2.add(this.t);
        this.m = new PosButton(Messages.getString("SeatSelectionDialog.2"));
        this.m.setActionCommand("Shared");
        this.m.addActionListener(this);
        jPanel2.add(this.m);
        this.l = new PosButton(Messages.getString("SeatSelectionDialog.1"));
        this.l.setFocusable(false);
        this.l.setVisible(false);
        this.l.addActionListener(this);
        jPanel2.add(this.l);
        PosButton posButton = new PosButton(Messages.getString("SeatSelectionDialog.5"));
        posButton.setActionCommand("Cancel");
        posButton.setFocusable(false);
        posButton.addActionListener(this);
        jPanel2.add(posButton);
        jPanel.add((Component)new JSeparator(0), "North");
        jPanel.add((Component)jPanel2, "South");
        this.add((Component)jPanel, "South");
        this.c();
    }

    private void c() {
        TableButton tableButton;
        Serializable serializable;
        this.c.setPreferredSize(new Dimension(400, 390));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(this.c);
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("fill"));
        JPanel jPanel3 = new JPanel(new WrapLayout());
        if (this.e != null && this.e.size() > 0) {
            serializable = new ButtonGroup();
            for (ShopTable object2 : this.e) {
                tableButton = new TableButton(object2);
                tableButton.setPreferredSize(new Dimension(90, 70));
                tableButton.setForeground(new Color(76, 52, 47));
                tableButton.setBackground(new Color(147, 187, 70));
                ((ButtonGroup)serializable).add(tableButton);
                jPanel3.add(tableButton);
                this.h.put(object2.getId(), tableButton);
            }
        }
        this.d = new SeatMemberInfoView(this.o);
        this.d.setBorder(BorderFactory.createTitledBorder(Messages.getString("SeatSelectionDialog.7")));
        serializable = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 6, 10), BorderFactory.createTitledBorder(Messages.getString("SeatSelectionDialog.3")));
        PosScrollPane posScrollPane = new PosScrollPane(jPanel, 20, 30);
        posScrollPane.getHorizontalScrollBar().setPreferredSize(PosUIManager.getSize(40, 40));
        posScrollPane.setAutoscrolls(true);
        posScrollPane.setBorder(null);
        this.u = new JPanel((LayoutManager)new MigLayout());
        HorizontalSimpleScrollPane horizontalSimpleScrollPane = new HorizontalSimpleScrollPane(this.u);
        tableButton = new TitledSeparator(Messages.getString("SeatSelectionDialog.12"), 2);
        this.v = new JPanel(new BorderLayout());
        this.v.add((Component)tableButton, "North");
        this.v.add((Component)((Object)horizontalSimpleScrollPane), "South");
        this.v.setVisible(Boolean.FALSE);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)posScrollPane, "Center");
        jPanel4.add((Component)this.v, "South");
        jPanel4.setBorder((Border)((Object)serializable));
        this.add((Component)jPanel4, "Center");
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (SystemProperties.isSeatCustomerEnable()) {
            this.d.setPreferredSize(PosUIManager.getSize(300, (int)dimension.getHeight()));
            jPanel2.add((Component)this.d, "grow, wrap");
        }
        if (this.e != null && this.e.size() > 1) {
            PosScrollPane posScrollPane2 = new PosScrollPane(jPanel3, 20, 31);
            posScrollPane2.setBorder(BorderFactory.createTitledBorder(Messages.getString("SeatSelectionDialog.9")));
            if (SystemProperties.isSeatCustomerEnable()) {
                posScrollPane2.setPreferredSize(this.d.getPreferredSize());
            } else {
                posScrollPane2.setPreferredSize(PosUIManager.getSize(300, (int)dimension.getHeight()));
            }
            jPanel2.add((Component)posScrollPane2, "grow");
        }
        this.add((Component)jPanel2, "West");
    }

    private void a(ShopTable shopTable) {
        this.c.removeAll();
        if (shopTable == null) {
            return;
        }
        this.f = shopTable;
        if (this.g()) {
            ShopTableButton shopTableButton = new ShopTableButton(this.c, shopTable);
            shopTableButton.drawShape(shopTable.getStateTableType());
            this.c.add((Component)shopTableButton, Float.valueOf(0.5f));
            this.g = new ButtonGroup();
            Set<ShopSeat> set = shopTable.getSeats();
            if (set != null) {
                for (ShopSeat comparable : set) {
                    SeatButton seatButton = new SeatButton(comparable);
                    this.c.add(seatButton);
                    this.g.add(seatButton);
                    this.i.put(comparable, seatButton);
                }
                if (this.o.getTicketItems() != null) {
                    for (TicketItemSeat ticketItemSeat : this.k.values()) {
                        SeatButton seatButton = this.i.get(ticketItemSeat.getShopSeat());
                        if (seatButton == null) continue;
                        seatButton.setBackground(Color.red);
                    }
                    this.d();
                }
            }
            this.c.moveToBack(shopTableButton);
            this.c.revalidate();
            this.c.repaint();
            this.b(shopTable);
        } else {
            JPanel jPanel = new JPanel(new WrapLayout(0));
            ButtonGroup buttonGroup = new ButtonGroup();
            Set<ShopSeat> set = shopTable.getSeats();
            if (set != null) {
                SeatButton seatButton;
                for (ShopSeat shopSeat : set) {
                    seatButton = new SeatButton(shopSeat);
                    jPanel.add(seatButton);
                    buttonGroup.add(seatButton);
                    this.i.put(shopSeat, seatButton);
                }
                if (this.o.getTicketItems() != null) {
                    for (TicketItemSeat ticketItemSeat : this.k.values()) {
                        seatButton = this.i.get(ticketItemSeat.getShopSeat());
                        if (seatButton == null) continue;
                        seatButton.setBackground(Color.red);
                    }
                    this.d();
                }
            }
            this.add(new PosScrollPane(jPanel));
        }
    }

    private void d() {
        if (this.b != null) {
            SeatButton seatButton = this.i.get(this.b);
            if (seatButton == null) {
                seatButton = this.j.get(this.b);
            }
            if (seatButton != null) {
                seatButton.setSelected(true);
                seatButton.setBackground(Color.green);
            }
        }
    }

    private void e() {
        if (this.o.getTicketItems() != null) {
            Set<ShopSeat> set = this.i.keySet();
            for (ShopSeat shopSeat : set) {
                TicketItemSeat ticketItemSeat = this.k.get(shopSeat);
                if (ticketItemSeat == null) continue;
                ticketItemSeat.setMember(shopSeat.getMember());
            }
            if (this.b != null) {
                SeatSelectionDialog.setCustomerForShopSeat(this.o, this.b, this.b.getMember());
            }
        }
        if (this.n != null && this.n.getSeatId().intern() != this.b.getId().intern()) {
            this.n.setMember(null);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.t.setSelected(Boolean.FALSE);
        String string = actionEvent.getActionCommand();
        if ("Shared".equalsIgnoreCase(string)) {
            this.b = null;
        } else {
            if ("Cancel".equalsIgnoreCase(string)) {
                this.setCanceled(true);
                this.dispose();
                return;
            }
            if ("Add seat".equalsIgnoreCase(string)) {
                this.c(this.f);
                return;
            }
            this.e();
        }
        this.f();
    }

    private void b(ShopTable shopTable) {
        this.u.removeAll();
        if (shopTable == null) {
            return;
        }
        List<ShopSeat> list = this.o.getExtraSeats();
        if (list.isEmpty()) {
            return;
        }
        for (ShopSeat shopSeat : list) {
            SeatButton seatButton = this.j.get(shopSeat);
            if (seatButton == null) {
                seatButton = new SeatButton(shopSeat);
            }
            if (this.k.containsKey(shopSeat)) {
                shopSeat.setMember(seatButton.getSeat().getMember());
                seatButton.setBackground(Color.red);
            }
            seatButton.updateSeatInfo(shopSeat);
            seatButton.setPreferredSize(PosUIManager.getSize(80, 80));
            this.u.add(seatButton);
        }
        this.v.setVisible(Boolean.TRUE);
        this.u.revalidate();
        this.u.repaint();
    }

    private void c(ShopTable shopTable) {
        try {
            if (shopTable == null) {
                return;
            }
            int n = (int)NumberSelectionDialog2.takeIntInput(Messages.getString("SeatSelectionDialog.14"));
            if (n <= 0) {
                POSMessageDialog.showError(Messages.getString("SeatSelectionDialog.6"));
                return;
            }
            List<ShopSeat> list = this.o.getExtraSeats();
            if (!this.a(list, n)) {
                POSMessageDialog.showError(Messages.getString("SeatSelectionDialog.13"));
                return;
            }
            ShopSeat shopSeat = new ShopSeat();
            shopSeat.setId(GlobalIdGenerator.generateGlobalId());
            shopSeat.setSeatNumber(n);
            list.add(shopSeat);
            this.o.addExtraSeats(list);
            SeatButton seatButton = new SeatButton(shopSeat);
            seatButton.setPreferredSize(PosUIManager.getSize(80, 80));
            this.j.put(shopSeat, seatButton);
            this.u.add(seatButton);
            this.v.setVisible(Boolean.TRUE);
            if (this.u.getComponentCount() > 1) {
                this.u.revalidate();
                this.u.repaint();
            } else {
                this.revalidate();
                this.repaint();
            }
        }
        catch (PosException posException) {
            POSMessageDialog.showError(SwingUtilities.getWindowAncestor(this), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(SwingUtilities.getWindowAncestor(this), exception.getMessage(), exception);
        }
    }

    private boolean a(List<ShopSeat> list, Integer n) {
        List<ShopSeat> list2 = this.o.getExtraSeats();
        if (list2 == null || list2.isEmpty()) {
            return true;
        }
        for (ShopSeat shopSeat : list2) {
            if (!shopSeat.getSeatNumber().equals(n)) continue;
            return false;
        }
        return true;
    }

    private void f() {
        if (this.p != null) {
            try {
                PropertyUtils.copyProperties((Object)this.p, (Object)this.n);
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), exception);
            }
        }
        this.setCanceled(false);
        this.dispose();
    }

    @Override
    public void setTitle(String string) {
        this.a.setTitle(string);
        super.setTitle(string);
    }

    public void setDialogTitle(String string) {
        super.setTitle(string);
    }

    private Customer a(ShopSeat shopSeat) {
        List<TicketItem> list = this.o.getTicketItems();
        for (TicketItem ticketItem : list) {
            Customer customer;
            TicketItemSeat ticketItemSeat;
            if (!ticketItem.isTreatAsSeat().booleanValue() || (ticketItemSeat = ticketItem.getSeat()) == null || !ticketItemSeat.getSeatId().equals(shopSeat.getId()) || (customer = ticketItemSeat.getMember()) == null) continue;
            return customer;
        }
        return null;
    }

    public static void setCustomerForShopSeat(Ticket ticket, ShopSeat shopSeat, Customer customer) {
        if (ticket == null) {
            return;
        }
        List<TicketItem> list = ticket.getTicketItems();
        for (TicketItem ticketItem : list) {
            TicketItemSeat ticketItemSeat;
            if (!ticketItem.isTreatAsSeat().booleanValue() || (ticketItemSeat = ticketItem.getSeat()) == null || !ticketItemSeat.getSeatId().equals(shopSeat.getId())) continue;
            ticketItemSeat.setMember(customer);
        }
    }

    public ShopSeat getSeat() {
        return this.b;
    }

    private boolean g() {
        FloorLayoutPlugin floorLayoutPlugin = (FloorLayoutPlugin)ExtensionManager.getPlugin(FloorLayoutPlugin.class);
        return floorLayoutPlugin != null && floorLayoutPlugin.getLicense().getLicenseMode() != LicenseMode.UNINILIZED;
    }

    public class ShopTableButton
    extends JLabel {
        private JLayeredPane b;
        private ShopTable c;
        private int d;

        public ShopTableButton(JLayeredPane jLayeredPane, ShopTable shopTable) {
            this.b = jLayeredPane;
            this.c = shopTable;
            this.setText(shopTable.getId() + "");
            this.setBackground(Color.WHITE);
            Integer n = shopTable.getWidth();
            Integer n2 = shopTable.getHeight();
            if (n == null || n == 0) {
                n = TerminalConfig.getFloorButtonWidth();
            }
            if (n2 == null || n2 == 0) {
                n2 = TerminalConfig.getFloorButtonHeight();
            }
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
            this.setBounds(this.b.getPreferredSize().width / 2 - n / 2, this.b.getPreferredSize().height / 2 - n2 / 2, n, n2);
            this.setFont(new Font(this.getFont().getName(), this.getFont().getStyle(), TerminalConfig.getFloorButtonFontSize() + 10));
        }

        public void drawShape(int n) {
            this.d = n;
            this.repaint();
        }

        @Override
        public void paintAll(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(this.getBackground());
            if (this.d == 2) {
                graphics2D.fillOval(10, 10, this.getSize().width - 20, this.getSize().height - 20);
            } else if (this.d == 1) {
                graphics2D.fillRoundRect(2, 2, this.getSize().width - 4, this.getSize().height - 4, 20, 20);
            } else if (this.d != 3) {
                graphics2D.fillRect(0, 0, this.getSize().width, this.getSize().height);
            }
        }

        @Override
        protected void paintBorder(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(this.getForeground());
            graphics2D.setStroke(new BasicStroke(6.0f));
            int n = this.getSize().width;
            int n2 = this.getSize().height;
            if (this.d == 2) {
                graphics2D.drawOval(10, 10, n - 20, n2 - 20);
            } else if (this.d == 1) {
                graphics2D.drawRoundRect(2, 2, n - 4, n2 - 4, 20, 20);
            } else if (this.d == 3) {
                int n3 = n / 2;
                int n4 = (int)Math.sqrt(n * n + n * n);
                int n5 = n4 - n;
                int n6 = n4 - n;
                graphics2D.rotate(Math.toRadians(45.0), n3, 0.0);
                graphics2D.drawRoundRect(n3 + 2, 4, n - n5, n - n6, 20, 20);
            } else {
                graphics2D.drawRect(0, 0, n, n2);
            }
        }

        public ShopTable getTable() {
            return this.c;
        }
    }

    class TableButton
    extends POSToggleButton
    implements ActionListener {
        ShopTable a;
        int b;
        int c;

        public TableButton(ShopTable shopTable) {
            this.a = shopTable;
            this.setText(shopTable.getTableNumber() + "");
            this.setBounds(shopTable.getX(), shopTable.getY(), shopTable.getWidth(), shopTable.getHeight());
            this.setFont(new Font(this.getFont().getName(), this.getFont().getStyle(), TerminalConfig.getFloorButtonFontSize()));
            this.addActionListener(this);
        }

        public ShopTable getTable() {
            return this.a;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SeatSelectionDialog.this.a(this.a);
        }
    }

    class SeatMemberInfoView
    extends JPanel {
        private JLabel b;
        private JLabel c;
        private JLabel d;
        private JLabel e;
        private byte[] f;
        private JLabel g;
        private JPanel h;
        private JPanel i;
        private Ticket j;
        private Customer k;
        private ShopSeat l;
        private PosButton m;
        private PosButton n;

        public SeatMemberInfoView(Ticket ticket) {
            this.j = ticket;
            this.a();
            this.updateView();
        }

        private void a() {
            this.setLayout(new BorderLayout());
            this.h = new JPanel();
            this.h.setLayout((LayoutManager)new MigLayout("fillx,hidemode 3"));
            this.b = new JLabel();
            this.c = new JLabel();
            this.d = new JLabel(Messages.getString("MemeberName"));
            this.g = new JLabel(Messages.getString("MemberID"));
            Font font = new Font(this.b.getFont().getName(), 1, this.b.getFont().getSize());
            this.b.setFont(font);
            this.c.setFont(font);
            this.h.add((Component)this.g, "grow");
            this.h.add((Component)this.b, "grow,h 25!,wrap");
            this.h.add((Component)this.d, "grow");
            this.h.add((Component)this.c, "grow,w 200!");
            this.n = new PosButton(Messages.getString("ClearSeatSelection"));
            this.n.addActionListener(actionEvent -> this.b());
            this.c();
            JPanel jPanel = new JPanel();
            jPanel.add(this.m);
            jPanel.add(this.n);
            this.add((Component)jPanel, "South");
            this.add(this.h);
        }

        private void b() {
            Serializable serializable;
            if (SeatSelectionDialog.this.n == null && SeatSelectionDialog.this.b != null) {
                serializable = (SeatButton)SeatSelectionDialog.this.i.get(SeatSelectionDialog.this.b);
                SeatSelectionDialog.this.b.setMember(null);
                if (serializable != null) {
                    ((SeatButton)serializable).updateSeatInfo(SeatSelectionDialog.this.b);
                    ((JComponent)serializable).setBackground(Color.WHITE);
                    ((AbstractButton)serializable).setSelected(false);
                }
                SeatSelectionDialog.this.d.a(false);
            }
            if (SeatSelectionDialog.this.n == null) {
                SeatSelectionDialog.this.d.a(true);
                return;
            }
            if (SeatSelectionDialog.this.n.getMember() == null) {
                SeatSelectionDialog.this.d.a(true);
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("NoNeedToClear"));
                return;
            }
            serializable = SeatSelectionDialog.this.n.getShopSeat();
            SeatButton seatButton = (SeatButton)SeatSelectionDialog.this.i.get(serializable);
            SeatSelectionDialog.this.n.setMember(null);
            SeatSelectionDialog.this.b.setMember(null);
            ((ShopSeat)serializable).setMember(null);
            if (seatButton != null) {
                seatButton.updateSeatInfo((ShopSeat)serializable);
                seatButton.setBackground(Color.WHITE);
                seatButton.setSelected(false);
            }
            SeatSelectionDialog.this.d.a(true);
        }

        public void rendererMemberInfo(ShopSeat shopSeat) {
            this.l = shopSeat;
            if (shopSeat != null) {
                this.k = shopSeat.getMember();
            }
            this.updateView();
        }

        private void c() {
            this.i = new JPanel((LayoutManager)new MigLayout());
            this.i.setBackground(Color.white);
            this.e = new JLabel("");
            this.e.setIconTextGap(0);
            this.e.setHorizontalAlignment(0);
            this.i.add((Component)this.e, "wrap,center");
            this.m = new PosButton(Messages.getString("SelectMember"));
            this.m.setFocusable(false);
            this.m.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    CustomerSelectorDialog customerSelectorDialog = CustomerSelectorFactory.createCustomerSelectorDialog(SeatMemberInfoView.this.j.getOrderType());
                    customerSelectorDialog.setCreateNewTicket(false);
                    if (SeatMemberInfoView.this.j != null) {
                        customerSelectorDialog.setTicket(SeatMemberInfoView.this.j);
                    }
                    customerSelectorDialog.openUndecoratedFullScreen();
                    if (customerSelectorDialog.isCanceled()) {
                        return;
                    }
                    SeatMemberInfoView.this.k = customerSelectorDialog.getSelectedCustomer();
                    if (SeatMemberInfoView.this.l != null) {
                        SeatMemberInfoView.this.l.setMember(SeatMemberInfoView.this.k);
                    }
                    SeatMemberInfoView.this.updateView();
                }
            });
            this.h.add((Component)this.i, "skip 1,newline");
            this.d();
        }

        private void a(Customer customer) {
            if (customer != null) {
                ImageIcon imageIcon = IconFactory.getIconFromImageResource(customer.getImageId(), 150, 150);
                if (imageIcon != null) {
                    this.e.setIcon(imageIcon);
                } else {
                    this.d();
                }
            }
        }

        private void d() {
            try {
                InputStream inputStream = this.getClass().getResourceAsStream("/images/generic-profile-pic-v2.png");
                this.f = IOUtils.toByteArray((InputStream)inputStream);
                IOUtils.closeQuietly((InputStream)inputStream);
                this.e.setIcon(new ImageIcon(this.f));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void a(boolean bl) {
            if (bl) {
                this.b.setText("");
                this.c.setText("");
            }
        }

        protected void updateView() {
            Customer customer;
            if (this.k != null) {
                this.b.setText(this.k.getMemberId());
                this.c.setText(this.k.getName());
                this.a(this.k);
            } else if (!SeatSelectionDialog.this.q && (customer = this.j.getCustomer()) != null) {
                this.b.setText(customer.getMemberId());
                this.c.setText(customer.getName());
                this.a(customer);
            }
        }

        public Customer getMember() {
            return this.k;
        }

        public String getCustomerName() {
            return this.c.getText();
        }

        public void setMember(Customer customer) {
            this.k = customer;
            this.updateView();
        }

        public void disableMemberSelection() {
            this.m.setEnabled(false);
        }

        public void enableMemberSelection() {
            this.m.setEnabled(true);
        }
    }

    public class SeatButton
    extends POSToggleButton
    implements ActionListener {
        ShopSeat a;
        int b;
        int c;

        public SeatButton(ShopSeat shopSeat) {
            this.setBounds(shopSeat.getPosX(), shopSeat.getPosY(), 70, 70);
            this.setFont(new Font(this.getFont().getName(), this.getFont().getStyle(), TerminalConfig.getFloorButtonFontSize()));
            this.addActionListener(this);
            this.updateSeatInfo(shopSeat);
        }

        public void updateSeatInfo(ShopSeat shopSeat) {
            this.a = shopSeat;
            Customer customer = shopSeat.getMember();
            String string = "";
            if (customer != null) {
                string = "<br><font size=\"2\">" + customer.getName() + "</font>";
            }
            if (SeatSelectionDialog.this.r) {
                this.setText("<html><center>" + shopSeat.getSeatNumber() + string + "</center></html>");
            } else {
                this.setText("<html><center>" + shopSeat.getSeatNumber() + "</center></html>");
            }
        }

        public ShopSeat getSeat() {
            return this.a;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            List<ShopSeat> list = SeatSelectionDialog.this.o.getExtraSeats();
            if (SeatSelectionDialog.this.t.isSelected()) {
                if (list.contains(this.a)) {
                    Customer customer = this.a.getMember();
                    Color color = this.getBackground();
                    if (customer != null || color == Color.red) {
                        this.setSelected(Boolean.FALSE);
                        String string = Messages.getString("SeatSelectionDialog.15");
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), string);
                        return;
                    }
                    SeatSelectionDialog.this.t.setSelected(Boolean.FALSE);
                    list.remove(this.a);
                    SeatSelectionDialog.this.o.addExtraSeats(list);
                    SeatSelectionDialog.this.u.remove(this);
                    if (SeatSelectionDialog.this.u.getComponentCount() == 0) {
                        SeatSelectionDialog.this.v.setVisible(Boolean.FALSE);
                    }
                    SeatSelectionDialog.this.u.revalidate();
                    SeatSelectionDialog.this.u.repaint();
                } else {
                    SeatSelectionDialog.this.g.clearSelection();
                    String string = Messages.getString("SeatSelectionDialog.16");
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), string);
                }
                return;
            }
            Customer customer = null;
            SeatButton seatButton = null;
            if (SeatSelectionDialog.this.b != null && (seatButton = (SeatButton)SeatSelectionDialog.this.i.get(SeatSelectionDialog.this.b)) == null) {
                seatButton = (SeatButton)SeatSelectionDialog.this.j.get(SeatSelectionDialog.this.b);
            }
            SeatSelectionDialog.this.b = this.a;
            if (SeatSelectionDialog.this.n == null) {
                Customer customer2 = SeatSelectionDialog.this.b.getMember();
                if (customer2 == null) {
                    customer2 = SeatSelectionDialog.this.a(SeatSelectionDialog.this.b);
                }
                Customer customer3 = SeatSelectionDialog.this.d.getMember();
                if (customer2 != null && customer3 != null && !customer2.equals(customer3)) {
                    if (SeatSelectionDialog.this.b.getMember() != null) {
                        this.a(customer2, customer3);
                        return;
                    }
                    SeatSelectionDialog.this.b.setMember(customer3);
                    SeatSelectionDialog.setCustomerForShopSeat(SeatSelectionDialog.this.o, SeatSelectionDialog.this.b, customer3);
                } else if (customer3 != null) {
                    SeatSelectionDialog.this.b.setMember(customer3);
                    if (list.contains(SeatSelectionDialog.this.b)) {
                        list.remove(SeatSelectionDialog.this.b);
                        list.add(SeatSelectionDialog.this.b);
                        SeatSelectionDialog.this.o.addExtraSeats(list);
                    }
                } else if (customer3 == null && StringUtils.isNotBlank((String)SeatSelectionDialog.this.d.getCustomerName())) {
                    SeatSelectionDialog.this.b.setMember(SeatSelectionDialog.this.o.getCustomer());
                }
                SeatSelectionDialog.this.setCanceled(false);
                SeatSelectionDialog.this.dispose();
            } else if (SeatSelectionDialog.this.n != null && SeatSelectionDialog.this.b != null) {
                if (customer == null) {
                    customer = SeatSelectionDialog.this.a(SeatSelectionDialog.this.b);
                }
                if (seatButton != null) {
                    if (SeatSelectionDialog.this.b != null && SeatSelectionDialog.this.b.getMember() != null) {
                        Customer customer4;
                        Customer customer5 = SeatSelectionDialog.this.b.getMember();
                        if (customer5.equals(customer4 = SeatSelectionDialog.this.d.getMember())) {
                            this.setSelected(false);
                            seatButton.setSelected(true);
                            SeatSelectionDialog.this.b = seatButton.getSeat();
                            return;
                        }
                        this.a(customer5, customer4);
                        this.setSelected(false);
                        seatButton.setSelected(true);
                        SeatSelectionDialog.this.b = seatButton.getSeat();
                        return;
                    }
                    ShopSeat shopSeat = seatButton.getSeat();
                    shopSeat.setMember(null);
                    if (SeatSelectionDialog.this.n != null) {
                        customer = SeatSelectionDialog.this.n.getMember();
                        SeatSelectionDialog.this.n.setShopSeat(this.a);
                    }
                    seatButton.updateSeatInfo(shopSeat);
                    seatButton.setBackground(Color.WHITE);
                    if (SeatSelectionDialog.this.i.containsValue(seatButton)) {
                        SeatSelectionDialog.this.g.clearSelection();
                    } else {
                        seatButton.setSelected(Boolean.FALSE);
                    }
                }
                SeatSelectionDialog.this.b.setMember(customer);
                this.updateSeatInfo(SeatSelectionDialog.this.b);
                SeatSelectionDialog.this.d();
                SeatSelectionDialog.this.d.rendererMemberInfo(SeatSelectionDialog.this.b);
            } else {
                SeatSelectionDialog.this.d.rendererMemberInfo(this.a);
            }
        }

        private void a(Customer customer, Customer customer2) {
            if (customer == null) {
                return;
            }
            if (customer2 == null) {
                String string = Messages.getString("SeatSelectionDialog.100");
                String string2 = String.format(string, SeatSelectionDialog.this.b.getSeatNumber(), customer.getName());
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), string2);
                return;
            }
            String string = Messages.getString("SeatSelectionDialog.10");
            String string3 = String.format(string, SeatSelectionDialog.this.b.getSeatNumber(), customer.getName(), customer2.getName());
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), string3);
        }
    }
}

