/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.floorplan;

import com.floreantpos.Messages;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.floorplan.ShopTableForm;
import com.floreantpos.ui.floorplan.ShopTableModelBrowser;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumn;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;

public class ShopTableBrowser
extends ShopTableModelBrowser<ShopTable> {
    private JTextField a;

    public ShopTableBrowser() {
        super(new ShopTableForm());
        this.a();
        this.add((Component)this.b(), "North");
    }

    private void a() {
        BeanTableModel beanTableModel = new BeanTableModel(ShopTable.class);
        beanTableModel.addColumn(Messages.getString("ShopTableBrowser.0"), ShopTable.PROP_ID);
        beanTableModel.addColumn(Messages.getString("ShopTableBrowser.6"), ShopTable.PROP_NAME);
        beanTableModel.addColumn(Messages.getString("ShopTableBrowser.1"), ShopTable.PROP_CAPACITY);
        beanTableModel.addColumn(Messages.getString("ShopTableBrowser.2"), ShopTable.PROP_DESCRIPTION);
        this.init(beanTableModel);
        this.a(0, 80);
        this.a(1, 60);
    }

    @Override
    public void refreshTable() {
        List<ShopTable> list = ShopTableDAO.getInstance().findAll();
        BeanTableModel beanTableModel = (BeanTableModel)this.browserTable.getModel();
        beanTableModel.removeAll();
        beanTableModel.addRows(list);
    }

    private void a(int n, int n2) {
        TableColumn tableColumn = this.browserTable.getColumnModel().getColumn(n);
        tableColumn.setPreferredWidth(n2);
        tableColumn.setMaxWidth(n2);
        tableColumn.setMinWidth(n2);
    }

    private JPanel b() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new MigLayout("", "[][]15[][]15[][]15[]", "[]5[]"));
        Border border = BorderFactory.createEtchedBorder(1);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, Messages.getString("Search"));
        titledBorder.setTitleJustification(1);
        jPanel.setBorder(titledBorder);
        JLabel jLabel = new JLabel(Messages.getString("ShopTableBrowser.26"));
        this.a = new JTextField(15);
        JButton jButton = new JButton(Messages.getString("Search"));
        JButton jButton2 = new JButton(Messages.getString("ShopTableBrowser.28"));
        JButton jButton3 = new JButton(Messages.getString("Refresh"));
        this.a.addActionListener(actionEvent -> this.c());
        jButton.addActionListener(actionEvent -> this.c());
        jButton2.addActionListener(actionEvent -> {
            this.a.setText("");
            this.doRefreshTable();
        });
        jButton3.addActionListener(actionEvent -> {
            this.a.setText("");
            this.doRefreshTable();
        });
        jPanel.add((Component)jLabel, "grow");
        jPanel.add((Component)this.a, "grow");
        jPanel.add((Component)jButton, "grow");
        jPanel.add((Component)jButton3, "grow");
        return jPanel;
    }

    private void c() {
        String string = this.a.getText();
        if (StringUtils.isEmpty((CharSequence)string)) {
            return;
        }
        List<ShopTable> list = ShopTableDAO.getInstance().findByCapacity(string);
        if (list == null || list.size() == 0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ShopTableBrowser.36"));
            return;
        }
        BeanTableModel beanTableModel = (BeanTableModel)this.browserTable.getModel();
        beanTableModel.removeAll();
        beanTableModel.addRows(list);
    }

    public void doRefreshTable() {
        List<ShopTable> list = ShopTableDAO.getInstance().findAllWithTypes();
        Collections.sort(list, (shopTable, shopTable2) -> shopTable.getTableNumber() - shopTable2.getTableNumber());
        BeanTableModel beanTableModel = (BeanTableModel)this.browserTable.getModel();
        beanTableModel.removeAll();
        beanTableModel.addRows(list);
        this.getBeanEditor().clearFields();
    }
}

