/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.forms;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.Customer;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.MonthOfYear;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.ImageResourceDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.model.util.GeneratePasswordUtil;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.ListComboBoxModel;
import com.floreantpos.swing.PosSmallButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.QwertyKeyPad;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.ImageGalleryDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.AddressUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.PosGuiUtil;
import com.jidesoft.swing.AutoCompletionComboBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Image;
import java.awt.LayoutManager;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.routines.EmailValidator;
import org.hibernate.StaleObjectStateException;

public class CustomerForm
extends BeanEditor<Customer> {
    private FixedLengthTextField a;
    private FixedLengthTextField b;
    private FixedLengthTextField c;
    private FixedLengthTextField d;
    private JTextArea e;
    private FixedLengthTextField f;
    private FixedLengthTextField g;
    private IntegerTextField h;
    private DoubleTextField i;
    private DoubleTextField j;
    private AddressUtil k;
    private AutoCompletionComboBox l;
    private AutoCompletionComboBox m;
    private AutoCompletionComboBox n;
    private JCheckBox o;
    private JCheckBox p;
    private JLabel q;
    private PosSmallButton r;
    private PosSmallButton s;
    private JComboBox t;
    private QwertyKeyPad u;
    public boolean isKeypad;
    private ImageResource v;
    private MyOwnFocusTraversalPolicy w;
    private Image x;
    private FixedLengthTextField y;
    private JPanel z;
    private AutoCompletionComboBox A;
    private AutoCompletionComboBox B;
    private AutoCompletionComboBox C;

    public CustomerForm() {
        this.k = new AddressUtil();
        this.a();
    }

    public CustomerForm(boolean bl) {
        this.isKeypad = bl;
        this.k = new AddressUtil();
        this.a();
    }

    private void a() {
        this.setOpaque(true);
        this.setLayout((LayoutManager)new MigLayout("fill", "[][][]", ""));
        this.add((Component)this.b(), "top 0");
        this.add((Component)this.c(), "grow");
        this.add((Component)this.f(), "grow, wrap");
        this.u = new QwertyKeyPad();
        if (this.isKeypad) {
            this.add((Component)((Object)this.u), "span, grow");
        }
        this.r.addActionListener(actionEvent -> this.doSelectImageFile());
        this.s.addActionListener(actionEvent -> this.doClearImage());
        this.enableCustomerFields(false);
        this.callOrderController();
    }

    private JPanel b() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout());
        this.q = new JLabel("");
        this.x = IconFactory.getIcon("/images/", "generic-profile-pic-v2.png").getImage();
        this.q = new JLabel("");
        this.q.setPreferredSize(PosUIManager.getSize(200, 200));
        this.q.setIcon(new ImageIcon(this.x.getScaledInstance(200, 200, 1)));
        this.q.setIconTextGap(0);
        this.q.setHorizontalAlignment(0);
        jPanel.setBorder(new TitledBorder(null, Messages.getString("CustomerForm.10"), 4, 2, null, null));
        jPanel.add((Component)this.q, "grow,wrap,center");
        this.r = new PosSmallButton();
        this.r.setText(Messages.getString("CustomerForm.44"));
        jPanel.add((Component)this.r, "split 2,center");
        this.s = new PosSmallButton();
        this.s.setText(Messages.getString("CustomerForm.45"));
        jPanel.add(this.s);
        return jPanel;
    }

    private JPanel c() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fillx", "[][grow]", ""));
        JLabel jLabel = new JLabel(Messages.getString("CustomerForm.0"));
        this.t = new JComboBox();
        this.t.addItem(Messages.getString("CustomerForm.2"));
        this.t.addItem(Messages.getString("CustomerForm.4"));
        this.t.addItem(Messages.getString("CustomerForm.5"));
        this.t.addItem(Messages.getString("CustomerForm.6"));
        this.t.setPreferredSize(PosUIManager.getSize(100, 0));
        JLabel jLabel2 = new JLabel(Messages.getString("CustomerForm.3"));
        this.a = new FixedLengthTextField(30);
        JLabel jLabel3 = new JLabel(Messages.getString("CustomerForm.11"));
        this.b = new FixedLengthTextField();
        JLabel jLabel4 = new JLabel(Messages.getString("CustomerForm.14"));
        this.A = new AutoCompletionComboBox((Object[])MonthOfYear.values());
        this.A.setSelectedIndex(-1);
        this.B = new AutoCompletionComboBox();
        List<Integer> list = POSUtil.getDayList();
        this.B.setModel((ComboBoxModel)new ListComboBoxModel(list));
        this.B.setSelectedIndex(-1);
        this.C = new AutoCompletionComboBox();
        List<Integer> list2 = POSUtil.getYearList(1900);
        this.C.setModel((ComboBoxModel)new ListComboBoxModel(list2));
        this.C.setSelectedIndex(-1);
        JLabel jLabel5 = new JLabel(Messages.getString("CustomerForm.16"));
        this.c = new FixedLengthTextField(30);
        JLabel jLabel6 = new JLabel(Messages.getString("CustomerForm.17"));
        this.d = new FixedLengthTextField();
        JLabel jLabel7 = new JLabel(Messages.getString("CustomerForm.8"));
        this.y = new FixedLengthTextField();
        JLabel jLabel8 = new JLabel(Messages.getString("CustomerForm.19"));
        this.g = new FixedLengthTextField();
        JButton jButton = new JButton(Messages.getString("CustomerForm.13"));
        jButton.addActionListener(actionEvent -> this.e());
        JLabel jLabel9 = new JLabel(Messages.getString("CustomerForm.20"));
        this.h = new IntegerTextField();
        this.h.setEditable(false);
        JLabel jLabel10 = new JLabel(Messages.getString("CustomerForm.23"));
        this.i = new DoubleTextField();
        this.i.setText("500.00");
        JLabel jLabel11 = new JLabel(Messages.getString("Balance"));
        this.j = new DoubleTextField();
        this.z = new JPanel((LayoutManager)new MigLayout("fillx", "[]", ""));
        this.z.add((Component)this.C, "grow");
        this.z.add((Component)this.A, "grow");
        this.z.add((Component)this.B, "grow");
        jPanel.add((Component)jLabel, "right");
        jPanel.add((Component)this.t, "wrap,grow");
        jPanel.add((Component)jLabel2, "right");
        jPanel.add((Component)this.a, "wrap,grow");
        jPanel.add((Component)jLabel3, "right");
        jPanel.add((Component)this.b, "wrap,grow");
        jPanel.add((Component)jLabel4, "right");
        jPanel.add((Component)this.z, "wrap,grow");
        jPanel.add((Component)jLabel5, "right");
        jPanel.add((Component)this.c, "wrap,grow");
        jPanel.add((Component)jLabel6, "right");
        jPanel.add((Component)this.d, "wrap,grow");
        jPanel.add((Component)jLabel7, "right");
        jPanel.add((Component)this.y, "wrap,grow");
        jPanel.add((Component)jLabel8, "right");
        jPanel.add((Component)this.g, "grow");
        jPanel.add((Component)jButton, "wrap");
        jPanel.add((Component)jLabel9, "right");
        jPanel.add((Component)this.h, "wrap,grow");
        jPanel.add((Component)jLabel10, "right");
        jPanel.add((Component)this.i, "wrap,grow");
        jPanel.add((Component)jLabel11, "right");
        jPanel.add((Component)this.j, "grow");
        this.A.addActionListener(actionEvent -> this.d());
        this.C.addActionListener(actionEvent -> this.d());
        return jPanel;
    }

    private void d() {
        int n = this.A.getSelectedIndex();
        int n2 = this.C.getSelectedIndex();
        List<Integer> list = POSUtil.getDayList(n, n2);
        this.B.setModel((ComboBoxModel)new ListComboBoxModel(list));
        this.B.setSelectedIndex(-1);
    }

    private void e() {
        try {
            GeneratePasswordUtil generatePasswordUtil = new GeneratePasswordUtil();
            this.g.setText(generatePasswordUtil.createRandPass("16"));
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage());
        }
    }

    private JPanel f() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fillx", "[][grow]"));
        JLabel jLabel = new JLabel(Messages.getString("CustomerForm.51"));
        this.e = new JTextArea();
        this.e.setRows(3);
        this.e.setLineWrap(true);
        JScrollPane jScrollPane = new JScrollPane(this.e);
        JLabel jLabel2 = new JLabel(Messages.getString("CustomerForm.55"));
        this.f = new FixedLengthTextField();
        this.f.setColumns(30);
        this.f.setLength(10);
        JLabel jLabel3 = new JLabel(Messages.getString("CustomerForm.56"));
        this.l = new AutoCompletionComboBox();
        this.l.setStrict(false);
        this.l.setModel(new DefaultComboBoxModel<Object>(this.k.getCountryNames().toArray()));
        JLabel jLabel4 = new JLabel(Messages.getString("CustomerForm.53"));
        this.m = new AutoCompletionComboBox();
        this.m.setStrict(false);
        JLabel jLabel5 = new JLabel(Messages.getString("CustomerForm.52"));
        this.n = new AutoCompletionComboBox();
        this.n.setStrict(false);
        this.o = new JCheckBox(Messages.getString("CustomerForm.58"));
        this.o.setFocusable(false);
        this.p = new JCheckBox(Messages.getString("CustomerForm.59"));
        jPanel.add((Component)jLabel, "right");
        jPanel.add((Component)jScrollPane, "wrap, span 0 1, grow");
        jPanel.add((Component)jLabel3, "right");
        jPanel.add((Component)this.l, "wrap");
        jPanel.add((Component)jLabel4, "right");
        jPanel.add((Component)this.m, "wrap");
        jPanel.add((Component)jLabel5, "right");
        jPanel.add((Component)this.n, "wrap");
        jPanel.add((Component)jLabel2, "right");
        jPanel.add((Component)this.f, "wrap");
        jPanel.add((Component)this.o, "skip 1,wrap");
        jPanel.add((Component)this.p, "skip 1");
        this.l.addActionListener(actionEvent -> this.h());
        this.m.addActionListener(actionEvent -> this.i());
        return jPanel;
    }

    public void callOrderController() {
        Vector<Component> vector = new Vector<Component>();
        vector.add(this.a);
        vector.add(this.b);
        vector.add((Component)this.C);
        vector.add((Component)this.A);
        vector.add((Component)this.B);
        vector.add(this.c);
        vector.add(this.d);
        vector.add(this.y);
        vector.add(this.g);
        vector.add(this.h);
        vector.add(this.i);
        vector.add(this.j);
        vector.add(this.e);
        vector.add((Component)this.l);
        vector.add((Component)this.m);
        vector.add((Component)this.n);
        vector.add(this.f);
        this.w = new MyOwnFocusTraversalPolicy(vector);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(this.w);
    }

    public void enableCustomerFields(boolean bl) {
        this.t.setEnabled(bl);
        this.b.setEnabled(bl);
        this.a.setEnabled(bl);
        this.z.setEnabled(bl);
        this.c.setEnabled(bl);
        this.d.setEnabled(bl);
        this.y.setEnabled(bl);
        this.e.setEnabled(bl);
        this.l.setEnabled(bl);
        this.m.setEditable(bl);
        this.n.setEnabled(bl);
        this.f.setEnabled(bl);
        this.g.setEnabled(bl);
        this.h.setEnabled(bl);
        this.i.setEnabled(bl);
        this.j.setEnabled(bl);
        this.o.setEnabled(bl);
        this.p.setEnabled(bl);
        this.s.setEnabled(bl);
        this.r.setEnabled(bl);
    }

    @Override
    public void setFieldsEnable(boolean bl) {
        this.t.setEnabled(bl);
        this.a.setEnabled(bl);
        this.b.setEnabled(bl);
        this.d.setEnabled(bl);
        this.y.setEnabled(bl);
        this.g.setEnabled(bl);
        this.e.setEnabled(bl);
        this.l.setEnabled(bl);
        this.n.setEnabled(bl);
        this.i.setEnabled(bl);
        this.f.setEnabled(bl);
        this.o.setEnabled(bl);
        this.p.setEnabled(bl);
        this.z.setEnabled(bl);
        this.j.setEnabled(bl);
        this.s.setEnabled(bl);
        this.r.setEnabled(bl);
        this.h.setEnabled(bl);
        this.c.setEnabled(bl);
    }

    public void setFieldsEditable(boolean bl) {
        this.t.setEditable(bl);
        this.a.setEditable(bl);
        this.b.setEditable(bl);
        this.d.setEditable(bl);
        this.y.setEditable(bl);
        this.g.setEditable(bl);
        this.e.setEditable(bl);
        this.l.setEditable(bl);
        this.n.setEditable(bl);
        this.i.setEditable(bl);
        this.f.setEditable(bl);
        this.o.setEnabled(bl);
        this.p.setEnabled(bl);
        this.j.setEditable(bl);
        this.s.setEnabled(bl);
        this.r.setEnabled(bl);
        this.h.setEditable(bl);
        this.c.setEditable(bl);
    }

    @Override
    public void createNew() {
        this.setBean(new Customer());
        this.a.setText("");
        this.b.setText("");
        this.t.setSelectedIndex(0);
        this.e.setText("");
        this.i.setText("");
        this.d.setText("");
        this.y.setText("");
        this.g.setText("");
        this.h.setText("");
        this.j.setText("");
        this.f.setText("");
        this.o.setSelected(false);
        this.p.setSelected(false);
        this.c.setText("");
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            Customer customer = (Customer)this.getBean();
            CustomerDAO.getInstance().saveOrUpdate(customer);
            this.updateView();
            return true;
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (IllegalModelStateException illegalModelStateException) {
        }
        catch (StaleObjectStateException staleObjectStateException) {
            BOMessageDialog.showError(this, Messages.getString("CustomerForm.47"));
        }
        return false;
    }

    @Override
    protected void updateView() {
        Customer customer = (Customer)this.getBean();
        if (customer == null) {
            return;
        }
        this.t.setSelectedItem(customer.getSalutation());
        this.a.setText(customer.getFirstName());
        this.b.setText(customer.getLastName());
        this.a(customer);
        this.e.setText(customer.getAddress());
        this.l.setSelectedItem((Object)customer.getCountry());
        this.m.setSelectedItem((Object)customer.getState());
        this.n.setSelectedItem((Object)customer.getCity());
        this.i.setText(NumberUtil.formatNumber(customer.getCreditLimit()));
        this.d.setText(customer.getEmail());
        this.y.setText(customer.getEmail2());
        this.g.setText(customer.getLoyaltyNo());
        this.h.setText(customer.getLoyaltyPoint().toString());
        this.j.setText(String.valueOf(NumberUtil.formatNumber(customer.getBalance())));
        this.f.setText(customer.getZipCode());
        this.o.setSelected(customer.isVip());
        this.p.setSelected(customer.isTaxExempt());
        this.c.setText(customer.getMobileNo());
        if (customer.getSsn() != null) {
            // empty if block
        }
        this.v = ImageResourceDAO.getInstance().findById(customer.getImageId());
        if (this.v != null) {
            this.q.setIcon(new ImageIcon(this.v.getImage().getScaledInstance(200, 200, 1)));
        } else {
            this.q.setIcon(new ImageIcon(this.x.getScaledInstance(200, 200, 1)));
        }
    }

    protected void doSelectImageFile() {
        ImageGalleryDialog imageGalleryDialog = ImageGalleryDialog.getInstance();
        imageGalleryDialog.setTitle(Messages.getString("CustomerForm.1"));
        imageGalleryDialog.setSelectBtnVisible(true);
        imageGalleryDialog.setSize(PosUIManager.getSize(650, 600));
        imageGalleryDialog.setResizable(false);
        imageGalleryDialog.open();
        if (imageGalleryDialog.isCanceled()) {
            return;
        }
        this.v = imageGalleryDialog.getImageResource();
        if (this.v != null) {
            this.q.setIcon(new ImageIcon(this.v.getImage().getScaledInstance(200, 200, 1)));
        }
    }

    protected void doClearImage() {
        this.q.setIcon(new ImageIcon(this.x.getScaledInstance(200, 200, 1)));
        this.v = null;
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        Object object;
        String string;
        String string2 = this.d.getText();
        String string3 = this.y.getText();
        String string4 = this.a.getText();
        String string5 = this.b.getText();
        String string6 = this.c.getText();
        String string7 = this.l.getSelectedItem() == null ? "" : this.l.getSelectedItem().toString();
        String string8 = this.m.getSelectedItem() == null ? "" : this.m.getSelectedItem().toString();
        String string9 = string = this.n.getSelectedItem() == null ? "" : this.n.getSelectedItem().toString();
        if (StringUtils.isBlank((String)string4)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CustomerForm.7"));
            return false;
        }
        Date date = this.g();
        if (date != null && date.compareTo(new Date()) > 0) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CustomerForm.15"));
            return false;
        }
        if (StringUtils.isNotEmpty((String)string2) && !this.a(string2)) {
            return false;
        }
        if (StringUtils.isNotEmpty((String)string3) && !this.a(string3)) {
            return false;
        }
        if (StringUtils.isNotBlank((String)string6) && !POSUtil.validatePhoneNo(string6)) {
            POSMessageDialog.showError(this, Messages.getString("QuickCustomerForm.10"));
            return false;
        }
        Customer customer = (Customer)this.getBean();
        if (customer == null) {
            customer = new Customer();
            this.setBean(customer, false);
        }
        if ((object = this.t.getSelectedItem()) != null) {
            customer.setSalutation(object.toString());
        }
        customer.setFirstName(string4);
        customer.setLastName(string5);
        customer.setDob(date != null ? DateUtil.formatAsGiftCardDateFormat(date) : null);
        if (StringUtils.isNotBlank((String)this.e.getText())) {
            customer.setAddress(this.e.getText().trim());
        }
        customer.setCountry(string7);
        customer.setState(string8);
        customer.setCity(string);
        customer.setCreditLimit(PosGuiUtil.parseDouble(this.i));
        customer.setEmail(string2);
        customer.setEmail2(this.y.getText());
        customer.setLoyaltyNo(this.g.getText());
        customer.setLoyaltyPoint(this.h.getInteger());
        customer.setZipCode(this.f.getText());
        customer.setVip(this.o.isSelected());
        customer.setTaxExempt(this.p.isSelected());
        customer.setMobileNo(string6);
        customer.setBalance(PosGuiUtil.parseDouble(this.j));
        if (this.v != null) {
            customer.setImageId(this.v.getId());
        } else {
            customer.setImageId("");
        }
        return true;
    }

    private Date g() {
        if (this.A.getSelectedItem() == null || this.B.getSelectedItem() == null || this.C.getSelectedItem() == null) {
            return null;
        }
        MonthOfYear monthOfYear = (MonthOfYear)((Object)this.A.getSelectedItem());
        int n = (Integer)this.B.getSelectedItem();
        int n2 = (Integer)this.C.getSelectedItem();
        return POSUtil.createDate(n, monthOfYear.getValue(), n2);
    }

    private void a(Customer customer) {
        String string = customer.getDob();
        if (string == null) {
            return;
        }
        try {
            Date date = DateUtil.parseByGiftCardDateFormat(string);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            int n = calendar.get(2);
            int n2 = calendar.get(5);
            int n3 = calendar.get(1);
            this.A.setSelectedItem((Object)MonthOfYear.getMonthOfYear(n + 1));
            this.C.setSelectedItem((Object)n3);
            this.B.setSelectedItem((Object)n2);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    private boolean a(String string) {
        boolean bl = EmailValidator.getInstance().isValid(string);
        if (!bl) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CustomerForm.9"));
            return false;
        }
        return bl;
    }

    @Override
    public boolean delete() {
        try {
            Customer customer = (Customer)this.getBean();
            if (customer == null) {
                return false;
            }
            int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), "Are you sure to delete selected table?", "Confirm");
            if (n != 0) {
                return false;
            }
            CustomerDAO.getInstance().delete(customer);
            return true;
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), exception.getMessage(), exception);
            return false;
        }
    }

    @Override
    public String getDisplayText() {
        if (this.getBean() == null) {
            return Messages.getString("CustomerForm.54");
        }
        return Messages.getString("CustomerForm.12");
    }

    public void setMobileNo(String string) {
        this.c.setText(string);
    }

    private void h() {
        try {
            this.m.setEnabled(true);
            this.n.setEnabled(false);
            String string = (String)this.l.getSelectedItem();
            List<String> list = this.k.getStateNames(string);
            this.m.removeAllItems();
            this.n.removeAllItems();
            this.m.addItem(null);
            for (String string2 : list) {
                this.m.addItem((Object)string2);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    private void i() {
        try {
            this.n.setEnabled(true);
            String string = (String)this.l.getSelectedItem();
            String string2 = (String)this.m.getSelectedItem();
            List<String> list = this.k.getCityNames(string, string2);
            this.n.removeAllItems();
            this.n.addItem(null);
            for (String string3 : list) {
                this.n.addItem((Object)string3);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    public static class MyOwnFocusTraversalPolicy
    extends FocusTraversalPolicy {
        Vector<Component> a;

        public MyOwnFocusTraversalPolicy(Vector<Component> vector) {
            this.a = new Vector(vector.size());
            this.a.addAll(vector);
        }

        @Override
        public Component getComponentAfter(Container container, Component component) {
            int n = (this.a.indexOf(component) + 1) % this.a.size();
            return this.a.get(n);
        }

        @Override
        public Component getComponentBefore(Container container, Component component) {
            int n = this.a.indexOf(component) - 1;
            if (n < 0) {
                n = this.a.size() - 1;
            }
            return this.a.get(n);
        }

        @Override
        public Component getDefaultComponent(Container container) {
            return this.a.get(0);
        }

        @Override
        public Component getLastComponent(Container container) {
            return this.a.lastElement();
        }

        @Override
        public Component getFirstComponent(Container container) {
            return this.a.get(0);
        }
    }
}

