/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.forms;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.Store;
import com.floreantpos.model.User;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.ImageResourceDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.dao.UserTypeDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthDocument;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.ImageGalleryDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.forms.GeneratePasswordDialog;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.routines.EmailValidator;

public class UserForm
extends BeanEditor {
    private FixedLengthTextField a;
    private FixedLengthTextField b;
    private FixedLengthTextField c;
    private JPasswordField d;
    private FixedLengthTextField e;
    private FixedLengthTextField f;
    private POSTextField g;
    private JComboBox h;
    private JLabel i;
    private DoubleTextField j;
    private JCheckBox k;
    private JCheckBox l;
    private JCheckBox m;
    private JCheckBox n;
    private JCheckBox o;
    private ImageResource p;
    private JCheckBox q;
    private boolean r;
    private DoubleTextField s;

    public UserForm() {
        this.a();
        UserTypeDAO userTypeDAO = new UserTypeDAO();
        List<UserType> list = userTypeDAO.findAll();
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(list.toArray());
        defaultComboBoxModel.insertElementAt(null, 0);
        this.h.setModel(defaultComboBoxModel);
    }

    private ComboBoxModel a(List list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("");
        arrayList.addAll(list);
        return new ComboBoxModel(arrayList);
    }

    private void a() {
        this.setLayout((LayoutManager)new MigLayout("hidemode 3", "[134px][204px,grow][][]", ""));
        JLabel jLabel = new JLabel(Messages.getString("UserForm.31"));
        JLabel jLabel2 = new JLabel(Messages.getString("UserForm.28"));
        JLabel jLabel3 = new JLabel(Messages.getString("UserForm.7"));
        JLabel jLabel4 = new JLabel(Messages.getString("UserForm.4"));
        JLabel jLabel5 = new JLabel(Messages.getString("UserForm.14"));
        JLabel jLabel6 = new JLabel(Messages.getString("UserForm.16"));
        JLabel jLabel7 = new JLabel(Messages.getString("UserForm.18"));
        JLabel jLabel8 = new JLabel(Messages.getString("UserForm.9"));
        JLabel jLabel9 = new JLabel(Messages.getString("Email"));
        this.f = new FixedLengthTextField();
        this.f.setLength(20);
        this.f.setColumns(20);
        this.g = new POSTextField();
        this.d = new JPasswordField(new FixedLengthDocument(16), "", 10);
        this.d.setEditable(false);
        this.b = new FixedLengthTextField(128);
        this.e = new FixedLengthTextField();
        this.e.setLength(30);
        this.e.setColumns(30);
        this.a = new FixedLengthTextField();
        this.a.setColumns(30);
        this.a.setLength(30);
        this.c = new FixedLengthTextField();
        this.c.setLength(30);
        this.c.setColumns(30);
        this.j = new DoubleTextField();
        this.s = new DoubleTextField();
        this.h = new JComboBox();
        this.i = new JLabel("");
        this.i.setHorizontalAlignment(0);
        this.i.setBorder(BorderFactory.createTitledBorder(null, Messages.getString("UserForm.5"), 2, 2));
        this.i.setPreferredSize(new Dimension(150, 160));
        JButton jButton = new JButton(Messages.getString("UserForm.6"));
        JButton jButton2 = new JButton(Messages.getString("UserForm.2"));
        JButton jButton3 = new JButton(Messages.getString("MenuItemForm.34"));
        jButton3.setHorizontalAlignment(11);
        jButton.addActionListener(actionEvent -> this.b());
        jButton2.addActionListener(actionEvent -> this.doSelectImageFile());
        jButton3.addActionListener(actionEvent -> this.doClearImage());
        this.add((Component)jLabel3, "cell 1 0 ,alignx trailing,aligny center");
        this.add((Component)this.b, "cell 2 0");
        this.add((Component)jLabel8, "cell 1 1,alignx trailing");
        this.add((Component)this.f, "cell 2 1,growx,aligny center");
        this.add((Component)jLabel4, "cell 1 2,alignx trailing,aligny center");
        this.add((Component)this.e, "cell 2 2,growx,aligny center");
        this.add((Component)jLabel5, "cell 1 3,alignx trailing,aligny center");
        this.add((Component)this.a, "cell 2 3,growx,aligny center");
        this.add((Component)jLabel6, "cell 1 4, alignx trailing,aligny center");
        this.add((Component)this.c, "cell 2 4,growx,aligny center");
        this.add((Component)jLabel9, "cell 1 5,alignx trailing");
        this.add((Component)this.g, "cell 2 5,growx,aligny center");
        this.add((Component)jLabel7, "cell 1 6,alignx trailing,aligny center");
        this.add((Component)this.d, "cell 2 6,growx,aligny center");
        this.add((Component)jLabel2, "cell 1 7,alignx trailing,aligny center");
        this.add((Component)this.j, "cell 2 7,growx,aligny center");
        this.add((Component)new JLabel(Messages.getString("UserForm.3")), "cell 1 8,gapleft 80,alignx trailing,aligny center");
        this.add((Component)this.s, "cell 2 8,growx,aligny center");
        this.add((Component)jLabel, "cell 1 9,alignx trailing,aligny center");
        this.h.setModel(new DefaultComboBoxModel<String>(new String[]{Messages.getString("UserForm.33"), Messages.getString("UserForm.34"), Messages.getString("UserForm.35")}));
        this.add((Component)this.h, "cell 2 9,growx,aligny center");
        this.k = new JCheckBox(Messages.getString("UserForm.0"));
        this.l = new JCheckBox(Messages.getString("UserForm.10"));
        this.m = new JCheckBox(Messages.getString("UserForm.12"));
        this.n = new JCheckBox(Messages.getString("UserForm.15"));
        this.o = new JCheckBox(Messages.getString("UserForm.19"));
        this.l.addActionListener(actionEvent -> {
            this.m.setEnabled(this.l.isSelected());
            this.o.setEnabled(this.l.isSelected());
        });
        this.m.setEnabled(this.l.isSelected());
        this.o.setEnabled(this.l.isSelected());
        this.add((Component)this.k, "cell 2 11");
        this.add((Component)this.l, "cell 2 12");
        this.add((Component)this.m, "cell 2 13");
        this.add((Component)this.o, "cell 2 14");
        this.add((Component)this.n, "cell 2 15");
        this.q = new JCheckBox(Messages.getString("ACTIVE"));
        this.add((Component)this.q, "cell 2 16");
        this.add((Component)this.i, "cell 0 0 8 8,growy");
        this.add((Component)jButton2, "cell 0 8 ,center");
        this.add((Component)jButton3, "cell 0 8 ,center");
        this.add((Component)jButton, "cell 3 5 ,center");
    }

    @Override
    public String getDisplayText() {
        if (this.isEditMode()) {
            return Messages.getString("UserForm.37");
        }
        return Messages.getString("UserForm.38");
    }

    @Override
    public boolean save() {
        try {
            this.updateModel();
        }
        catch (IllegalModelStateException illegalModelStateException) {
            POSMessageDialog.showError(this, illegalModelStateException.getMessage());
            return false;
        }
        User user = (User)this.getBean();
        UserDAO userDAO = UserDAO.getInstance();
        if (!this.r && userDAO.isUserExist(user.getId())) {
            POSMessageDialog.showError(this, Messages.getString("UserForm.39") + user.getId() + " " + Messages.getString("UserForm.1"));
            return false;
        }
        try {
            userDAO.saveOrUpdate(user, this.r);
            this.a(user);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(this, posException.getMessage(), posException);
            PosLog.error(this.getClass(), posException);
            return false;
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, Messages.getString("UserForm.41"), exception);
            PosLog.error(this.getClass(), exception);
            return false;
        }
        return true;
    }

    private void a(User user) {
        if (this.r) {
            String string = String.format("User %s updated.", user.getId());
            ActionHistoryDAO.saveHistory("user modified", string);
        } else {
            String string = String.format("User %s created.", user.getId());
            ActionHistoryDAO.saveHistory("user created", string);
        }
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        List<User> list;
        User user = null;
        user = !(this.getBean() instanceof User) ? new User() : (User)this.getBean();
        String string = this.f.getText();
        String string2 = this.b.getText();
        String string3 = this.e.getText();
        String string4 = this.a.getText();
        String string5 = this.c.getText();
        String string6 = new String(this.d.getPassword());
        double d = this.j.getDoubleOrZero();
        double d2 = this.s.getDoubleOrZero();
        if (StringUtils.isNotBlank((String)string) && !POSUtil.validatePhoneNo(string)) {
            throw new IllegalModelStateException(Messages.getString("QuickCustomerForm.10"));
        }
        if (POSUtil.isBlankOrNull(string2)) {
            throw new IllegalModelStateException(Messages.getString("UserForm.50"));
        }
        if (POSUtil.isBlankOrNull(string4)) {
            throw new IllegalModelStateException(Messages.getString("UserForm.43"));
        }
        String string7 = this.g.getText();
        if (StringUtils.isNotEmpty((String)string7) && !EmailValidator.getInstance().isValid(string7)) {
            throw new IllegalModelStateException(Messages.getString("CustomerForm.9"));
        }
        if (POSUtil.isBlankOrNull(string6)) {
            throw new IllegalModelStateException(Messages.getString("UserForm.45"));
        }
        User user2 = UserDAO.getInstance().findUserBySecretKey(string6);
        if (user2 != null && !user2.equals(user)) {
            throw new IllegalModelStateException(Messages.getString("UserForm.48"));
        }
        if (d < 0.0) {
            this.j.requestFocus();
            this.j.selectAll();
            throw new IllegalModelStateException(POSConstants.NEGATIVE_AMOUNT_NOT_ALLOWED);
        }
        if (d2 < 0.0) {
            this.s.requestFocus();
            this.s.selectAll();
            throw new IllegalModelStateException(POSConstants.NEGATIVE_AMOUNT_NOT_ALLOWED);
        }
        UserType userType = (UserType)this.h.getSelectedItem();
        if (userType != null) {
            list = user.getLinkedUser();
            if (list == null || list.isEmpty()) {
                list = new ArrayList<User>();
                user.setParentUser(user);
                user.setRoot(true);
            }
            for (User user3 : list) {
                if (user3.isDeleted().booleanValue()) continue;
                if (user.getType() != null && user.getType().getId().equals(userType.getId())) break;
                if (user3.getType() == null || !user3.getType().getName().equals(userType.getName())) continue;
                throw new IllegalModelStateException(Messages.getString("UserRoleForm.13"));
            }
        }
        if (d2 == 0.0) {
            d2 = d;
        }
        user.setOutletId(DataProvider.get().getCurrentOutletId());
        list = DataProvider.get().getStore();
        double d3 = ((Store)((Object)list)).getOvertimeMarkup();
        if (d > 0.0 && d3 > 0.0 && d2 == 0.0) {
            d2 = d + d * (d3 / 100.0);
        }
        user.setType(userType);
        user.setRoot(true);
        user.setCostPerHour(d);
        user.setSsn(string3);
        user.setId(string2);
        user.setFirstName(string4);
        user.setLastName(string5);
        user.setEmail(string7);
        user.setPhoneNo(string);
        user.setEncryptedPassword(string6);
        user.setDriver(this.k.isSelected());
        user.setStaffBank(this.l.isSelected());
        user.setActive(this.q.isSelected());
        user.setOvertimeRatePerHour(d2);
        user.setAllowReceiveTips(this.n.isSelected());
        if (this.l.isSelected()) {
            user.setAutoStartStaffBank(this.m.isSelected());
            user.setBlindAccountableAmount(this.o.isSelected());
        } else {
            user.setAutoStartStaffBank(false);
            user.setBlindAccountableAmount(false);
        }
        if (this.p != null) {
            user.setImageId(this.p.getId());
        } else {
            user.setImageId(null);
        }
        this.setBean(user);
        return true;
    }

    @Override
    protected void updateView() {
        if (!(this.getBean() instanceof User)) {
            return;
        }
        User user = (User)this.getBean();
        this.b(user);
    }

    private void b(User user) {
        if (user.getId() != null) {
            this.b.setText(String.valueOf(user.getId()));
        } else {
            this.b.setText("");
        }
        if (user.getSsn() != null) {
            this.e.setText(user.getSsn());
        } else {
            this.e.setText("");
        }
        this.a.setText(user.getFirstName());
        this.c.setText(user.getLastName());
        this.g.setText(user.getEmail());
        this.d.setText(user.getPasswordAsPlainText());
        this.f.setText(user.getPhoneNo());
        this.h.setSelectedItem(user.getType());
        Double d = user.getCostPerHour();
        if (d == null) {
            d = 0.0;
        }
        this.j.setText(NumberUtil.formatAmount(d));
        this.k.setSelected(user.isDriver());
        this.l.setSelected(user.isStaffBank());
        this.m.setSelected(user.isAutoStartStaffBank());
        this.o.setSelected(user.isBlindAccountableAmount());
        this.q.setSelected(user.isActive());
        this.n.setSelected(user.isAllowReceiveTips());
        this.p = ImageResourceDAO.getInstance().findById(user.getImageId());
        if (this.p != null) {
            this.i.setIcon(this.p.getButtonBigImage());
        }
        this.m.setEnabled(this.l.isSelected());
        this.o.setEnabled(this.l.isSelected());
        if (user.getOvertimeRatePerHour() != null) {
            this.s.setText(NumberUtil.formatAmount(user.getOvertimeRatePerHour()));
        }
    }

    public boolean isEditMode() {
        return this.r;
    }

    public void setEditMode(boolean bl) {
        this.r = bl;
        if (bl) {
            this.b.setEditable(false);
        } else {
            this.b.setEditable(true);
        }
    }

    public void setId(Integer n) {
        if (n != null) {
            this.b.setText(String.valueOf(n));
        }
    }

    protected void doSelectImageFile() {
        ImageGalleryDialog imageGalleryDialog = ImageGalleryDialog.getInstance();
        imageGalleryDialog.setSelectBtnVisible(true);
        imageGalleryDialog.setTitle(Messages.getString("UserForm.17"));
        imageGalleryDialog.setSize(PosUIManager.getSize(650, 600));
        imageGalleryDialog.setResizable(false);
        imageGalleryDialog.open();
        if (imageGalleryDialog.isCanceled()) {
            return;
        }
        this.p = imageGalleryDialog.getImageResource();
        if (this.p != null) {
            this.i.setIcon(this.p.getButtonBigImage());
        }
    }

    protected void doClearImage() {
        this.i.setIcon(null);
        this.p = null;
    }

    private void b() {
        boolean bl = false;
        BackOfficeWindow backOfficeWindow = BackOfficeWindow.getInstance();
        User user = null;
        if (backOfficeWindow != null) {
            user = backOfficeWindow.getCurrentUser();
        }
        if (user != null && user.isAdministrator()) {
            bl = true;
        }
        GeneratePasswordDialog generatePasswordDialog = new GeneratePasswordDialog(bl);
        generatePasswordDialog.setSize(530, 340);
        generatePasswordDialog.open();
        if (generatePasswordDialog.isCanceled()) {
            return;
        }
        this.d.setText(generatePasswordDialog.getGenPassword());
    }
}

