/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.menuitem.variant;

import com.floreantpos.Messages;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.InventoryVendorItems;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.Recepie;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.dao.ImageResourceDAO;
import com.floreantpos.model.dao.InventoryVendorItemsDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.swing.IUpdatebleView;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.menuitem.ButtonStylePanel;
import com.floreantpos.ui.menuitem.InventoryPanel;
import com.floreantpos.ui.menuitem.OrderTypeBaseTaxPanel;
import com.floreantpos.ui.menuitem.VariantGeneralPanel;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.hibernate.StaleStateException;

public class VariantForm
extends BeanEditor<MenuItem>
implements RefreshableView,
ChangeListener {
    private ButtonStylePanel a;
    private InventoryPanel b;
    private VariantGeneralPanel c;
    private OrderTypeBaseTaxPanel d;
    private JTabbedPane e;

    public VariantForm(MenuItem menuItem) {
        this.a(menuItem);
        this.setBean(menuItem);
    }

    private void a(MenuItem menuItem) {
        this.setLayout(new BorderLayout());
        this.e = new JTabbedPane();
        this.a = new ButtonStylePanel();
        this.a.setSortOrderVisibility(true);
        this.b = new InventoryPanel(menuItem);
        this.c = new VariantGeneralPanel(menuItem);
        this.d = new OrderTypeBaseTaxPanel();
        List<TaxGroup> list = TaxGroupDAO.getInstance().findAll();
        this.d.setTaxGroups(list);
        this.e.addTab(Messages.getString("VariantForm.5"), this.c);
        this.e.addTab(Messages.getString("VariantForm.0"), this.a);
        this.e.addTab(Messages.getString("VariantForm.1"), this.b);
        this.e.addTab(Messages.getString("MenuItemForm.22"), this.d);
        this.add((Component)this.e, "Center");
        this.e.addChangeListener(this);
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            MenuItem menuItem = (MenuItem)this.getBean();
            MenuItemDAO menuItemDAO = new MenuItemDAO();
            if (menuItem.getId() == null) {
                menuItemDAO.save(menuItem);
            } else {
                menuItemDAO.saveOrUpdate(menuItem);
            }
            List<InventoryVendorItems> list = this.b.getVendorItems();
            InventoryVendorItemsDAO.getInstance().saveOrUpdateMenuItemVendors(menuItem, list);
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(this, this);
            return false;
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
            return false;
        }
        return true;
    }

    @Override
    protected void updateView() {
        Color color;
        MenuItem menuItem = (MenuItem)this.getBean();
        ImageResource imageResource = ImageResourceDAO.getInstance().findById(menuItem.getImageId());
        if (imageResource != null) {
            this.a.setImageResource(imageResource);
        }
        if ((color = menuItem.getButtonColor()) != null) {
            this.a.setButtonColor(color);
            this.a.setTextColor(color);
        }
        if (menuItem.getTextColor() != null) {
            this.a.setTextForegroundColor(menuItem.getTextColor());
        }
        this.a.setSortOrder(menuItem.getSortOrder());
        this.c.setUnit(menuItem.getUnit());
        this.c.setExtraPrice(menuItem.getPrice());
        Double d = menuItem.getCost();
        if (d == 0.0) {
            d = menuItem.getParentMenuItem().getCost();
        }
        this.c.setCost(d);
        TaxGroup taxGroup = menuItem.getTaxGroup();
        if (menuItem.isVariant().booleanValue() && taxGroup == null) {
            taxGroup = menuItem.getParentMenuItem().getTaxGroup();
        }
        this.c.setTaxGroup(taxGroup);
        this.c.setDisplayName(menuItem.getDisplayName());
        this.c.setDescription(menuItem.getDescription());
        this.c.setRecipe(menuItem.getDefaultRecipeId());
        this.b.setSku(menuItem.getSku());
        this.b.setReOrderLevel(menuItem.getReorderLevel());
        this.b.setReplenishLevel(menuItem.getReplenishLevel());
        this.b.setCbDisableStockCount(menuItem.isDisableWhenStockAmountIsZero());
    }

    @Override
    public boolean updateModel() {
        MenuItem menuItem = (MenuItem)this.getBean();
        double d = this.c.getExtraPrice();
        if (d < 0.0) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("NegativePriceNotAllowed"));
            return false;
        }
        double d2 = this.c.getCost();
        if (d2 < 0.0) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("MenuItemForm.11"));
            return false;
        }
        menuItem.setReorderLevel(this.b.getReOrderLevel());
        menuItem.setReplenishLevel(this.b.getReplenishLevel());
        menuItem.setDisableWhenStockAmountIsZero(this.b.isCbDisableStockCount());
        menuItem.setShowImageOnly(this.a.isShowTextWithImage());
        menuItem.setUnit(this.c.getUnit());
        menuItem.setTaxGroup(this.c.getTaxGroup());
        menuItem.setTranslatedName(this.c.getDisplayName());
        menuItem.setDescription(this.c.getDescription());
        Recepie recepie = this.c.getRecipe();
        if (recepie instanceof Recepie) {
            String string = recepie.getId();
            menuItem.setDefaultRecipeId(string);
        } else {
            menuItem.setDefaultRecipeId(null);
        }
        menuItem.setPrice(d);
        menuItem.setCost(d2);
        menuItem.setButtonColor(this.a.getButtonColor());
        menuItem.setButtonColorCode(this.a.getButtonColorCode());
        menuItem.setTextColor(this.a.getTextColor());
        menuItem.setTextColorCode(this.a.getTextColorCode());
        menuItem.setImageId(this.a.getImageResourceId());
        menuItem.setSortOrder(this.a.getSortOrder());
        menuItem.setSku(this.b.getSku());
        int n = this.e.getTabCount();
        for (int i = 0; i < n; ++i) {
            IUpdatebleView iUpdatebleView;
            Component component = this.e.getComponent(i);
            if (!(component instanceof IUpdatebleView) || (iUpdatebleView = (IUpdatebleView)((Object)component)).updateModel(menuItem)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getDisplayText() {
        MenuItem menuItem = (MenuItem)this.getBean();
        return menuItem.getName() + " " + Messages.getString("VariantForm.3");
    }

    @Override
    public void refresh() {
        MenuItem menuItem = (MenuItem)this.getBean();
        MenuItem menuItem2 = MenuItemDAO.getInstance().get(menuItem.getId());
        this.setBean(menuItem2, false);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Component component = this.e.getSelectedComponent();
        if (!(component instanceof IUpdatebleView)) {
            return;
        }
        IUpdatebleView iUpdatebleView = (IUpdatebleView)((Object)component);
        MenuItem menuItem = (MenuItem)this.getBean();
        iUpdatebleView.initView(menuItem);
    }
}

