/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.DuplicateDataException;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.Department;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuShift;
import com.floreantpos.model.dao.DepartmentDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuShiftDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.swing.CheckBoxList;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.hibernate.StaleStateException;

public class MenuCategoryForm
extends BeanEditor
implements RefreshableView {
    private JCheckBox a;
    private CheckBoxList b;
    private CheckBoxList c;
    private CheckBoxList d;
    private JCheckBox e;
    private JCheckBox f;
    private JLabel g;
    private FixedLengthTextField h;
    private IntegerTextField i;
    private JButton j;
    private JLabel k;
    private JLabel l;
    private JLabel m;
    private FixedLengthTextField n;
    private JLabel o;
    private JButton p;

    public MenuCategoryForm() throws Exception {
        this(new MenuCategory());
    }

    public MenuCategoryForm(MenuCategory menuCategory) throws Exception {
        this.a();
        this.setBean(menuCategory);
    }

    @Override
    public String getDisplayText() {
        MenuCategory menuCategory = (MenuCategory)this.getBean();
        if (menuCategory.getId() == null) {
            return POSConstants.NEW_MENU_CATEGORY;
        }
        return POSConstants.EDIT_MENU_CATEGORY;
    }

    private void a() {
        this.g = new JLabel();
        this.f = new JCheckBox();
        this.h = new FixedLengthTextField();
        this.h.setLength(120);
        this.e = new JCheckBox();
        this.a = new JCheckBox("Ticket discount applicable");
        this.g.setText(POSConstants.NAME + ":");
        this.f.setText(POSConstants.VISIBLE);
        this.f.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.f.setMargin(new Insets(0, 0, 0, 0));
        this.e.setText(POSConstants.BEVERAGE);
        this.e.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.e.setMargin(new Insets(0, 0, 0, 0));
        this.k = new JLabel(Messages.getString("MenuCategoryForm.1"));
        this.i = new IntegerTextField();
        this.i.setColumns(10);
        this.l = new JLabel(Messages.getString("MenuCategoryForm.2"));
        this.j = new JButton();
        this.j.setPreferredSize(new Dimension(140, 40));
        this.b = new CheckBoxList();
        List<Department> list = DepartmentDAO.getInstance().findAll();
        this.b.setModel(list);
        TitledBorder titledBorder = new TitledBorder(Messages.getString("MenuCategoryForm.0"));
        JScrollPane jScrollPane = new JScrollPane(this.b);
        jScrollPane.setBorder(titledBorder);
        jScrollPane.setPreferredSize(new Dimension(228, 100));
        this.c = new CheckBoxList();
        this.c.setModel(OrderTypeDAO.getInstance().findAll());
        JScrollPane jScrollPane2 = new JScrollPane(this.c);
        jScrollPane2.setBorder(BorderFactory.createTitledBorder(Messages.getString("MenuCategoryForm.3")));
        jScrollPane2.setPreferredSize(new Dimension(228, 120));
        this.d = new CheckBoxList();
        List<MenuShift> list2 = MenuShiftDAO.getInstance().findAll();
        this.d.setModel(list2);
        TitledBorder titledBorder2 = new TitledBorder(Messages.getString("MenuCategoryForm.4"));
        JScrollPane jScrollPane3 = new JScrollPane(this.d);
        jScrollPane3.setBorder(titledBorder2);
        jScrollPane3.setPreferredSize(new Dimension(228, 100));
        this.m = new JLabel(Messages.getString("MenuCategoryForm.7"));
        this.n = new FixedLengthTextField();
        this.n.setLength(120);
        this.o = new JLabel(Messages.getString("MenuCategoryForm.5"));
        this.p = new JButton();
        this.p.setText(Messages.getString("MenuCategoryForm.16"));
        this.p.setPreferredSize(new Dimension(140, 40));
        this.setLayout(new GridLayout(1, 2));
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("hidemode 3", "", ""));
        jPanel.add((Component)this.g, "alignx left");
        jPanel.add((Component)this.h, "growx,aligny top");
        jPanel.add((Component)this.m, "newline");
        jPanel.add((Component)this.n, "growx");
        jPanel.add((Component)this.k, "newline,alignx left");
        jPanel.add((Component)this.i, "alignx left,aligny top");
        jPanel.add((Component)this.l, "newline,h 25!,alignx left,growy");
        jPanel.add((Component)this.j, "h 25!,alignx left,growy");
        jPanel.add((Component)this.o, "newline,h 25!");
        jPanel.add((Component)this.p, "h 25!,growy");
        jPanel.add((Component)this.a, "newline, skip 1");
        jPanel.add((Component)this.e, "newline,alignx left,growy, skip 1");
        jPanel.add((Component)this.f, "newline,alignx left,gapbottom 5, skip 1");
        this.add(jPanel);
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("fill"));
        jPanel2.add((Component)jScrollPane2, "grow");
        jPanel2.add((Component)jScrollPane3, "newline, grow");
        jPanel2.add((Component)jScrollPane, "newline, grow");
        this.add(jPanel2);
        this.j.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(POSUtil.getBackOfficeWindow(), Messages.getString("MenuCategoryForm.21"), MenuCategoryForm.this.j.getBackground());
                if (color != null) {
                    MenuCategoryForm.this.j.setBackground(color);
                    MenuCategoryForm.this.p.setBackground(color);
                }
            }
        });
        this.p.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(POSUtil.getBackOfficeWindow(), Messages.getString("MenuCategoryForm.22"), MenuCategoryForm.this.p.getForeground());
                if (color != null) {
                    MenuCategoryForm.this.p.setForeground(color);
                }
            }
        });
    }

    @Override
    protected void updateView() {
        Color color;
        MenuCategory menuCategory = (MenuCategory)this.getBean();
        MenuCategoryDAO.getInstance().initialize(menuCategory);
        if (menuCategory == null) {
            this.h.setText("");
            this.n.setText("");
            this.i.setText("0");
            this.f.setSelected(false);
            return;
        }
        this.h.setText(menuCategory.getName());
        this.n.setText(menuCategory.getTranslatedName());
        if (menuCategory.getSortOrder() != null) {
            this.i.setText(menuCategory.getSortOrder().toString());
        }
        if ((color = menuCategory.getButtonColor()) != null) {
            this.j.setBackground(color);
            this.p.setBackground(color);
        }
        if (menuCategory.getTextColor() != null) {
            this.p.setForeground(menuCategory.getTextColor());
        }
        this.a.setSelected(menuCategory.isTicketDiscountApplicable());
        this.e.setSelected(menuCategory.isBeverage());
        if (menuCategory.getId() == null) {
            this.f.setSelected(true);
        } else {
            this.f.setSelected(menuCategory.isVisible());
        }
        if (menuCategory.getDepartments() != null) {
            ArrayList<Department> arrayList = new ArrayList<Department>(menuCategory.getDepartments());
            this.b.selectItems(arrayList);
        }
        this.c.selectItems(menuCategory.getOrderTypes());
        this.d.selectItems(menuCategory.getMenuShifts());
    }

    @Override
    protected boolean updateModel() {
        String string;
        MenuCategory menuCategory;
        block4: {
            menuCategory = (MenuCategory)this.getBean();
            if (menuCategory == null) {
                return false;
            }
            string = this.h.getText();
            if (POSUtil.isBlankOrNull(string)) {
                MessageDialog.showError(Messages.getString("MenuCategoryForm.26"));
                return false;
            }
            try {
                GenericDAO.getInstance().checkIdOrNameExists(menuCategory.getId(), string, MenuCategory.class);
            }
            catch (DuplicateDataException duplicateDataException) {
                String string2 = String.format(Messages.getString("SAME_NAME_WARRING"), Messages.getString("DataImportAction.7"));
                String string3 = Messages.getString("WARNING");
                int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), string2, string3, Messages.getString("YES"), Messages.getString("NO"));
                if (n == 0) break block4;
                return false;
            }
        }
        menuCategory.setName(string);
        menuCategory.setTranslatedName(this.n.getText());
        menuCategory.setSortOrder(this.i.getInteger());
        menuCategory.setButtonColor(this.j.getBackground());
        menuCategory.setTextColor(this.p.getForeground());
        menuCategory.setButtonColorCode(this.j.getBackground().getRGB());
        menuCategory.setTextColorCode(this.p.getForeground().getRGB());
        menuCategory.setTicketDiscountApplicable(this.a.isSelected());
        menuCategory.setBeverage(this.e.isSelected());
        menuCategory.setVisible(this.f.isSelected());
        menuCategory.setOrderTypes(POSUtil.copySelectedValues(menuCategory.getOrderTypes(), this.c.getCheckedValuesAsSet()));
        menuCategory.setDepartments(POSUtil.copySelectedValues(menuCategory.getDepartments(), this.b.getCheckedValuesAsSet()));
        menuCategory.setMenuShifts(POSUtil.copySelectedValues(menuCategory.getMenuShifts(), this.d.getCheckedValuesAsSet()));
        return true;
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            MenuCategory menuCategory = (MenuCategory)this.getBean();
            MenuCategoryDAO.getInstance().saveOrUpdate(menuCategory);
            return true;
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(this, this);
            return false;
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
            return false;
        }
    }

    @Override
    public void refresh() {
        MenuCategory menuCategory = (MenuCategory)this.getBean();
        MenuCategory menuCategory2 = MenuCategoryDAO.getInstance().get(menuCategory.getId());
        this.setBean(menuCategory2);
    }
}

