/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.util.MenuSearchCriteria;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.OverflowCombobox;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.PaginatedTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosTable;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.MenuItemSelectionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MenuItemForm;
import com.floreantpos.ui.model.PizzaItemForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnExt;

public class MenuItemSelectionView
extends JPanel {
    private JComboBox a;
    private PosTable b;
    private MenuItemTableModel c;
    private POSTextField d;
    private MenuItem e;
    private JButton f;
    private JButton g;
    private MenuGroup h;
    private JLabel i = new JLabel();
    private JLabel j;
    private JButton k;
    private JPanel l;
    private Map<String, MenuItem> m = new HashMap<String, MenuItem>();
    private JCheckBox n;
    private JCheckBox o;
    private JLabel p;
    private boolean q;
    private boolean r = true;
    private boolean s = true;
    public static final int SINGLE_SELECTION = 0;
    public static final int MULTIPLE_SELECTION = 1;
    private MenuItemSelectionDialog t;
    private boolean u = true;
    private boolean v = true;

    public MenuItemSelectionView(List<MenuItem> list, boolean bl) {
        this(list, bl, null);
    }

    public MenuItemSelectionView(List<MenuItem> list, boolean bl, MenuItemSelectionDialog menuItemSelectionDialog) {
        this.q = bl;
        this.t = menuItemSelectionDialog;
        this.a();
        this.c.setCurrentRowIndex(0);
        this.a.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                MenuItemSelectionView.this.c.setCurrentRowIndex(0);
                MenuItemSelectionView.this.setSelectedMenuGroup(MenuItemSelectionView.this.a.getSelectedItem());
            }
        });
        this.setSelectedItems(list);
    }

    private void a() {
        this.setLayout(new BorderLayout(5, 5));
        this.c = new MenuItemTableModel();
        this.c.setColumnNames(new String[]{"-", Messages.getString("MenuItemSelectionView.1")});
        this.c.setPageSize(10);
        this.b = new PosTable();
        this.b.setModel(this.c);
        this.b.setRowHeight(PosUIManager.getSize(40));
        this.b.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    MenuItemSelectionView.this.i();
                } else {
                    MenuItemSelectionView.this.m();
                }
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(10, 5, 10, 5));
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.b));
        jScrollPane.setPreferredSize(PosUIManager.getSize(500, 250));
        jPanel.add(jScrollPane);
        jPanel.add((Component)this.c(), "North");
        this.add(jPanel);
        this.resizeColumnWidth((JTable)((Object)this.b));
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("ins 5 0 0 0,fillx", "[left,grow][][][]", ""));
        jPanel2.add((Component)this.f(), "left,split 2");
        this.n = new JCheckBox(Messages.getString("MenuItemSelectionView.7"));
        this.n.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuItemSelectionView.this.b();
            }
        });
        jPanel2.add(this.n);
        jPanel2.add((Component)this.i, "split 3,center");
        this.g = new JButton(Messages.getString("MenuItemSelectionView.8"));
        jPanel2.add((Component)this.g, "center");
        PosButton posButton = new PosButton();
        posButton.setBorder(null);
        posButton.setOpaque(false);
        posButton.setContentAreaFilled(false);
        posButton.setIcon(IconFactory.getIcon("/ui_icons/", "dot.png"));
        this.f = new JButton(Messages.getString("MenuItemSelectionView.11"));
        jPanel2.add(this.f);
        jPanel2.add((Component)new JSeparator(), "newline,span,grow");
        jPanel.add((Component)jPanel2, "South");
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Object object = actionEvent.getSource();
                    if (object == MenuItemSelectionView.this.g) {
                        MenuItemSelectionView.this.k();
                    } else if (object == MenuItemSelectionView.this.f) {
                        MenuItemSelectionView.this.j();
                    }
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), exception.getMessage(), exception);
                }
            }
        };
        this.g.addActionListener(actionListener);
        this.f.addActionListener(actionListener);
        this.f.setEnabled(false);
        this.g.setEnabled(false);
    }

    private void b() {
        if (this.n.isSelected()) {
            this.c.setRows(new ArrayList<MenuItem>(this.m.values()));
            this.n.setText(Messages.getString("MenuItemSelectionView.13") + "(" + this.m.values().size() + ")");
            this.i.setText("");
            this.g.setEnabled(false);
            this.f.setEnabled(false);
            this.a.setEnabled(false);
            this.b.repaint();
        } else {
            if (this.a.getSelectedItem() != null) {
                this.searchItem();
            }
            this.a.setEnabled(true);
        }
    }

    private JPanel c() {
        this.l = new JPanel();
        this.l.setLayout((LayoutManager)new MigLayout("inset 0,fillx,hidemode 3", "", "[]10[]"));
        this.j = new JLabel(POSConstants.NAME + "/" + Messages.getString("MenuItemSelectionView.16"));
        this.d = new POSTextField(15);
        this.k = new JButton(POSConstants.SEARCH_ITEM_BUTTON_TEXT);
        this.l.add((Component)this.j, "align label,split 5");
        this.l.add((Component)this.d, "growx");
        this.o = new JCheckBox(Messages.getString("MenuItemSelectionView.18"));
        this.o.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuItemSelectionView.this.d();
            }
        });
        this.a = new OverflowCombobox();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(Messages.getString("MenuItemSelectionView.19"));
        List<MenuGroup> list = MenuGroupDAO.getInstance().findAll();
        arrayList.addAll(list);
        ComboBoxModel comboBoxModel = new ComboBoxModel(arrayList);
        this.a.setModel(comboBoxModel);
        this.a.setSelectedItem(Messages.getString("MenuItemSelectionView.19"));
        this.a.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                MenuItemSelectionView.this.searchItem();
            }
        });
        this.l.add(this.k);
        this.p = new JLabel(Messages.getString("MenuItemSelectionView.21"));
        this.l.add((Component)this.p, "split 2,right");
        this.l.add((Component)this.a, "wrap,width 150!");
        this.l.add((Component)this.o, "left, split 2");
        this.k.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuItemSelectionView.this.searchItem();
            }
        });
        this.d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuItemSelectionView.this.searchItem();
            }
        });
        return this.l;
    }

    public void searchItem() {
        this.searchItem(null);
    }

    public void searchItem(String string) {
        try {
            this.h = this.a.getSelectedItem() instanceof MenuGroup ? (MenuGroup)this.a.getSelectedItem() : null;
            this.c.setPageSize(50);
            this.c.setCurrentRowIndex(0);
            string = StringUtils.isEmpty((String)string) ? this.d.getText() : string;
            this.d.setText(string);
            MenuSearchCriteria menuSearchCriteria = new MenuSearchCriteria(this.isInventoryItemOnly(), this.h, string, this.r, this.isIncludePizzaItem() ? Boolean.valueOf(false) : null, false, this.u, this.v, this.t != null ? this.t.getCurrentMenuItem() : null);
            MenuItemDAO.getInstance().findByBarcodeOrName(this.c, menuSearchCriteria);
            this.e();
            this.c.fireTableDataChanged();
            this.b.repaint();
            this.n.setSelected(false);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private void d() {
        try {
            List list = this.c.getRows();
            if (list == null) {
                return;
            }
            for (MenuItem menuItem : list) {
                if (this.e != null && this.e.getId() != null && this.e.getId().equals(menuItem.getId())) continue;
                if (this.o.isSelected()) {
                    if (!this.m.containsKey(menuItem.getId())) {
                        this.m.put(menuItem.getId(), menuItem);
                    }
                } else {
                    this.m.remove(menuItem.getId());
                }
                this.n.setText(Messages.getString("MenuItemSelectionView.25") + "(" + this.m.values().size() + ")");
                this.b.repaint();
            }
            this.b.repaint();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private void e() {
        int n;
        int n2 = this.c.getCurrentRowIndex() + 1;
        int n3 = this.c.getNextRowIndex();
        if (n3 > (n = this.c.getNumRows())) {
            n3 = n;
        }
        this.i.setText(String.format(Messages.getString("MenuItemSelectionView.27"), n2, n3, n));
        this.g.setEnabled(this.c.hasPrevious());
        this.f.setEnabled(this.c.hasNext());
        if (this.c.getRowCount() > 0) {
            this.b.setRowSelectionInterval(0, 0);
        }
        this.o.setSelected(false);
        this.n.setText(Messages.getString("MenuItemSelectionView.28") + "(" + this.m.values().size() + ")");
    }

    private TransparentPanel f() {
        ExplorerButtonPanel explorerButtonPanel = new ExplorerButtonPanel();
        JButton jButton = explorerButtonPanel.getEditButton();
        JButton jButton2 = explorerButtonPanel.getAddButton();
        jButton2.setText(POSConstants.ADD);
        jButton.setText(POSConstants.EDIT);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuItemSelectionView.this.h();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuItemSelectionView.this.n();
            }
        });
        TransparentPanel transparentPanel = new TransparentPanel((LayoutManager)new MigLayout("center,ins 0", "sg,fill", ""));
        return transparentPanel;
    }

    public void resizeColumnWidth(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth((Integer)this.g().get(i));
        }
    }

    private List g() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(70);
        arrayList.add(250);
        arrayList.add(70);
        return arrayList;
    }

    private void h() {
        try {
            int n = this.b.getSelectedRow();
            if (n < 0) {
                return;
            }
            n = this.b.convertRowIndexToModel(n);
            MenuItem menuItem = (MenuItem)this.c.getRowData(n);
            MenuItemDAO.getInstance().initialize(menuItem);
            BeanEditor beanEditor = null;
            beanEditor = menuItem.isPizzaType() != false ? new PizzaItemForm(menuItem) : new MenuItemForm(menuItem);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), beanEditor);
            beanEditorDialog.openWithScale(1000, 700);
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            this.b.repaint();
        }
        catch (Throwable throwable) {
            POSMessageDialog.showError(this, throwable.getMessage(), throwable);
        }
    }

    private void i() {
        try {
            if (this.t != null) {
                if (this.b.getSelectedRow() < 0) {
                    return;
                }
                this.t.setCanceled(false);
                this.t.dispose();
            }
        }
        catch (Throwable throwable) {
            POSMessageDialog.showError(this, throwable.getMessage(), throwable);
        }
    }

    public List<MenuItem> getSelectedMenuItemList() {
        return new ArrayList<MenuItem>(this.m.values());
    }

    public void setSelectedItems(List<MenuItem> list) {
        if (list != null) {
            for (MenuItem menuItem : list) {
                this.m.put(menuItem.getId(), menuItem);
            }
        }
    }

    public void setParentMenuItem(MenuItem menuItem, boolean bl) {
        this.e = menuItem;
        if (bl) {
            this.n.setSelected(true);
            this.b();
        } else {
            this.searchItem();
        }
    }

    private void j() {
        this.c.setCurrentRowIndex(this.c.getNextRowIndex());
        this.l();
    }

    private void k() {
        this.c.setCurrentRowIndex(this.c.getPreviousRowIndex());
        this.l();
    }

    private void l() {
        MenuItem menuItem = this.t == null ? null : this.t.getCurrentMenuItem();
        MenuSearchCriteria menuSearchCriteria = new MenuSearchCriteria(this.isInventoryItemOnly(), this.h, this.d.getText(), this.r, this.isIncludePizzaItem() ? Boolean.valueOf(false) : null, false, this.u, this.v, menuItem);
        MenuItemDAO.getInstance().findByBarcodeOrName(this.c, menuSearchCriteria);
        this.e();
        this.b.repaint();
        this.n.setSelected(false);
    }

    public void setSelectedMenuGroup(Object object) {
        this.h = object instanceof MenuGroup ? (MenuGroup)object : null;
        this.searchItem();
    }

    private void m() {
        if (this.b.getSelectedRow() < 0) {
            return;
        }
        int n = this.b.getSelectedRow();
        n = this.b.convertRowIndexToModel(n);
        MenuItem menuItem = (MenuItem)this.c.getRowData(n);
        if (this.e != null && this.e.getId() != null && this.e.getId().equals(menuItem.getId())) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("MenuItemSelectionView.33"));
            return;
        }
        if (this.m.containsKey(menuItem.getId())) {
            this.m.remove(menuItem.getId());
        } else {
            this.m.put(menuItem.getId(), menuItem);
        }
        this.n.setText(Messages.getString("MenuItemSelectionView.34") + "(" + this.m.values().size() + ")");
        this.b.repaint();
    }

    public int getSelectedRow() {
        int n = this.b.getSelectedRow();
        if (n < 0) {
            return -1;
        }
        return this.b.convertRowIndexToModel(n);
    }

    public void repaintTable() {
        this.b.repaint();
    }

    public void setSelectionMode(int n) {
        this.n.setVisible(n == 1);
        this.o.setVisible(n == 1);
        this.b.getSelectionModel().setSelectionMode(n);
        if (n == 0) {
            this.a(false);
        } else {
            this.a(true);
        }
    }

    private void a(boolean bl) {
        DefaultTableColumnModelExt defaultTableColumnModelExt = (DefaultTableColumnModelExt)this.b.getColumnModel();
        List list = defaultTableColumnModelExt.getColumns(true);
        TableColumnExt tableColumnExt = (TableColumnExt)list.get(0);
        tableColumnExt.setVisible(bl);
    }

    public void setSelectedGroup(MenuGroup menuGroup) {
        if (this.h != null && this.h.getId().equals(menuGroup.getId())) {
            return;
        }
        this.h = menuGroup;
        this.a.setSelectedItem(menuGroup);
        this.searchItem();
    }

    public void setEnableSearch(boolean bl) {
        this.d.setVisible(bl);
        this.j.setVisible(bl);
        this.k.setVisible(bl);
    }

    public boolean isInventoryItemOnly() {
        return this.q;
    }

    public void setInventoryItemOnly(boolean bl) {
        this.q = bl;
    }

    public MenuItemTableModel getModel() {
        return this.c;
    }

    private void n() {
        try {
            MenuItem menuItem = new MenuItem();
            MenuItemForm menuItemForm = new MenuItemForm(menuItem);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)menuItemForm);
            beanEditorDialog.open();
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            MenuItem menuItem2 = (MenuItem)menuItemForm.getBean();
            this.c.addItem(menuItem2);
            this.c.setNumRows(this.c.getNumRows() + 1);
            this.e();
        }
        catch (Throwable throwable) {
            POSMessageDialog.showError(this, throwable.getMessage(), throwable);
        }
    }

    public void setShowVariantParent(boolean bl) {
        this.r = bl;
    }

    public void setShowVariant(boolean bl) {
        this.u = bl;
    }

    public void setShowComboItem(boolean bl) {
        this.v = bl;
    }

    public boolean isIncludePizzaItem() {
        return this.s;
    }

    public void setIncludePizzaItem(boolean bl) {
        this.s = bl;
    }

    public class MenuItemTableModel
    extends PaginatedTableModel<MenuItem> {
        @Override
        public Object getValueAt(int n, int n2) {
            MenuItem menuItem = (MenuItem)this.getRowData(n);
            MenuItem menuItem2 = (MenuItem)MenuItemSelectionView.this.m.get(menuItem.getId());
            switch (n2) {
                case 0: {
                    return menuItem2 != null;
                }
                case 1: {
                    return menuItem.getDisplayName();
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return Boolean.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return Double.class;
                }
            }
            throw new InternalError();
        }
    }
}

