/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.order;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.PaginatedTableModel;
import com.floreantpos.swing.PosUIManager;
import java.awt.Component;
import java.util.Date;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.apache.commons.lang.StringUtils;

public class TicketListTableModel
extends PaginatedTableModel<Ticket>
implements TableModelListener {
    private JTable a;

    public TicketListTableModel(JTable jTable) {
        super(new String[]{POSConstants.TICKET_LIST_COLUMN_ID, Messages.getString("TicketListTableModel.0"), POSConstants.TICKET_LIST_COLUMN_TABLE, POSConstants.TICKET_LIST_COLUMN_SERVER, POSConstants.TICKET_LIST_COLUMN_CREATE_DATE, POSConstants.TICKET_LIST_COLUMN_CUSTOMER, POSConstants.TICKET_LIST_COLUMN_DELIVERY_ADDRESS, POSConstants.TICKET_LIST_COLUMN_DELIVERY_DATE, POSConstants.TICKET_LIST_COLUMN_TICKET_TYPE, POSConstants.TICKET_LIST_COLUMN_STATUS, POSConstants.TICKET_LIST_COLUMN_TOTAL, POSConstants.TICKET_LIST_COLUMN_DUE});
        this.a = jTable;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Ticket ticket = (Ticket)this.rows.get(n);
        switch (n2) {
            case 0: {
                return ticket.getId();
            }
            case 1: {
                return ticket.getTokenNo();
            }
            case 2: {
                return ticket.getTableNameDisplay();
            }
            case 3: {
                User user = ticket.getOwner();
                if (user == null) {
                    return "";
                }
                return user.getFirstName() + " " + user.getLastName();
            }
            case 4: {
                Date date = ticket.getCreateDate();
                if (date == null) {
                    return "";
                }
                if (DateUtil.isToday(date)) {
                    return DateUtil.formatAsTodayDate(date);
                }
                return DateUtil.formatDateWithTime(date);
            }
            case 5: {
                if (ticket.getCustomerId() != null) {
                    String string = "";
                    string = ticket.getCustomer() != null ? ticket.getCustomer().getName() : ticket.getCustomerNameByProperty();
                    String string2 = "<html><body>" + string;
                    string2 = string2 + "</body></html>";
                    return string2;
                }
                String string = ticket.getProperty("CUSTOMER_MOBILE");
                if (string != null) {
                    return string;
                }
                return Messages.getString("GUEST");
            }
            case 6: {
                String string = ticket.getDeliveryAddress();
                if (StringUtils.isBlank((String)string)) {
                    return null;
                }
                String string3 = ticket.getDeliveryFlatNo();
                String string4 = ticket.getDeliveryZipCode();
                if (StringUtils.isNotBlank((String)string3)) {
                    string = string + ", Flat/Suite: " + string3;
                }
                if (StringUtils.isNotBlank((String)string4)) {
                    string = string + ", Zip/Postal: " + string4;
                }
                return string;
            }
            case 7: {
                Date date = ticket.getDeliveryDate();
                if (date == null) {
                    return "";
                }
                if (DateUtil.isToday(date)) {
                    return DateUtil.formatAsTodayDate(date);
                }
                return DateUtil.formatDateWithTime(date);
            }
            case 8: {
                return ticket.getOrderType();
            }
            case 9: {
                String string = "";
                string = ticket.isPaid() != false ? Messages.getString("TicketListView.8") : Messages.getString("TicketListView.9");
                if (ticket.isVoided().booleanValue()) {
                    string = Messages.getString("TicketListView.12");
                } else if (ticket.isClosed().booleanValue()) {
                    string = Messages.getString("TicketListView.13");
                }
                return string;
            }
            case 10: {
                return ticket.getTotalAmountWithTips();
            }
            case 11: {
                return ticket.getDueAmount();
            }
        }
        return null;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        for (int i = 0; i < this.a.getRowCount(); ++i) {
            int n = PosUIManager.getSize(60);
            for (int j = 0; j < this.a.getColumnCount(); ++j) {
                Component component = this.a.prepareRenderer(this.a.getCellRenderer(i, j), i, j);
                component.setSize(200, 10);
                n = Math.max(n, component.getPreferredSize().height);
            }
            if (n == this.a.getRowHeight(i)) continue;
            this.a.setRowHeight(i, n);
            System.out.println("neue Zeilenh\u00f6he: " + n + " bei Zeile: " + i);
        }
    }
}

