/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.order;

import com.floreantpos.ITicketList;
import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.actions.ShowOrderInfoAction;
import com.floreantpos.actions.TicketEditAction;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.services.TicketService;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosBlinkButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.OrderFilterPanel;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.TicketListUpdateListener;
import com.floreantpos.ui.dialog.GlobalInputDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.order.TicketListTableModel;
import com.floreantpos.ui.ticket.MultiLineTableCellRenderer;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.plaf.basic.BasicScrollBarUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import jiconfont.IconCode;
import jiconfont.icons.FontAwesome;
import jiconfont.swing.IconFontSwing;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.ColumnControlButton;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.table.TableColumnModelExt;

public class TicketListView
extends JPanel
implements ITicketList,
DataChangeListener {
    private JXTable a = new JXTable();
    private TicketListTableModel b;
    private OrderFilterPanel c;
    private PosBlinkButton d;
    private PosButton e;
    private PosButton f;
    private TableColumnModelExt g;
    private ArrayList<TicketListUpdateListener> h = new ArrayList();
    private POSToggleButton i;
    private JScrollBar j;

    public TicketListView() {
        this.setLayout(new BorderLayout());
        this.c = new OrderFilterPanel(this);
        this.add((Component)((Object)this.c), "North");
        this.a();
    }

    private void a() {
        this.a.setSortable(true);
        this.a.setSelectionMode(0);
        this.a.setColumnControlVisible(true);
        this.b = new TicketListTableModel((JTable)this.a);
        this.a.setModel((TableModel)this.b);
        this.b.setPageSize(TerminalConfig.getOrderViewPageSize());
        this.a.setRowHeight(PosUIManager.getSize(60));
        this.a.setAutoResizeMode(3);
        this.a.setDefaultRenderer(Object.class, (TableCellRenderer)new PosTableRenderer());
        this.a.setGridColor(Color.LIGHT_GRAY);
        this.a.getTableHeader().setPreferredSize(new Dimension(100, PosUIManager.getSize(40)));
        this.a.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    TicketListView.this.doEditOrShowOrderInfo();
                }
            }
        });
        this.g = (TableColumnModelExt)this.a.getColumnModel();
        this.g.getColumn(0).setPreferredWidth(65);
        this.g.getColumn(1).setPreferredWidth(30);
        this.g.getColumn(2).setPreferredWidth(20);
        this.g.getColumn(3).setPreferredWidth(100);
        this.g.getColumn(4).setPreferredWidth(100);
        this.g.getColumn(6).setPreferredWidth(200);
        this.g.getColumn(6).setCellRenderer(new MultiLineTableCellRenderer());
        this.a.getActionMap().remove("column.horizontalScroll");
        this.a.getActionMap().remove("column.packAll");
        this.a.getActionMap().remove("column.packSelected");
        this.c();
        this.b();
        this.e();
    }

    private void b() {
        this.g.addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
                TicketListView.this.d();
            }

            @Override
            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent changeEvent) {
            }

            @Override
            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
                TicketListView.this.d();
            }
        });
    }

    private void c() {
        String string = TerminalConfig.getTicketListViewHiddenColumns();
        TableColumnModelExt tableColumnModelExt = (TableColumnModelExt)this.a.getColumnModel();
        if (string.isEmpty()) {
            return;
        }
        String[] stringArray = string.split("\\*");
        for (int i = 0; i < stringArray.length; ++i) {
            Integer n = Integer.parseInt(stringArray[i]);
            tableColumnModelExt.getColumnExt(n - i).setVisible(false);
        }
    }

    private void d() {
        List list = this.g.getColumns(true);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (TableColumn tableColumn : list) {
            TableColumnExt tableColumnExt = (TableColumnExt)tableColumn;
            if (tableColumnExt.isVisible()) continue;
            arrayList.add(tableColumnExt.getModelIndex());
        }
        this.a(arrayList);
    }

    private void e() {
        this.i = new POSToggleButton();
        this.i.setIcon(IconFactory.getIcon("/ui_icons/", "filter-16.png"));
        this.a(TerminalConfig.isOrderFilterPanelVisible());
        int n = PosUIManager.getSize(20);
        this.d = new PosBlinkButton(IconFactory.getIcon("/ui_icons/", "refresh-16.png"));
        this.e = new PosButton();
        this.e.setIcon(IconFontSwing.buildIcon((IconCode)FontAwesome.ANGLE_DOUBLE_LEFT, (float)n));
        this.f = new PosButton();
        this.f.setIcon(IconFontSwing.buildIcon((IconCode)FontAwesome.ANGLE_DOUBLE_RIGHT, (float)n));
        this.createActionHandlers();
        PosScrollPane posScrollPane = new PosScrollPane((Component)this.a, 20, 31);
        posScrollPane.getVerticalScrollBar().setUI(new CustomScrollbarUI());
        int n2 = PosUIManager.getSize(40);
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("ins 0", "grow", ""));
        ColumnControlButton columnControlButton = new ColumnControlButton(this.a);
        jPanel.add((Component)columnControlButton, "h " + n2 + "!, grow, wrap");
        jPanel.add((Component)this.d, "h " + n2 + "!, grow, wrap");
        jPanel.add((Component)this.e, "h " + n2 + "!, grow, wrap");
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("ins 0", "grow", ""));
        jPanel2.add((Component)this.f, "h " + n2 + "!, grow,gaptop 5, wrap");
        jPanel2.add((Component)this.i, "h " + n2 + "!,grow, wrap");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        jPanel3.setPreferredSize(PosUIManager.getSize(48, 0));
        jPanel3.add((Component)jPanel, "North");
        jPanel3.add((Component)jPanel2, "South");
        this.j = posScrollPane.getVerticalScrollBar();
        posScrollPane.getViewport().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TicketListView.this.j.repaint();
            }
        });
        jPanel3.add(this.j);
        this.add(posScrollPane);
        this.add((Component)jPanel3, "East");
    }

    public void createActionHandlers() {
        this.e.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TicketListView.this.b.hasPrevious()) {
                    TicketListView.this.b.setCurrentRowIndex(TicketListView.this.b.getPreviousRowIndex());
                    TicketDAO.getInstance().loadTickets(TicketListView.this.b);
                }
                TicketListView.this.updateButtonStatus();
            }
        });
        this.f.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TicketListView.this.b.hasNext()) {
                    TicketListView.this.b.setCurrentRowIndex(TicketListView.this.b.getNextRowIndex());
                    TicketDAO.getInstance().loadTickets(TicketListView.this.b);
                }
                TicketListView.this.updateButtonStatus();
            }
        });
        this.d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicketListView.this.getTableModel().setCurrentRowIndex(0);
                TicketListView.this.updateTicketList();
                Application.getPosWindow().clearMqttTickets();
            }
        });
        this.i.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicketListView.this.c.setCollapsed(!TicketListView.this.c.isCollapsed());
                TerminalConfig.setOrderFilterPanelVisible(TicketListView.this.i.isSelected());
            }
        });
    }

    public void updateButtonStatus() {
        this.f.setEnabled(this.b.hasNext());
        this.e.setEnabled(this.b.hasPrevious());
    }

    @Override
    public synchronized void updateTicketList() {
        try {
            this.b.setCurrentRowIndex(0);
            TicketDAO.getInstance().loadTickets(this.b);
            this.d.setBlinking(false);
            this.updateButtonStatus();
            for (int i = 0; i < this.h.size(); ++i) {
                TicketListUpdateListener ticketListUpdateListener = this.h.get(i);
                ticketListUpdateListener.ticketListUpdated();
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, Messages.getString("SwitchboardView.19"), exception);
        }
    }

    public void addTicketListUpateListener(TicketListUpdateListener ticketListUpdateListener) {
        this.h.add(ticketListUpdateListener);
    }

    public void setTickets(List<Ticket> list) {
        this.b.setRows(list);
    }

    public void addTicket(Ticket ticket) {
        this.b.addItem(ticket);
    }

    @Override
    public Ticket getSelectedTicket() {
        int n = this.a.getSelectedRow();
        if (n < 0) {
            return null;
        }
        return (Ticket)this.b.getRowData(this.a.convertRowIndexToModel(n));
    }

    public List<Ticket> getSelectedTickets() {
        ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
        Ticket ticket = this.getSelectedTicket();
        if (ticket == null) {
            return null;
        }
        arrayList.add(ticket);
        return arrayList;
    }

    public Ticket getFirstSelectedTicket() {
        List<Ticket> list = this.getSelectedTickets();
        if (list.size() == 0 || list.size() > 1) {
            POSMessageDialog.showMessage(Messages.getString("TicketListView.14"));
            return null;
        }
        Ticket ticket = list.get(0);
        return ticket;
    }

    public String getFirstSelectedTicketId() {
        Ticket ticket = this.getFirstSelectedTicket();
        if (ticket == null) {
            return null;
        }
        return ticket.getId();
    }

    public JXTable getTable() {
        return this.a;
    }

    public TicketListTableModel getTableModel() {
        return this.b;
    }

    public void setCurrentRowIndexZero() {
        this.getTableModel().setCurrentRowIndex(0);
    }

    public void setAutoUpdateCheck(boolean bl) {
    }

    private void a(boolean bl) {
        if (bl) {
            this.c.setCollapsed(!TerminalConfig.isOrderFilterPanelVisible());
            this.i.setSelected(!this.c.isCollapsed());
        }
    }

    private void a(List list) {
        String string = "";
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string2 = String.valueOf(iterator.next());
            string = string + string2;
            if (!iterator.hasNext()) continue;
            string = string + "*";
        }
        TerminalConfig.setTicketListViewHiddenColumns(string);
    }

    @Override
    public void dataAdded(Object object) {
        if (object == null) {
            return;
        }
        TicketListTableModel ticketListTableModel = this.getTableModel();
        ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
        arrayList.add((Ticket)object);
        arrayList.addAll(ticketListTableModel.getRows());
        ticketListTableModel.setRows(arrayList);
        ticketListTableModel.setNumRows(ticketListTableModel.getNumRows() + 1);
        this.updateButtonStatus();
    }

    @Override
    public void dataChanged(Object object) {
        this.updateTicketList();
    }

    @Override
    public void dataRemoved(Object object) {
        if (object == null) {
            return;
        }
        this.b.deleteItem(object);
        this.b.setNumRows(this.b.getNumRows() - 1);
        this.b.fireTableDataChanged();
    }

    @Override
    public Object getSelectedData() {
        Ticket ticket = this.getSelectedTicket();
        if (ticket == null) {
            GlobalInputDialog globalInputDialog = new GlobalInputDialog(Application.getPosWindow());
            globalInputDialog.setCaption(Messages.getString("TicketListView.20"));
            globalInputDialog.setBlankErrorMessage(Messages.getString("TicketIdCannotBeEmpty"));
            globalInputDialog.open();
            if (globalInputDialog.isCanceled()) {
                return null;
            }
            String string = globalInputDialog.getInput();
            ticket = TicketService.getTicket(string);
        }
        return ticket;
    }

    @Override
    public void dataSetUpdated() {
        this.updateTicketList();
    }

    @Override
    public void dataChangeCanceled(Object object) {
        if (object == null) {
            return;
        }
        Ticket ticket = (Ticket)object;
        if (ticket.getId() == null) {
            return;
        }
        ticket = TicketDAO.getInstance().get(ticket.getId());
        this.dataChanged(ticket);
    }

    public void doEditOrShowOrderInfo() {
        try {
            Ticket ticket = this.getSelectedTicket();
            if (ticket == null) {
                return;
            }
            if (ticket.isClosed().booleanValue()) {
                new ShowOrderInfoAction(this).actionPerformed(null);
            } else {
                new TicketEditAction(this).actionPerformed(null);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
        }
    }

    class LocalMultiLineTableCellRenderer
    extends JTextArea
    implements TableCellRenderer {
        public LocalMultiLineTableCellRenderer() {
            this(15, 2);
        }

        public LocalMultiLineTableCellRenderer(int n, int n2) {
            this.setOpaque(true);
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
            this.setBorder(new EmptyBorder(PosUIManager.getSize(n), PosUIManager.getSize(n2), n, n2));
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setFont(jTable.getFont());
            if (object != null) {
                this.setText(object.toString().trim());
            } else {
                this.setText("");
            }
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
            }
            return this;
        }
    }

    class CustomScrollbarUI
    extends BasicScrollBarUI {
        @Override
        protected JButton createDecreaseButton(int n) {
            PosButton posButton = new PosButton(){

                @Override
                public Dimension getPreferredSize() {
                    return PosUIManager.getSize(40, 40);
                }

                @Override
                public boolean isVisible() {
                    this.setEnabled(CustomScrollbarUI.this.thumbRect.getY() > 0.0);
                    return super.isVisible();
                }
            };
            posButton.setIcon(IconFontSwing.buildIcon((IconCode)FontAwesome.ANGLE_UP, (float)PosUIManager.getSize(20)));
            return posButton;
        }

        @Override
        protected JButton createIncreaseButton(int n) {
            PosButton posButton = new PosButton(){

                @Override
                public Dimension getPreferredSize() {
                    return PosUIManager.getSize(40, 40);
                }

                @Override
                public boolean isVisible() {
                    this.setEnabled(CustomScrollbarUI.this.thumbRect.getY() > 0.0);
                    return super.isVisible();
                }
            };
            posButton.setIcon(IconFontSwing.buildIcon((IconCode)FontAwesome.ANGLE_DOWN, (float)PosUIManager.getSize(20)));
            return posButton;
        }
    }
}

