/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.ticket;

import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.ext.KitchenStatus;
import com.floreantpos.swing.VerticalTouchScrollPanel;
import com.floreantpos.ui.ticket.MultiLineTableCellRenderer;
import com.floreantpos.ui.ticket.TicketViewerTableModel;
import com.floreantpos.util.NumberUtil;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class TicketViewerTableCellRenderer
extends DefaultTableCellRenderer {
    public static final Color SAVED_ITEM_COLOR = Color.decode("#FFFACD");
    private boolean a = false;
    private MultiLineTableCellRenderer b;

    public TicketViewerTableCellRenderer() {
        this(15, 2);
    }

    public TicketViewerTableCellRenderer(int n, int n2) {
        this.b = new MultiLineTableCellRenderer(n, n2);
        VerticalTouchScrollPanel verticalTouchScrollPanel = this.a(this);
        if (verticalTouchScrollPanel != null && verticalTouchScrollPanel instanceof VerticalTouchScrollPanel) {
            verticalTouchScrollPanel.addListener(this.b);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Component component = null;
        TicketViewerTableModel ticketViewerTableModel = (TicketViewerTableModel)jTable.getModel();
        Object object2 = ticketViewerTableModel.get(n);
        if (n2 == 0) {
            this.b.setPreferredSize(null);
            component = this.b.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        } else {
            component = super.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
            this.setHorizontalAlignment(4);
        }
        if (!this.a || bl) {
            return component;
        }
        component.setBackground(jTable.getBackground());
        if (object2 instanceof ITicketItem) {
            ITicketItem iTicketItem = (ITicketItem)object2;
            if (iTicketItem.getKitchenStatusValue() == KitchenStatus.BUMP) {
                component.setBackground(Color.GREEN);
            } else if (iTicketItem.isPrintedToKitchen().booleanValue()) {
                component.setBackground(Color.YELLOW);
            } else if (this.a(iTicketItem)) {
                component.setBackground(SAVED_ITEM_COLOR);
            }
        }
        return component;
    }

    private boolean a(ITicketItem iTicketItem) {
        if (iTicketItem instanceof TicketItem) {
            return ((TicketItem)iTicketItem).isInventoryAdjusted();
        }
        if (iTicketItem instanceof TicketItemModifier) {
            TicketItem ticketItem = ((TicketItemModifier)iTicketItem).getTicketItem();
            return ticketItem != null && ticketItem.isInventoryAdjusted();
        }
        return false;
    }

    @Override
    protected void setValue(Object object) {
        if (object == null) {
            this.setText("");
            return;
        }
        String string = object.toString();
        if (object instanceof Double || object instanceof Float) {
            string = NumberUtil.formatNumberAcceptNegative(((Number)object).doubleValue());
        }
        this.setText(string);
    }

    public boolean isInTicketScreen() {
        return this.a;
    }

    public void setInTicketScreen(boolean bl) {
        this.a = bl;
    }

    private VerticalTouchScrollPanel a(Component component) {
        if (component instanceof VerticalTouchScrollPanel) {
            return (VerticalTouchScrollPanel)component;
        }
        if (component == null) {
            return null;
        }
        return this.a(component.getParent());
    }
}

