/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.SettleTicketAction;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.payment.GiftCardProcessor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class GiftCardAddBalanceView
extends OkCancelOptionDialog {
    private JTextField a;
    private DoubleTextField b;
    private GiftCard c;
    private GiftCardProcessor d;
    private JComboBox<OrderType> e;

    public GiftCardAddBalanceView(GiftCardProcessor giftCardProcessor) {
        this.d = giftCardProcessor;
        this.a();
        this.c();
        this.b();
    }

    public GiftCardAddBalanceView(JFrame jFrame) {
        super((Window)jFrame);
        this.a();
        this.c();
        this.b();
    }

    @Override
    public Boolean isShowKeybord() {
        return Boolean.TRUE;
    }

    private void a() {
        this.setCaption(Messages.getString("AddBalance"));
        JPanel jPanel = this.getContentPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = this.d();
        jPanel.add(jPanel2);
        this.setOkButtonText(Messages.getString("DONE"));
        this.setCancelButtonText(POSConstants.CANCEL);
    }

    private void b() {
        String string = TerminalConfig.getGiftOrdertype();
        ComboBoxModel comboBoxModel = (ComboBoxModel)this.e.getModel();
        List list = comboBoxModel.getDataList();
        for (OrderType orderType : list) {
            if (!orderType.getId().equals(string)) continue;
            this.e.setSelectedItem(orderType);
            break;
        }
    }

    private void c() {
        List<OrderType> list = OrderTypeDAO.getInstance().findAll();
        ComboBoxModel comboBoxModel = new ComboBoxModel();
        for (OrderType orderType : list) {
            comboBoxModel.addElement(orderType);
        }
        this.e.setModel(comboBoxModel);
    }

    private JPanel d() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("fillx"));
        this.e = new JComboBox();
        jPanel2.add((Component)new JLabel(Messages.getString("OrderType")), "gapleft 15, aligny center, alignx right");
        jPanel2.add(this.e, "w 250!");
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel3 = new JPanel((LayoutManager)new MigLayout("fillx,aligny center", "[][]", ""));
        JLabel jLabel = new JLabel(Messages.getString("CardNumber"));
        this.a = new JTextField(20);
        JLabel jLabel2 = new JLabel(Messages.getString("Balance"));
        this.b = new DoubleTextField(20);
        jPanel3.add((Component)jLabel, "alignx right");
        jPanel3.add((Component)this.a, "w 250!, wrap");
        jPanel3.add((Component)jLabel2, "alignx right");
        jPanel3.add((Component)this.b, "w 250!,wrap");
        jPanel.add((Component)jPanel3, "Center");
        return jPanel;
    }

    public void doGenerate() {
        try {
            if (this.e()) {
                this.dispose();
            }
        }
        catch (PosException posException) {
            POSMessageDialog.showError(Application.getPosWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage());
        }
    }

    private boolean e() {
        String string = this.a.getText();
        double d = this.b.getDoubleOrZero();
        OrderType orderType = (OrderType)this.e.getSelectedItem();
        this.c = this.d.getCard(string);
        if (this.c == null) {
            POSMessageDialog.showMessage(this, Messages.getString("GiftCardAddBalanceView.16"));
            return false;
        }
        if (StringUtils.isEmpty((String)string)) {
            MessageDialog.showError(Messages.getString("EnterCardNumber"));
            return false;
        }
        if (d == 0.0) {
            MessageDialog.showError(Messages.getString("GiftCardAddBalanceView.18"));
            return false;
        }
        if (d < 0.0) {
            MessageDialog.showError(Messages.getString("GiftCardAddBalanceView.0"));
            return false;
        }
        if (!this.c.isActive().booleanValue()) {
            MessageDialog.showError(Messages.getString("GiftCardAddBalanceView.19"));
            return false;
        }
        if (orderType == null) {
            POSMessageDialog.showMessage(this, Messages.getString("GiftCardAddBalanceView.5"));
            return false;
        }
        TerminalConfig.setGiftOrdertype(orderType.getId());
        Ticket ticket = new Ticket(true);
        ticket.setOrderType(orderType);
        ticket.addTable(0);
        ticket.setHasGiftCard(true);
        ticket.setShouldIncludeInSales(false);
        if (DataProvider.get().getCurrentTerminal().getSalesArea() != null) {
            ticket.setSalesArea(DataProvider.get().getCurrentTerminal().getSalesArea());
        }
        MenuItem menuItem = MenuItemDAO.getInstance().findByName("Gift Card");
        TicketItem ticketItem = null;
        if (menuItem != null) {
            ticketItem = menuItem.convertToTicketItem(ticket, 1.0);
        }
        if (ticketItem == null) {
            ticketItem = new TicketItem();
        }
        ticketItem.setTicket(ticket);
        ticketItem.setItemIsGiftCard(string, d);
        ticket.addToticketItems(ticketItem);
        ticket.calculatePrice();
        return new SettleTicketAction(ticket).performSettle();
    }

    @Override
    public void doOk() {
        this.doGenerate();
    }
}

