/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.actions.CloseDialogAction;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.mailservices.MailService;
import com.floreantpos.model.BalanceForwardTransaction;
import com.floreantpos.model.BalanceUpdateTransaction;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.service.GiftCarReportService;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosOptionPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.GiftCardTransactionInfoDialog;
import com.floreantpos.ui.views.payment.GiftCardProcessor;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRPdfExporterParameter;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTable;

public class GiftCardTransactionInfoView
extends POSDialog {
    private JXTable a;
    private BeanTableModel<BalanceUpdateTransaction> b;
    private Pattern c;
    private Matcher d;
    private static final String e = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
    private GiftCardProcessor f;
    private GiftCard g;
    private JXDatePicker h;
    private JXDatePicker i;
    private List<BalanceUpdateTransaction> j;

    public GiftCardTransactionInfoView(GiftCard giftCard, GiftCardProcessor giftCardProcessor) {
        this.f = giftCardProcessor;
        this.g = giftCard;
        this.a();
        this.b();
    }

    private void a() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle(Messages.getString("GiftCardTransactionInfoView.1") + this.g.getCardNumber());
        jPanel.add((Component)titlePanel, "grow,span");
        JLabel jLabel = new JLabel(Messages.getString("GiftCardTransactionInfoView.3"));
        this.h = new JXDatePicker(new Date());
        JLabel jLabel2 = new JLabel(Messages.getString("GiftCardTransactionInfoView.4"));
        this.i = new JXDatePicker(new Date());
        JButton jButton = new JButton(Messages.getString("Search"));
        jPanel.add((Component)jLabel, "split 5");
        jPanel.add((Component)this.h, "gapright 10");
        jPanel.add(jLabel2);
        jPanel.add((Component)this.i, "gapright 10");
        jPanel.add(jButton);
        jButton.addActionListener(actionEvent -> this.b());
        this.add((Component)jPanel, "North");
        this.c = Pattern.compile(e);
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("fill"));
        this.b = new BeanTableModel(BalanceUpdateTransaction.class);
        this.b.addColumn(Messages.getString("TRANSACTION_TIME"), "transactionTime");
        this.b.addColumn(Messages.getString("AMOUNT") + CurrencyUtil.getCurrencySymbolWithBracket(), "amount", 4, BeanTableModel.DataType.MONEY);
        this.a = new JXTable(this.b);
        this.a.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.a.setRowHeight(30);
        this.a.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                BalanceUpdateTransaction balanceUpdateTransaction = (BalanceUpdateTransaction)GiftCardTransactionInfoView.this.b.getRow(n);
                if (balanceUpdateTransaction instanceof BalanceForwardTransaction) {
                    object = balanceUpdateTransaction.getTicketId();
                }
                if (object instanceof Date) {
                    return super.getTableCellRendererComponent(jTable, DateUtil.formatReportDateAsString((Date)object), bl, bl2, n, n2);
                }
                return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
        });
        this.a.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                BeanTableModel beanTableModel = (BeanTableModel)jTable.getModel();
                BeanTableModel.BeanColumn beanColumn = beanTableModel.getColumn(jTable.convertColumnIndexToModel(n2));
                this.setHorizontalAlignment(beanColumn.getHorizontalAlignment());
                if (object instanceof Double) {
                    BalanceUpdateTransaction balanceUpdateTransaction = (BalanceUpdateTransaction)GiftCardTransactionInfoView.this.b.getRow(n);
                    double d = (Double)object;
                    if (balanceUpdateTransaction.getDataVersion() != null && balanceUpdateTransaction.getDataVersion() == 2) {
                        return super.getTableCellRendererComponent(jTable, NumberUtil.formatNumberAcceptNegative(d), bl, bl2, n, n2);
                    }
                    if (!(balanceUpdateTransaction instanceof BalanceForwardTransaction) && balanceUpdateTransaction.getTransactionType().equals(TransactionType.CREDIT.name())) {
                        return super.getTableCellRendererComponent(jTable, NumberUtil.formatNumberAcceptNegative(d * -1.0), bl, bl2, n, n2);
                    }
                    double d2 = balanceUpdateTransaction.getGiftCertFaceValue();
                    if (d2 == 0.0) {
                        d2 = balanceUpdateTransaction.getAmount() - (balanceUpdateTransaction.getServiceChargeAmount() + balanceUpdateTransaction.getTaxAmount() + balanceUpdateTransaction.getTipsAmount());
                    }
                    return super.getTableCellRendererComponent(jTable, NumberUtil.formatNumberAcceptNegative(d2), bl, bl2, n, n2);
                }
                return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            }
        });
        jPanel2.add((Component)new JScrollPane((Component)this.a), "grow");
        this.add((Component)jPanel2, "Center");
        this.resizeColumnWidth((JTable)this.a);
        JPanel jPanel3 = new JPanel((LayoutManager)new MigLayout("al center", "sg, fill", ""));
        PosButton posButton = new PosButton(Messages.getString("Print"));
        jPanel3.add((Component)posButton, "grow");
        posButton.addActionListener(actionEvent -> this.doPrint());
        PosButton posButton2 = new PosButton(Messages.getString("Email"));
        jPanel3.add((Component)posButton2, "grow");
        posButton2.addActionListener(actionEvent -> this.doEmail());
        jPanel3.add(new PosButton(new CloseDialogAction(this, Messages.getString("Cancel"))));
        this.add((Component)jPanel3, "South");
    }

    private void b() {
        Date date;
        Date date2 = this.h.getDate();
        if (date2.after(date = this.i.getDate())) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
            return;
        }
        this.j = this.f.getTransactionList(this.g, date2, date);
        if (this.j == null || this.j.isEmpty()) {
            this.b.removeAll();
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GiftCardTransactionDialog.15"));
            return;
        }
        this.b.setRows(this.j);
    }

    public void doPrint() {
        JasperPrint jasperPrint = new GiftCarReportService().reportCreation(this.j, this.g);
        if (jasperPrint == null) {
            return;
        }
        GiftCardTransactionInfoDialog giftCardTransactionInfoDialog = new GiftCardTransactionInfoDialog(jasperPrint);
        giftCardTransactionInfoDialog.setTitle(Messages.getString("GiftCardTransactionInfoView.14"));
        giftCardTransactionInfoDialog.setDefaultCloseOperation(2);
        giftCardTransactionInfoDialog.setSize(PosUIManager.getSize(900, 600));
        giftCardTransactionInfoDialog.setLocationRelativeTo(POSUtil.getFocusedWindow());
        giftCardTransactionInfoDialog.setVisible(true);
    }

    public void doEmail() {
        String string = PosOptionPane.showInputDialog(Messages.getString("GiftCardTransactionInfoView.15"));
        if (string == null) {
            return;
        }
        this.d = this.c.matcher(string);
        if (this.d.matches()) {
            JasperPrint jasperPrint = new GiftCarReportService().reportCreation(this.j, this.g);
            if (jasperPrint == null) {
                return;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            JRPdfExporter jRPdfExporter = new JRPdfExporter();
            jRPdfExporter.setParameter(JRPdfExporterParameter.JASPER_PRINT, (Object)jasperPrint);
            jRPdfExporter.setParameter(JRPdfExporterParameter.OUTPUT_STREAM, (Object)byteArrayOutputStream);
            try {
                jRPdfExporter.exportReport();
            }
            catch (JRException jRException) {
                PosLog.error(this.getClass(), (Exception)((Object)jRException));
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            MailService.sendMail(string, Messages.getString("GiftCardTransactionInfoView.0"), Messages.getString("GiftCardTransactionInfoView.18"), Messages.getString("GiftCardTransactionInfoView.18"), "GiftCardTransactionReport.pdf", byArray);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GiftCardTransactionInfoView.20"));
        } else {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("GiftCardTransactionInfoView.21"));
            this.doEmail();
        }
    }

    public void resizeColumnWidth(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth((Integer)this.c().get(i));
        }
    }

    private List c() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(200);
        arrayList.add(100);
        arrayList.add(150);
        arrayList.add(180);
        arrayList.add(200);
        arrayList.add(300);
        return arrayList;
    }
}

