/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.ComboItem;
import com.floreantpos.model.ComboTicketItem;
import com.floreantpos.model.DefaultMenuModifier;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.TicketItemSeat;
import com.floreantpos.model.base.BaseMenuItem;
import com.floreantpos.model.base.BaseTicketItem;
import com.floreantpos.model.base.BaseTicketItemModifier;
import com.floreantpos.model.base.BaseTicketItemSeat;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.AutomatedWeightInputDialog;
import com.floreantpos.ui.dialog.ComboTicketItemSelectionDialog;
import com.floreantpos.ui.dialog.ItemDetailDialog;
import com.floreantpos.ui.dialog.ItemQtySelectionDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.ticket.TicketViewerTable;
import com.floreantpos.ui.views.order.GroupView;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.TicketView;
import com.floreantpos.ui.views.order.actions.CategorySelectionListener;
import com.floreantpos.ui.views.order.actions.GroupSelectionListener;
import com.floreantpos.ui.views.order.actions.ItemSelectionListener;
import com.floreantpos.ui.views.order.actions.TicketEditListener;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionDialog;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionModel;
import com.floreantpos.ui.views.order.multipart.PizzaModifierSelectionDialog;
import com.floreantpos.util.NumberUtil;
import com.orocube.common.util.TicketStatus;
import java.awt.Dialog;
import java.awt.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;

public class OrderController
implements CategorySelectionListener,
GroupSelectionListener,
ItemSelectionListener {
    protected OrderView orderView;
    private TicketViewerTable a;

    public OrderController(OrderView orderView) {
        this.orderView = orderView;
        this.a = orderView.getTicketView().getTicketViewerTable();
        orderView.getCategoryView().addCategorySelectionListener(this);
        orderView.getGroupView().addGroupSelectionListener(this);
        orderView.getItemView().addItemSelectionListener(this);
    }

    @Override
    public void categorySelected(MenuCategory menuCategory) {
        try {
            this.orderView.showView("GROUP_VIEW");
            this.orderView.getGroupView().setMenuCategory(menuCategory);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    @Override
    public void groupSelected(MenuGroup menuGroup) {
        try {
            this.orderView.showView("ITEM_VIEW");
            this.orderView.getItemView().setMenuGroup(menuGroup);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    @Override
    public void itemSelected(MenuItem menuItem) {
        try (Session session = MenuItemDAO.getInstance().createNewSession();){
            Object object;
            Serializable serializable;
            Serializable serializable2;
            menuItem = MenuItemDAO.getInstance().get(menuItem.getId(), session);
            if (!this.a(menuItem, 1.0)) {
                return;
            }
            if (menuItem.isVariant().booleanValue()) {
                serializable2 = MenuItemDAO.getInstance().get(menuItem.getParentMenuItemId(), session);
                menuItem.setParentMenuItem((MenuItem)serializable2);
            } else if (menuItem.isHasVariant().booleanValue()) {
                this.orderView.getItemView().rendererVariants(menuItem);
                return;
            }
            serializable2 = this.orderView.getTicketView();
            Ticket ticket = this.orderView.getCurrentTicket();
            double d = 1.0;
            IUnit iUnit = null;
            double d2 = 0.0;
            DataProvider.get().refreshCurrentTerminal();
            Terminal terminal = DataProvider.get().getCurrentTerminal();
            if (terminal.isEnableItemDetailShowing() || menuItem.isFractionalUnit().booleanValue() || menuItem.isAllowUnitSelection() || menuItem.isEditablePrice().booleanValue()) {
                if (menuItem.isFractionalUnit().booleanValue() && TerminalConfig.getScaleActivationValue().equals("cas10")) {
                    d = AutomatedWeightInputDialog.takeDoubleInput(menuItem.getName(), 1.0);
                } else {
                    serializable = new ItemDetailDialog(ticket, menuItem);
                    ((Window)serializable).pack();
                    ((OkCancelOptionDialog)serializable).setOkButtonText(POSConstants.ADD_BUTTON_TEXT);
                    ((POSDialog)serializable).open();
                    if (((POSDialog)serializable).isCanceled()) {
                        return;
                    }
                    d = ((ItemDetailDialog)serializable).getWeightOrQuantity();
                    if (menuItem.isAllowUnitSelection()) {
                        iUnit = ((ItemDetailDialog)serializable).getSelectedUnit();
                    }
                    if (d == 0.0) {
                        POSMessageDialog.showError(Messages.getString("OrderController.3"));
                        return;
                    }
                    if (menuItem.isEditablePrice().booleanValue()) {
                        d2 = ((ItemDetailDialog)serializable).getPrice();
                        if (d2 <= -1.0) {
                            return;
                        }
                        menuItem.setPrice(d2 / d);
                    }
                }
            }
            serializable = menuItem.convertToTicketItem(ticket, d, iUnit);
            Object var13_19 = null;
            boolean bl = false;
            double d3 = 0.0;
            if (menuItem.isVariant().booleanValue()) {
                OrderController.loadVariantData(menuItem);
            }
            if (menuItem.isComboItem().booleanValue() && !this.a(menuItem, (TicketItem)serializable)) {
                return;
            }
            ((BaseTicketItem)serializable).setTicket(ticket);
            Object object2 = this.orderView.getSelectedSeatNumber();
            if (object2 instanceof Integer) {
                ((BaseTicketItem)serializable).setSeatNumber((Integer)object2);
            } else if (object2 instanceof TicketItemSeat) {
                object = (TicketItemSeat)object2;
                ((BaseTicketItem)serializable).setSeat((TicketItemSeat)object);
                ((BaseTicketItem)serializable).setSeatNumber(((BaseTicketItemSeat)object).getSeatNumber());
            }
            if (menuItem.isPizzaType().booleanValue()) {
                object = new PizzaModifierSelectionDialog(ticket, (TicketItem)serializable, menuItem, false);
                ((Dialog)object).setResizable(false);
                if (TerminalConfig.isKioskMode()) {
                    ((POSDialog)object).openUndecoratedFullScreen();
                } else {
                    ((POSDialog)object).openFullScreen();
                }
                if (((POSDialog)object).isCanceled()) {
                    return;
                }
                List<TicketItem> list = ((PizzaModifierSelectionDialog)object).getPizzzItemList();
                for (TicketItem ticketItem : list) {
                    ((TicketView)serializable2).addTicketItem(ticketItem);
                }
            } else if (menuItem.hasMandatoryModifiers()) {
                object = new ModifierSelectionModel(ticket, (TicketItem)serializable, menuItem);
                ModifierSelectionDialog modifierSelectionDialog = new ModifierSelectionDialog((ModifierSelectionModel)object);
                modifierSelectionDialog.open();
                if (!modifierSelectionDialog.isCanceled()) {
                    ((TicketView)serializable2).addTicketItem((TicketItem)serializable);
                }
            } else {
                ((TicketView)serializable2).addTicketItem((TicketItem)serializable);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    @Override
    public void variableMeasureItemSelected(MenuItem menuItem, Double d, Double d2) {
        try (Session session = MenuItemDAO.getInstance().createNewSession();){
            Serializable serializable;
            menuItem = MenuItemDAO.getInstance().get(menuItem.getId(), session);
            Double d3 = menuItem.getVariantPrice();
            double d4 = 1.0;
            d4 = d2 == null ? (NumberUtil.isZero(d3) ? 1.0 : d / d3) : d2;
            if (!this.a(menuItem, d4)) {
                return;
            }
            if (menuItem.isVariant().booleanValue()) {
                serializable = MenuItemDAO.getInstance().get(menuItem.getParentMenuItemId(), session);
                menuItem.setParentMenuItem((MenuItem)serializable);
            } else if (menuItem.isHasVariant().booleanValue()) {
                this.orderView.getItemView().rendererVariants(menuItem);
                return;
            }
            serializable = this.orderView.getTicketView();
            Ticket ticket = this.orderView.getCurrentTicket();
            IUnit iUnit = null;
            TicketItem ticketItem = menuItem.convertToTicketItem(ticket, d4, iUnit);
            if (d != null) {
                ticketItem.setUnitPrice(d / d4);
            }
            ticketItem.setTicket(ticket);
            Object object = this.orderView.getSelectedSeatNumber();
            if (object instanceof Integer) {
                ticketItem.setSeatNumber((Integer)object);
            } else if (object instanceof TicketItemSeat) {
                TicketItemSeat ticketItemSeat = (TicketItemSeat)object;
                ticketItem.setSeat(ticketItemSeat);
                ticketItem.setSeatNumber(ticketItemSeat.getSeatNumber());
            }
            ((TicketView)serializable).addTicketItem(ticketItem, Boolean.TRUE);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    private boolean a(MenuItem menuItem, double d) {
        List<TicketItem> list;
        if (menuItem == null || !menuItem.isDisableWhenStockAmountIsZero().booleanValue() || menuItem.isHasVariant().booleanValue()) {
            return true;
        }
        Ticket ticket = this.orderView.getCurrentTicket();
        double d2 = 0.0;
        if (ticket != null && (list = ticket.getTicketItems()) != null) {
            for (TicketItem ticketItem : list) {
                if (ticketItem.isTreatAsSeat().booleanValue() || !ticketItem.getMenuItemId().equals(menuItem.getId())) continue;
                d2 += ticketItem.getQuantity() - ticketItem.getInventoryAdjustQty();
            }
        }
        d2 += d;
        return !(menuItem.getAvailableUnit() < d2) || POSMessageDialog.showYesNoQuestionDialog(Application.getPosWindow(), Messages.getString("OrderController.6"), Messages.getString("CONFIRM"), Messages.getString("OrderController.8"), Messages.getString("OrderController.9")) == 0;
    }

    public void doEditTicketItemQuantity(Object object) {
        TicketItem ticketItem = (TicketItem)object;
        MenuItem menuItem = ticketItem.getMenuItem();
        double d = 0.0;
        if (ticketItem.isFractionalUnit().booleanValue() || ticketItem.isAllowUnitSelection()) {
            ItemQtySelectionDialog itemQtySelectionDialog = ItemQtySelectionDialog.getQtyAndUnit(menuItem, DataProvider.get().getUnitByCode(ticketItem.getUnitName()), Messages.getString("OrderController.2"), ticketItem.getQuantity());
            itemQtySelectionDialog.pack();
            itemQtySelectionDialog.open();
            d = itemQtySelectionDialog.isCanceled() ? -1.0 : itemQtySelectionDialog.getValue();
        } else {
            d = NumberSelectionDialog2.takeIntInput(Messages.getString("OrderController.10"), Math.abs(ticketItem.getQuantity()));
        }
        if (d <= 0.0) {
            return;
        }
        if (d > ticketItem.getQuantity() && !this.a(menuItem, d - ticketItem.getQuantity())) {
            return;
        }
        if (menuItem != null && menuItem.isComboItem().booleanValue()) {
            this.updateComboTicketItemQuantity(ticketItem, d);
        }
        ticketItem.setQuantity(d);
        if (ticketItem.isComboItem().booleanValue()) {
            ticketItem.doCalculateComboItemPrice(true);
        }
    }

    public void updateComboTicketItemQuantity(TicketItem ticketItem, double d) {
        List<TicketItem> list = ticketItem.getComboItems();
        double d2 = ticketItem.getQuantity();
        double d3 = d - d2;
        if (list != null) {
            for (TicketItem ticketItem2 : list) {
                ticketItem2.setQuantity(ticketItem2.getQuantity() + d3 * ticketItem2.getQuantity() / d2);
            }
        }
    }

    private boolean a(MenuItem menuItem, TicketItem ticketItem) {
        ComboTicketItem comboTicketItem = (ComboTicketItem)ticketItem;
        Ticket ticket = this.orderView.getCurrentTicket();
        if (menuItem.getComboItems() != null && !menuItem.getComboItems().isEmpty()) {
            for (ComboItem comboItem : menuItem.getComboItems()) {
                POSDialog pOSDialog;
                MenuItemDAO menuItemDAO;
                MenuItem menuItem2;
                if (comboItem.getQuantity() == 0.0 || comboItem.getItemId() == null || (menuItem2 = (menuItemDAO = MenuItemDAO.getInstance()).get(comboItem.getItemId())) == null) continue;
                menuItemDAO.initialize(menuItem2);
                if (menuItem2.isVariant().booleanValue()) {
                    menuItemDAO.initialize(menuItem2.getParentMenuItem());
                }
                TicketItem ticketItem2 = menuItem2.convertToTicketItem(ticket, comboItem.getQuantity(), false, null, false);
                ticketItem2.setComboChild(true);
                ticketItem2.setMenuItem(menuItem2);
                OrderController.loadVariantData(menuItem2);
                if (menuItem2.hasMandatoryModifiers()) {
                    pOSDialog = new ModifierSelectionDialog(new ModifierSelectionModel(ticket, ticketItem2, menuItem2));
                    pOSDialog.open();
                    if (pOSDialog.isCanceled()) {
                        return false;
                    }
                } else if (menuItem.isPizzaType().booleanValue()) {
                    pOSDialog = new PizzaModifierSelectionDialog(ticket, ticketItem2, menuItem2, false);
                    pOSDialog.openFullScreen();
                    if (pOSDialog.isCanceled()) {
                        return false;
                    }
                }
                ticketItem2.setMenuItemId(menuItem2.getId());
                ticketItem2.setName(menuItem2.getDisplayName());
                ticketItem2.setQuantity(comboTicketItem.getQuantity() * comboItem.getQuantity());
                ticketItem2.setParentTicketItem(comboTicketItem);
                ticketItem2.setTicket(null);
                ticketItem2.setGroupId(null);
                comboTicketItem.addTocomboItems(ticketItem2);
            }
        }
        if (menuItem.getComboGroups() != null && !menuItem.getComboGroups().isEmpty()) {
            ComboTicketItemSelectionDialog comboTicketItemSelectionDialog = new ComboTicketItemSelectionDialog(menuItem, comboTicketItem);
            comboTicketItemSelectionDialog.setTitle(Messages.getString("OrderController.13"));
            comboTicketItemSelectionDialog.setSize(PosUIManager.getSize(1024, 700));
            comboTicketItemSelectionDialog.open();
            if (comboTicketItemSelectionDialog.isCanceled()) {
                return false;
            }
        }
        comboTicketItem.doCalculateComboItemPrice();
        return true;
    }

    public static void loadVariantData(MenuItem menuItem) {
        MenuItem menuItem2 = menuItem.getParentMenuItem();
        if (!menuItem.isVariant().booleanValue() || menuItem2 == null) {
            return;
        }
        if ((menuItem.getImageId() == null || menuItem.getImageId().isEmpty()) && menuItem2.getImageId() != null) {
            menuItem.setImageId(menuItem2.getImageId());
        }
        menuItem.setHasMandatoryModifiers(menuItem2.hasMandatoryModifiers());
        menuItem.setPizzaType(menuItem2.isPizzaType());
        menuItem.setMenuItemModiferSpecs(menuItem2.getMenuItemModiferSpecs());
        List<MenuItemModifierSpec> list = menuItem.getMenuItemModiferSpecs();
        if (list != null && list.size() > 0) {
            for (MenuItemModifierSpec menuItemModifierSpec : list) {
                List<DefaultMenuModifier> list2 = menuItemModifierSpec.getDefaultModifierList();
                if (list2 == null || list2.size() <= 0) continue;
                for (DefaultMenuModifier defaultMenuModifier : list2) {
                    MenuModifier menuModifier = defaultMenuModifier.getModifier();
                    if (menuModifier == null) continue;
                    MenuModifierDAO.getInstance().initialize(menuModifier);
                }
            }
        }
    }

    public void itemSelectionFinished(MenuGroup menuGroup) {
        GroupView groupView;
        MenuCategory menuCategory = menuGroup.getParent();
        if (!menuCategory.equals((groupView = this.orderView.getGroupView()).getMenuCategory())) {
            groupView.setMenuCategory(menuCategory);
        }
        this.orderView.showView("GROUP_VIEW");
    }

    public static void openModifierDialog(ITicketItem iTicketItem) {
        try {
            ArrayList arrayList;
            List<TicketItemModifier> list;
            Comparable comparable;
            Ticket ticket = OrderView.getInstance().getCurrentTicket();
            TicketItem ticketItem = null;
            if (iTicketItem instanceof TicketItem) {
                ticketItem = (TicketItem)iTicketItem;
            } else if (iTicketItem instanceof TicketItemModifier && (ticketItem = ((BaseTicketItemModifier)(comparable = (TicketItemModifier)iTicketItem)).getTicketItem()) == null) {
                ticketItem = ((BaseTicketItemModifier)comparable).getTicketItem();
            }
            comparable = ticketItem.getMenuItem();
            MenuItemDAO.getInstance().initialize((MenuItem)comparable);
            if (((BaseMenuItem)comparable).isVariant().booleanValue()) {
                MenuItemDAO.getInstance().initialize(((MenuItem)comparable).getParentMenuItem());
                OrderController.loadVariantData((MenuItem)comparable);
            }
            if ((list = ticketItem.getTicketItemModifiers()) == null) {
                list = new ArrayList<TicketItemModifier>();
            }
            TicketItem ticketItem2 = ticketItem.clone();
            boolean bl = ticketItem.isPizzaType();
            if (bl) {
                arrayList = new PizzaModifierSelectionDialog(ticket, ticketItem2, (MenuItem)comparable, true);
                ((POSDialog)((Object)arrayList)).openFullScreen();
                if (((POSDialog)((Object)arrayList)).isCanceled()) {
                    return;
                }
                TicketItemModifier ticketItemModifier = ticketItem2.getSizeModifier();
                ticketItemModifier.setTicketItem(ticketItem);
                ticketItem.setSizeModifier(ticketItemModifier);
                if (ticketItemModifier != null) {
                    ticketItemModifier.setTicketItem(ticketItem);
                    ticketItem.setSizeModifier(ticketItemModifier);
                }
                ticketItem.setPizzaSectionMode(ticketItem2.getPizzaSectionMode());
                ticketItem.setQuantity(ticketItem2.getQuantity());
                ticketItem.setUnitPrice(ticketItem2.getUnitPrice());
            } else {
                arrayList = new ModifierSelectionDialog(new ModifierSelectionModel(ticket, ticketItem2, (MenuItem)comparable));
                ((POSDialog)((Object)arrayList)).open();
                if (((POSDialog)((Object)arrayList)).isCanceled()) {
                    return;
                }
            }
            arrayList = ticketItem2.getTicketItemModifiers();
            if (arrayList == null) {
                arrayList = new ArrayList();
            }
            list.clear();
            for (TicketItemModifier ticketItemModifier : arrayList) {
                ticketItemModifier.setTicketItem(ticketItem);
                ticketItem.addToticketItemModifiers(ticketItemModifier);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
        OrderView.getInstance().getTicketView().getTicketViewerTable().updateView();
    }

    public static synchronized void saveOrder(Ticket ticket) {
        if (ticket == null) {
            return;
        }
        TicketDAO.getInstance().saveOrUpdate(ticket);
    }

    public static synchronized void closeOrder(Ticket ticket) {
        TicketStatus ticketStatus = ticket.getTicketStatus();
        if (ticketStatus != TicketStatus.DeliveryFailed) {
            ticket.setTicketStatus(TicketStatus.Completed);
        }
        ticket.setClosed(true);
        ticket.setClosingDate(StoreDAO.getServerTimestamp());
        TicketDAO.getInstance().saveOrUpdate(ticket);
    }

    public void addTicketUpdateListener(TicketEditListener ticketEditListener) {
        this.a.addTicketUpdateListener(ticketEditListener);
    }

    public void removeTicketUpdateListener(TicketEditListener ticketEditListener) {
        this.a.removeTicketUpdateListener(ticketEditListener);
    }

    public void fireTicketItemUpdated(Ticket ticket, TicketItem ticketItem) {
        this.a.fireTicketItemUpdated(ticket, ticketItem);
    }

    public void fireTicketEditingStart(Ticket ticket) {
        this.a.fireTicketEditingStart(ticket);
    }

    public void fireTicketEdited(Ticket ticket) {
        this.a.fireTicketEdited(ticket);
    }

    public void fireTicketEditingFinish(Ticket ticket) {
        this.a.fireTicketEditingFinish(ticket);
    }
}

