/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order.modifier;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.main.Application;
import com.floreantpos.model.DefaultMenuModifier;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Store;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.base.BaseTicketItemModifier;
import com.floreantpos.model.dao.MenuItemModifierSpecDAO;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.MultiplierDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.modifier.ModifierGroupSelectionListener;
import com.floreantpos.ui.views.order.modifier.ModifierGroupView;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionListener;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionModel;
import com.floreantpos.ui.views.order.modifier.ModifierView;
import com.floreantpos.ui.views.order.modifier.ModifierViewerTable;
import com.floreantpos.ui.views.order.modifier.TicketItemModifierTableView;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTable;
import net.miginfocom.swing.MigLayout;

public class ModifierSelectionDialog
extends POSDialog
implements ModifierGroupSelectionListener,
ModifierSelectionListener {
    private ModifierSelectionModel a;
    private ModifierGroupView b;
    private ModifierView c;
    private TicketItemModifierTableView d;
    private JPanel e = new JPanel(new BorderLayout(5, 5));
    private TransparentPanel f;
    private PosButton g;
    private PosButton h;

    public ModifierSelectionDialog(ModifierSelectionModel modifierSelectionModel) {
        super((Frame)Application.getPosWindow(), true);
        this.a = modifierSelectionModel;
        this.b();
        this.a();
    }

    private void a() {
        MenuItem menuItem = this.a.getMenuItem();
        if (this.a.getTicketItem().getTicketItemModifiers() == null) {
            List<MenuItemModifierSpec> list = menuItem.getMenuItemModiferSpecs();
            Multiplier multiplier = MultiplierDAO.getInstance().getDefaultMutltiplier();
            for (MenuItemModifierSpec menuItemModifierSpec : list) {
                List<DefaultMenuModifier> list2;
                if (!menuItemModifierSpec.isEnable().booleanValue() || (list2 = menuItemModifierSpec.getDefaultModifierList()) == null) continue;
                for (DefaultMenuModifier defaultMenuModifier : list2) {
                    MenuModifier menuModifier = defaultMenuModifier.getModifier();
                    MenuModifierDAO.getInstance().initialize(menuModifier);
                    Multiplier multiplier2 = defaultMenuModifier.getMultiplier();
                    if (multiplier2 == null) {
                        multiplier2 = multiplier;
                    }
                    menuModifier.setMenuItemModifierGroup(menuItemModifierSpec);
                    this.a(menuModifier, multiplier2, defaultMenuModifier.getQuantity(), true);
                }
            }
        }
    }

    private void b() {
        this.setTitle(Messages.getString("ModifierSelectionDialog.0"));
        this.setLayout(new BorderLayout(PosUIManager.getSize(5), PosUIManager.getSize(5)));
        this.b = new ModifierGroupView(this.a);
        this.c = new ModifierView(this.a);
        this.d = new TicketItemModifierTableView(this.a);
        this.f = new TransparentPanel();
        this.f.setLayout((LayoutManager)new MigLayout("fill, ins 4", "fill", ""));
        this.e.add(this.d);
        this.add(this.c);
        boolean bl = DataProvider.get().getStore().getBooleanProperty("order_view.ticket_on_right", false);
        if (!bl) {
            this.add((Component)this.b, "East");
            this.add((Component)this.e, "West");
        } else {
            this.add((Component)this.b, "West");
            this.add((Component)this.e, "East");
        }
        this.createButtonPanel();
        Rectangle rectangle = Application.getPosWindow().getBounds();
        this.setBounds(new Rectangle((int)(rectangle.getWidth() - 40.0), (int)(rectangle.getHeight() - 40.0)));
        this.d.addModifierSelectionListener(this);
        this.b.addModifierGroupSelectionListener(this);
        this.c.addModifierSelectionListener(this);
        this.b.selectFirst();
    }

    public void createButtonPanel() {
        this.g = new PosButton(Messages.getString("DONE"));
        this.g.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModifierSelectionDialog.this.c();
            }
        });
        this.h = new PosButton(POSConstants.CANCEL.toUpperCase());
        this.h.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModifierSelectionDialog.this.setCanceled(true);
                ModifierSelectionDialog.this.dispose();
            }
        });
        this.f.add(this.h);
        this.f.add(this.g);
    }

    public ModifierGroupView getModifierGroupView() {
        return this.b;
    }

    public void setModifierGroupView(ModifierGroupView modifierGroupView) {
        this.b = modifierGroupView;
    }

    public ModifierView getModifierView() {
        return this.c;
    }

    public void setModifierView(ModifierView modifierView) {
        this.c = modifierView;
    }

    private void c() {
        List<MenuItemModifierSpec> list = this.a.getMenuItem().getMenuItemModiferSpecs();
        if (list == null) {
            this.dispose();
            return;
        }
        for (MenuItemModifierSpec menuItemModifierSpec : list) {
            if (!menuItemModifierSpec.isEnable().booleanValue() || ModifierSelectionDialog.isRequiredModifiersAdded(this.a.getTicketItem(), menuItemModifierSpec)) continue;
            this.a(menuItemModifierSpec);
            this.b.setSelectedModifierGroup(menuItemModifierSpec);
        }
    }

    @Override
    public void modifierGroupSelected(MenuItemModifierSpec menuItemModifierSpec) {
        this.c.setModifierGroup(menuItemModifierSpec);
    }

    @Override
    public void modifierSelected(MenuModifier menuModifier, Multiplier multiplier) {
        this.a(menuModifier, multiplier);
    }

    private void a(MenuModifier menuModifier, Multiplier multiplier) {
        this.a(menuModifier, multiplier, 1.0, false);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void a(MenuModifier menuModifier, Multiplier serializable, Double d, boolean bl) {
        void var2_4;
        int n;
        Object object;
        Serializable serializable2;
        Object object2;
        void var4_6;
        TicketItem ticketItem = this.a.getTicketItem();
        MenuItemModifierSpec menuItemModifierSpec = menuModifier.getMenuItemModifierGroup();
        int n2 = ticketItem.countModifierFromGroup(menuItemModifierSpec);
        int n3 = menuItemModifierSpec.getMinQuantity();
        int n4 = menuItemModifierSpec.getMaxQuantity();
        if (n4 < n3) {
            n4 = n3;
        }
        if (n2 >= n4 && var4_6 == false) {
            object2 = DataProvider.get().getStore();
            if (((Store)object2).hasExtraMultiplier().booleanValue()) {
                serializable2 = ((Store)object2).getExtraMultiplier();
                String string = Messages.getString("ModifierSelectionDialog.4");
                n = POSMessageDialog.showYesNoQuestionDialog(this, string, (String)(object = Messages.getString("ModifierSelectionDialog.8")));
                if (n != 0) return;
                Serializable serializable3 = serializable2;
            } else {
                POSMessageDialog.showError(Messages.getString("ModifierSelectionDialog.3") + menuModifier.getMenuItemModifierGroup().getDisplayName());
                return;
            }
        }
        object2 = ticketItem.findTicketItemModifierFor(menuModifier, (Multiplier)var2_4);
        serializable2 = this.d.getTicketViewerTable();
        int n5 = ((JTable)serializable2).getRowCount();
        object = null;
        if (n5 > 0) {
            object = (TicketItemModifier)((ModifierViewerTable)serializable2).get(n5 - 1);
        }
        int n6 = n = object2 != null && object != null && ((BaseTicketItemModifier)object2).getName().equals(((BaseTicketItemModifier)object).getName()) ? 1 : 0;
        if (n == 0) {
            void var3_5;
            OrderType orderType = ticketItem.getTicket().getOrderType();
            TicketItemModifier ticketItemModifier = ticketItem.addTicketItemModifier(menuModifier, 1, orderType, (Multiplier)var2_4);
            ticketItemModifier.setItemQuantity((Double)var3_5);
        } else {
            object2 = object;
            ((BaseTicketItemModifier)object2).setItemQuantity(((TicketItemModifier)object2).getItemQuantity() + 1.0);
        }
        if (menuItemModifierSpec.hasPriceRules()) {
            ticketItem.updateModifiersUnitPriceByGroup(menuItemModifierSpec);
        }
        this.d();
        if (n2 + 1 != n3) return;
        this.modifierGroupSelectionDone(menuModifier.getMenuItemModifierGroup());
    }

    private void d() {
        this.a.getTicketItem().calculatePrice();
        this.c.updateView();
        this.d.updateView();
    }

    @Override
    public void clearModifiers(MenuItemModifierSpec menuItemModifierSpec) {
        TicketItem ticketItem = this.a.getTicketItem();
        List<TicketItemModifier> list = ticketItem.getTicketItemModifiers();
        if (list != null) {
            Iterator<TicketItemModifier> iterator = list.iterator();
            while (iterator.hasNext()) {
                TicketItemModifier ticketItemModifier = iterator.next();
                if (ticketItemModifier.isPrintedToKitchen().booleanValue()) continue;
                iterator.remove();
            }
        }
        if (menuItemModifierSpec.hasPriceRules()) {
            ticketItem.updateModifiersUnitPriceByGroup(menuItemModifierSpec);
        }
        this.d();
    }

    @Override
    public void modifierGroupSelectionDone(MenuItemModifierSpec menuItemModifierSpec) {
        if (!ModifierSelectionDialog.isRequiredModifiersAdded(this.a.getTicketItem(), menuItemModifierSpec)) {
            this.a(menuItemModifierSpec);
            this.b.setSelectedModifierGroup(menuItemModifierSpec);
            return;
        }
        if (menuItemModifierSpec.isJumpGroup().booleanValue() && this.b.hasNextMandatoryGroup()) {
            this.b.selectNextGroup();
        }
        List<MenuItemModifierSpec> list = this.a.getMenuItem().getMenuItemModiferSpecs();
        boolean bl = false;
        for (MenuItemModifierSpec menuItemModifierSpec2 : list) {
            if (ModifierSelectionDialog.isRequiredModifiersAdded(this.a.getTicketItem(), menuItemModifierSpec2)) {
                bl = true;
                continue;
            }
            bl = false;
            break;
        }
        if (bl && !this.b.hasNextMandatoryGroup() && menuItemModifierSpec.isJumpGroup().booleanValue()) {
            this.setCanceled(false);
            this.dispose();
        }
    }

    @Override
    public void finishModifierSelection() {
        TicketItem ticketItem = this.a.getTicketItem();
        List<MenuItemModifierSpec> list = this.a.getMenuItem().getMenuItemModiferSpecs();
        if (list == null) {
            this.setCanceled(false);
            this.dispose();
            return;
        }
        if (!list.isEmpty()) {
            for (MenuItemModifierSpec menuItemModifierSpec : list) {
                if (ticketItem.requiredModifiersAdded(menuItemModifierSpec)) continue;
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ModifierSelectionDialog.7"));
                return;
            }
        }
        this.setCanceled(false);
        this.dispose();
    }

    public ModifierSelectionModel getModifierSelectionModel() {
        return this.a;
    }

    public void setModifierSelectionModel(ModifierSelectionModel modifierSelectionModel) {
        this.a = modifierSelectionModel;
    }

    public static boolean isRequiredModifiersAdded(TicketItem ticketItem, MenuItemModifierSpec menuItemModifierSpec) {
        return ticketItem.requiredModifiersAdded(menuItemModifierSpec);
    }

    private void a(MenuItemModifierSpec menuItemModifierSpec) {
        String string = menuItemModifierSpec.getName();
        int n = menuItemModifierSpec.getMinQuantity();
        String string2 = n <= 1 ? Messages.getString("modifierArt") : Messages.getString("modifiersArt");
        POSMessageDialog.showError(Messages.getString("ModifierSelectionDialog.5") + " " + n + string2 + Messages.getString("ModifierSelectionDialog.6") + " " + string);
    }

    @Override
    public void modifierRemoved(TicketItemModifier ticketItemModifier) {
        MenuItemModifierSpec menuItemModifierSpec = MenuItemModifierSpecDAO.getInstance().get(ticketItemModifier.getGroupId());
        MenuItemModifierSpecDAO.getInstance().initialize(menuItemModifierSpec);
        this.c.setModifierGroup(menuItemModifierSpec);
        if (menuItemModifierSpec.hasPriceRules()) {
            ticketItemModifier.getTicketItem().updateModifiersUnitPriceByGroup(menuItemModifierSpec);
        }
    }

    @Override
    public void modifierUpdated(TicketItemModifier ticketItemModifier, double d) {
        MenuItemModifierSpec menuItemModifierSpec = MenuItemModifierSpecDAO.getInstance().get(ticketItemModifier.getGroupId());
        int n = (int)((double)ticketItemModifier.getTicketItem().countModifierFromGroup(menuItemModifierSpec) - ticketItemModifier.getItemQuantity() + d);
        int n2 = menuItemModifierSpec.getMinQuantity();
        int n3 = menuItemModifierSpec.getMaxQuantity();
        if (n3 < n2) {
            n3 = n2;
        }
        if (n > n3) {
            POSMessageDialog.showError(Messages.getString("ModifierSelectionDialog.3") + menuItemModifierSpec.getDisplayName());
            return;
        }
        ticketItemModifier.setItemQuantity(d);
        if (menuItemModifierSpec.hasPriceRules()) {
            ticketItemModifier.getTicketItem().updateModifiersUnitPriceByGroup(menuItemModifierSpec);
        }
        this.c.updateView();
    }
}

