/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order.multipart;

import com.floreantpos.Messages;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierMultiplierPrice;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.PizzaModifierPrice;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.NumberUtil;
import java.math.BigDecimal;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class PizzaPriceTableModel
extends AbstractTableModel {
    private List<PizzaModifierPrice> a;
    private String[] b;
    private Class[] c;

    public PizzaPriceTableModel(List<PizzaModifierPrice> list, List<Multiplier> list2) {
        this.setPriceList(list, list2);
    }

    public void setPriceList(List<PizzaModifierPrice> list, List<Multiplier> list2) {
        this.b = new String[list2.size() + 1];
        this.c = new Class[list2.size() + 1];
        this.b[0] = "Size";
        this.c[0] = String.class;
        int n = 2;
        for (Multiplier comparable : list2) {
            if (comparable.isDefaultMultiplier().booleanValue()) {
                this.b[1] = comparable.getId();
                this.c[1] = BigDecimal.class;
                continue;
            }
            this.b[n] = comparable.getId();
            this.c[n] = BigDecimal.class;
            ++n;
        }
        this.a = list;
        for (PizzaModifierPrice pizzaModifierPrice : list) {
            pizzaModifierPrice.initializeSizeAndPriceList(list2);
        }
    }

    @Override
    public String getColumnName(int n) {
        return this.b[n];
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (n == 0) {
            return this.c[n];
        }
        return BigDecimal.class;
    }

    @Override
    public int getColumnCount() {
        return this.b.length;
    }

    @Override
    public int getRowCount() {
        return this.a.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        PizzaModifierPrice pizzaModifierPrice = this.a.get(n);
        if (pizzaModifierPrice == null) {
            return null;
        }
        if (0 == n2) {
            if (pizzaModifierPrice != null && pizzaModifierPrice.getSize() != null) {
                return pizzaModifierPrice.getSize().getName();
            }
        } else {
            ModifierMultiplierPrice modifierMultiplierPrice = pizzaModifierPrice.getMultiplier(this.b[n2]);
            if (modifierMultiplierPrice == null) {
                return null;
            }
            Double d = modifierMultiplierPrice.getPrice();
            if (d != null) {
                return BigDecimal.valueOf(modifierMultiplierPrice.getPrice());
            }
            return null;
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 != 0;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        PizzaModifierPrice pizzaModifierPrice = this.a.get(n);
        if (n2 == 0) {
            super.setValueAt(object, n, n2);
        } else {
            String string = (String)object;
            double d = NumberUtil.parseOrGetZero(string).doubleValue();
            if (d < 0.0) {
                POSMessageDialog.showError(Messages.getString("NegativePriceNotAllowed"));
                return;
            }
            ModifierMultiplierPrice modifierMultiplierPrice = pizzaModifierPrice.getMultiplier(this.b[n2]);
            modifierMultiplierPrice.setPrice(d);
        }
    }

    public List<PizzaModifierPrice> getRows(MenuModifier menuModifier) {
        for (PizzaModifierPrice pizzaModifierPrice : this.a) {
            pizzaModifierPrice.populateMultiplierPriceListRowValue(menuModifier);
        }
        return this.a;
    }
}

