/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order.multipart;

import com.floreantpos.Messages;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.multipart.PizzaModifierSelectionDialog;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.TableColumnModel;

class PizzaSection
extends JPanel
implements MouseListener {
    private final PizzaModifierSelectionDialog e;
    boolean a;
    boolean b;
    PosButton c;
    private final String f;
    private final int g;
    private final String h;
    private final double i;
    private JTable j;
    SectionTableModel d;
    public static final String WHOLE = "WHOLE";
    public static final String HALF = "Half";
    public static final String QUARTER = "Quarter";

    public PizzaSection(PizzaModifierSelectionDialog pizzaModifierSelectionDialog, String string, String string2, int n, boolean bl, double d) {
        this.e = pizzaModifierSelectionDialog;
        this.f = string;
        this.h = string2;
        this.g = n;
        this.b = bl;
        this.i = d;
        this.setLayout(new BorderLayout());
        this.c = new PosButton(string);
        this.c.setHorizontalAlignment(0);
        this.c.setFont(this.c.getFont().deriveFont(1, 14.0f));
        this.c.setOpaque(true);
        this.setOpaque(false);
        this.setPreferredSize(PosUIManager.getSize(160, 135));
        this.setBorder(null);
        this.j = new JTable();
        this.j.setTableHeader(null);
        this.j.setRowHeight(PosUIManager.getSize(30));
        this.d = new SectionTableModel();
        this.j.setDefaultRenderer(Object.class, new SectionTableCellRenderer());
        this.j.setModel(this.d);
        JScrollPane jScrollPane = new JScrollPane(this.j);
        jScrollPane.setBorder(null);
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.setOpaque(false);
        jScrollPane.setOpaque(false);
        jScrollPane.getViewport().setBorder(null);
        this.add((Component)jScrollPane, "Center");
        jViewport.addMouseListener(this);
        this.j.addMouseListener(this);
        this.resizeColumnWidth(this.j);
    }

    public void resizeColumnWidth(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth((Integer)this.a().get(i));
        }
    }

    private List a() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(70);
        arrayList.add(30);
        return arrayList;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        AlphaComposite alphaComposite = (AlphaComposite)graphics2D.getComposite();
        AlphaComposite alphaComposite2 = alphaComposite.derive(0.75f);
        graphics2D.setComposite(alphaComposite2);
        super.paintComponent(graphics);
    }

    public boolean isEmpty() {
        return this.d.getRows().size() <= 0;
    }

    public void clearItems() {
        boolean bl = false;
        List<TicketItemModifier> list = this.e.d.getTicketItemModifiers();
        if (list != null) {
            Iterator<TicketItemModifier> iterator = list.iterator();
            while (iterator.hasNext()) {
                TicketItemModifier ticketItemModifier = iterator.next();
                if (!ticketItemModifier.isPrintedToKitchen().booleanValue()) {
                    if (ticketItemModifier.getSectionName() == null || !ticketItemModifier.getSectionName().equals(this.getSectionName())) continue;
                    iterator.remove();
                    this.e.d.deleteTicketItemModifier(ticketItemModifier);
                    this.d.deleteGivenItem(ticketItemModifier);
                    continue;
                }
                bl = true;
            }
        }
        this.e.f.updateView();
        this.j.repaint();
        this.repaint();
        if (bl) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("PizzaModifierSelectionDialog.84"));
        }
        this.e.c = null;
    }

    public void clearSelectedItem() {
        boolean bl = false;
        if (this.d.getRows() == null) {
            return;
        }
        if (this.d.getRows().size() == 0) {
            return;
        }
        int n = this.j.getSelectedRow();
        if (n < 0) {
            return;
        }
        TicketItemModifier ticketItemModifier = (TicketItemModifier)this.d.getRowData(n);
        if (ticketItemModifier == null) {
            return;
        }
        if (!ticketItemModifier.isPrintedToKitchen().booleanValue()) {
            this.e.d.deleteTicketItemModifier(ticketItemModifier);
            this.d.deleteGivenItem(ticketItemModifier);
            if (this.d.getRows().size() == 0) {
                this.clearItems();
            }
        } else {
            bl = true;
        }
        this.e.f.updateView();
        this.repaint();
        if (bl) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("PizzaModifierSelectionDialog.85"));
        }
        this.e.c = null;
    }

    public void clearItem(TicketItemModifier ticketItemModifier) {
        boolean bl = false;
        List<TicketItemModifier> list = this.getRows();
        if (list == null || list.isEmpty()) {
            return;
        }
        if (!ticketItemModifier.isPrintedToKitchen().booleanValue()) {
            this.e.d.deleteTicketItemModifierByName(ticketItemModifier);
            this.d.deleteGivenItemByName(ticketItemModifier);
            if (list.size() == 0) {
                this.clearItems();
            }
        } else {
            bl = true;
        }
        this.e.f.updateView();
        this.repaint();
        if (bl) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("PizzaModifierSelectionDialog.86"));
        }
        this.e.c = null;
    }

    public void setSelected(boolean bl) {
        this.a = bl;
        this.repaint();
    }

    public boolean isSelected() {
        return this.a;
    }

    public void addItem(TicketItemModifier ticketItemModifier) {
        this.d.addItem(ticketItemModifier);
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.e.setSelectedSection(this);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    public String getSectionName() {
        return this.f;
    }

    public double getPrice() {
        return this.i;
    }

    public double calculatePrice(double d) {
        return d * this.getPrice();
    }

    public void fireTableDataChanged() {
        this.d.fireTableDataChanged();
    }

    public List<TicketItemModifier> getRows() {
        return this.d.getRows();
    }

    class SectionTableCellRenderer
    extends PosTableRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            ITicketItem iTicketItem;
            Component component = null;
            SectionTableModel sectionTableModel = (SectionTableModel)jTable.getModel();
            Object e = sectionTableModel.getRowData(n);
            if (n2 == 1) {
                component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            } else {
                component = super.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
                if (n2 == 0) {
                    this.setHorizontalAlignment(0);
                } else {
                    this.setHorizontalAlignment(4);
                }
            }
            if (bl) {
                component.setBackground(Color.BLUE);
                component.setForeground(Color.WHITE);
                return component;
            }
            component.setBackground(jTable.getBackground());
            component.setForeground(Color.BLACK);
            if (e instanceof TicketItemModifier && (iTicketItem = (ITicketItem)e).isPrintedToKitchen().booleanValue()) {
                component.setBackground(Color.YELLOW);
                component.setForeground(Color.BLACK);
            }
            return component;
        }
    }

    class SectionTableModel
    extends ListTableModel<TicketItemModifier> {
        public SectionTableModel() {
            super(new String[]{Messages.getString("PizzaModifierSelectionDialog.109"), Messages.getString("PizzaModifierSelectionDialog.110")});
        }

        @Override
        public Object getValueAt(int n, int n2) {
            TicketItemModifier ticketItemModifier = (TicketItemModifier)this.rows.get(n);
            if (ticketItemModifier instanceof TicketItemModifier) {
                ticketItemModifier.calculatePrice();
            }
            switch (n2) {
                case 0: {
                    if (ticketItemModifier instanceof TicketItemModifier) {
                        return ticketItemModifier.getName();
                    }
                    return " " + ticketItemModifier.getNameDisplay();
                }
                case 1: {
                    Double d = null;
                    if (ticketItemModifier instanceof TicketItemModifier) {
                        d = ticketItemModifier.getUnitPrice();
                        return NumberUtil.roundToTwoDigit(d);
                    }
                    return null;
                }
            }
            return null;
        }

        public void deleteGivenItem(TicketItemModifier ticketItemModifier) {
            Iterator iterator = this.rows.iterator();
            while (iterator.hasNext()) {
                TicketItemModifier ticketItemModifier2 = (TicketItemModifier)iterator.next();
                if (ticketItemModifier != ticketItemModifier2) continue;
                iterator.remove();
            }
            this.fireTableDataChanged();
        }

        public void deleteGivenItemByName(TicketItemModifier ticketItemModifier) {
            Iterator iterator = this.rows.iterator();
            while (iterator.hasNext()) {
                TicketItemModifier ticketItemModifier2 = (TicketItemModifier)iterator.next();
                if (!ticketItemModifier.getName().equals(ticketItemModifier2.getName())) continue;
                iterator.remove();
            }
            this.fireTableDataChanged();
        }
    }
}

