/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.payment;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.actions.ActionCommand;
import com.floreantpos.actions.CloseDialogAction;
import com.floreantpos.actions.PosAction;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.config.CardConfig;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.swing.ListComboBoxModel;
import com.floreantpos.swing.MultiSelectComboBox;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.TransactionListView;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.payment.AuthorizationDialog;
import com.floreantpos.ui.views.payment.CardProcessor;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;

public class AuthorizableTicketBrowser
extends POSDialog {
    private TransactionListView a = new TransactionListView(Boolean.FALSE);
    private TransactionListView b = new TransactionListView(Boolean.TRUE);
    private JPanel c;
    private POSToggleButton d = new POSToggleButton(Messages.getString("AuthorizableTicketBrowser.12"));
    private POSToggleButton e = new POSToggleButton(Messages.getString("AuthorizableTicketBrowser.13"));
    private User f;
    private Terminal g;
    private PosButton h;
    private JPanel i;
    private PosButton j;
    private PosButton k;
    private PosButton l;
    private JTextField m;
    private JComboBox<Object> n;
    private MultiSelectComboBox<User> o;

    public AuthorizableTicketBrowser(JFrame jFrame, User user, Terminal terminal) {
        super(POSUtil.getFocusedWindow(), Dialog.ModalityType.APPLICATION_MODAL);
        this.f = user;
        this.g = terminal;
        this.a();
    }

    private void a() {
        this.setTitle(POSConstants.AUTHORIZE_BUTTON_TEXT);
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle(Messages.getString("TicketAuthorizationDialog.0"));
        this.add((Component)titlePanel, "North");
        this.c = new JPanel(new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("", "", ""));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.d);
        buttonGroup.add(this.e);
        this.d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AuthorizableTicketBrowser.this.c.remove(AuthorizableTicketBrowser.this.a);
                AuthorizableTicketBrowser.this.c.add(AuthorizableTicketBrowser.this.b);
                AuthorizableTicketBrowser.this.c.revalidate();
                AuthorizableTicketBrowser.this.c.repaint();
                AuthorizableTicketBrowser.this.h.setVisible(true);
                AuthorizableTicketBrowser.this.i.revalidate();
                AuthorizableTicketBrowser.this.i.repaint();
                AuthorizableTicketBrowser.this.j.setVisible(true);
                AuthorizableTicketBrowser.this.k.setVisible(true);
                AuthorizableTicketBrowser.this.l.setVisible(true);
            }
        });
        this.e.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AuthorizableTicketBrowser.this.c.remove(AuthorizableTicketBrowser.this.b);
                AuthorizableTicketBrowser.this.c.add(AuthorizableTicketBrowser.this.a);
                AuthorizableTicketBrowser.this.c.revalidate();
                AuthorizableTicketBrowser.this.c.repaint();
                AuthorizableTicketBrowser.this.h.setVisible(false);
                AuthorizableTicketBrowser.this.i.revalidate();
                AuthorizableTicketBrowser.this.i.repaint();
                AuthorizableTicketBrowser.this.j.setVisible(false);
                AuthorizableTicketBrowser.this.k.setVisible(false);
                AuthorizableTicketBrowser.this.l.setVisible(false);
            }
        });
        jPanel.add(this.d);
        jPanel.add(this.e);
        JPanel jPanel2 = this.b();
        jPanel.add(jPanel2);
        this.d.setSelected(true);
        this.c.add((Component)jPanel, "North");
        this.c.add(this.b);
        this.b.setBorder(BorderFactory.createEmptyBorder(5, 8, 5, 8));
        this.a.setBorder(BorderFactory.createEmptyBorder(5, 8, 5, 8));
        this.h = new PosButton(Messages.getString("ActionCommand.6"));
        this.h.addActionListener(this.c());
        ActionHandler actionHandler = new ActionHandler();
        this.i = new JPanel((LayoutManager)new MigLayout("al center,hidemode 3", "sg, fill", ""));
        this.j = new PosButton(ActionCommand.EDIT_TIPS, actionHandler);
        this.j.setText(ActionCommand.EDIT_TIPS.getDisplayString());
        this.i.add((Component)this.j, "grow");
        this.k = new PosButton(ActionCommand.CAPTURE, actionHandler);
        this.k.setText(ActionCommand.CAPTURE.getDisplayString());
        this.i.add((Component)this.k, "grow");
        this.l = new PosButton(ActionCommand.CAPTURE_ALL, actionHandler);
        this.l.setText(ActionCommand.CAPTURE_ALL.getDisplayString());
        this.i.add((Component)this.l, "grow");
        this.i.add((Component)this.h, "grow");
        PosButton posButton = new PosButton(ActionCommand.VOID_TRANS, actionHandler);
        posButton.setText(ActionCommand.VOID_TRANS.getDisplayString());
        this.i.add((Component)posButton, "grow");
        this.i.add(new PosButton(new CloseDialogAction(this)));
        this.c.add((Component)this.i, "South");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JPanel jPanel4 = new JPanel((LayoutManager)new MigLayout("al center", "sg, fill", ""));
        jPanel4.add((Component)posButton, "grow");
        jPanel4.add(new PosButton(new CloseDialogAction(this)));
        jPanel3.add(this.a);
        jPanel3.add((Component)jPanel4, "South");
        this.add(this.c);
        this.updateTransactiontList();
    }

    private JPanel b() {
        JPanel jPanel = new JPanel();
        try {
            jPanel.setLayout((LayoutManager)new MigLayout("", "[][]15[][]15[][]15[]", "[]5[]"));
            JLabel jLabel = new JLabel(Messages.getString("AuthorizableTicketBrowser.0"));
            this.m = new JTextField(15);
            JLabel jLabel2 = new JLabel(POSConstants.TERMINAL);
            this.n = new JComboBox();
            TerminalDAO terminalDAO = new TerminalDAO();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(0, POSConstants.ALL);
            List<Terminal> list = terminalDAO.findAll();
            for (Terminal serializable2 : list) {
                if (!serializable2.isHasCashDrawer().booleanValue()) continue;
                arrayList.add(serializable2);
            }
            this.n.setModel(new ListComboBoxModel(arrayList));
            JLabel jLabel3 = new JLabel(POSConstants.USER);
            this.o = new MultiSelectComboBox();
            this.o.setItems(UserDAO.getInstance().findAllActive());
            JButton jButton = new JButton(Messages.getString("Search"));
            JButton jButton2 = new JButton(Messages.getString("MenuItemForm.34"));
            jPanel.add((Component)jLabel, "align label");
            jPanel.add(this.m);
            jPanel.add(jLabel2);
            jPanel.add(this.n, "width 120!");
            jPanel.add(jLabel3);
            jPanel.add(this.o);
            jPanel.add(jButton);
            jPanel.add(jButton2);
            jButton.addActionListener(actionEvent -> this.searchTransactiontList());
            jButton2.addActionListener(actionEvent -> this.doClear());
            KeyListener keyListener = new KeyListener(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                }

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    if (AuthorizableTicketBrowser.this.m.getText().length() > 3) {
                        AuthorizableTicketBrowser.this.g();
                        AuthorizableTicketBrowser.this.updateTransactiontList();
                    }
                }

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    int n = keyEvent.getKeyCode();
                    if (n == 10) {
                        AuthorizableTicketBrowser.this.g();
                        AuthorizableTicketBrowser.this.updateTransactiontList();
                    }
                }
            };
            this.m.addKeyListener(keyListener);
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
        return jPanel;
    }

    public void doClear() {
        this.g();
        this.m.setText("");
        this.n.setSelectedIndex(0);
        this.o.setSelectedIndex(0);
        this.o.unselectAllItems();
        this.updateTransactiontList();
    }

    private ActionListener c() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new HideAction().actionPerformed(null);
            }
        };
    }

    public void searchTransactiontList() {
        this.g();
        this.updateTransactiontList();
    }

    public void updateTransactiontList() {
        this.b.getTable().editingStopped(null);
        String string = this.m.getText();
        Terminal terminal = null;
        if (this.n.getSelectedItem() instanceof Terminal) {
            terminal = (Terminal)this.n.getSelectedItem();
        }
        List<User> list = this.o.getSelectedItems();
        List<String> list2 = POSUtil.getStringIds(list, User.class);
        this.b.setTransactions(PosTransactionDAO.getInstance().findUnauthorizedTransactions(string, terminal, list2));
        this.a.setTransactions(PosTransactionDAO.getInstance().findCapturedTransactions(string, terminal, list2));
    }

    private boolean a(String string) {
        int n = JOptionPane.showConfirmDialog(this, string, Messages.getString("CONFIRM"), 2);
        return n == 0;
    }

    private void d() {
        try {
            List<PosTransaction> list = null;
            list = this.e.isSelected() ? this.a.getSelectedTransactions() : this.b.getSelectedTransactions();
            if (list == null || list.size() == 0) {
                POSMessageDialog.showMessage(this, Messages.getString("TicketAuthorizationDialog.2"));
                return;
            }
            if (!this.a(Messages.getString("TicketAuthorizationDialog.3"))) {
                return;
            }
            AuthorizationDialog authorizationDialog = new AuthorizationDialog(this, list);
            authorizationDialog.setVisible(true);
            this.updateTransactiontList();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, Messages.getString("AuthorizableTicketBrowser.5"));
            PosLog.error(this.getClass(), exception);
        }
    }

    public void doAuthorizeAll() {
        try {
            List<PosTransaction> list = this.b.getAllTransactions();
            if (list == null || list.size() == 0) {
                POSMessageDialog.showMessage(this, Messages.getString("TicketAuthorizationDialog.5"));
                return;
            }
            if (!this.a(Messages.getString("TicketAuthorizationDialog.6"))) {
                return;
            }
            AuthorizationDialog authorizationDialog = new AuthorizationDialog(this, list);
            authorizationDialog.setVisible(true);
            this.updateTransactiontList();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, Messages.getString("AuthorizableTicketBrowser.5"));
            PosLog.error(this.getClass(), exception);
        }
    }

    private void e() {
        try {
            PosTransaction posTransaction = null;
            posTransaction = this.e.isSelected() ? this.a.getFirstSelectedTransaction() : this.b.getFirstSelectedTransaction();
            if (posTransaction == null) {
                return;
            }
            Ticket ticket = TicketDAO.getInstance().loadFullTicket(posTransaction.getTicket().getId());
            Set<PosTransaction> set = ticket.getTransactions();
            for (PosTransaction posTransaction2 : set) {
                if (!posTransaction.getId().equals(posTransaction2.getId())) continue;
                posTransaction = posTransaction2;
                break;
            }
            double d = posTransaction.getTipsAmount();
            double d2 = NumberSelectionDialog2.show(this, Messages.getString("EnterTipsAmount"), false, true, d);
            if (Double.isNaN(d2)) {
                return;
            }
            posTransaction.setTipsAmount(NumberUtil.round(d2));
            posTransaction.setAmount(NumberUtil.round(posTransaction.getAmount() - d + d2));
            if (ticket.hasGratuity()) {
                double d3 = ticket.getGratuity().getAmount();
                double d4 = ticket.getPaidAmount();
                double d5 = d3 - d + d2;
                double d6 = d4 - d + d2;
                ticket.setGratuityAmount(NumberUtil.round(d5));
                ticket.setPaidAmount(NumberUtil.round(d6));
            } else {
                ticket.setGratuityAmount(NumberUtil.round(d2));
                ticket.setPaidAmount(NumberUtil.round(ticket.getPaidAmount() + d2));
            }
            ticket.calculatePrice();
            TicketDAO.getInstance().saveOrUpdate(ticket);
            TransactionListView.TransactionListTableModel transactionListTableModel = (TransactionListView.TransactionListTableModel)this.b.getTable().getModel();
            int n = this.b.getTable().getSelectedRow();
            transactionListTableModel.getRows().set(n, posTransaction);
            transactionListTableModel.addEditedRow(posTransaction.getId());
            transactionListTableModel.fireTableRowsUpdated(n, n);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, Messages.getString("AuthorizableTicketBrowser.5"));
            PosLog.error(this.getClass(), exception);
        }
    }

    private void f() {
        try {
            PosTransaction posTransaction = this.b.getSelectedTransaction();
            if (this.e.isSelected()) {
                posTransaction = this.a.getSelectedTransaction();
            }
            if (posTransaction == null) {
                POSMessageDialog.showMessage(this, Messages.getString("AuthorizableTicketBrowser.6"));
                return;
            }
            int n = POSMessageDialog.showYesNoQuestionDialog(this, Messages.getString("AuthorizableTicketBrowser.14"), Messages.getString("CONFIRM"));
            if (n != 0) {
                return;
            }
            CardProcessor cardProcessor = CardConfig.getPaymentGateway().getProcessor();
            cardProcessor.voidTransaction(posTransaction);
            PosTransactionDAO.getInstance().saveOrUpdate(posTransaction);
            POSMessageDialog.showMessage(this, Messages.getString("AuthorizableTicketBrowser.9"));
            this.updateTransactiontList();
        }
        catch (PosException posException) {
            POSMessageDialog.showError(this, posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, Messages.getString("AuthorizableTicketBrowser.10"));
            PosLog.error(this.getClass(), exception);
        }
    }

    private void g() {
        TransactionListView.TransactionListTableModel transactionListTableModel = (TransactionListView.TransactionListTableModel)this.b.getTable().getModel();
        transactionListTableModel.editedTransactionIds.clear();
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ActionCommand actionCommand = ActionCommand.valueOf(actionEvent.getActionCommand());
            try {
                AuthorizableTicketBrowser.this.b.getTable().editingStopped(null);
                switch (actionCommand) {
                    case EDIT_TIPS: {
                        AuthorizableTicketBrowser.this.e();
                        break;
                    }
                    case CAPTURE: {
                        AuthorizableTicketBrowser.this.d();
                        break;
                    }
                    case CAPTURE_ALL: {
                        AuthorizableTicketBrowser.this.doAuthorizeAll();
                        break;
                    }
                    case VOID_TRANS: {
                        AuthorizableTicketBrowser.this.f();
                        break;
                    }
                }
            }
            catch (Exception exception) {
                POSMessageDialog.showError(AuthorizableTicketBrowser.this, exception.getMessage(), exception);
            }
        }
    }

    private class HideAction
    extends PosAction {
        public HideAction() {
            this.setRequiredPermission(UserPermission.PERFORM_MANAGER_TASK);
            this.setMandatoryPermission(true);
        }

        @Override
        public void execute() {
            try {
                List<PosTransaction> list = AuthorizableTicketBrowser.this.b.getSelectedTransactions();
                if (list.isEmpty()) {
                    POSMessageDialog.showMessage(Messages.getString("AuthorizableTicketBrowser.11"));
                    return;
                }
                int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("AuthorizableTicketBrowser.16"), Messages.getString("AuthorizableTicketBrowser.17"));
                if (n == 0) {
                    for (PosTransaction posTransaction : list) {
                        posTransaction.setMarkedCaptured(true);
                        PosTransactionDAO.getInstance().saveOrUpdate(posTransaction);
                    }
                }
                AuthorizableTicketBrowser.this.updateTransactiontList();
            }
            catch (Exception exception) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
                PosLog.error(this.getClass(), exception);
            }
        }

        @Override
        protected User getCurrentUser() {
            return AuthorizableTicketBrowser.this.f;
        }
    }
}

