/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.payment;

import com.floreantpos.Messages;
import com.floreantpos.config.AppProperties;
import com.floreantpos.main.Application;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.ReversalTransaction;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.StoreUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;

public class SessionBasedTransactionBrowser
extends POSDialog {
    private JTable a;
    private TransactionListTableModel b;

    public SessionBasedTransactionBrowser() {
        this.setTitle(AppProperties.getAppName());
        this.b();
        this.a();
    }

    private void a() {
        StoreSession storeSession = StoreUtil.getCurrentStoreSession();
        List<PosTransaction> list = PosTransactionDAO.getInstance().getStoreSessionTransactions(storeSession);
        this.b.setRows(list);
    }

    private void b() {
        this.setLayout(new BorderLayout(5, 5));
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle(Messages.getString("SessionBasedTransactionBrowser.0"));
        this.add((Component)titlePanel, "North");
        this.a = new JTable();
        this.b = new TransactionListTableModel();
        this.a.setModel(this.b);
        this.a.setRowHeight(PosUIManager.getSize(40));
        this.a.setAutoResizeMode(3);
        this.a.setDefaultRenderer(Object.class, new PosTableRenderer());
        this.a.setGridColor(Color.LIGHT_GRAY);
        PosScrollPane posScrollPane = new PosScrollPane(this.a, 20, 31);
        JScrollBar jScrollBar = posScrollPane.getVerticalScrollBar();
        jScrollBar.setPreferredSize(PosUIManager.getSize(30, 60));
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        TitledBorder titledBorder = BorderFactory.createTitledBorder(null, Messages.getString("SessionBasedTransactionBrowser.2"), 2, 0);
        jPanel.setBorder(titledBorder);
        jPanel.add((Component)posScrollPane, "grow");
        this.add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("center"));
        PosButton posButton = new PosButton(Messages.getString("DELETE"));
        posButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SessionBasedTransactionBrowser.this.c();
            }
        });
        PosButton posButton2 = new PosButton(Messages.getString("SessionBasedTransactionBrowser.6"));
        posButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SessionBasedTransactionBrowser.this.dispose();
            }
        });
        jPanel2.add(posButton);
        jPanel2.add(posButton2);
        this.add((Component)jPanel2, "South");
    }

    private void c() {
        int n = this.a.getSelectedRow();
        if (n < 0) {
            return;
        }
        int n2 = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("SessionBasedTransactionBrowser.7"), Messages.getString("SessionBasedTransactionBrowser.8"));
        if (n2 != 0) {
            return;
        }
        n = this.a.convertRowIndexToModel(n);
        PosTransaction posTransaction = (PosTransaction)this.b.getRowData(n);
        Ticket ticket = posTransaction.getTicket();
        TicketDAO.getInstance().loadFullTicket(ticket);
        double d = ticket.getDueAmount();
        double d2 = posTransaction.getAmount();
        ticket.setDueAmount(NumberUtil.round(d + d2));
        ticket.setPaidAmount(0.0);
        ticket.setPaid(false);
        ticket.setClosed(false);
        ticket.setClosingDate(null);
        ticket.getTransactions().remove(posTransaction);
        ReversalTransaction reversalTransaction = new ReversalTransaction();
        reversalTransaction.setPaymentType(PaymentType.CASH);
        reversalTransaction.setTicket(ticket);
        reversalTransaction.setCaptured(true);
        reversalTransaction.setAmount(d2);
        reversalTransaction.setTransactionTime(new Date());
        reversalTransaction.setTerminal(Application.getInstance().getTerminal());
        User user = Application.getCurrentUser();
        reversalTransaction.setUser(user);
        reversalTransaction.setServer(user);
        reversalTransaction.setNote(Messages.getString("SessionBasedTransactionBrowser.9") + (Object)((Object)posTransaction.getPaymentType()));
        PosTransactionDAO.getInstance().saveReversalTransaction(ticket, posTransaction, reversalTransaction);
        this.b.deleteItem(posTransaction);
        this.b.fireTableDataChanged();
        this.a.repaint();
        this.a.revalidate();
    }

    private class TransactionListTableModel
    extends ListTableModel<PosTransaction> {
        public TransactionListTableModel() {
            super(new String[]{Messages.getString("SessionBasedTransactionBrowser.10"), Messages.getString("SessionBasedTransactionBrowser.11"), Messages.getString("SessionBasedTransactionBrowser.12"), Messages.getString("SessionBasedTransactionBrowser.13"), Messages.getString("SessionBasedTransactionBrowser.14"), Messages.getString("SessionBasedTransactionBrowser.15"), Messages.getString("SessionBasedTransactionBrowser.16"), Messages.getString("SessionBasedTransactionBrowser.17")});
        }

        @Override
        public Object getValueAt(int n, int n2) {
            PosTransaction posTransaction = (PosTransaction)this.rows.get(n);
            Ticket ticket = posTransaction.getTicket();
            switch (n2) {
                case 0: {
                    return posTransaction.getId();
                }
                case 1: {
                    return ticket.getId();
                }
                case 2: {
                    User user = ticket.getOwner();
                    if (user == null) {
                        return null;
                    }
                    return user.getFirstName();
                }
                case 3: {
                    return posTransaction.getTransactionTime();
                }
                case 4: {
                    return posTransaction.getPaymentType().getDisplayString();
                }
                case 5: {
                    return posTransaction.getTipsAmount();
                }
                case 6: {
                    return posTransaction.getAmount() - posTransaction.getTipsAmount();
                }
                case 7: {
                    return posTransaction.getAmount();
                }
            }
            return null;
        }
    }
}

