/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.payment;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.actions.PosAction;
import com.floreantpos.actions.TaxExemptAction;
import com.floreantpos.config.CardConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.CustomPaymentTransaction;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.swing.ButtonColumn;
import com.floreantpos.swing.ButtonColumnWithLabel;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.UpdatableView;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.ticket.TicketViewerTable;
import com.floreantpos.ui.ticket.TicketViewerTableChangeListener;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.payment.AuthorizationDialog;
import com.floreantpos.ui.views.payment.BusyDialog;
import com.floreantpos.ui.views.payment.CardProcessor;
import com.floreantpos.ui.views.payment.PaymentListener;
import com.floreantpos.ui.views.payment.PaymentView;
import com.floreantpos.ui.views.payment.SettleTicketProcessor;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.jidesoft.swing.TitledSeparator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import jiconfont.IconCode;
import jiconfont.icons.GoogleMaterialDesignIcons;
import jiconfont.swing.IconFontSwing;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.hibernate.StaleStateException;

public class SettleTicketDialog
extends POSDialog
implements RefreshableView,
UpdatableView,
TicketViewerTableChangeListener,
PaymentListener {
    private PaymentView a;
    private TicketViewerTable b;
    private JScrollPane c;
    private Ticket d;
    private JTextField e;
    private JTextField f;
    private JTextField g = new JTextField();
    private JTextField h = new JTextField();
    private JTextField i;
    private JTextField j;
    private JTextField k;
    private JTextField l;
    private JTextField m;
    private JPanel n;
    private JPanel o;
    private JScrollPane p;
    private JPanel q;
    private SettleTicketProcessor r = null;
    private JTable s;
    private TicketDiscountTableModel t;
    private JPanel u;
    private JTable v;
    private TransactionDataTableModel w;
    private JLabel x;
    private JLabel y;
    private JButton z;

    public SettleTicketDialog(Ticket ticket, User user) {
        this.d = ticket;
        this.r = new SettleTicketProcessor(user, this);
        if (ticket.getOrderType().isConsolidateItemsInReceipt().booleanValue()) {
            ticket.consolidateTicketItems();
        }
        this.setTitle(Messages.getString("SettleTicketDialog.6"));
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.q = new JPanel(new BorderLayout(5, 5));
        this.q.setBorder(BorderFactory.createEmptyBorder(5, 5, 3, 5));
        this.b = new TicketViewerTable(ticket);
        this.b.getModel().addTicketDataChangeListener(this);
        this.b.setVisibleDeleteButton(0);
        this.b.getModel().setEditable(true);
        this.c = new PosScrollPane(this.b);
        TitledSeparator titledSeparator = new TitledSeparator((JComponent)this.a(), 0);
        this.c.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(""), BorderFactory.createEmptyBorder(0, 0, 0, 0)));
        this.b.getTableHeader().setPreferredSize(PosUIManager.getSize(0, 35));
        this.n = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.n.add((Component)jPanel2, "Center");
        this.o = new JPanel((LayoutManager)new MigLayout("fill"));
        this.p = new JScrollPane(this.o);
        this.p.setPreferredSize(PosUIManager.getSize(0, 70));
        this.p.setVisible(false);
        this.n.add((Component)this.p, "North");
        this.q.add((Component)titledSeparator, "North");
        this.q.add((Component)this.c, "Center");
        this.q.add((Component)this.n, "South");
        this.a = new PaymentView(this.r, this);
        jPanel2.add((Component)this.g(), "East");
        this.getContentPane().add((Component)this.q, "Center");
        this.getContentPane().add((Component)this.a, "East");
        this.createTicketDiscountPanel();
        this.createTransactionListPanel();
        jPanel2.add((Component)this.u, "Center");
        this.r.addPaymentListener(this);
        this.updateView();
        this.a.setTicket(ticket);
        this.r.setTicket(ticket);
        this.a.setDefaultFocus();
        this.a.updateView();
    }

    @Override
    public void updateView() {
        if (this.d == null) {
            this.e.setText("");
            this.f.setText("");
            this.i.setText("");
            this.j.setText("");
            this.k.setText("");
            this.g.setText("");
            this.h.setText("");
            this.l.setText("");
            this.m.setText("");
            return;
        }
        this.b();
        this.e.setText(NumberUtil.formatNumber(this.d.getSubtotalAmount(), true));
        this.f.setText(NumberUtil.formatNumber(this.d.getDiscountAmount(), true));
        this.i.setText(NumberUtil.formatNumber(this.d.getDeliveryCharge()));
        this.k.setText(NumberUtil.formatNumberAcceptNegative(this.d.getServiceCharge()));
        Store store = DataProvider.get().getStore();
        if (POSUtil.getBoolean(store.getProperty("show_tax_exempt_button.in_settlement_screen"))) {
            this.z.setVisible(Boolean.TRUE);
            if (this.d.isTaxExempt().booleanValue()) {
                this.z.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.UNDO, (float)15.0f));
            } else {
                this.z.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.CLEAR, (float)15.0f));
            }
        } else {
            this.z.setVisible(Boolean.FALSE);
        }
        if (this.d.isTaxIncluded().booleanValue()) {
            this.j.setText(Messages.getString("TicketView.35"));
        } else {
            this.j.setText(NumberUtil.formatNumber(this.d.getTaxAmount(), true));
        }
        if (this.d.getGratuity() != null) {
            this.m.setText(NumberUtil.formatNumber(this.d.getGratuity().getAmount()));
        } else {
            this.m.setText(NumberUtil.formatNumber(0));
        }
        Double d = this.d.getRefundAmount();
        this.g.setText(NumberUtil.formatNumber(d));
        this.h.setText(NumberUtil.formatNumber(this.d.getPaidAmount()));
        this.l.setText(NumberUtil.formatNumber(this.d.getTotalAmountWithTips(), true));
        this.x.setVisible(d > 0.0);
        this.g.setVisible(d > 0.0);
        this.e();
        this.f();
        OrderView.getInstance().getOrderController().fireTicketEdited(this.d);
    }

    private JPanel a() {
        JLabel jLabel = new JLabel();
        Font font = jLabel.getFont().deriveFont(1);
        this.y = new JLabel();
        Font font2 = this.y.getFont().deriveFont(1);
        this.y.setFont(font2);
        jLabel.setFont(font);
        jLabel.setText(" " + Messages.getString("SettleTicketDialog.3"));
        JLabel jLabel2 = new JLabel();
        jLabel2.setFont(font2);
        if (!this.i().isShowTableNumber()) {
            jLabel2.setText(" " + this.d.getTableNames());
        } else {
            jLabel2.setText(" " + this.d.getTableNameDisplay());
            if (this.d.getTableNumbers() == null || this.d.getTableNumbers().isEmpty()) {
                jLabel2.setVisible(false);
                jLabel.setVisible(false);
            }
        }
        JLabel jLabel3 = new JLabel();
        jLabel3.setFont(font);
        jLabel3.setText(", " + Messages.getString("SettleTicketDialog.10") + ": ");
        JLabel jLabel4 = new JLabel();
        jLabel4.setFont(font2);
        String string = this.d.getCustomerNameByProperty();
        if (string.length() > 30) {
            string = string.substring(0, 30) + "...";
        }
        jLabel4.setText(string);
        if (this.d.getProperty("CUSTOMER_NAME") == null) {
            jLabel4.setVisible(false);
            jLabel3.setVisible(false);
        }
        TransparentPanel transparentPanel = new TransparentPanel((LayoutManager)new MigLayout("hidemode 3,ins 0", "[]0[]0[]0[]0[]0[]", "[]"));
        transparentPanel.add(this.y);
        transparentPanel.add(jLabel);
        transparentPanel.add(jLabel2);
        transparentPanel.add(jLabel3);
        transparentPanel.add(jLabel4);
        Color color = UIManager.getColor("TitledBorder.titleColor");
        this.y.setForeground(color);
        jLabel.setForeground(color);
        jLabel2.setForeground(color);
        jLabel3.setForeground(color);
        jLabel4.setForeground(color);
        return transparentPanel;
    }

    private void b() {
        if (this.d.getTokenNo() > 0) {
            this.y.setText(String.valueOf(Messages.getString("SettleTicketDialog.0") + "# " + this.d.getTokenNo()));
        } else {
            this.y.setText(Messages.getString("SettleTicketDialog.13"));
        }
    }

    public void createTransactionListPanel() {
        this.u = new JPanel(new BorderLayout());
        this.v = new JTable();
        this.v.setGridColor(Color.LIGHT_GRAY);
        this.v.setCellSelectionEnabled(false);
        this.v.setColumnSelectionAllowed(false);
        this.v.setRowSelectionAllowed(false);
        this.v.setAutoscrolls(true);
        this.v.setRowHeight(PosUIManager.getSize(40));
        this.v.setShowVerticalLines(false);
        this.v.setIntercellSpacing(new Dimension(0, 2));
        this.v.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.v.setFocusable(false);
        this.v.getTableHeader().setPreferredSize(new Dimension(0, 0));
        this.v.getTableHeader().setVisible(false);
        this.v.setAutoResizeMode(4);
        this.w = new TransactionDataTableModel();
        this.v.setModel(this.w);
        this.a(1, PosUIManager.getSize(80), this.v);
        this.a(2, PosUIManager.getSize(50), this.v);
        this.a(3, PosUIManager.getSize(50), this.v);
        this.d();
        this.j();
        this.c();
        PosScrollPane posScrollPane = new PosScrollPane(this.v);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Messages.getString("SettleTicketDialog.24")), BorderFactory.createEmptyBorder(0, 5, 0, 5));
        posScrollPane.setBorder(compoundBorder);
        this.u.add(posScrollPane);
        posScrollPane.setPreferredSize(PosUIManager.getSize(0, 130));
        this.u.setVisible(false);
        this.f();
    }

    private void c() {
        PosAction posAction = new PosAction(){
            int a = -1;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.a = Integer.parseInt(actionEvent.getActionCommand());
                super.actionPerformed(actionEvent);
            }

            @Override
            public void execute() {
                if (this.a == -1) {
                    return;
                }
                PosTransaction posTransaction = (PosTransaction)SettleTicketDialog.this.w.getRowData(this.a);
                if (posTransaction == null) {
                    return;
                }
                SettleTicketDialog.this.b(posTransaction);
            }
        };
        posAction.setRequiredPermission(UserPermission.AUTHORIZE_TICKETS);
        ButtonColumn buttonColumn = new ButtonColumn(this.v, posAction, 1){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                PosButton posButton = (PosButton)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                PosTransaction posTransaction = (PosTransaction)SettleTicketDialog.this.w.getRowData(n);
                if (posTransaction.isCard() && posTransaction.isAuthorizable().booleanValue() && !posTransaction.isCaptured().booleanValue()) {
                    posButton.setText(Messages.getString("SettleTicketDialog.15"));
                    posButton.setHorizontalAlignment(0);
                    jTable.setRowHeight(n, jTable.getRowHeight(0));
                    return posButton;
                }
                return new JLabel("");
            }

            @Override
            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                PosTransaction posTransaction = (PosTransaction)SettleTicketDialog.this.w.getRowData(n);
                if (posTransaction.isCard() && posTransaction.isAuthorizable().booleanValue() && !posTransaction.isCaptured().booleanValue()) {
                    return super.getTableCellEditorComponent(jTable, object, false, n, n2);
                }
                return new JLabel("");
            }
        };
        MatteBorder matteBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, this.v.getBackground());
        PosButton posButton = new PosButton();
        buttonColumn.setUnselectedBorder(new CompoundBorder(matteBorder, posButton.getBorder()));
        buttonColumn.setFocusBorder(new CompoundBorder(matteBorder, posButton.getBorder()));
    }

    private void d() {
        PosAction posAction = new PosAction(){
            int a = -1;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.a = Integer.parseInt(actionEvent.getActionCommand());
                super.actionPerformed(actionEvent);
            }

            @Override
            public void execute() {
                if (this.a == -1) {
                    return;
                }
                PosTransaction posTransaction = (PosTransaction)SettleTicketDialog.this.w.getRowData(this.a);
                if (posTransaction == null) {
                    return;
                }
                SettleTicketDialog.this.a(posTransaction);
            }
        };
        posAction.setRequiredPermission(UserPermission.VOID_PAYMENTS);
        ButtonColumn buttonColumn = new ButtonColumn(this.v, posAction, 3){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                PosButton posButton = (PosButton)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                posButton.setText("X");
                posButton.setHorizontalAlignment(0);
                jTable.setRowHeight(n, jTable.getRowHeight(0));
                return posButton;
            }

            @Override
            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                return super.getTableCellEditorComponent(jTable, object, false, n, n2);
            }
        };
        MatteBorder matteBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, this.v.getBackground());
        PosButton posButton = new PosButton();
        buttonColumn.setUnselectedBorder(new CompoundBorder(matteBorder, posButton.getBorder()));
        buttonColumn.setFocusBorder(new CompoundBorder(matteBorder, posButton.getBorder()));
    }

    private void a(final PosTransaction posTransaction) {
        if (this.d.isRefunded().booleanValue()) {
            POSMessageDialog.showError(this, Messages.getString("SettleTicketDialog.25"));
            return;
        }
        if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("SettleTicketDialog.26"), POSConstants.CONFIRM) != 0) {
            return;
        }
        final BusyDialog busyDialog = new BusyDialog();
        busyDialog.setCaption(Messages.getString("SettleTicketDialog.18"));
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                TicketDAO.getInstance().reversePayment(SettleTicketDialog.this.d, posTransaction);
                ActionHistoryDAO.saveHistory(SettleTicketDialog.this.d, "Void payment", "Check#:" + SettleTicketDialog.this.d.getId() + " Voided payment#:" + posTransaction.getId());
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                    busyDialog.dispose();
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("SettleTicketDialog.27"));
                    SettleTicketDialog.this.ticketDataChanged();
                }
                catch (Exception exception) {
                    busyDialog.dispose();
                    Throwable throwable = exception.getCause();
                    if (throwable instanceof PosException) {
                        POSMessageDialog.showError(throwable.getMessage());
                    } else if (throwable instanceof StaleStateException) {
                        POSMessageDialog.showError(Messages.getString("SplitedTicketSelectionDialog.0"));
                        SettleTicketDialog.this.refresh();
                    } else {
                        POSMessageDialog.showError(throwable.getMessage(), throwable);
                    }
                }
                finally {
                    busyDialog.dispose();
                }
            }
        };
        swingWorker.execute();
        busyDialog.setVisible(true);
    }

    private void b(PosTransaction posTransaction) {
        try {
            if (!this.c(posTransaction)) {
                return;
            }
            ArrayList<PosTransaction> arrayList = new ArrayList<PosTransaction>();
            arrayList.add(posTransaction);
            AuthorizationDialog authorizationDialog = new AuthorizationDialog(this, arrayList);
            authorizationDialog.setVisible(true);
            this.d.closeIfApplicable();
            TicketDAO.getInstance().update(this.d);
            this.updateView();
        }
        catch (Exception exception) {
            this.d = TicketDAO.getInstance().loadFullTicket(this.d.getId());
            this.updateView();
            POSMessageDialog.showError(this, exception.getMessage());
            PosLog.error(this.getClass(), exception);
        }
    }

    private boolean c(PosTransaction posTransaction) {
        double d = posTransaction.getTipsAmount();
        double d2 = NumberSelectionDialog2.takeDoubleInput(Messages.getString("EnterTipsAmount"), d, true);
        if (d2 == -1.0) {
            return false;
        }
        posTransaction.setTipsAmount(NumberUtil.round(d2));
        posTransaction.setAmount(NumberUtil.round(posTransaction.getAmount() - d + d2));
        if (this.d.hasGratuity()) {
            double d3 = this.d.getGratuity().getAmount();
            double d4 = this.d.getPaidAmount();
            double d5 = d3 - d + d2;
            double d6 = d4 - d + d2;
            this.d.setGratuityAmount(NumberUtil.round(d5));
            this.d.setPaidAmount(NumberUtil.round(d6));
        } else {
            this.d.setGratuityAmount(NumberUtil.round(d2));
            this.d.setPaidAmount(NumberUtil.round(this.d.getPaidAmount() + d2));
        }
        this.d.calculatePrice();
        return true;
    }

    public void createTicketDiscountPanel() {
        this.o = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3,ins 2 0 0 0"));
        this.s = new JTable();
        this.s.setGridColor(Color.LIGHT_GRAY);
        this.s.setCellSelectionEnabled(false);
        this.s.setColumnSelectionAllowed(false);
        this.s.setRowSelectionAllowed(false);
        this.s.setAutoscrolls(true);
        this.s.setRowHeight(PosUIManager.getSize(40));
        this.s.setShowGrid(true);
        this.s.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.s.setFocusable(false);
        this.s.getTableHeader().setPreferredSize(new Dimension(0, 0));
        this.s.getTableHeader().setVisible(false);
        this.s.setAutoResizeMode(4);
        this.t = new TicketDiscountTableModel();
        this.s.setModel(this.t);
        this.s.getColumnModel().getColumn(2).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
                this.setHorizontalAlignment(4);
                if (bl) {
                    return component;
                }
                component.setBackground(jTable.getBackground());
                return component;
            }

            @Override
            protected void setValue(Object object) {
                if (object == null) {
                    this.setText("");
                    return;
                }
                String string = object.toString();
                if (object instanceof Double || object instanceof Float) {
                    string = NumberUtil.formatNumberAcceptNegative(((Number)object).doubleValue());
                }
                this.setText(string);
            }
        });
        this.a(1, PosUIManager.getSize(50), this.s);
        this.a(2, PosUIManager.getSize(175), this.s);
        this.s.removeColumn(this.s.getColumnModel().getColumn(1));
        JLabel jLabel = new JLabel(Messages.getString("SettleTicketDialog.30"));
        this.o.add((Component)jLabel, "wrap");
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = Integer.parseInt(actionEvent.getActionCommand());
                TicketDiscount ticketDiscount = (TicketDiscount)SettleTicketDialog.this.t.getRowData(n);
                List<TicketDiscount> list = SettleTicketDialog.this.d.getDiscounts();
                if (list != null) {
                    Iterator<TicketDiscount> iterator = list.iterator();
                    while (iterator.hasNext()) {
                        TicketDiscount ticketDiscount2 = iterator.next();
                        if (ticketDiscount2 != ticketDiscount) continue;
                        iterator.remove();
                        ActionHistoryDAO.addDiscountRemovedActionHistory(SettleTicketDialog.this.d, ticketDiscount2);
                        break;
                    }
                    SettleTicketDialog.this.ticketDataChanged();
                }
                SettleTicketDialog.this.d.setDiscounts(list);
            }
        };
        new ButtonColumnWithLabel(this.s, abstractAction, 0, "delete-icon.png", false){

            @Override
            public boolean hasButtonAction(int n) {
                return true;
            }
        };
        JScrollPane jScrollPane = new JScrollPane(this.s);
        this.o.add((Component)jScrollPane, "newline,grow,span");
        jScrollPane.setPreferredSize(PosUIManager.getSize(0, 70));
        this.o.setVisible(false);
        this.n.add((Component)this.o, "North");
        this.e();
    }

    private void a(int n, int n2, JTable jTable) {
        TableColumn tableColumn = jTable.getColumnModel().getColumn(n);
        tableColumn.setPreferredWidth(n2);
        tableColumn.setMaxWidth(n2);
        tableColumn.setMinWidth(n2);
    }

    private void e() {
        List<TicketDiscount> list = this.d.getDiscounts();
        this.t.setRows(list);
        this.o.setVisible(list != null && list.size() > 0);
        this.q.revalidate();
        this.q.repaint();
        this.repaint();
    }

    private void f() {
        Set<PosTransaction> set = this.d.getTransactions();
        if (set == null || set.size() == 0) {
            return;
        }
        ArrayList<PosTransaction> arrayList = new ArrayList<PosTransaction>();
        for (PosTransaction posTransaction : set) {
            if (posTransaction.isVoided().booleanValue() || posTransaction instanceof RefundTransaction) continue;
            arrayList.add(posTransaction);
        }
        Collections.sort(arrayList, new Comparator<PosTransaction>(){

            @Override
            public int compare(PosTransaction posTransaction, PosTransaction posTransaction2) {
                return posTransaction.getTransactionTime().compareTo(posTransaction2.getTransactionTime());
            }
        });
        this.w.setRows(arrayList);
        this.u.setVisible(arrayList.size() > 0);
        this.q.revalidate();
        this.q.repaint();
        this.repaint();
    }

    private JPanel g() {
        JLabel jLabel = new JLabel();
        jLabel.setHorizontalAlignment(4);
        jLabel.setText(POSConstants.SUBTOTAL + ": " + CurrencyUtil.getCurrencySymbol());
        this.e = new JTextField(10);
        this.e.setHorizontalAlignment(11);
        this.e.setEditable(false);
        JLabel jLabel2 = new JLabel();
        jLabel2.setHorizontalAlignment(4);
        jLabel2.setText(Messages.getString("TicketView.9") + " " + CurrencyUtil.getCurrencySymbol());
        this.f = new JTextField(10);
        this.f.setHorizontalAlignment(11);
        this.f.setEditable(false);
        this.f.setText(this.d.getDiscountAmount().toString());
        JLabel jLabel3 = new JLabel();
        jLabel3.setHorizontalAlignment(4);
        jLabel3.setText(Messages.getString("SettleTicketDialog.1") + " " + CurrencyUtil.getCurrencySymbol());
        this.i = new JTextField(10);
        this.i.setHorizontalAlignment(11);
        this.i.setEditable(false);
        JLabel jLabel4 = new JLabel();
        jLabel4.setHorizontalAlignment(4);
        jLabel4.setText(POSConstants.TAX + ": " + CurrencyUtil.getCurrencySymbol());
        this.z = new JButton();
        this.z.setVisible(false);
        this.z.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.CLEAR, (float)15.0f));
        this.z.addActionListener(actionEvent -> this.h());
        this.j = new JTextField(10);
        this.j.setEditable(false);
        this.j.setHorizontalAlignment(11);
        JLabel jLabel5 = new JLabel();
        jLabel5.setHorizontalAlignment(4);
        jLabel5.setText(Messages.getString("SettleTicketDialog.2") + " " + CurrencyUtil.getCurrencySymbol());
        this.k = new JTextField(10);
        this.k.setEditable(false);
        this.k.setHorizontalAlignment(11);
        this.g.setEditable(false);
        this.g.setHorizontalAlignment(11);
        this.h.setEditable(false);
        this.h.setHorizontalAlignment(11);
        JLabel jLabel6 = new JLabel();
        jLabel6.setHorizontalAlignment(4);
        jLabel6.setText(Messages.getString("SettleTicketDialog.5") + ": " + CurrencyUtil.getCurrencySymbol());
        this.m = new JTextField(10);
        this.m.setEditable(false);
        this.m.setHorizontalAlignment(11);
        JLabel jLabel7 = new JLabel();
        jLabel7.setFont(jLabel7.getFont().deriveFont(1, PosUIManager.getFontSize(18)));
        jLabel7.setHorizontalAlignment(4);
        jLabel7.setText(POSConstants.TOTAL + ": " + CurrencyUtil.getCurrencySymbol());
        this.l = new JTextField(10);
        this.l.setFont(this.l.getFont().deriveFont(1, PosUIManager.getFontSize(18)));
        this.l.setHorizontalAlignment(11);
        this.l.setEditable(false);
        TransparentPanel transparentPanel = new TransparentPanel((LayoutManager)new MigLayout("fillx,hidemode 3,ins 2 10 3 2,alignx trailing", "[grow]2[]", ""));
        transparentPanel.add((Component)jLabel, "growx,aligny center");
        transparentPanel.add((Component)this.e, "growx,aligny center");
        transparentPanel.add((Component)jLabel2, "newline,growx,aligny center");
        transparentPanel.add((Component)this.f, "growx,aligny center");
        transparentPanel.add((Component)jLabel5, "newline,growx,aligny center");
        transparentPanel.add((Component)this.k, "growx,aligny center");
        transparentPanel.add((Component)jLabel4, "newline,growx,aligny center");
        transparentPanel.add((Component)this.z, "growx,aligny center,split 2");
        transparentPanel.add((Component)this.j, "growx,aligny center");
        if (this.d.getDeliveryCharge() > 0.0) {
            transparentPanel.add((Component)jLabel3, "newline,growx,aligny center");
            transparentPanel.add((Component)this.i, "growx,aligny center");
        }
        transparentPanel.add((Component)jLabel6, "newline,growx,aligny center");
        transparentPanel.add((Component)this.m, "growx,aligny center");
        transparentPanel.add((Component)jLabel7, "newline,growx,aligny center");
        transparentPanel.add((Component)this.l, "growx,aligny center");
        transparentPanel.add((Component)new JLabel(Messages.getString("SettleTicketDialog.36") + CurrencyUtil.getCurrencySymbol(), 11), "newline,growx,aligny center");
        transparentPanel.add((Component)this.h, "growx,aligny center");
        this.x = new JLabel(Messages.getString("SettleTicketDialog.37") + CurrencyUtil.getCurrencySymbol(), 11);
        transparentPanel.add((Component)this.x, "newline,growx,aligny center");
        transparentPanel.add((Component)this.g, "growx,aligny center");
        return transparentPanel;
    }

    private void h() {
        try {
            if (this.d.getPaidAmount() > 0.0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CANNOT_CHENGED_TAX_EXAMPT"));
                return;
            }
            Boolean bl = this.d.isTaxExempt();
            String string = bl != false ? Messages.getString("SettleTicketDialog.19") : Messages.getString("SettleTicketDialog.4");
            int n = POSMessageDialog.showYesNoQuestionDialog(this, string, POSConstants.CONFIRM);
            if (n != 0) {
                return;
            }
            new TaxExemptAction(this.d, this, this.a).actionPerformed(null);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
        }
    }

    @Override
    public void open() {
        super.open();
    }

    public Ticket getTicket() {
        return this.d;
    }

    public void setTicket(Ticket ticket) {
        this.d = ticket;
        this.r.setTicket(ticket);
        this.b.setTicket(ticket);
        this.a.setTicket(ticket);
    }

    @Override
    public void paymentCanceled() {
        this.setCanceled(true);
        this.dispose();
    }

    @Override
    public void paymentDone() {
        this.setCanceled(false);
        this.dispose();
    }

    @Override
    public void paymentDataChanged() {
        this.updateView();
        this.a.updateView();
        this.b.updateView();
    }

    @Override
    public void discountUpdated() {
        this.updateView();
        this.a.updateView();
        this.b.updateView();
    }

    @Override
    public void gratuityUpdated() {
        this.updateView();
        this.a.updateView();
        this.b.updateView();
    }

    public SettleTicketProcessor getTicketProcessor() {
        return this.r;
    }

    @Override
    public void ticketDataChanged() {
        this.d.calculatePrice();
        this.updateView();
        this.b.updateView();
        this.a.updateView();
    }

    private Terminal i() {
        return Application.getInstance().getTerminal();
    }

    @Override
    public void refresh() {
        Ticket ticket = TicketDAO.getInstance().loadFullTicket(this.getTicket().getId());
        this.setTicket(ticket);
        this.ticketDataChanged();
    }

    public void settleBartab() throws Exception {
        String string;
        String string2;
        String string3;
        String string4;
        int n;
        PosTransaction posTransaction = this.d.getBartabTransaction();
        if (posTransaction != null && !posTransaction.isCaptured().booleanValue() && !posTransaction.isVoided().booleanValue() && (n = POSMessageDialog.showYesNoQuestionDialog(this, string4 = Messages.getString("SettleTicketDialog.53"), string3 = Messages.getString("SettleTicketDialog.54"), string2 = Messages.getString("SettleTicketDialog.55"), string = Messages.getString("SettleTicketDialog.56"))) == 0) {
            this.d(posTransaction);
            return;
        }
        int n2 = POSMessageDialog.showYesNoQuestionDialog(this, Messages.getString("SettleTicketDialog.57"), Messages.getString("SettleTicketDialog.58"), Messages.getString("SettleTicketDialog.59"), Messages.getString("Cancel"));
        if (n2 != 0) {
            POSMessageDialog.showMessage(Messages.getString("SettleTicketDialog.61"));
            this.setCanceled(true);
            this.dispose();
            return;
        }
        this.doVoidBartab(posTransaction);
    }

    private void d(PosTransaction posTransaction) throws Exception {
        OrderType orderType;
        ReceiptPrintService.printTicket(this.d);
        double d = NumberSelectionDialog2.takeDoubleInput(Messages.getString("EnterTipsAmount"), 0.0);
        if (d > 0.0) {
            this.d.setGratuityAmount(d);
            this.d.calculatePrice();
            posTransaction.setTipsAmount(d);
        }
        Double d2 = this.d.getDueAmount();
        posTransaction.setTenderAmount(d2);
        posTransaction.setAmount(d2);
        this.r.setTenderAmount(d2);
        this.captureBartabTransaction(posTransaction);
        this.d.setPaidAmount(this.d.getPaidAmount() + posTransaction.getAmount());
        this.d.calculatePrice();
        d2 = this.d.getDueAmount() + posTransaction.getAmount();
        if (this.d.getDueAmount() == 0.0) {
            this.d.setPaid(true);
            orderType = this.d.getOrderType();
            if (orderType.isCloseOnPaid().booleanValue()) {
                this.d.setClosed(true);
                this.d.setClosingDate(new Date());
            }
        }
        orderType = null;
        try (Session session = TicketDAO.getInstance().createNewSession();){
            orderType = session.beginTransaction();
            TicketDAO.getInstance().update(this.d, session);
            orderType.commit();
            this.r.doAfterSettleTask(posTransaction, d2, true);
        }
        catch (Exception exception) {
            if (orderType != null) {
                orderType.rollback();
            }
            throw exception;
        }
    }

    public boolean captureBartabTransaction(PosTransaction posTransaction) throws Exception {
        CardProcessor cardProcessor = CardConfig.getPaymentGateway().getProcessor();
        cardProcessor.captureAuthAmount(posTransaction);
        return true;
    }

    public void doVoidBartab(final PosTransaction posTransaction) throws Exception, PosException {
        if (posTransaction == null || posTransaction.isVoided().booleanValue() || posTransaction.isCaptured().booleanValue()) {
            return;
        }
        final BusyDialog busyDialog = new BusyDialog();
        busyDialog.setCaption(Messages.getString("SettleTicketDialog.18"));
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                TicketDAO.getInstance().reversePreAuthorizedTabPayment(SettleTicketDialog.this.d, posTransaction);
                ActionHistoryDAO.saveHistory(SettleTicketDialog.this.d, "Void payment", "Check#:" + SettleTicketDialog.this.d.getId() + " Voided payment#:" + posTransaction.getId());
                return null;
            }

            @Override
            protected void done() {
                try {
                    busyDialog.dispose();
                    POSMessageDialog.showMessage(Messages.getString("SettleTicketDialog.62"));
                    SettleTicketDialog.this.ticketDataChanged();
                }
                catch (Exception exception) {
                    busyDialog.dispose();
                    Throwable throwable = exception.getCause();
                    if (throwable instanceof PosException) {
                        POSMessageDialog.showError(throwable.getMessage());
                    } else if (throwable instanceof StaleStateException) {
                        POSMessageDialog.showError(Messages.getString("SplitedTicketSelectionDialog.0"));
                        SettleTicketDialog.this.refresh();
                    } else {
                        POSMessageDialog.showError(throwable.getMessage(), throwable);
                    }
                }
                finally {
                    busyDialog.dispose();
                }
            }
        };
        swingWorker.execute();
        busyDialog.setVisible(true);
    }

    private void j() {
        PosAction posAction = new PosAction(){
            int a = -1;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.a = Integer.parseInt(actionEvent.getActionCommand());
                super.actionPerformed(actionEvent);
            }

            @Override
            public void execute() {
                if (this.a == -1) {
                    return;
                }
                PosTransaction posTransaction = (PosTransaction)SettleTicketDialog.this.w.getRowData(this.a);
                if (posTransaction == null) {
                    return;
                }
                SettleTicketDialog.this.e(posTransaction);
            }
        };
        ButtonColumn buttonColumn = new ButtonColumn(this.v, posAction, 2){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                PosButton posButton = (PosButton)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                posButton.setText("Print");
                posButton.setHorizontalAlignment(0);
                jTable.setRowHeight(n, jTable.getRowHeight(0));
                return posButton;
            }

            @Override
            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                return super.getTableCellEditorComponent(jTable, object, false, n, n2);
            }
        };
        MatteBorder matteBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, this.v.getBackground());
        PosButton posButton = new PosButton();
        buttonColumn.setUnselectedBorder(new CompoundBorder(matteBorder, posButton.getBorder()));
        buttonColumn.setFocusBorder(new CompoundBorder(matteBorder, posButton.getBorder()));
    }

    private void e(PosTransaction posTransaction) {
        if (ReceiptPrintService.hasNoReceiptPrinters()) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("NoPrinterIsConfigured"));
            return;
        }
        ReceiptPrintService.printTransaction(posTransaction, false);
    }

    public class TransactionDataTableModel
    extends ListTableModel<PosTransaction> {
        public TransactionDataTableModel() {
            super(new String[]{"Payment", "Capture", "Print", "Void"});
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 1 || n2 == 2 || n2 == 3;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            PosTransaction posTransaction = (PosTransaction)this.rows.get(n);
            switch (n2) {
                case 0: {
                    Object object;
                    String string = " ";
                    if (posTransaction instanceof CustomPaymentTransaction) {
                        object = (CustomPaymentTransaction)posTransaction;
                        string = string + object.getCustomPaymentName();
                    } else {
                        string = string + (Object)((Object)posTransaction.getPaymentType());
                        object = posTransaction.getPaymentType();
                        if ((object == PaymentType.CREDIT_CARD || object == PaymentType.DEBIT_CARD) && StringUtils.isNotBlank((String)posTransaction.getCardNumber())) {
                            string = string + " [" + posTransaction.getCardNumber().replace("X", "") + "]";
                        }
                    }
                    object = posTransaction.getAmount();
                    if (posTransaction instanceof RefundTransaction) {
                        object = (Double)object * -1.0;
                    }
                    string = string + "   " + NumberUtil.getCurrencyFormat(object);
                    return string;
                }
                case 1: {
                    return Messages.getString("SettleTicketDialog.51");
                }
                case 2: {
                    return "Print";
                }
                case 3: {
                    return "X";
                }
            }
            return null;
        }
    }

    public class TicketDiscountTableModel
    extends ListTableModel<TicketDiscount> {
        public TicketDiscountTableModel() {
            super(new String[]{"name", "qty", "subtotal"});
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            TicketDiscount ticketDiscount = (TicketDiscount)this.rows.get(n);
            switch (n2) {
                case 0: {
                    return ticketDiscount.getNameDisplay();
                }
                case 1: {
                    return "";
                }
                case 2: {
                    return -ticketDiscount.getTotalDiscountAmount().doubleValue();
                }
            }
            return null;
        }
    }
}

